/*
 *  Copyright (C) 2005  Maarten de Boer <maarten@resorama.com>
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 *  02110-1301, USA.
 * 
 */

#ifndef __Loader__
#define __Loader__

#include "RGBA.hxx"
#include <string>

class LoaderException
{
public:
   std::string message;
   LoaderException(const std::string& m)
         :message(m)
   {}
   const char* what()
   {
      return message.c_str();
   }
};
class JpgLoader
{
public:
   unsigned int width;
   unsigned int height;

   void Load(const std::string& filename,RGB& target,int x = 0,int y = 0);
   void Load(const std::string& filename,RGBA& target,int x = 0,int y = 0);
   void Merge(const std::string& filename,RGBA& target,int x = 0,int y = 0);
};

class PngLoader
{
public:
   void Load(const std::string& filename,RGBA& target);
};

#endif
