/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "gtype-utils.h"


GList *
g_type_get_fundamental_type_list (void)
{
  GList *type_list;

  type_list = NULL;

  {
    GType  type;
    int    n;
    int    i;

    n = G_TYPE_RESERVED_GLIB_FIRST;

    for (i = 1; i < n; ++i)
      {
	type = G_TYPE_MAKE_FUNDAMENTAL (i);
	
	type_list = g_list_append (type_list, GTYPE_TO_POINTER (type));
      }
  }

  {
    GType  type;
    GTypeClass *type_class;
    int    n;
    int    i;

    n = (g_type_fundamental_next () >> G_TYPE_FUNDAMENTAL_SHIFT);

    for (i = G_TYPE_RESERVED_GLIB_FIRST; i < n; ++i)
      {
	type = G_TYPE_MAKE_FUNDAMENTAL (i);
	type_class = g_type_class_peek (type);
	
	if (type_class != NULL) /* XXX right? */
	  {
	    type_list = g_list_append (type_list, GTYPE_TO_POINTER (type));
	  }
      }
  }

  return type_list;
}

static GList *
g_type_get_descendants_type_list (GType type)
{
  GList   *types;
  GType   child_type;
  GType  *children_types;
  guint   n_children_types;
  guint i;

  types = NULL;

  children_types = g_type_children (type, &n_children_types);
  for (i = 0; i < n_children_types; ++i)
    {
      child_type = children_types[i];

      types = g_list_append (types, (gpointer)child_type);
      types = g_list_concat (types,
			     g_type_get_descendants_type_list (child_type));
    }
  g_free (children_types);

  return types;
}

GList *
g_type_get_type_list (void)
{
  GList *type_list;
  GList *fundamental_type_list;
  GList *tmp;
  GType type;

  type_list = NULL;

  fundamental_type_list = g_type_get_fundamental_type_list ();

  tmp = fundamental_type_list;
  while (tmp != NULL)
    {
      type = GPOINTER_TO_TYPE (tmp->data);
      tmp = g_list_next (tmp);

      type_list = g_list_append (type_list,
				 GTYPE_TO_POINTER (type));
      type_list = g_list_concat (type_list,
				 g_type_get_descendants_type_list (type));
    }

  g_list_free (fundamental_type_list);

  return type_list;
}
