# if you make changes, the it is advised to increment this number, and provide
# a descriptive suffix to identify who owns or what the change represents
# e.g. release_version 2.MSW
%define release 1%{?dist}
%define _libexecdir %{_prefix}/local/libexec/

# if you wish to compile an rpm without rdma support, compile like this...
# rpmbuild -ta glusterfs-3.2.5.tar.gz --without rdma
%{?_without_rdma:%define _without_rdma --disable-ibverbs}

# if you wish to compile an rpm without epoll...
# rpmbuild -ta glusterfs-3.2.5.tar.gz --without epoll
%{?_without_epoll:%define _without_epoll --disable-epoll}

# if you wish to compile an rpm with fusermount...
# rpmbuild -ta glusterfs-3.2.5.tar.gz --with fusermount
%{?_with_fusermount:%define _with_fusermount --enable-fusermount}

# if you wish to compile an rpm without geo-replication support, compile like this...
# rpmbuild -ta glusterfs-3.2.5.tar.gz --without georeplication
%{?_without_georeplication:%define _without_georeplication --disable-geo-replication}

Summary: Cluster File System
Name: glusterfs
Version: 3.2.5
Release: %{release}
License: GPLv3+
Group: System Environment/Base
Vendor: Gluster Inc
Packager: gluster-users@gluster.org
URL: http://www.gluster.org/docs/index.php/GlusterFS
Source0: ftp://ftp.gluster.com/pub/gluster/glusterfs/3.2.5/glusterfs-3.2.5.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Requires(post): /sbin/chkconfig
Requires(preun): /sbin/service, /sbin/chkconfig
Requires(postun): /sbin/service

BuildRequires: bison flex
BuildRequires: gcc make
%define _prefix /opt/%{name}/%{version}

%description
GlusterFS is a clustered file-system capable of scaling to several
peta-bytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file system in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in userspace and easily manageable.

%package core
Summary: GlusterFS common files for both the client and the server
Group: System Environment/Libraries
Obsoletes: glusterfs-libs <= 2.0.0 glusterfs-common < 3.1.0 glusterfs-server < 3.1.0
Provides: glusterfs-libs = %{version}-%{release}

%description core
GlusterFS is a clustered file-system capable of scaling to several
peta-bytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file system in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in userspace and easily manageable.

This package includes the glusterfs binary, the glusterd daemon and the gluster
command line, libglusterfs and glusterfs translator modules common to both
GlusterFS server and client framework.

%if 0%{!?_without_rdma:1}
%package rdma
Summary: GlusterFS rdma
Group: Applications/File
Requires: glusterfs-core >= %{version}-%{release}
BuildRequires: libibverbs-devel

%description rdma
GlusterFS is a clustered file-system capable of scaling to several
peta-bytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file system in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in userspace and easily manageable.

This package provides support to ib-verbs library.
%endif

%if 0%{!?_without_georeplication:1}
%package geo-replication
Summary: GlusterFS Geo-replication
Group: Applications/File
Requires: glusterfs-core >= %{version}-%{release} , python-ctypes , rsync >= 3.0.0

%description geo-replication
GlusterFS is a clustered file-system capable of scaling to several
peta-bytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file system in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in userspace and easily manageable.

This package provides support to geo-replication.
%endif

%package fuse
Summary: GlusterFS Fuse
Group: Applications/File
Requires: glusterfs-core >= %{version}-%{release}
Obsoletes: glusterfs-client < 3.1.0

%description fuse
GlusterFS is a clustered file-system capable of scaling to several
peta-bytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file system in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in userspace and easily manageable.

This package provides support to FUSE based clients.

%prep
%setup -q -n %{name}-%{version}

%build

%configure %{?_without_rdma} %{?_without_epoll} %{?_with_fusermount} %{?_without_georeplication}

# Remove rpath
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
%{__make} %{?_smp_mflags}


%install
%{__rm} -rf %{buildroot}
%{__make} install DESTDIR=%{buildroot}
%{__mkdir_p} %{buildroot}/usr/sbin
%{__mkdir_p} %{buildroot}/usr/local/libexec/glusterfs
%{__ln_s} ../..%{_sbindir}/glusterd %{buildroot}/usr/sbin/glusterd
%{__ln_s} ../..%{_sbindir}/glusterfsd %{buildroot}/usr/sbin/glusterfsd
%{__ln_s} ../..%{_sbindir}/gluster %{buildroot}/usr/sbin/gluster
%{__ln_s} ../..%{_sbindir}/glusterfs %{buildroot}/usr/sbin/glusterfs
%{__ln_s} %{_libexecdir}/glusterfs/gsyncd %{buildroot}/usr/local/libexec/glusterfs/gsyncd
%{__mkdir_p} %{buildroot}%{_includedir}/glusterfs
%{__mkdir_p} %{buildroot}/var/log/glusterfs
%{__install} -p -m 0644 libglusterfs/src/*.h \
    %{buildroot}%{_includedir}/glusterfs/

# Remove unwanted files from all the shared libraries
find %{buildroot}%{_libdir} -name '*.la' | xargs rm -f
find %{buildroot}%{_libdir} -name '*.a' | xargs rm -f

#update  /etc/ld.so.conf.d
%{__mkdir_p} %{buildroot}%{_sysconfdir}/ld.so.conf.d
%ifarch x86_64
echo "%{_prefix}/lib64" > %{buildroot}%{_sysconfdir}/ld.so.conf.d/glusterfs.conf
%else
echo "%{_prefix}/lib" > %{buildroot}%{_sysconfdir}/ld.so.conf.d/glusterfs.conf
%endif

%clean
%{__rm} -rf %{buildroot}

%post core
/sbin/ldconfig
/sbin/chkconfig --add glusterd


/sbin/ldconfig

if [ -d /etc/glusterd/vols ]; then
#for each dir under vols, backup non-fuse .vol files  as .Vol.old
for file in `find /etc/glusterd/vols -type f ! -name *-fuse.vol `;
do
grep ".vol" $file &> /dev/null && fname=`basename $file .vol` && dname=`dirname $file` && cp $file $dname/$fname.Vol.old
done
fi

pidof -c -o %PPID -x glusterd &> /dev/null
if [ $? -eq 0 ];
then
kill -9 `pgrep -f gsyncd.py` &> /dev/null

killall glusterd glusterfsd &> /dev/null
# add marker translator
glusterd --xlator-option *.upgrade=on
else
glusterd --xlator-option *.upgrade=on
sleep 10
killall glusterd &> /dev/null
fi

%postun core
/sbin/ldconfig -n %{_libdir}

%preun core
if [ $1 -eq 0 ]; then
    /sbin/chkconfig --del glusterd
fi

%files core
%defattr(-,root,root)
%doc AUTHORS ChangeLog COPYING INSTALL NEWS README THANKS
%doc %{_datadir}/doc/glusterfs
%if 0%{?_with_fusermount:1}
%{_bindir}/fusermount-glusterfs
%endif
%{_libdir}/glusterfs
%{_libdir}/*.so.*
%{_sbindir}/glusterfs*
%{_sbindir}/gluster
%{_sbindir}/glusterd
/usr/sbin
%{_mandir}/man8/*glusterfs.8*
%{_mandir}/man8/*glusterfsd.8*
%{_mandir}/man8/*gluster.8*
%{_mandir}/man8/*glusterd.8*
%dir /var/log/glusterfs
%if 0%{!?_without_rdma:1}
%exclude %{_libdir}/glusterfs/%{version}/rpc-transport/rdma*
%endif
%exclude %{_libdir}/glusterfs/%{version}/xlator/mount/fuse*
%config %{_sysconfdir}/glusterfs
%{_sysconfdir}/init.d/glusterd
%{_includedir}/glusterfs
%exclude %{_includedir}/glusterfs/y.tab.h
%{_sysconfdir}/ld.so.conf.d/glusterfs.conf
%{_libdir}/*.so
%exclude %{_libexecdir}/glusterfs/gsyncd
%exclude %{_libexecdir}/glusterfs/python/syncdaemon/*
%exclude /usr/local/libexec/glusterfs/gsyncd

%if 0%{!?_without_rdma:1}
%files rdma
%defattr(-,root,root)
%{_libdir}/glusterfs/%{version}/rpc-transport/rdma*
%endif

%if 0%{!?_without_georeplication:1}
%post geo-replication
#restart glusterd.
/etc/init.d/glusterd restart &> /dev/null
%endif

%if 0%{!?_without_georeplication:1}
%files geo-replication
%defattr(-,root,root)
%{_libexecdir}/glusterfs/gsyncd
%{_libexecdir}/glusterfs/python/syncdaemon/*
/usr/local/libexec/glusterfs/gsyncd
%endif


%files fuse
%defattr(-,root,root)
%{_libdir}/glusterfs/%{version}/xlator/mount/fuse*
/sbin/mount.glusterfs

%changelog
* Wed Jul 01 2009 Harshavardhana <harsha@gluster.com> - 2.1
- Removed mod_glusterfs.so and added new --without epoll build
  option.

* Thu Apr 16 2009 Harshavardhana <harsha@gluster.com> - 2.0
- Galore of updates including new packages added common,
  client,server splitting the original package. rpmbuild
  fully restructured to adhere to Fedora rpm standards.
  Older changelog removed as there were warnings when
  tried with 'rpmlint'.
