/*
  Copyright (c) 2007-2014 Red Hat, Inc. <http://www.redhat.com>
  This file is part of GlusterFS.

  This file is licensed to you under your choice of the GNU Lesser
  General Public License, version 3 or any later version (LGPLv3 or
  later), or the GNU General Public License, version 2 (GPLv2), in all
  cases as published by the Free Software Foundation.
*/

#include "compat.h"
#include "xdr-common.h"
#include "xdr-nfs3.h"

#if defined(__GNUC__)
#if __GNUC__ >= 4
#if !defined(__clang__)
#if !defined(__NetBSD__)
#pragma GCC diagnostic ignored "-Wunused-but-set-variable"
#pragma GCC diagnostic ignored "-Wunused-variable"
#endif
#else
#pragma clang diagnostic ignored "-Wunused-variable"
#pragma clang diagnostic ignored "-Wunused-value"
#endif
#endif
#endif

/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include "../../../rpc/xdr/src/acl3-xdr.h"

bool_t
xdr_aclentry (XDR *xdrs, aclentry *objp)
{
	register int32_t *buf;

	 if (!xdr_int (xdrs, &objp->type))
		 return FALSE;
	 if (!xdr_int (xdrs, &objp->uid))
		 return FALSE;
	 if (!xdr_int (xdrs, &objp->perm))
		 return FALSE;
	return TRUE;
}

bool_t
xdr_getaclargs (XDR *xdrs, getaclargs *objp)
{
	register int32_t *buf;

	 if (!xdr_netobj (xdrs, &objp->fh))
		 return FALSE;
	 if (!xdr_int (xdrs, &objp->mask))
		 return FALSE;
	return TRUE;
}

bool_t
xdr_getaclreply (XDR *xdrs, getaclreply *objp)
{
	register int32_t *buf;

	 if (!xdr_int (xdrs, &objp->status))
		 return FALSE;
	 if (!xdr_int (xdrs, &objp->attr_follows))
		 return FALSE;
	 if (!xdr_fattr3 (xdrs, &objp->attr))
		 return FALSE;
	 if (!xdr_int (xdrs, &objp->mask))
		 return FALSE;
	 if (!xdr_int (xdrs, &objp->aclcount))
		 return FALSE;
	 if (!xdr_array (xdrs, (char **)&objp->aclentry.aclentry_val, (u_int *) &objp->aclentry.aclentry_len, ~0,
		sizeof (aclentry), (xdrproc_t) xdr_aclentry))
		 return FALSE;
	 if (!xdr_int (xdrs, &objp->daclcount))
		 return FALSE;
	 if (!xdr_array (xdrs, (char **)&objp->daclentry.daclentry_val, (u_int *) &objp->daclentry.daclentry_len, ~0,
		sizeof (aclentry), (xdrproc_t) xdr_aclentry))
		 return FALSE;
	return TRUE;
}

bool_t
xdr_setaclargs (XDR *xdrs, setaclargs *objp)
{
	register int32_t *buf;

	 if (!xdr_netobj (xdrs, &objp->fh))
		 return FALSE;
	 if (!xdr_int (xdrs, &objp->mask))
		 return FALSE;
	 if (!xdr_int (xdrs, &objp->aclcount))
		 return FALSE;
	 if (!xdr_array (xdrs, (char **)&objp->aclentry.aclentry_val, (u_int *) &objp->aclentry.aclentry_len, ~0,
		sizeof (aclentry), (xdrproc_t) xdr_aclentry))
		 return FALSE;
	 if (!xdr_int (xdrs, &objp->daclcount))
		 return FALSE;
	 if (!xdr_array (xdrs, (char **)&objp->daclentry.daclentry_val, (u_int *) &objp->daclentry.daclentry_len, ~0,
		sizeof (aclentry), (xdrproc_t) xdr_aclentry))
		 return FALSE;
	return TRUE;
}

bool_t
xdr_setaclreply (XDR *xdrs, setaclreply *objp)
{
	register int32_t *buf;

	 if (!xdr_int (xdrs, &objp->status))
		 return FALSE;
	 if (!xdr_int (xdrs, &objp->attr_follows))
		 return FALSE;
	 if (!xdr_fattr3 (xdrs, &objp->attr))
		 return FALSE;
	return TRUE;
}
