/*
  Copyright (c) 2007-2014 Red Hat, Inc. <http://www.redhat.com>
  This file is part of GlusterFS.

  This file is licensed to you under your choice of the GNU Lesser
  General Public License, version 3 or any later version (LGPLv3 or
  later), or the GNU General Public License, version 2 (GPLv2), in all
  cases as published by the Free Software Foundation.
*/

#include "compat.h"
#include "xdr-common.h"
#include "xdr-nfs3.h"

#if defined(__GNUC__)
#if __GNUC__ >= 4
#if !defined(__clang__)
#if !defined(__NetBSD__)
#pragma GCC diagnostic ignored "-Wunused-but-set-variable"
#pragma GCC diagnostic ignored "-Wunused-variable"
#endif
#else
#pragma clang diagnostic ignored "-Wunused-variable"
#pragma clang diagnostic ignored "-Wunused-value"
#endif
#endif
#endif

/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _ACL3_XDR_H_RPCGEN
#define _ACL3_XDR_H_RPCGEN

#include <rpc/rpc.h>


#ifdef __cplusplus
extern "C" {
#endif


struct aclentry {
	int type;
	int uid;
	int perm;
};
typedef struct aclentry aclentry;

struct getaclargs {
	netobj fh;
	int mask;
};
typedef struct getaclargs getaclargs;

struct getaclreply {
	int status;
	int attr_follows;
	struct fattr3 attr;
	int mask;
	int aclcount;
	struct {
		u_int aclentry_len;
		struct aclentry *aclentry_val;
	} aclentry;
	int daclcount;
	struct {
		u_int daclentry_len;
		struct aclentry *daclentry_val;
	} daclentry;
};
typedef struct getaclreply getaclreply;

struct setaclargs {
	netobj fh;
	int mask;
	int aclcount;
	struct {
		u_int aclentry_len;
		struct aclentry *aclentry_val;
	} aclentry;
	int daclcount;
	struct {
		u_int daclentry_len;
		struct aclentry *daclentry_val;
	} daclentry;
};
typedef struct setaclargs setaclargs;

struct setaclreply {
	int status;
	int attr_follows;
	struct fattr3 attr;
};
typedef struct setaclreply setaclreply;

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_aclentry (XDR *, aclentry*);
extern  bool_t xdr_getaclargs (XDR *, getaclargs*);
extern  bool_t xdr_getaclreply (XDR *, getaclreply*);
extern  bool_t xdr_setaclargs (XDR *, setaclargs*);
extern  bool_t xdr_setaclreply (XDR *, setaclreply*);

#else /* K&R C */
extern bool_t xdr_aclentry ();
extern bool_t xdr_getaclargs ();
extern bool_t xdr_getaclreply ();
extern bool_t xdr_setaclargs ();
extern bool_t xdr_setaclreply ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_ACL3_XDR_H_RPCGEN */
