/*
movesort.h/movesort.cpp - Source Code for ElephantEye, Part VII

ElephantEye - a Chinese Chess Program (UCCI Engine)
Designed by Morning Yellow, Version: 3.11, Last Modified: Dec. 2007
Copyright (C) 2004-2007 www.elephantbase.net

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "base.h"
#include "x86asm.h"
#include "position.h"
#include "movesort.h"

int nHistory[65536]; // ʷ

// ʷŷбֵ
void MoveSortStruct::SetHistory(void) {
  int i, j, vl, nShift, nNewShift;
  nShift = 0;
  for (i = nMoveIndex; i < nMoveNum; i ++) {
    // ŷķֵ65536ͱŷķֵʹǶ65536
    vl = nHistory[mvs[i].wmv] >> nShift;
    if (vl > 65535) {
      nNewShift = Bsr(vl) - 15;
      for (j = nMoveIndex; j < i; j ++) {
        mvs[j].wvl >>= nNewShift;
      }
      vl >>= nNewShift;
      __ASSERT_BOUND(32768, vl, 65535);
      nShift += nNewShift;
    }
    mvs[i].wvl = vl;
  }
}

// 򷨣"1, 4, 13, 40 ..."УҪ"1, 2, 4, 8, ..."
static const int cnShellStep[8] = {0, 1, 4, 13, 40, 121, 364, 1093};

void MoveSortStruct::ShellSort(void) {
  int i, j, nStep, nStepLevel;
  MoveStruct mvsBest;
  nStepLevel = 1;
  while (cnShellStep[nStepLevel] < nMoveNum - nMoveIndex) {
    nStepLevel ++;
  }
  nStepLevel --;
  while (nStepLevel > 0) {
    nStep = cnShellStep[nStepLevel];
    for (i = nMoveIndex + nStep; i < nMoveNum; i ++) {
      mvsBest = mvs[i];
      j = i - nStep;
      while (j >= nMoveIndex && mvsBest.wvl > mvs[j].wvl) {
        mvs[j + nStep] = mvs[j];
        j -= nStep;
      }
      mvs[j + nStep] = mvsBest;
    }
    nStepLevel --;
  }
}

/* ɽ⽫ŷΨһӦŷ(жӦŷ򷵻)
 * 
 * ⽫ŷ˳£
 * 1. ûŷ(SORT_VALUE_MAX)
 * 2. ɱŷ(SORT_VALUE_MAX - 12)
 * 3. ŷʷ(1SORT_VALUE_MAX - 3)
 * 4. ܽ⽫ŷ(0)Щŷ˵
 */
int MoveSortStruct::InitEvade(PositionStruct &pos, int mv, const uint16_t *lpwmvKiller) {
  int i, nLegal;
  nPhase = PHASE_REST;
  nMoveIndex = 0;
  nMoveNum = pos.GenAllMoves(mvs);
  SetHistory();
  nLegal = 0;
  for (i = nMoveIndex; i < nMoveNum; i ++) {
    if (mvs[i].wmv == mv) {
      nLegal ++;
      mvs[i].wvl = SORT_VALUE_MAX;
    } else if (pos.MakeMove(mvs[i].wmv)) {
      pos.UndoMakeMove();
      nLegal ++;
      if (mvs[i].wmv == lpwmvKiller[0]) {
        mvs[i].wvl = SORT_VALUE_MAX - 1;
      } else if (mvs[i].wmv == lpwmvKiller[1]) {
        mvs[i].wvl = SORT_VALUE_MAX - 2;
      } else {
        mvs[i].wvl = MIN(mvs[i].wvl + 1, SORT_VALUE_MAX - 3);
      }
    } else {
      mvs[i].wvl = 0;
    }
  }
  ShellSort();
  nMoveNum = nMoveIndex + nLegal;
  return (nLegal == 1 ? mvs[0].wmv : 0);
}

// һŷ
int MoveSortStruct::NextFull(const PositionStruct &pos) {
  switch (nPhase) {
  // "nPhase"ʾŷɽ׶ΣΪ

  // 0. ûŷɺһ׶Σ
  case PHASE_HASH:
    nPhase = PHASE_GEN_CAP;
    if (mvHash != 0) {
      __ASSERT(pos.LegalMove(mvHash));
      return mvHash;
    }
    // ɣû"break"ʾ"switch"һ"case"ִһ"case"ͬ

  // 1. гŷɺһ׶Σ
  case PHASE_GEN_CAP:
    nPhase = PHASE_GOODCAP;
    nMoveIndex = 0;
    nMoveNum = pos.GenCapMoves(mvs);
    ShellSort();

  // 2. MVV(LVA)ҪѭɴΣ
  case PHASE_GOODCAP:
    if (nMoveIndex < nMoveNum && mvs[nMoveIndex].wvl > 1) {
      // ע⣺MVV(LVA)ֵ1˵ӲֱܻƵģЩŷԺ
      nMoveIndex ++;
      __ASSERT_PIECE(pos.ucpcSquares[DST(mvs[nMoveIndex - 1].wmv)]);
      return mvs[nMoveIndex - 1].wmv;
    }

  // 3. ɱŷ(һɱŷ)ɺһ׶Σ
  case PHASE_KILLER1:
    nPhase = PHASE_KILLER2;
    if (mvKiller1 != 0 && pos.LegalMove(mvKiller1)) {
      // ע⣺ɱŷŷԣͬ
      return mvKiller1;
    }

  // 4. ɱŷ(ڶɱŷ)ɺһ׶Σ
  case PHASE_KILLER2:
    nPhase = PHASE_GEN_NONCAP;
    if (mvKiller2 != 0 && pos.LegalMove(mvKiller2)) {
      return mvKiller2;
    }

  // 5. вŷɺһ׶Σ
  case PHASE_GEN_NONCAP:
    nPhase = PHASE_REST;
    nMoveNum += pos.GenNonCapMoves(mvs + nMoveNum);
    SetHistory();
    ShellSort();

  // 6. ʣŷʷ(ؽ⽫ŷ)
  case PHASE_REST:
    if (nMoveIndex < nMoveNum) {
      nMoveIndex ++;
      return mvs[nMoveIndex - 1].wmv;
    }

  // 7. ûŷˣ㡣
  default:
    return 0;
  }
}

// ɸŷ
void MoveSortStruct::InitRoot(const PositionStruct &pos, int nBanMoves, const uint16_t *lpwmvBanList) {
  int i, j, nBanned;
  nMoveIndex = 0;
  nMoveNum = pos.GenAllMoves(mvs);
  nBanned = 0;
  for (i = 0; i < nMoveNum; i ++) {
    mvs[i].wvl = 1;
    for (j = 0; j < nBanMoves; j ++) {
      if (mvs[i].wmv == lpwmvBanList[j]) {
        mvs[i].wvl = 0;
        nBanned ++;
        break;
      }
    }  
  }
  ShellSort();
  nMoveNum -= nBanned;
}

// ¸ŷб
void MoveSortStruct::UpdateRoot(int mv) {
  int i;
  for (i = 0; i < nMoveNum; i ++) {
    if (mvs[i].wmv == mv) {
      mvs[i].wvl = SORT_VALUE_MAX;
    } else if (mvs[i].wvl > 0) {
      mvs[i].wvl --;      
    }
  }
}
