open Gdome;;

exception Impossible

let ctr = ref 0

let di = domImplementation ()

let doc = di#createDocumentFromURI ~uri:(Sys.argv.(1)) ()
let _ = di#disableEvent doc "*"

let helmns = "http://www.cs.unibo.it/helm"
let xref = "xref"

let dom_helmns = Gdome.domString helmns
let dom_xref = Gdome.domString xref

let full_visit (doc : Gdome.document) =
  let counter = ref 0 in
  let rec visit_node (n : Gdome.node) =
    incr ctr ;
    match n#get_nodeType with
      GdomeNodeTypeT.ELEMENT_NODE -> visit_element (new Gdome.element_of_node n)
    | _ -> ()
  and visit_element (el : Gdome.element) =
    if el#hasAttributeNS dom_helmns dom_xref then incr counter ;
    visit_siblings el#get_firstChild
  and visit_siblings n =
    match n with
      Some n' ->
        visit_node n' ;
	visit_siblings n'#get_nextSibling
    | None -> ()
  in 
  let root = doc#get_documentElement in
  visit_element root ;
  prerr_endline ("found " ^ string_of_int !counter)

let t = ref 0.0

let rec a (el: Gdome.element) =
  function
    0 -> ()
  | n -> 
    let tempo1 = Sys.time () in
    ignore (el#get_nodeType) ; 
    t := !t +. (Sys.time () -. tempo1) ;
    a el (n - 1)

let _ =
  let t2 = Sys.time () in
  (* let doc2 = full_visit doc in *)
  let doc2 = a (doc#get_documentElement) 600000 in
  let t3 = Sys.time () in
  prerr_endline ("T1: " ^ (string_of_float (t3 -. t2)) ^ " " ^ string_of_float !t ^ " " ^ string_of_int !ctr)

