/*
 *    filter.h  --  FIR filter
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _FILTER_H
#define _FILTER_H

#include "cmplx.h"

#define BufferLen	1024

/* ---------------------------------------------------------------------- */

#ifdef __i386__
#include "filter-i386.h"
#endif				/* __i386__ */

/* ---------------------------------------------------------------------- */

#ifndef __HAVE_ARCH_MAC
extern __inline__ float mac(const float *a, const float *b, unsigned int size)
{
	float sum = 0;
	unsigned int i;

	for (i = 0; i < size; i++)
		sum += (*a++) * (*b++);
	return sum;
}
#endif				/* __HAVE_ARCH_MAC */

/* ---------------------------------------------------------------------- */

struct filter {
	int length;
	int decimateratio;

	float *ifilter;
	float *qfilter;

	float ibuffer[BufferLen];
	float qbuffer[BufferLen];

	int pointer;
	int counter;
};

extern struct filter *filter_init(int len, int dec, float *ifil, float *qfil);
extern struct filter *filter_init_lowpass(int len, float freq);
extern struct filter *filter_init_bandpass(int len, float f1, float f2);
extern struct filter *filter_init_hilbert(int len);
extern void filter_free(struct filter *f);

extern int filter_run(struct filter *f, complex in, complex *out);
extern int filter_I_run(struct filter *f, float in, float *out);
extern int filter_Q_run(struct filter *f, float in, float *out);

extern void filter_dump(struct filter *f);

/* ---------------------------------------------------------------------- */
#endif				/* _FILTER_H */
