/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <gtk/gtk.h>

#include "config.h"
#include "dpreferences.h"
#include "settings.h"
#include "rcfile.h"
#include "run.h"
#include "help.h"

void dialog_preferences_create(d_preferences_t*);

void gm_dialog_preferences_open() {
    d_preferences_t *p = g_malloc(sizeof(d_preferences_t));
    p->settings = gm_settings_copy(settings);
    dialog_preferences_create(p);
}

int dialog_preferences_apply(d_preferences_t *p) {
    if(debug) printf("Applying preferences in the preferences dialog\n");
    p->settings = gm_settings_replace(p->settings);
#ifdef ZVT
    gm_run_apply_changes(p->run);
#endif
    return TRUE;
}

void dialog_preferences_close(d_preferences_t *p) {
    gm_settings_free(p->settings);
#ifdef ZVT
    gm_run_free_dialog(p->run);
#endif
    gm_colorsel_free(p->colorsel);
    g_free(p);
}

void dialog_preferences_help(int page, char *page_name, d_preferences_t *p) {
    char *chapter;
    int i;
    if(debug) printf("Help pressed for %d (\"%s\")\n", page, page_name);
    chapter = g_strconcat(HELP_DPREFERENCES, "_", page_name, NULL);
    for(i = 0; chapter[i] != '\0'; i++) {
        if(chapter[i] == ' ') chapter[i] = '_';
    }
    gm_help_show(p->pc->window, chapter);
    g_free(chapter);
}

void dialog_preferences_create(d_preferences_t *p) {
    pc_sec *s, *iface, *output, *mcp;
    pc_var *master;
    pc_var *s0, *s1, *s2, *s3;
#if defined(PIXBUF) || defined(IMLIB)
    pc_var *sTile;
#endif
#ifdef IMLIB
    pc_var *s4, *s5, *s6, *s7;
#endif

    p->pc = pc_new(_("Global preferences"),
                   (pc_apply_func)dialog_preferences_apply,
                   (pc_func)      dialog_preferences_close,
                   (pc_help_func) dialog_preferences_help,
                   TRUE,
                   p);

    iface = s = pc_section_new(p->pc, _("Interface")); 
    pc_check_new(s, _("Restore worlds when gmoo starts"),
                 &p->settings->restore_open_worlds);
    pc_check_new(s, _("Show toolbar"),
                 &p->settings->toolbar);
    pc_check_new(s, _("Save input height"), &p->settings->save_input_height);
    pc_option_new(s, _("World switching hotkey"), &p->settings->hotkey,
                  _("Ctrl"), _("Alt"), _("Either"), NULL);
    pc_check_new(s, _("Switch world by <hotkey>-arrow"),
                 &p->settings->hotkey_arrow);
    
    s = pc_subsection_new(iface, _("Window")); 
    pc_check_new(s, _("Save window size"), &p->settings->save_window_size);
    pc_option_new(s, _("Tab position"), &p->settings->tab_position,
                  _("Left"), _("Right"), _("Top"), _("Bottom"), NULL);
    pc_check_new(s, _("Homogenous tab size"), &p->settings->homo_tabs);
    pc_check_new(s, _("Tabs show lines waiting"),
                 &p->settings->tabs_show_lines_waiting);
    pc_check_new(s, _("The number for <hotkey>-n is shown on the tabs"),
                 &p->settings->tab_pos_on_tab);
    master = pc_check_new(s, _("Limit the length of the name tabs"),
                          &p->settings->tab_limit_length);
    s0 = pc_spin_new(s, _("Max length"), 10, G_MAXINT,
                     &p->settings->tab_max_length);
    pc_check_lock(master, s0, NULL);


    output = s = pc_subsection_new(iface, _("Output"));
    pc_check_new(s, _("gmoo beeps"), &p->settings->beep);
    pc_check_new(s, _("Scroll down when you press <enter>"),
                 &p->settings->scroll_on_enter);
    pc_check_new(s, _("Scroll down when new text appears"),
                 &p->settings->scroll_on_text);
    pc_spin_new (s, _("Buffer size in lines\nUse 0 for unlimited"), 0, G_MAXINT,
                 &p->settings->buffer_size);
    pc_entry_new(s, _("Timestamp\nSee strftime(3) for\nthe format"),
                 &p->settings->timestamp);

    s = pc_subsection_new(output, _("Background"));
    s0 = pc_radio_new(s, NULL, _("Use background color"), &p->settings->bg_col);
#if defined(PIXBUF) || defined(IMLIB)
    s1 = pc_radio_new(s, s0,   _("Transparent"), &p->settings->bg_trans);
    s2 = pc_radio_new(s, s0,   _("Background from file"), &p->settings->bg_file);
    s3 = pc_file_new(s, _("Filename"), &p->settings->bg_filename);
    sTile = pc_option_new(s, _("Method"), &p->settings->bg_tile,
			  _("Fit to window"), _("Tile"), NULL);
    pc_check_lock(s2, s3, sTile, NULL);
#ifdef IMLIB
    s4 = pc_check_new(s, _("Tint background"), &p->settings->bg_tinted);
    s5 = pc_scale_new(s, _("Red"), TRUE, TRUE, 0,256, &p->settings->bg_tint_r);
    s6 = pc_scale_new(s, _("Green"), TRUE, TRUE, 0,256, &p->settings->bg_tint_g);
    s7 = pc_scale_new(s, _("Blue"), TRUE, TRUE, 0,256, &p->settings->bg_tint_b);
    pc_check_lock_reversed(s0, s4, NULL);
    pc_check_lock_through(s4, s5, s6, s7, NULL);
#endif /* IMLIB */
#endif /* PIXBUF || IMLIB */

    s = pc_subsection_new(output, _("User Input"));
    master = pc_check_new(s, _("Show your own input"),
                          &p->settings->show_own_input);
    s0 = pc_option_new(s, _("Foreground color"),
                       &p->settings->show_own_input_fgcolor,
                       gm_settings_get_color_name(0),
                       gm_settings_get_color_name(1),
                       gm_settings_get_color_name(2),
                       gm_settings_get_color_name(3),
                       gm_settings_get_color_name(4),
                       gm_settings_get_color_name(5),
                       gm_settings_get_color_name(6),
                       gm_settings_get_color_name(7),
                       _("None"), NULL);
    s1 = pc_option_new(s, _("Background color"),
                       &p->settings->show_own_input_bgcolor,
                       gm_settings_get_color_name(0),
                       gm_settings_get_color_name(1),
                       gm_settings_get_color_name(2),
                       gm_settings_get_color_name(3),
                       gm_settings_get_color_name(4),
                       gm_settings_get_color_name(5),
                       gm_settings_get_color_name(6),
                       gm_settings_get_color_name(7),
                       _("None"), NULL);
    s2 = pc_check_new(s, _("Show in bold"),
                      &p->settings->show_own_input_bold);
    s3 = pc_check_new(s, _("Show underlined"),
                      &p->settings->show_own_input_underline);
    pc_check_lock(master, s0, s1, s2, s3, NULL);

    s = pc_subsection_new(output, _("Fonts"));
    pc_font_new(s, _("Font"), &p->settings->fontname);

    s = pc_subsection_new(output, _("Colors"));
    p->colorsel = gm_colorsel_create_properties(s, p->settings);
    p->colorsel->pc = p->pc;

    s = pc_subsection_new(iface, _("History"));
    master = pc_check_new(s, _("Enable input history"), &p->settings->history);
    s0     = pc_spin_new(s, _("History size"), 10, G_MAXINT,
                         &p->settings->history_size);
    s1     = pc_check_new(s, _("Selective history"),
                          &p->settings->history_selective);
    s2     = pc_check_new(s, _("Case sensitive"),
                          &p->settings->history_sensitive);
    s3     = pc_check_new(s, _("Store history"),
                          &p->settings->history_store);
    pc_check_lock(master, s0, s1, s3, NULL);
    pc_check_lock2(master, s1, s2, NULL);

#ifdef ZVT
    s = pc_subsection_new(iface, _("Run menu"));
    p->run = gm_run_create_properties(s, p->settings);
    p->run->pc = p->pc;
#endif

    s = pc_section_new(p->pc, _("Misc"));
    pc_check_new(s, _("Reconnect on disconnect"),
                 &p->settings->reconnect);

    s = pc_section_new(p->pc, _("Editor"));
    master = pc_check_new(s, _("Use external editor"),
                          &p->settings->editor_external);
    s0 = pc_check_new(s, _("Use $EDITOR enviroment variable"),
                      &p->settings->editor_use_env);
    s1 = pc_entry_new(s, _("Editor command"),
                      &p->settings->editor_command);
    s2 = pc_check_new(s, _("Delete local file cache when editor closes"),
                      &p->settings->editor_delete_file);
#ifndef ZVT
    pc_check_lock(master, s0, s1, s2, NULL);
#else
    s3 = pc_check_new(s, _("Editor needs terminal"),
                      &p->settings->editor_needs_term);
    pc_check_lock(master, s0, s1, s2, s3, NULL);
#endif


    mcp = s = pc_section_new(p->pc, _("MCP"));

    s = pc_subsection_new(mcp, _("Userlist"));
    pc_check_new(s, _("Place userlist right"),
                 &p->settings->userlist_pos);
    pc_check_new(s, _("Userlist resizeable"),
                 &p->settings->userlist_resizeable);
    pc_check_new(s, _("Show totals"),
                 &p->settings->userlist_totals);
    pc_check_new(s, _("Show column headers"),
                 &p->settings->userlist_headers);
    pc_check_new(s, _("Show object column"),
                 &p->settings->userlist_objects);
    pc_option_new(s, _("Friends color"),
                  &p->settings->userlist_friends_color,
                  gm_settings_get_color_name(0),
                  gm_settings_get_color_name(1),
                  gm_settings_get_color_name(2),
                  gm_settings_get_color_name(3),
                  gm_settings_get_color_name(4),
                  gm_settings_get_color_name(5),
                  gm_settings_get_color_name(6),
                  gm_settings_get_color_name(7),
                  _("None"),
                  NULL);

    pc_check_new(s, _("Automatically open userlist if available"),
                 &p->settings->userlist_auto_open);


    pc_show(p->pc);
}
