/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GM_DPROPERTIES_H
#define GM_DPROPERTIES_H

#include "properties_creator.h"
#include "world.h"
#include "properties.h"

struct _d_properties_t {
    pc_win *pc;		/* properties creator dialog */
    world *belongs_to;  /* one of the open worlds it belongs to (if any) */
    char *belongs_name; /* one of the closed worlds it belongs to (ditto) */
    properties_t *p;    /* properties struct */
    int open_world;     /* If we have to open the world if it is an new world*/
};

d_properties_t *gm_dialog_properties_open              (world *w);
d_properties_t *gm_dialog_properties_open_by_name      (const char *name);
d_properties_t *gm_dialog_properties_open_new          ();
d_properties_t *gm_dialog_properties_open_current_world();

void gm_dialog_properties_close(d_properties_t *p);

#endif /*  GM_DPROPERTIES_H */
