/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <ctype.h>

#include "config.h"

#include "misc.h"

GList *str_to_GList_sep(const char *str, char seperator) {
    char *dup;
    char *s;
    GList *list = NULL;
    int i = 0;

    if(!str) {
	return NULL;
    }
    s = dup = g_strdup(str);
    /* DEBUG(printf("str_to_GList: Parsing \"%s\"\n", str)); */
    
    while(1) {
	if(dup[i] == seperator || dup[i] == '\0') {
	    dup[i] = 0;
	    list = g_list_append(list, g_strdup(s));
	    /* DEBUG(printf("\tFound \"%s\"\n", s)); */
	    s = dup + i + 1;
	    if(str[i] == '\0')
		break;
	}
	i++;
    }
    /* DEBUG(printf("Done (%d elements found)\n", g_list_length(list))); */

    g_free(dup);
    return list;
}

GList *str_to_GList(const char *str) {
    return str_to_GList_sep(str, ',');
}

char *GList_to_str(const GList *list) {
    char *s = NULL;
    char *tmp;

    if(list == NULL)
	return NULL;

    s = g_strdup(list->data);
    for(list = g_list_next(list); list != NULL; list = g_list_next(list)) {
	tmp = g_strconcat(s, list->data, NULL);
	g_free(s);
	s = tmp;
    }
    return s;
}

char *GList_to_str_sep(const GList *list, char *seperator) {
    char *s = NULL;
    char *tmp;

    if(list ==  NULL)
	return NULL;
    if(seperator == NULL || seperator[0] == 0)
	return GList_to_str(list);

    for(; list != NULL; list = g_list_next(list)) {
	tmp = s ? g_strconcat(s, list->data, NULL) : g_strdup(list->data);
	g_free(s);
	s = tmp;
	if(g_list_next(list)) {
	    tmp = g_strconcat(s, seperator, NULL);
	    g_free(s);
	    s = tmp;
	}
    }
    return s;
}

#define BLOCK_SIZE 512
GList *get_lines_from_file(const char *filename) {
    GList *lines = NULL;
    struct stat stats;
    int   filesize;
    FILE *stream;
    char *line;
    char *s;

    stat(filename, &stats);
    filesize = stats.st_blocks * BLOCK_SIZE + 10;
    line = g_malloc(filesize);

    stream = fopen(filename, "r");

    while((line = fgets(line, filesize, stream))) {
        if((s = strchr(line, '\n'))) {
            s[0] = '\n';
        }
        lines = g_list_append(lines, g_strdup(line));
        /* DEBUG(printf(">> %s\n", line)); */
    }
    /* DEBUG(printf(">> DONE <<\n")); */

    fclose(stream);
    g_free(line);

    return lines;
}

#define ESCAPE '\x1b'
char *strip_ansi(const char *s, int len) { /* needs to be free()ed */
    char *ret = g_malloc(len + 1);
    int i, j = 0;
    for(i = 0; i < len; i++) {
	if(s[i] == ESCAPE) {
	    i++;
	    if(s[i] == '[') {
		i++;
		while(i < len && ((s[i] >= '0' && s[i] <= '9')||s[i] == ';')) {
		    i++;
		}
	    }
	} else {
	    ret[j] = s[i];
	    j++;
	}
    }
    ret[j] = '\0';
    return ret;
}


char *limit_string_to_length(const char *s, int length) {
    char *ret = NULL;
    int len;

    if(length > 0 || !s) {
	ret = g_malloc(length + 1);
	len = strlen(s);
	if(len >= length - 3) {
	    strncpy(ret, s, length - 3);
	    strcpy(ret + length - 3, "...");
	} else {
	    strcpy(ret, s);
	}
    } else {
	ret = NULL;
    }
    return ret;
}

int exists_dir(const char *dirname) {
    DIR *dir = opendir(dirname);
    if(!dir) {
	return FALSE;
    }
    closedir(dir);
    return TRUE;
}

char *str_tolower(char *s) {
    int i = 0;
    if(s) {
        while(s[i]) {
            s[i] = tolower(s[i]);
            i++;
        }
    }
    return s;
}

