close all;
clear all;

%% l2 [Order][Mesh]

%% f = [Sin(10x),  Sin(10y)]

h = [1, 1/2, 1/4, 1/8, 1/16];
p = [1:5];

l2 = ...
    [...
        +1.224839e+00 , +7.506745e-01 , +1.947692e-01 , +5.290998e-02 , +1.310630e-02 ; ...
        +1.136486e+00 , +2.649562e-01 , +5.094337e-02 , +6.781482e-03 , +8.954483e-04 ; ...
        +7.863819e-01 , +1.076230e-01 , +6.312907e-03 , +4.039742e-04 , +2.384884e-05 ; ...
        +3.025262e-01 , +2.100662e-02 , +9.893349e-04 , +3.352325e-05 , +1.078586e-06 ; ...
        +2.353779e-01 , +6.042023e-03 , +8.737518e-05 , +1.360547e-06 , +2.216694e-08 ; ...
    ];

P = size(p, 2);
H = size(h, 2);

delta = zeros(P, H - 1);

for i = 1:H-1
    delta(:, i) = ...
        (log10(l2(:, i + 1)) - log10(l2(:, i))) / ...
        (log10(1/h(i + 1))   - log10(1/h(i)));
end

delta

figure;
loglog(1./h, l2', '-*');
grid;
