.TH MGD77LIST GMTMANSECTION "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
mgd77list \- A data-extractor for <legid>.mgd77 files
.SH SYNOPSIS
\fBmgd77list\fP \fIleg-ids\fP [ \fB\-Da\fP\fIstartdate\fP ] [ \fB\-Db\fP\fIstopdate\fP ]
[ \fB\-E\fP ] [ \fB\-F\fP\fIflags\fP ] [ \fB\-H\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP ]
[ \fB\-R\fIwest/east/south/north\fP ] [ \fB\-Sa\fP\fIstartdist\fP ] [ \fB\-Sb\fP\fIstopdist\fP ]
[ \fB\-V\fP ] [ \fB\-W\fP\fIweight\fP ] [ \fB\-bo\fP ]
.SH DESCRIPTION
\fBmgd77list\fP reads <legid>.mgd77 files and produces an ASCII [or binary] table.
The <legid>.mgd77 files contain track information such as time and position, geophysical
observables such as gravity, magnetics, and bathymetry, and control codes and corrections
such as Eotvos or diurnal corrections. The user may extract any combination of these parameters
plus the computed quantities distance, heading, and velocity (\fBv\fP), and finally weight
(see \fB\-W\fP). A sub-section can be specified by passing time- or distance-intervals along
track or by selecting a region.
.TP
\fIleg-ids\fP
Can be one or more MGD77 8-character cruise identifiers. To give a list of names, use `cat cruises.lis`.
The ".mgd77" extension will automatically be appended, if needed. Cruise files will be looked for
in the current directory and in all directories listed in \fB$MGD77_DIR\fP/MGD77_paths.txt.
.SH OPTIONS
No space between the option flag and the associated arguments
.TP
.B \-Da
Do not list data collected before \fIstartdate\fP (yyyy-mm-dd\fBT\fP[hh:mm:ss]) [Default is start of cruise].
.TP
.B \-Db
Do not list data collected after \fIstopdate\fP (yyyy-mm-dd\fBT\fP[hh:mm:ss]). [Default is end of cruise].
.TP
.B \-E
Exact match: Only output records that matches all the requested geophysical columns [Default outputs records that matches
at least one of the observed columns].
.TP
.B \-F
Comma-separated list of parameter abbreviations in the desired output order. Those parameters
given in UPPER case must be present in all output records. Unless indicated, the
output format is controlled by \fBD_FORMAT\fP. The available abbreviations are:
.TP
.B id
The 8-character cruise ID string
.TP
.B time
Absolute calendar time in the format dictated by the GMT default settings \fBOUTPUT_DATE_FORMAT\fP
and \fBOUTPUT_CLOCK_FORMAT\fP.
.TP
.B lon
Longitude in the format dictated by the GMT default \fBOUTPUT_DEGREE_FORMAT\fP.
.TP
.B lat
Longitude in the format dictated by the GMT default \fBOUTPUT_DEGREE_FORMAT\fP.
.TP
.B dist
Along-track distance in km or nautical miles (see \fB\-N\fP).
.TP
.B az
Ship azimuth (heading) in degrees.
.TP
.B vel
Ship speed in m/s or knots (see \fB\-N\fP).
.TP
.B weight
Weight assigned to this data set (see \fB\-W\fP).
.TP
.B twt
Two-way travel time (in s).
.TP
.B depth
Corrected bathymetry (in m).
.TP
.B mtf1
Total magnetic field intensity from sensor 1 (in nTesla).
.TP
.B mtf2
Total magnetic field intensity from sensor 2 (in nTesla).
.TP
.B mag
Residual magnetic anomaly (in nTesla).
.TP
.B gobs
Observed gravity (in mGal).
.TP
.B faa
Free-air gravity anomaly (in mGal).
.TP
.B ptc
Position Type Code (1 = fix, 3 = interpolated, 9 = unspecified).
.TP
.B bcc
Bathymetric Correction Code, indicating the procedure used to convert travel time to depth.
(01-55 = Matthews' zone - use only if Matthews' zones were used to correct depth, 59 = Matthews'\"'
corrections used but zones unspecified in data record, 60 = S. Kuwahara formula, 61 = Wilson
formula, 62 = Del Grosso formula, 63 = Carter's tables, 88 = Other, described in header sections,\"'
99 = unspecified).
.TP
.B btc
Bathymetric Type Code, indicating how the bathymetry value was obtained (1 = observed,
3 = interpolated, 9 = unspecified).
.TP
.B msens
Magnetic sensor for residual field (1 = 1st or leading sensor, 2 = 2nd or trailing sensor, 9 = unspecified).
.TP
.B msd
Depth (or altitutde) of the magnetic sensor (m, positive below sealevel).
.TP
.B diur
Magnetic diurnal correction (nTesla).
.TP
.B eot
Eotvos correction (mGal).
.TP
.B sln
Seismic line number string.
.TP
.B sspn
Seismic shot point number string.
.TP
.B nqc
Navigation quality Code (5 = suspected, by source institution, 6 = suspected, by NGDC, 90 = no problems identified).
.br
.sp
Logical tests may be added for any of the parameters by appending one or more comma-separated instructions
of the form \fIpar\fP\fBOP\fP\fIvalue\fP, where \fIpar\fP is one of the parameters listed above, \fBOP\fP is
a logical operator (<. <=, =, !=, >=, >), and \fIvalue\fP is used in the comparison. Floating point
parameters are compared numerically; character parameters are compared lexically (after leading and trailing
blanks have been removed). At least one of the tests must be true for the record to be output, expect for
tests using UPPER case parameters in which case the test must be true for output to occur. Note that
specifying a test does not imply that the corresponding column will be included in the output stream;
you must specify the dataflag for that to occur.
.TP
.B \-H
Issue a header record with names for each data field.
.TP
.B \-M
Issue a multisegment header record with cruise ID for each cruise.
.TP
.B \-N
Use nautical units for distance (nautical miles) and speed (knots) [Default is km and m/s].
.TP
.B \-Sa
Do not list data that are less than \fIstartdist\fP km (or nautical miles; see \fB\-N\fP) along
track from port of departure. [Default is 0].
.TP
.B \-Sb
Do not list data that are more than \fIstopdist\fP km (or nautical miles; see \fB\-N\fP) along
track from port of departure. [Default is length of track].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Set the weight for these data. Weight output option must be set in \fB\-F\fP. This is
useful if the data are to be processed with the weighted averaging techniques offered by
\fBblockmean\fP, \fBblockmedian\fP, and \fBblockmode\fP.
.TP
.B \-bo
Selects binary output mode (single precision; append \fBd\fP for double precision) [Default is ASCII].
\fB\-H\fP and \fB\-M\fP are ignored if \fB\-bo\fP is selected.
.SH EXAMPLES
To get a (distance, heading, gravity, bathymetry) listing from 01010047.mgd77,
starting at June 3 1971 20:45 and ending at distance = 5000 km, use the following command:
.br
.sp
\fBmgd77list\fP 01010047 \fB\-Da\fP1971-06-03T20:45 \fB\-Sb\fP5000 \fB\-F\fPdist,azim,faa,depth > myfile.d
.br
.sp
To make input for \fBblockmean\fP and \fBsurface\fP using free-air anomalies from all the cruises listed in the file cruises.lis,
but only the data that are inside the specified area, and make the output binary:
.br
.sp
\fBmgd77list\fP `cat cruises.lis` \fB\-F\fPlon,lat,faa \fB\-R\fP-40/-30/25/35 \fB\-bo\fP > allgrav.b
.br
.sp
To extract the locations of depths exceeding 9000 meter that were not interpolated (\fBbtc\fP != 1) from all the cruises listed in the file cruises.lis:
.br
.sp
\fBmgd77list\fP `cat cruises.lis` \fB\-F\fP"depth,DEPTH>9000,BTC!=1" > really_deep.d
.SH "SEE ALSO"
.IR mgd77info (GMTMANSECTION),
.IR mgd77track (GMTMANSECTION)
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 2004, The Generic Mapping Tools (GMT) version
4 Technical Reference & Cookbook, SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1998, New, Improved Version of Generic Mapping
Tools Released, EOS Trans., AGU, 79 (47), p. 579.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, EOS Trans., AGU, 76 (33), p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, http:
American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data,
EOS Trans., AGU, 72 (41), p. 441.
.br
