/*--------------------------------------------------------------------
 *	$Id: pslib_inc.h,v 1.25 2004/09/03 20:26:45 pwessel Exp $
 *
 *	Copyright (c) 1991-2004 by P. Wessel and W. H. F. Smith
 *	See COPYING file for copying and redistribution conditions.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; version 2 of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	Contact info: gmt.soest.hawaii.edu
 *--------------------------------------------------------------------*/
/*
 * This include file is only included in pslib.c.  Calling programs must
 * include file pslib.h
 *
 * Author:	Paul Wessel
 * Date:	02-JUN-2004
 * Version:	4.1
 */

#ifndef _PSLIB_INC_H
#define _PSLIB_INC_H

/*  PSL is POSIX COMPLIANT  */

#define _POSIX_SOURCE 1

/* Declaration modifiers for DLL support (MSC et al) */

#if defined(DLL_PSL)		/* define when library is a DLL */
#if defined(DLL_EXPORT)		/* define when building the library */
#define MSC_EXTRA_PSL __declspec(dllexport)
#else
#define MSC_EXTRA_PSL __declspec(dllimport)
#endif
#else
#define MSC_EXTRA_PSL
#endif				/* defined(DLL_PSL) */

#ifndef EXTERN_MSC
#define EXTERN_MSC extern MSC_EXTRA_PSL
#endif

/* So unless DLL_PSL is defined, EXTERN_MSC is simply extern */

/*--------------------------------------------------------------------
 *			SYSTEM HEADER FILES
 *--------------------------------------------------------------------*/

#include <ctype.h>
#include <float.h>
#include <limits.h>
#include <math.h>
#include <stddef.h>
#ifdef __MACHTEN__
/* Kludge to fix a Machten POSIX bug */
#include <sys/types.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "gmt_notunix.h"
#include "gmt_math.h"

#ifndef WIN32
#include <unistd.h>
#endif

/*--------------------------------------------------------------------
 *			PSL CONSTANTS MACRO DEFINITIONS
 *--------------------------------------------------------------------*/

#define PSL_Version "4.1"
#ifndef R2D
#define R2D (180.0/M_PI)
#endif
#define SMALL 1.0e-10
#define MAX_L1_PATH 1000 /* Max path length in Level 1 implementations */
#define I_255 (1.0 / 255.0)
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef M_PI
#define M_PI            3.14159265358979323846
#endif
#ifndef M_SQRT2
#define M_SQRT2         1.41421356237309504880
#endif
#define VNULL		((void *)NULL)
#define PAGE_HEIGHT_IN_PTS 842
#ifndef CNULL
#define CNULL (char *)NULL
#endif
/*--------------------------------------------------------------------
 *			PSL FUNCTION MACRO DEFINITIONS
 *--------------------------------------------------------------------*/

#ifndef MIN
#define MIN(x, y) (((x) < (y)) ? (x) : (y))
#endif
#ifndef MAX
#define MAX(x, y) (((x) > (y)) ? (x) : (y))
#endif
#ifndef irint
#define irint(x) ((int)rint(x))
#endif
#define YIQ(rgb) irint (0.299 * (rgb[0]) + 0.587 * (rgb[1]) + 0.114 * (rgb[2]))	/* How B/W TV's convert RGB to Gray */
#define iscolor(rgb) (rgb[0] != rgb[1] || rgb[1] != rgb[2])

int N_PS_FONTS;		/* Total no of fonts;  To add more, modify the file CUSTOM_font_info.d */
int N_GMT_FONTS;	/* Total no of standard GMT fonts. */

typedef int BOOLEAN;		/* BOOLEAN used for logical variables */

/*--------------------------------------------------------------------
 *			PSL PARAMETERS DEFINITIONS
 *--------------------------------------------------------------------*/

struct PS_FONT {
	char *name;		/* Name of this font */
	double height;		/* Height of A for unit fontsize */ 
	BOOLEAN encoded;	/* TRUE if we never should reencode this font (e.g. symbols) */
				/* This is also changed to TRUE after we do reencode a font */
};
	
/* Global structure used internally by pslib */

struct {
	FILE *fp;		/* PS output file pointer. NULL = stdout	*/
	int bb[4];		/* Boundingbox arguments			*/
	int font_no;		/* Current font number				*/
	int linewidth;		/* Current pen thickness			*/
	int rgb[3];		/* Current paint				*/
	BOOLEAN landscape;	/* TRUE = Landscape, FALSE = Portrait			*/
	int ix, iy;		/* Absolute coordinates of last point		*/
	int npath;		/* Length of current unstroked path		*/
	int split;		/* 1 if last ps_line had to split path		*/
	char bw_format[8];	/* Format used for grayshade value		*/
	char rgb_format[64];	/* Same, for RGB color triplets			*/
	char cmyk_format[64];	/* Same, for CMYK color quadruples		*/
	double xscl, yscl;	/* Global scale values [1.0]			*/
	double xoff, yoff;	/* Origin offset [1/1]				*/
	double scale;		/* Must be set through plotinit();		*/
	int p_width;		/* Paper width in points, set in plotinit();	*/
	int p_height;		/* Paper height in points, set in plotinit();	*/
	double points_pr_unit;	/* # of points pr measure unit (e.g., 72/inch	*/
	int v1_path_length_limit;	/* Implementation limit on path lengths	in Level 1 PostScript	*/
	int max_path_length;	/* Maximum path length encountered during execution	*/
	int clip_path_length;	/* Current length of clip path			*/
	int hex_image;		/* TRUE writes images in hex, FALSE uses binary	*/
	int cmyk_mode;		/* TRUE writes all color calls in cmyk, FALSE uses rgb	*/
	int absolute;		/* TRUE will reset origin, FALSE means relative position	*/
	int eps_format;		/* TRUE makes EPS file, FALSE means PS file	*/
	char *encoding;		/* The encoding name. e.g. ISO-8859-1 */
	struct PS_FONT *font;	/* Pointer to array of font structures 		*/
} ps;

char *PSHOME = (char *)NULL;	/* Pointer to path of directory with lib subdirectory */

char *ps_scandcodes[13][4] = {	/* Short-hand converrsion for Norwegian characters in both Standard [0], Standard+ [1], ISOLatin1 [2], and ISOLatin1+ [2] encoding */
	{ "AA", "\\375", "\\305", "\\305"},	/* Aring */
	{ "AE", "\\341", "\\306", "\\306"},	/* AE */
	{ "OE", "\\351", "\\330", "\\330"},	/* Oslash */
	{ "aa", "\\376", "\\345", "\\345"},	/* aring */
	{ "ae", "\\372", "\\346", "\\346"},	/* ae */
	{ "oe", "\\371", "\\370", "\\370"},	/* oslash */
	{ "C", "\\201", "\\307", "\\307"},	/* Ccedilla */
	{ "N", "\\204", "\\321", "\\321"},	/* Ntilde */
	{ "U", "\\335", "\\334", "\\334"},	/* Udieresis */
	{ "c", "\\215", "\\347", "\\347"},	/* ccedilla */
	{ "n", "\\227", "\\36", "\\361"},	/* ntilde */
	{ "\\373", "\\373", "\\337", "\\337"},	/* germandbls */
	{ "u", "\\370", "\\374", "\\374"}	/* udieresis */
};

	/* Pattern information */
	
#define N_PATTERNS 91	/* Current number of predefined patterns + 1, # 91 is user-supplied */

char ps_pattern_status[N_PATTERNS][2];
int ps_pattern_nx[N_PATTERNS][2];
int ps_pattern_ny[N_PATTERNS][2];

int ps_n_userimages;
struct USERIMAGE {
	char *name;
	int nx, ny;
} ps_user_image[N_PATTERNS];

int no_rgb[3] = {-1, -1, -1};

int ps_outline_offset[4] = {0, 2, 5, 3};
char ps_paint_code[4] = {'A', 'C', 'K', ' '};

#endif	/* _PSLIB_INC_H */
