/*
 *  Copyright 2004-2006 Michael Terry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __CHAR_BOX_H__
#define __CHAR_BOX_H__

#include <gtkmm.h>

class CharBox
	: public Gtk::EventBox
{
	public:
	
	CharBox (char c, bool border);
	CharBox (const char *str, bool border);
	
	protected:
	
	Glib::ustring string;
	Gtk::EventBox *inner;
	Glib::RefPtr <Pango::Layout> layout;
	void size_allocated (Gdk::Rectangle& allocation);
	bool exposed (GdkEventExpose *event);
	void setup (const char *str, bool border);
};

#endif /* __CHAR_BOX_H__ */
