------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-binds.ads,v 1.5 2004/06/28 04:57:05 vagul Exp $

with OCI.Thick.Statements;

package OCI.Thick.Binds is

   use Statements;

   type Abstract_Bind is abstract tagged private;

private

   procedure Bind
     (Stmt    : in     Statement;
      Var     : in out Abstract_Bind'Class;
      Name    : in      String;
      Type_Id : in      Ub2;
      Value   : in      DVoid;
      Size    : in      Sb4;
      Ind     : in      A_Sb2);

   type Abstract_Bind is abstract new RF.Controlled_Reference with record
      Bind : aliased OCIBind := OCIBind (Empty_Handle);
      Stmt : Statement;
   end record;

   procedure Destroy (Item : in out Abstract_Bind);

end OCI.Thick.Binds;
