-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/samples/adbc/client.adb,v $
--  Description     : Ada Database Objects - Test client                     --
--  Author          : Michael Erdmann                                        --
--  Created         : 18.1.2002                                              --
--  Last Modified By: $Author: merdmann $                                    --
--  Last Modified On: $Date: 2002/03/09 16:38:18 $                           --
--  Version         : $Revision: 1.3 $
--  Status          : $State: Exp $
--                                                                           --
--  Copyright (C) 2001 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  This software is implemented to work with GNAT, the GNU Ada compiler.    --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--  This is the test client for the ADO packages                             --
--                                                                           --
--                                                                           --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  Only Linux                                                               --
--                                                                           --
--  Contact                                                                  --
--  =======                                                                  --
--  Error reports shall be handled via http://gnade.sourceforge.net          --
--  Features and ideas via: gnade-develop@lists.sourceforge.net              --
--                                                                           --
--  Author contact:                                                          --
--               purl:/net/michael.erdmann                                   --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;                        use Ada.Text_IO;

with GNU.DB.ADBC.Connection;             use GNU.DB.ADBC.Connection;
with GNU.DB.ADBC.Driver;                 use GNU.DB.ADBC.Driver;
with GNU.DB.ADBC.Statement;              use GNU.DB.ADBC.Statement;
with GNU.DB.ADBC.Resultset;              use GNU.DB.ADBC.Resultset;
with GNU.DB.ADBC.Hostvariable;           use GNU.DB.ADBC.Hostvariable;
with GNU.DB.ADBC.Driver.MySQL;           use GNU.DB.ADBC.Driver.MySQL;
with GNU.DB.ADBC;                        use GNU.DB.ADBC;
with GNU.DB.ADBC.Hostvariable;           use GNU.DB.ADBC.Hostvariable;
with GNU.DB.ADBC.Hostvariable.Types;     use GNU.DB.ADBC.Hostvariable.Types;

procedure Client is
   X  : Driver.Handle := Driver.MySQL.Create;
   C  : Connection.Object(X);

   S  : Statement_ID;
   R  : Resultset_ID;

   subtype Name_Type  is String(1..50);
   subtype Empno_Type is Integer range 1..999;

   V  : SQL_String ;
   E  : SQL_Integer;

begin
   Connect(C, "gnade", Password => "", Database => "gnade" );

   -- prepare a query
   S := Prepare( C,
        "select empno, name, firstname from EMPLOYEES " &
        "where empno > :emp and job = :id" );
   Bind(S, "id", V );
   Bind(S, "emp", E );

   Put_Line("Executing query and running through result set");
   -- execute a query
   Value( V, "Genius" );
   Value( E, 5 );
   R := Execute(C, S );

   -- retrieve the result
   declare
      package D_Empname  is
         new String_Domain( Size => Name_Type'Length, Result => R, Name => "name");
      package D_Firstname  is
         new String_Domain( Size => Name_Type'Length, Result => R, Name => "firstname");
      package D_Empno is
         new Integer_Domain( Number_Type => Empno_Type, Result => R, Name => "empno");
   begin

      while not End_Of_Result(R) loop
         Fetch( R );
         Put_Line(
            Integer'Image(D_Empno.Value) & " " &
            D_Empname.Value &
            D_Firstname.Value
         );
      end loop;

      Fetch( R, First );
      Put_Line( "First record is: " & D_Empname.Value );
      Put_Line("");

      Put_Line("Same result set backwards");
      Fetch( R, Last );
      while not Begin_Of_Result(R) loop
         Put_Line(
            Integer'Image(D_Empno.Value) & " " &
            D_Empname.Value &
            D_Firstname.Value
         );
         Fetch( R, Previous );
      end loop;

   end ;
   Deallocate( R );


   Put_Line("************** Executing next query ******************");
   R := Execute( C, "select * from EMPLOYEES" );
   Put_Line( "Nbr of Records :" & Integer'Image( Number_Of_Records(R)));
   Deallocate(R);

   Put_Line("*********** Disconnecting from database **************");

   R := Execute( C,"insert INTO DEPARTMENTS VALUES( 1111x, 'hallo', 'xxx')" );
   Deallocate(R);
   R := Execute( C, "select * from DEPARTMENTS" );
   Put_Line( "Nbr of Records :" & Integer'Image( Number_Of_Records(R)));
   Deallocate(R);

   Disconnect(C);
end Client;
