------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: dyn.adb,v 1.6 2006/12/10 09:29:35 merdmann Exp $

--  Example of using dynamically allocated bind variables.

with Ada.Strings.Fixed;
with Ada.Text_IO;

with OCI.Thick.Connections;
with OCI.Thick.Statements;
with OCI.Thick.Strings;

procedure Dyn is
   use OCI.Thick;
   use OCI.Thick.Connections;
   use OCI.Thick.Statements;
   use OCI.Thick.Strings;
   use Ada.Strings.Fixed;
   use Ada.Text_IO;

   Connect : Connection := Logon ("scott/tiger");

   Stmt1 : Statement := Prepare (Connect,
      "begin :Result := null; end;");

   Stmt2 : Statement := Prepare (Connect,
      "begin :Result := '----------------- would see.'; end;");

   Stmt3 : Statement := Prepare (Connect,
      "begin if False then :Result := :Result; end if; end;");

   Stmt4 : Statement := Prepare (Connect,
      "begin :Result := '1'; end;");

   Stmt5 : Statement := Prepare (Connect,
      "begin" &
      " :Result := '-------';" &
      " :Result1 := '11111111111';" &
      " :Result2 := '22222222';" &
      " end;");

   Stmt6 : Statement := Prepare (Connect,
      "declare Dummy Varchar2 (64) := :Result; "&
      "begin" &
      " :Result1 := '11111111111';" &
      " :Result2 := '22222222';" &
      " end;");

   Stmt7 : Statement := Prepare (Connect,
      "declare Dummy Varchar2 (64) := :Result1; "&
      "begin" &
      " :Result := '-------';" &
      " :Result2 := '22222222';" &
      " end;");

   Stmt : Statement := Prepare (Connect,
      "begin"
        & " if true then"
        & " :result1 := nvl (:result1, 'eeeeeeeeeeeee');"
        & " end if;"
      & " end;");

   Sel : Statement := Prepare (Connect,
      "select * from ("
      & " select rownum || ', '|| dname ||', '|| loc ||';' from dept"
      & " union select rownum || ', '||  loc ||', '|| dname ||';' from dept"
      & " union select loc  || ', '||  rownum ||', '|| dname ||';' from dept"
      & " union select loc  || ', '||  dname ||', '|| rownum ||';' from dept"
      & " union select dname || ', '|| loc   ||', '|| rownum ||';' from dept"
      & " union select dname || ', '|| rownum  ||', '|| loc  ||';' from dept"
      & " union all select '22' from dept"
      & " union all select '2' from dept"
      & " union all select null from dept"
      & " union all select '=====================' from dept)"
      & " where rownum < :cond");

   Result : Variable;

   Result1 : Variable;
   Result2 : Variable;
begin
   Bind  (Stmt1, Result, "Result");

   Execute (Stmt1);

   Put_Line ("Result " & Value (Result, "(null)"));

   Set_Value (Result, "does not matter");

   Execute (Stmt1);

   Put_Line ("Result " & Value (Result, "(null)"));

   Bind  (Stmt2, Result, "Result");
   Execute (Stmt2);
   Put_Line ("Result " & Value (Result));

   Bind  (Stmt3, Result, "Result");
   Execute (Stmt3);
   Put_Line ("Result Stmt3 '" & Value (Result) & ''');

   Bind  (Stmt4, Result, "Result");
   Execute (Stmt4);
   Put_Line ("Result Stmt4 '" & Value (Result) & ''');

   Bind  (Stmt5, Result, "Result");
   Bind  (Stmt5, Result1, "Result1");
   Bind  (Stmt5, Result2, "Result2");
   Execute (Stmt5);
   Put_Line ("Result  Stmt5 '" & Value (Result) & ''');
   Put_Line ("Result1 Stmt5 '" & Value (Result1) & ''');
   Put_Line ("Result2 Stmt5 '" & Value (Result2) & ''');

   Bind  (Stmt6, Result, "Result");
   Bind  (Stmt6, Result1, "Result1");
   Bind  (Stmt6, Result2, "Result2");
   Execute (Stmt6);
   Put_Line ("Result  Stmt6 '" & Value (Result) & ''');
   Put_Line ("Result1 Stmt6 '" & Value (Result1) & ''');
   Put_Line ("Result2 Stmt6 '" & Value (Result2) & ''');

   Clear_Value (Result1);
   Clear_Value (Result2);
   Execute (Stmt6);
   Put_Line ("Result  Stmt6 '" & Value (Result) & ''');
   Put_Line ("Result1 Stmt6 '" & Value (Result1) & ''');
   Put_Line ("Result2 Stmt6 '" & Value (Result2) & ''');

   Bind  (Stmt7, Result, "Result");
   Bind  (Stmt7, Result1, "Result1");
   Bind  (Stmt7, Result2, "Result2");
   Clear_Value (Result);
   Clear_Value (Result2);
   Execute (Stmt7);
   Put_Line ("Result  Stmt7 '" & Value (Result) & ''');
   Put_Line ("Result1 Stmt7 '" & Value (Result1) & ''');
   Put_Line ("Result2 Stmt7 '" & Value (Result2) & ''');

   Bind  (Stmt, Result1, "Result1");

   Define (Sel, Result1, 1);
   Bind   (Sel, Result2, "cond");

   Ada.Text_IO.Put_Line ("binded");

   Set_Value (Result1, 2 * "aBcDeFgH." & "=_");
   Ada.Text_IO.Put ("execute");
   Execute (Stmt);
   Ada.Text_IO.Put_Line ("d");
   Ada.Text_IO.Put_Line ("Result1 " & Value (Result1) & ';');
   Clear_Value (Result1);
   Execute (Stmt);
   Ada.Text_IO.Put_Line ("d");
   Ada.Text_IO.Put_Line ("Result1 " & Value (Result1, "(null)") & ';');
   Set_Value (Result2, "97");
   Execute (Sel);

   while Fetch (Sel) loop
      if Is_Null (Result1) then
         Ada.Text_IO.Put_Line ("(null)");
      else
         declare
            F1 : String := Value (Result1);
         begin
            Ada.Text_IO.Put_Line (F1 & '.'
              & Integer'Image (Character'Pos (F1 (F1'Last))));
         end;
      end if;
   end loop;
end Dyn;
