------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: in_null.adb,v 1.1 2006/06/16 09:03:14 vagul Exp $

--  Example of untouched null value.

with Ada.Strings.Fixed;
with Ada.Text_IO;

with OCI.Thick.Connections;
with OCI.Thick.Statements;
with OCI.Thick.Strings;

procedure In_Null is

   use OCI.Thick;
   use OCI.Thick.Connections;
   use OCI.Thick.Statements;
   use OCI.Thick.Strings;
   use Ada.Strings.Fixed;

   Connect : Connection := Logon ("scott/tiger");
   Stmt : Statement := Prepare (Connect,
         "begin if :result1 is not null then"
       & " :result1 := 'eeeeeeeeeeeee';"
       & " end if;"
       & " end;");

   Result1 : Var_Type;

   procedure Show_Result;

   -----------------
   -- Show_Result --
   -----------------

   procedure Show_Result is
   begin
      if Is_Null (Result1) then
         Ada.Text_IO.Put_Line ("Result1 is null");
      else
         Ada.Text_IO.Put_Line ("Result1 " & Value (Result1) & ';');
      end if;
   end Show_Result;

begin
   Bind (Stmt, Result1, "result1");

   Ada.Text_IO.Put_Line ("binded");

   Clear_Value (Result1);
   Ada.Text_IO.Put ("execute");
   Execute (Stmt);
   Ada.Text_IO.Put_Line ("d");
   Show_Result;
end In_Null;
