-----------------------------------------------------------------------
--                             RADical                               --
--                                                                   --
--                         Copyright (C) 2000                        --
--                            ACT-Europe                             --
--                                                                   --
-- GVD is free  software;  you can redistribute it and/or modify  it --
-- under the terms of the GNU General Public License as published by --
-- the Free Software Foundation; either version 2 of the License, or --
-- (at your option) any later version.                               --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this library; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

with Gtkada.Types; use Gtkada.Types;

package RAD.Pixmaps is

   --  Note that the following pixmaps are in alphabetical order.
   --  The actual size of the pixmaps is only known by GtkAda, which is
   --  enough for our needs and avoid having to maintain this information here.

   accellabel_xpm     : aliased Chars_Ptr_Array (0 .. 0);
   alignment_xpm      : aliased Chars_Ptr_Array (0 .. 0);
   arrow_xpm          : aliased Chars_Ptr_Array (0 .. 0);
   aspectframe_xpm    : aliased Chars_Ptr_Array (0 .. 0);
   button_xpm         : aliased Chars_Ptr_Array (0 .. 0);
   calendar_xpm       : aliased Chars_Ptr_Array (0 .. 0);
   checkbutton_xpm    : aliased Chars_Ptr_Array (0 .. 0);
   checkmenuitem_xpm  : aliased Chars_Ptr_Array (0 .. 0);
   clist_xpm          : aliased Chars_Ptr_Array (0 .. 0);
   colorseldialog_xpm : aliased Chars_Ptr_Array (0 .. 0);
   colorselection_xpm : aliased Chars_Ptr_Array (0 .. 0);
   combo_xpm          : aliased Chars_Ptr_Array (0 .. 0);
   ctree_xpm          : aliased Chars_Ptr_Array (0 .. 0);
   curve_xpm          : aliased Chars_Ptr_Array (0 .. 0);
   custom_bg_xpm      : aliased Chars_Ptr_Array (0 .. 0);
   custom_xpm         : aliased Chars_Ptr_Array (0 .. 0);
   dialog_xpm         : aliased Chars_Ptr_Array (0 .. 0);
   drawingarea_xpm    : aliased Chars_Ptr_Array (0 .. 0);
   entry_xpm          : aliased Chars_Ptr_Array (0 .. 0);
   eventbox_xpm       : aliased Chars_Ptr_Array (0 .. 0);
   fileseldialog_xpm  : aliased Chars_Ptr_Array (0 .. 0);
   fixed_xpm          : aliased Chars_Ptr_Array (0 .. 0);
   fontsel_xpm        : aliased Chars_Ptr_Array (0 .. 0);
   fontseldialog_xpm  : aliased Chars_Ptr_Array (0 .. 0);
   frame_xpm          : aliased Chars_Ptr_Array (0 .. 0);
   gammacurve_xpm     : aliased Chars_Ptr_Array (0 .. 0);
   handlebox_xpm      : aliased Chars_Ptr_Array (0 .. 0);
   hbox_xpm           : aliased Chars_Ptr_Array (0 .. 0);
   hbuttonbox_xpm     : aliased Chars_Ptr_Array (0 .. 0);
   hpaned_xpm         : aliased Chars_Ptr_Array (0 .. 0);
   hruler_xpm         : aliased Chars_Ptr_Array (0 .. 0);
   hscale_xpm         : aliased Chars_Ptr_Array (0 .. 0);
   hscrollbar_xpm     : aliased Chars_Ptr_Array (0 .. 0);
   hseparator_xpm     : aliased Chars_Ptr_Array (0 .. 0);
   image_xpm          : aliased Chars_Ptr_Array (0 .. 0);
   inputdialog_xpm    : aliased Chars_Ptr_Array (0 .. 0);
   label_xpm          : aliased Chars_Ptr_Array (0 .. 0);
   layout_xpm         : aliased Chars_Ptr_Array (0 .. 0);
   list_xpm           : aliased Chars_Ptr_Array (0 .. 0);
   listitem_xpm       : aliased Chars_Ptr_Array (0 .. 0);
   menubar_xpm        : aliased Chars_Ptr_Array (0 .. 0);
   menuitem_xpm       : aliased Chars_Ptr_Array (0 .. 0);
   new_xpm            : aliased Chars_Ptr_Array (0 .. 0);
   notebook_xpm       : aliased Chars_Ptr_Array (0 .. 0);
   open_xpm           : aliased Chars_Ptr_Array (0 .. 0);
   optionmenu_xpm     : aliased Chars_Ptr_Array (0 .. 0);
   options_xpm        : aliased Chars_Ptr_Array (0 .. 0);
   packer_xpm         : aliased Chars_Ptr_Array (0 .. 0);
   pixmap_xpm         : aliased Chars_Ptr_Array (0 .. 0);
   placeholder_xpm    : aliased Chars_Ptr_Array (0 .. 0);
   popup_xpm          : aliased Chars_Ptr_Array (0 .. 0);
   popupmenu_xpm      : aliased Chars_Ptr_Array (0 .. 0);
   preview_xpm        : aliased Chars_Ptr_Array (0 .. 0);
   progressbar_xpm    : aliased Chars_Ptr_Array (0 .. 0);
   radiobutton_xpm    : aliased Chars_Ptr_Array (0 .. 0);
   radiomenuitem_xpm  : aliased Chars_Ptr_Array (0 .. 0);
   save_xpm           : aliased Chars_Ptr_Array (0 .. 0);
   scrolledwindow_xpm : aliased Chars_Ptr_Array (0 .. 0);
   selector_xpm       : aliased Chars_Ptr_Array (0 .. 0);
   source_xpm         : aliased Chars_Ptr_Array (0 .. 0);
   spinbutton_xpm     : aliased Chars_Ptr_Array (0 .. 0);
   statusbar_xpm      : aliased Chars_Ptr_Array (0 .. 0);
   table_xpm          : aliased Chars_Ptr_Array (0 .. 0);
   text_xpm           : aliased Chars_Ptr_Array (0 .. 0);
   togglebutton_xpm   : aliased Chars_Ptr_Array (0 .. 0);
   toolbar_xpm        : aliased Chars_Ptr_Array (0 .. 0);
   tree_xpm           : aliased Chars_Ptr_Array (0 .. 0);
   treeitem_xpm       : aliased Chars_Ptr_Array (0 .. 0);
   unknown_xpm        : aliased Chars_Ptr_Array (0 .. 0);
   vbox_xpm           : aliased Chars_Ptr_Array (0 .. 0);
   vbuttonbox_xpm     : aliased Chars_Ptr_Array (0 .. 0);
   viewport_xpm       : aliased Chars_Ptr_Array (0 .. 0);
   vpaned_xpm         : aliased Chars_Ptr_Array (0 .. 0);
   vruler_xpm         : aliased Chars_Ptr_Array (0 .. 0);
   vscale_xpm         : aliased Chars_Ptr_Array (0 .. 0);
   vscrollbar_xpm     : aliased Chars_Ptr_Array (0 .. 0);
   vseparator_xpm     : aliased Chars_Ptr_Array (0 .. 0);
   window_xpm         : aliased Chars_Ptr_Array (0 .. 0);

private
   pragma Import (C, accellabel_xpm, "accellabel_xpm");
   pragma Import (C, alignment_xpm, "alignment_xpm");
   pragma Import (C, arrow_xpm, "big_arrow_xpm");
   pragma Import (C, aspectframe_xpm, "aspectframe_xpm");
   pragma Import (C, button_xpm, "button_xpm");
   pragma Import (C, calendar_xpm, "calendar_xpm");
   pragma Import (C, checkbutton_xpm, "checkbutton_xpm");
   pragma Import (C, checkmenuitem_xpm, "checkmenuitem_xpm");
   pragma Import (C, clist_xpm, "clist_xpm");
   pragma Import (C, colorseldialog_xpm, "colorseldialog_xpm");
   pragma Import (C, colorselection_xpm, "colorselection_xpm");
   pragma Import (C, combo_xpm, "combo_xpm");
   pragma Import (C, ctree_xpm, "ctree_xpm");
   pragma Import (C, curve_xpm, "curve_xpm");
   pragma Import (C, custom_bg_xpm, "custom_bg_xpm");
   pragma Import (C, custom_xpm, "custom_xpm");
   pragma Import (C, dialog_xpm, "dialog_xpm");
   pragma Import (C, drawingarea_xpm, "drawingarea_xpm");
   pragma Import (C, entry_xpm, "entry_xpm");
   pragma Import (C, eventbox_xpm, "eventbox_xpm");
   pragma Import (C, fileseldialog_xpm, "fileseldialog_xpm");
   pragma Import (C, fixed_xpm, "fixed_xpm");
   pragma Import (C, fontsel_xpm, "fontsel_xpm");
   pragma Import (C, fontseldialog_xpm, "fontseldialog_xpm");
   pragma Import (C, frame_xpm, "frame_xpm");
   pragma Import (C, gammacurve_xpm, "gammacurve_xpm");
   pragma Import (C, handlebox_xpm, "handlebox_xpm");
   pragma Import (C, hbox_xpm, "hbox_xpm");
   pragma Import (C, hbuttonbox_xpm, "hbuttonbox_xpm");
   pragma Import (C, hpaned_xpm, "hpaned_xpm");
   pragma Import (C, hruler_xpm, "hruler_xpm");
   pragma Import (C, hscale_xpm, "hscale_xpm");
   pragma Import (C, hscrollbar_xpm, "hscrollbar_xpm");
   pragma Import (C, hseparator_xpm, "hseparator_xpm");
   pragma Import (C, image_xpm, "image_xpm");
   pragma Import (C, inputdialog_xpm, "inputdialog_xpm");
   pragma Import (C, label_xpm, "label_xpm");
   pragma Import (C, layout_xpm, "layout_xpm");
   pragma Import (C, list_xpm, "list_xpm");
   pragma Import (C, listitem_xpm, "listitem_xpm");
   pragma Import (C, menubar_xpm, "menubar_xpm");
   pragma Import (C, menuitem_xpm, "menuitem_xpm");
   pragma Import (C, new_xpm, "new_xpm");
   pragma Import (C, notebook_xpm, "notebook_xpm");
   pragma Import (C, open_xpm, "open_xpm");
   pragma Import (C, optionmenu_xpm, "optionmenu_xpm");
   pragma Import (C, options_xpm, "options_xpm");
   pragma Import (C, packer_xpm, "packer_xpm");
   pragma Import (C, pixmap_xpm, "pixmap_xpm");
   pragma Import (C, placeholder_xpm, "placeholder_xpm");
   pragma Import (C, popup_xpm, "popup_xpm");
   pragma Import (C, popupmenu_xpm, "popupmenu_xpm");
   pragma Import (C, preview_xpm, "preview_xpm");
   pragma Import (C, progressbar_xpm, "progressbar_xpm");
   pragma Import (C, radiobutton_xpm, "radiobutton_xpm");
   pragma Import (C, radiomenuitem_xpm, "radiomenuitem_xpm");
   pragma Import (C, save_xpm, "save_xpm");
   pragma Import (C, scrolledwindow_xpm, "scrolledwindow_xpm");
   pragma Import (C, selector_xpm, "selector_xpm");
   pragma Import (C, source_xpm, "source_xpm");
   pragma Import (C, spinbutton_xpm, "spinbutton_xpm");
   pragma Import (C, statusbar_xpm, "statusbar_xpm");
   pragma Import (C, table_xpm, "table_xpm");
   pragma Import (C, text_xpm, "text_xpm");
   pragma Import (C, togglebutton_xpm, "togglebutton_xpm");
   pragma Import (C, toolbar_xpm, "toolbar_xpm");
   pragma Import (C, tree_xpm, "tree_xpm");
   pragma Import (C, treeitem_xpm, "treeitem_xpm");
   pragma Import (C, unknown_xpm, "unknown_xpm");
   pragma Import (C, vbox_xpm, "vbox_xpm");
   pragma Import (C, vbuttonbox_xpm, "vbuttonbox_xpm");
   pragma Import (C, viewport_xpm, "viewport_xpm");
   pragma Import (C, vpaned_xpm, "vpaned_xpm");
   pragma Import (C, vruler_xpm, "vruler_xpm");
   pragma Import (C, vscale_xpm, "vscale_xpm");
   pragma Import (C, vscrollbar_xpm, "vscrollbar_xpm");
   pragma Import (C, vseparator_xpm, "vseparator_xpm");
   pragma Import (C, window_xpm, "window_xpm");
end RAD.Pixmaps;
