with Entities;          use Entities;
with Entities.Debug;    use Entities.Debug;
with GNAT.IO;           use GNAT.IO;
with VFS;               use VFS;
with Projects;          use Projects;
with Projects.Registry; use Projects.Registry;
with Traces;            use Traces;

procedure Test_Entities is
   Test_Refs  : constant Boolean := True;

   Registry   : Project_Registry;

   function Load_Project (Name : String) return Project_Type;

   function Load_Project (Name : String) return Project_Type is
      Predefined_Source_Path : constant String :=
        "/usr/local/gnat/lib/gcc-lib/i686-pc-linux-gnu/2.8.1/adainclude";
      Predefined_Object_Path : constant String :=
        "/usr/local/gnat/lib/gcc-lib/i686-pc-linux-gnu/2.8.1/adalib";
      New_Project_Loaded : Boolean;
   begin
      Load (Registry, Name, null, New_Project_Loaded);

      Set_Predefined_Source_Path (Registry, Predefined_Source_Path);
      Set_Predefined_Object_Path (Registry, Predefined_Object_Path);

      Recompute_View (Registry, null);
      return Get_Root_Project (Registry);
   end Load_Project;

   Project    : Project_Type;
   Db         : Entities_Database := Create;
   L1, L2     : LI_File;
   F1, F2     : Source_File;
   E1, E2, E3, E4 : Entity_Information;

begin
   Projects.Registry.Initialize;
   Parse_Config_File (".gnatdebug");
   Project := Load_Project ("default.gpr");

   Put_Line ("++++++++ Empty db +++++++");
   Dump (Db);

   New_Line; Put_Line ("++++++++ One single file ++++++");
   L1 := Get_Or_Create (Db, Create ("file1.ali"), Project);
   F1 := Get_Or_Create (Db, Create ("file1.adb"), L1);
   Dump (Db);

   New_Line; Put_Line ("++++++++ Second file ++++++");
   L2 := Get_Or_Create (Db, Create ("file2.ali"), Project);
   F2 := Get_Or_Create (Db, Create ("file2.adb"), L2);
   Add_Depends_On (F1, F2);
   Add_Depends_On (F2, F1);
   Dump (Db);

   New_Line; Put_Line ("++++++++ Adding entities ++++++");
   E1 := Get_Or_Create (Db, "Ent1", F1, 10, 20);
   Set_Kind (E1, (Record_Kind, False, False, False));
   Set_End_Of_Scope (E1, (F1, 10, 25), End_Of_Spec);
   Set_End_Of_Scope (E1, (F1, 10, 26), End_Of_Body);
   Add_Reference (E1, (F2, 12, 21), Reference);

   E3 := Get_Or_Create (Db, "Type1", F2, 10, 18);
   Add_Primitive_Subprogram (E3, E1);

   E4 := Get_Or_Create (Db, "Type2", F1, 10, 18);
   Set_Kind (E4, (Class, False, Is_Type => True, Is_Abstract => False));
   Set_Type_Of (E4, E3);

   E2 := Get_Or_Create (Db, "Ent2", F2, 11, 21);
   Set_Is_Renaming_Of (E2, E1);
   Set_Type_Of (E2, E3);
   Dump (Db);

   --  Keep some Refs
   if Test_Refs then
      Ref (E1);
      Ref (F1);
   end if;

   New_Line; Put_Line ("++++++++ Reseting File1 +++++++");
   Reset (F1);
   Dump (Db);

   New_Line; Put_Line ("++++++++ Reseting File2 +++++++");
   Reset (F2);
   Dump (Db);

   if Test_Refs then
      New_Line; Put_Line ("++++++++ Testing references +++++++");
      Dump (E1, Full => True, Name => "");
      Dump (F1);
   end if;

   New_Line; Put_Line ("++++++++ Destroying Db +++++++");
   Destroy (Db);
   Dump (Db);

   if Test_Refs then
      New_Line; Put_Line ("++++++++ Testing references +++++++");
      Dump (E1, Full => True, Name => "");
      Dump (F1);
   end if;

   Traces.Finalize;
end Test_Entities;
