-----------------------------------------------------------------------
--              GtkAda - Ada95 binding for Gtk+/Gnome                --
--                                                                   --
--                   Copyright (C) 2005 AdaCore                      --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-- As a special exception, if other files instantiate generics from  --
-- this unit, or you link this unit with other files to produce an   --
-- executable, this  unit  does not  by itself cause  the resulting  --
-- executable to be covered by the GNU General Public License. This  --
-- exception does not however invalidate any other reasons why the   --
-- executable file  might be covered by the  GNU Public License.     --
-----------------------------------------------------------------------

with Gtk.Enums;                  use Gtk.Enums;
with Gtk.Main;
with Gtk.Scrolled_Window;        use Gtk.Scrolled_Window;
with Gtk.Box;                    use Gtk.Box;
with Gtk.Window;                 use Gtk.Window;
with Gtk.Menu;                   use Gtk.Menu;
with Gtk.Menu_Bar;               use Gtk.Menu_Bar;
with Gtk.Menu_Item;              use Gtk.Menu_Item;
with Gtkada.Text_Buffer;         use Gtkada.Text_Buffer;
with Gtkada.Text_View;           use Gtkada.Text_View;

with Test_Text_Box;              use Test_Text_Box;

procedure Run_Test_Text_Box is
   Main_Window     : Gtk_Window;
   Scrolled_Window : Gtk_Scrolled_Window;
   Vbox            : Gtk_Vbox;
   Buffer          : Gtkada_Text_Buffer;
   View            : Gtkada_Text_View;
   Menu            : Gtk_Menu;
   Menu_Bar        : Gtk_Menu_Bar;
   Menu_Item       : Gtk_Menu_Item;

begin
   Gtk.Main.Set_Locale;
   Gtk.Main.Init;

   Gtk_New (Main_Window);
   Set_USize (Main_Window, 600, 450);

   Gtk_New_Vbox (Vbox);
   Add (Main_Window, Vbox);

   Gtk_New (Scrolled_Window);
   Set_Policy (Scrolled_Window, Policy_Automatic, Policy_Automatic);

   Gtk_New (Buffer);

   Gtk_New (View, Buffer);
   Add (Scrolled_Window, View);

   Gtk_New (Menu_Bar);

   Gtk_New (Menu);

   Gtk_New (Menu_Item, "Edit");
   Set_Submenu (Menu_Item, Menu);
   Add (Menu_Bar, Menu_Item);

   Gtk_New (Menu_Item, "Clear");
   Text_Buffer_Callback.Connect
     (Menu_Item, "activate", On_Clear'Access, Buffer);
   Add (Menu, Menu_Item);

   Pack_Start (Vbox, Menu_Bar, False, True, 0);
   Pack_Start (Vbox, Scrolled_Window, True, True, 0);

   Show_All (Main_Window);

   Gtk.Main.Main;
end Run_Test_Text_Box;
