
--  Several tests to be done:
--
--  * Run the program, and check whether the "Interrupt" button works
--  * Run the program, and exit gvd from the title bar. Shouldn't get any
--    error
--  * Run the program, and check that no other command can be executed at
--    the same time

--  * When running a non-infinite loop, the execution should be almost
--    immediate (compare with an xterm).

with Ada.Text_IO;   use Ada.Text_IO;
procedure Infinite is
   Num_Loop : constant := 5000;
begin
   if Num_Loop = 0 then
      loop
         delay 1.0;
         Put_Line ("Loop");
      end loop;

   else
      for J in 1 .. Num_Loop loop
         Put_Line ("Loop " & J'Img);
      end loop;
   end if;
end Infinite;
