/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
//FILE: gnaural.h - variables and functions that will be used across several files
//NOTE: this file requires GTK and various other headers to be declared first

#ifndef GNAURAL_H
#define GNAURAL_H

//I thought GTK declared something called G_PLATFORM_WIN32 and G_OS_WIN32,
//but the documentation is unclear and apparently these declarations can be unreliable. So
//I came up with GNAURAL_WIN32 -- a lot hinges on it being declared, so beware. 
//It should get defined via autoconf/automake magic.
//#define GNAURAL_WIN32

#ifdef GNAURAL_WIN32
#include <windows.h>            //for win32
#include <mmsystem.h>           //for sound on win32
#include <io.h>                 //for binary-mode stdout on Win32
#include <fcntl.h>              //for binary-mode stdout on Win32
#include <process.h>            //for _spawn on Win32
#endif

extern CBinauralBeat *bb;
extern int gnaural_ManualFreqBaseControl;
extern float gnaural_FreqBase_old;
extern float gnaural_OverallVolume;     // range 0 to 1
extern float gnaural_OverallBalance;    //range -1 to 1; zero is neutral
//extern GtkWindow *window1;
extern int gnaural_pauseflag;
extern char *gnaural_writefilename;     //used to determine if a write thread is running
extern void bbl_DialogInput (gchar * message, gchar * title);
extern int cmdline_d;           //Show debugging information

//global string and Path/File variables:
extern char szDir_CurrentWorking[PATH_MAX + 1]; //whatever directory user called gnaural from
extern char szDir_Home[PATH_MAX + 1];   //  ~/    -- not meaningfull in Win32
extern char szDir_Gnaural[PATH_MAX + 1];        // ~/.gnaural/    -- not meaningfull in Win32
extern char szFile_gnaural_schedule_file[PATH_MAX + 1]; // ~/.gnaural/gnaural_schedule.txt
extern char *szFile_ExecutablePath;     //so program can call itself to make MP3
extern char szGnauralHelp[];
extern char szPath_Temp[PATH_MAX + PATH_MAX + 1];       //used to copy the other paths and strcat filenames-to; could use gnaural_tmpstr, but could encounter threading conflicts

extern void *bbl_writethreadWAV (void *ptr);
extern void bbl_do_writethreadWAV (char *);     //sets up the write thread requested by callback.cpp
//extern void bbl_writethreadMP3 (void *);      //needed so user can see progress on MP3 (know when it is done, basically)
//extern void bbl_do_writethreadMP3 (char *);   //sets up the write thread requested by callback.cpp
extern void *bbl_soundthread (void *ptr);
extern void bbl_mainInit ();    //bbl: set up all vars, widgets, etc. -- must be called AFTER gui graphical stuff is ready for input
extern void bbl_InitGUIVars (); //sets all the GUI handles in main.h to corresponding Glade entries
extern void bbl_InitGUI ();     //inits the gui according to what it has found in userfile and-or BinauralBeat object
extern bool bbl_UpdateGUI_Labels ();    //bbl: updates textual info on main window, hit every second (the main GUI updater)
extern void bbl_UpdateGUI_Info ();      //basically just sets bb->InfoFlag to BB_NEWENTRY then calls bbl_UpdateGUI_LoopInfo();
extern void bbl_UpdateGUI_LoopInfo ();  //bbl: updates the Program Status window
extern void bbl_UpdateGUI_LoopModeInfo ();      //bbl: updates projected runtime info (that's it; should change name of func)
extern void bbl_UpdateGUI_ManualControlInfo (); //really just needed whenever init'ing a new schedule, since in GTK slider keeps track of itself
extern void bbl_UpdateGUI_Progressbar ();
extern void bbl_UpdateGUI_UserDataInfo ();
extern void bbl_UpdateGUI_Statusbar (char *msg1, char *msg2);
extern void bbl_UpdateGUI_ProgramStatus (char *msg1, char *msg2);
extern void bbl_UpdateGUI_Filename ();
extern void bbl_mainCleanup (); //bbl: cleanup all alloted memory, etc.
extern void bbl_InterceptCtrl_C (int sig);      //capture Ctrl-C in case user kills it from a window
extern int bbl_SoundInit ();
extern void bbl_SoundCleanup (void);
extern void bbl_UpdateTerminalGUI (FILE * gstream);     //gives a way to see info in a terminal
extern void bbl_ParseCmdLine (int argc, char *argv[]);
extern void bbl_RunCmdLineMode ();      // also parses command line, but necessary for a variety of reasons...
extern void bbl_SetupPathsAndFiles ();  //returns non-0 if something went wrong enough to exit
extern int bbl_TestPathOrFileExistence (char *PathName);        //returns non-0 if file or directory doesn't exist.
extern void bbl_SetIcon ();     //makes an icon then sets it as default (ugly, but cross-platform path inconsistencies are uglier)
void bbl_FixPathTerminator (char *pth);

//20070224these were in callbacks.cpp, moved to main.cpp
extern void bbl_ScheduleGUI_reinit ();
extern void bbl_ScheduleGUI_redraw (gboolean rescaleflag);
extern void bbl_BackupDataPoints ();
//The following three are the only functions associated with reading XML
extern int bbl_XMLReadFile (char *tmpfilename); //20070224 - tries to open and parse an XML file; returns 0 if successful
extern int main_XMLEventDataParser (const gchar * DataType, const gchar * Value);       //only called by main_XMLParser
extern void main_XMLParser (const gchar * CurrentElement,       //this must always be a valid string
                            const gchar * Attribute,    //beware: this will equal NULL if there are none
                            const gchar * Value);       //beware: this will equal NULL to announce end of CurrnetElement

extern void bbl_SaveScheduleFile (char *filename, int type);    //type==1 is oldstyle comma deliminator, type==2 is gnaural2 style XML 
extern int bbl_AskForOpenFilename (char *userfilename);
extern int bbl_AskForSaveAsFilename (char *userfilename);
extern void bbl_OnUserOpenFile ();      //callbacks.cpp calls this when user wants to open a file
extern void bbl_OnUserSaveAsFile ();
extern void bbl_ScheduleGUI_ApplyToBBSchedule ();
extern void bbl_on_hscaleBalance (float range);
extern void bbl_on_hscaleVolume (float range);

//menu/button handlers:
extern void bbl_OnButton_Play ();
extern void bbl_OnButton_Stop ();
extern void bbl_OnReloadFile ();
extern void bbl_OnRestoreDefaultFile ();
extern void bbl_AboutDialogBox ();
extern bool bbl_MessageDialogBox (char *msg, GtkMessageType messagetype =
                                  GTK_MESSAGE_ERROR,
                                  GtkButtonsType buttonformation =
                                  GTK_BUTTONS_OK);
static void bbl_activate_url (GtkAboutDialog * about, const gchar * url,
                              gpointer data);
#endif //GNAURAL_H
