/*
 * Copyright (C) 2004,2005 Olivier Rossiny <mrfreeze@tuxfamily.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

GtkWidget*
create_netswitch (void)
{
  GtkWidget *netswitch;
  GdkPixbuf *netswitch_icon_pixbuf;
  GtkWidget *vbox1;
  GtkWidget *menubar1;
  GtkWidget *profil;
  GtkWidget *profil_menu;
  GtkWidget *actualiser_profils;
  GtkWidget *image208;
  GtkWidget *autoconnect;
  GtkWidget *image209;
  GtkWidget *hide_the_window;
  GtkWidget *image210;
  GtkWidget *sep2;
  GtkWidget *import;
  GtkWidget *image211;
  GtkWidget *export;
  GtkWidget *image212;
  GtkWidget *sep1;
  GtkWidget *quitter;
  GtkWidget *menuitem4;
  GtkWidget *menuitem4_menu;
  GtkWidget *___propos1;
  GtkWidget *notebook;
  GtkWidget *activation_vert;
  GtkWidget *table_netswitch;
  GtkWidget *pppbox;
  GtkWidget *label123;
  GtkWidget *scrolledwindow4;
  GtkWidget *treeview1;
  GtkWidget *toolbarppp;
  GtkIconSize tmp_toolbar_icon_size;
  GtkWidget *addppp;
  GtkWidget *editppp;
  GtkWidget *deleteppp;
  GtkWidget *hbox2;
  GtkWidget *progres;
  GtkWidget *label42;
  GtkWidget *recherche_box;
  GtkWidget *hbox9;
  GtkWidget *fermer2;
  GtkWidget *refresh_scan;
  GtkWidget *scrolledwindow1;
  GtkWidget *treescan;
  GtkWidget *label43;
  GtkAccelGroup *accel_group;

  accel_group = gtk_accel_group_new ();

  netswitch = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (netswitch, "netswitch");
  gtk_window_set_title (GTK_WINDOW (netswitch), _("Netswitch - Network profiles manager"));
  gtk_window_set_position (GTK_WINDOW (netswitch), GTK_WIN_POS_CENTER);
  gtk_window_set_resizable (GTK_WINDOW (netswitch), FALSE);
  netswitch_icon_pixbuf = create_pixbuf ("netswitch-16x16.png");
  if (netswitch_icon_pixbuf)
    {
      gtk_window_set_icon (GTK_WINDOW (netswitch), netswitch_icon_pixbuf);
      gdk_pixbuf_unref (netswitch_icon_pixbuf);
    }
  gtk_window_set_type_hint (GTK_WINDOW (netswitch), GDK_WINDOW_TYPE_HINT_DIALOG);
  gtk_window_set_gravity (GTK_WINDOW (netswitch), GDK_GRAVITY_CENTER);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox1, "vbox1");
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (netswitch), vbox1);

  menubar1 = gtk_menu_bar_new ();
  gtk_widget_set_name (menubar1, "menubar1");
  gtk_widget_show (menubar1);
  gtk_box_pack_start (GTK_BOX (vbox1), menubar1, FALSE, FALSE, 0);

  profil = gtk_menu_item_new_with_mnemonic (_("_Profiles"));
  gtk_widget_set_name (profil, "profil");
  gtk_widget_show (profil);
  gtk_container_add (GTK_CONTAINER (menubar1), profil);

  profil_menu = gtk_menu_new ();
  gtk_widget_set_name (profil_menu, "profil_menu");
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (profil), profil_menu);

  actualiser_profils = gtk_image_menu_item_new_with_mnemonic (_("Refresh profiles lists"));
  gtk_widget_set_name (actualiser_profils, "actualiser_profils");
  gtk_widget_show (actualiser_profils);
  gtk_container_add (GTK_CONTAINER (profil_menu), actualiser_profils);
  gtk_widget_add_accelerator (actualiser_profils, "activate", accel_group,
                              GDK_R, (GdkModifierType) GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  image208 = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_MENU);
  gtk_widget_set_name (image208, "image208");
  gtk_widget_show (image208);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (actualiser_profils), image208);

  autoconnect = gtk_image_menu_item_new_with_mnemonic (_("Autoconnection"));
  gtk_widget_set_name (autoconnect, "autoconnect");
  gtk_widget_show (autoconnect);
  gtk_container_add (GTK_CONTAINER (profil_menu), autoconnect);
  gtk_widget_add_accelerator (autoconnect, "activate", accel_group,
                              GDK_space, (GdkModifierType) GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  image209 = gtk_image_new_from_stock ("gtk-network", GTK_ICON_SIZE_MENU);
  gtk_widget_set_name (image209, "image209");
  gtk_widget_show (image209);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (autoconnect), image209);

  hide_the_window = gtk_image_menu_item_new_with_mnemonic (_("Hide the window"));
  gtk_widget_set_name (hide_the_window, "hide_the_window");
  gtk_widget_show (hide_the_window);
  gtk_container_add (GTK_CONTAINER (profil_menu), hide_the_window);
  gtk_widget_add_accelerator (hide_the_window, "activate", accel_group,
                              GDK_Escape, (GdkModifierType) 0,
                              GTK_ACCEL_VISIBLE);

  image210 = gtk_image_new_from_stock ("gtk-remove", GTK_ICON_SIZE_MENU);
  gtk_widget_set_name (image210, "image210");
  gtk_widget_show (image210);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (hide_the_window), image210);

  sep2 = gtk_separator_menu_item_new ();
  gtk_widget_set_name (sep2, "sep2");
  gtk_widget_show (sep2);
  gtk_container_add (GTK_CONTAINER (profil_menu), sep2);
  gtk_widget_set_sensitive (sep2, FALSE);

  import = gtk_image_menu_item_new_with_mnemonic (_("Import the profile(s)"));
  gtk_widget_set_name (import, "import");
  gtk_widget_show (import);
  gtk_container_add (GTK_CONTAINER (profil_menu), import);

  image211 = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_MENU);
  gtk_widget_set_name (image211, "image211");
  gtk_widget_show (image211);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (import), image211);

  export = gtk_image_menu_item_new_with_mnemonic (_("Export the profile(s)"));
  gtk_widget_set_name (export, "export");
  gtk_widget_show (export);
  gtk_container_add (GTK_CONTAINER (profil_menu), export);

  image212 = gtk_image_new_from_stock ("gtk-save", GTK_ICON_SIZE_MENU);
  gtk_widget_set_name (image212, "image212");
  gtk_widget_show (image212);
  gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (export), image212);

  sep1 = gtk_separator_menu_item_new ();
  gtk_widget_set_name (sep1, "sep1");
  gtk_widget_show (sep1);
  gtk_container_add (GTK_CONTAINER (profil_menu), sep1);
  gtk_widget_set_sensitive (sep1, FALSE);

  quitter = gtk_image_menu_item_new_from_stock ("gtk-quit", accel_group);
  gtk_widget_set_name (quitter, "quitter");
  gtk_widget_show (quitter);
  gtk_container_add (GTK_CONTAINER (profil_menu), quitter);

  menuitem4 = gtk_menu_item_new_with_mnemonic (_("_Help"));
  gtk_widget_set_name (menuitem4, "menuitem4");
  gtk_widget_show (menuitem4);
  gtk_container_add (GTK_CONTAINER (menubar1), menuitem4);

  menuitem4_menu = gtk_menu_new ();
  gtk_widget_set_name (menuitem4_menu, "menuitem4_menu");
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem4), menuitem4_menu);

  ___propos1 = gtk_image_menu_item_new_from_stock ("gtk-about", accel_group);
  gtk_widget_set_name (___propos1, "___propos1");
  gtk_widget_show (___propos1);
  gtk_container_add (GTK_CONTAINER (menuitem4_menu), ___propos1);

  notebook = gtk_notebook_new ();
  gtk_widget_set_name (notebook, "notebook");
  gtk_widget_show (notebook);
  gtk_box_pack_start (GTK_BOX (vbox1), notebook, FALSE, FALSE, 0);

  activation_vert = gtk_vbox_new (FALSE, 10);
  gtk_widget_set_name (activation_vert, "activation_vert");
  gtk_widget_show (activation_vert);
  gtk_container_add (GTK_CONTAINER (notebook), activation_vert);
  gtk_container_set_border_width (GTK_CONTAINER (activation_vert), 5);

  table_netswitch = gtk_hbox_new (FALSE, 5);
  gtk_widget_set_name (table_netswitch, "table_netswitch");
  gtk_widget_show (table_netswitch);
  gtk_box_pack_start (GTK_BOX (activation_vert), table_netswitch, FALSE, FALSE, 0);

  pppbox = gtk_vbox_new (FALSE, 5);
  gtk_widget_set_name (pppbox, "pppbox");
  gtk_widget_show (pppbox);
  gtk_box_pack_start (GTK_BOX (table_netswitch), pppbox, TRUE, FALSE, 0);

  label123 = gtk_label_new (_("PPP Connections"));
  gtk_widget_set_name (label123, "label123");
  gtk_widget_show (label123);
  gtk_box_pack_start (GTK_BOX (pppbox), label123, FALSE, FALSE, 0);

  scrolledwindow4 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow4, "scrolledwindow4");
  gtk_widget_show (scrolledwindow4);
  gtk_box_pack_start (GTK_BOX (pppbox), scrolledwindow4, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow4), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow4), GTK_SHADOW_IN);

  treeview1 = gtk_tree_view_new ();
  gtk_widget_set_name (treeview1, "treeview1");
  gtk_widget_show (treeview1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow4), treeview1);

  toolbarppp = gtk_toolbar_new ();
  gtk_widget_set_name (toolbarppp, "toolbarppp");
  gtk_widget_show (toolbarppp);
  gtk_box_pack_start (GTK_BOX (pppbox), toolbarppp, FALSE, FALSE, 0);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbarppp), GTK_TOOLBAR_ICONS);
  gtk_toolbar_set_tooltips (GTK_TOOLBAR (toolbarppp), FALSE);
  gtk_toolbar_set_show_arrow (GTK_TOOLBAR (toolbarppp), FALSE);
  tmp_toolbar_icon_size = gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbarppp));

  addppp = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-add");
  gtk_widget_set_name (addppp, "addppp");
  gtk_widget_show (addppp);
  gtk_container_add (GTK_CONTAINER (toolbarppp), addppp);

  editppp = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-edit");
  gtk_widget_set_name (editppp, "editppp");
  gtk_widget_show (editppp);
  gtk_container_add (GTK_CONTAINER (toolbarppp), editppp);

  deleteppp = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-delete");
  gtk_widget_set_name (deleteppp, "deleteppp");
  gtk_widget_show (deleteppp);
  gtk_container_add (GTK_CONTAINER (toolbarppp), deleteppp);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox2, "hbox2");
  gtk_widget_show (hbox2);
  gtk_box_pack_end (GTK_BOX (activation_vert), hbox2, FALSE, FALSE, 0);

  progres = gtk_progress_bar_new ();
  gtk_widget_set_name (progres, "progres");
  gtk_box_pack_start (GTK_BOX (hbox2), progres, TRUE, FALSE, 0);

  label42 = gtk_label_new (_("Profiles configuration"));
  gtk_widget_set_name (label42, "label42");
  gtk_widget_show (label42);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 0), label42);

  recherche_box = gtk_vbox_new (FALSE, 10);
  gtk_widget_set_name (recherche_box, "recherche_box");
  gtk_container_add (GTK_CONTAINER (notebook), recherche_box);
  gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (notebook), recherche_box,
                                      FALSE, FALSE, GTK_PACK_START);
  gtk_container_set_border_width (GTK_CONTAINER (recherche_box), 5);

  hbox9 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox9, "hbox9");
  gtk_widget_show (hbox9);
  gtk_box_pack_end (GTK_BOX (recherche_box), hbox9, FALSE, FALSE, 0);

  fermer2 = gtk_button_new_from_stock ("gtk-close");
  gtk_widget_set_name (fermer2, "fermer2");
  gtk_widget_show (fermer2);
  gtk_box_pack_start (GTK_BOX (hbox9), fermer2, FALSE, FALSE, 0);

  refresh_scan = gtk_button_new_from_stock ("gtk-refresh");
  gtk_widget_set_name (refresh_scan, "refresh_scan");
  gtk_widget_show (refresh_scan);
  gtk_box_pack_end (GTK_BOX (hbox9), refresh_scan, FALSE, FALSE, 0);
  gtk_widget_add_accelerator (refresh_scan, "clicked", accel_group,
                              GDK_Return, (GdkModifierType) GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow1, "scrolledwindow1");
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (recherche_box), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_SHADOW_ETCHED_IN);

  treescan = gtk_tree_view_new ();
  gtk_widget_set_name (treescan, "treescan");
  gtk_widget_show (treescan);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), treescan);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treescan), TRUE);
  gtk_tree_view_set_reorderable (GTK_TREE_VIEW (treescan), TRUE);
  gtk_tree_view_set_hover_selection (GTK_TREE_VIEW (treescan), TRUE);

  label43 = gtk_label_new (_("Active networks"));
  gtk_widget_set_name (label43, "label43");
  gtk_widget_show (label43);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 1), label43);

  g_signal_connect ((gpointer) netswitch, "realize",
                    G_CALLBACK (maj_liste),
                    NULL);
  g_signal_connect ((gpointer) netswitch, "delete_event",
                    G_CALLBACK (gtk_main_quit),
                    NULL);
  g_signal_connect ((gpointer) actualiser_profils, "activate",
                    G_CALLBACK (on_actualiser_profils_activate),
                    NULL);
  g_signal_connect ((gpointer) autoconnect, "activate",
                    G_CALLBACK (on_autoconnect_activate),
                    NULL);
  g_signal_connect ((gpointer) hide_the_window, "activate",
                    G_CALLBACK (on_hide_the_window_activate),
                    NULL);
  g_signal_connect ((gpointer) import, "activate",
                    G_CALLBACK (on_import_activate),
                    NULL);
  g_signal_connect ((gpointer) export, "activate",
                    G_CALLBACK (on_export_activate),
                    NULL);
  g_signal_connect ((gpointer) quitter, "activate",
                    G_CALLBACK (gtk_main_quit),
                    NULL);
  g_signal_connect ((gpointer) ___propos1, "activate",
                    G_CALLBACK (on_btn_about_clicked),
                    NULL);
  g_signal_connect ((gpointer) fermer2, "clicked",
                    G_CALLBACK (gtk_main_quit),
                    NULL);
  g_signal_connect_swapped ((gpointer) refresh_scan, "clicked",
                            G_CALLBACK (rescan),
                            GTK_OBJECT (treescan));

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (netswitch, netswitch, "netswitch");
  GLADE_HOOKUP_OBJECT (netswitch, vbox1, "vbox1");
  GLADE_HOOKUP_OBJECT (netswitch, menubar1, "menubar1");
  GLADE_HOOKUP_OBJECT (netswitch, profil, "profil");
  GLADE_HOOKUP_OBJECT (netswitch, profil_menu, "profil_menu");
  GLADE_HOOKUP_OBJECT (netswitch, actualiser_profils, "actualiser_profils");
  GLADE_HOOKUP_OBJECT (netswitch, image208, "image208");
  GLADE_HOOKUP_OBJECT (netswitch, autoconnect, "autoconnect");
  GLADE_HOOKUP_OBJECT (netswitch, image209, "image209");
  GLADE_HOOKUP_OBJECT (netswitch, hide_the_window, "hide_the_window");
  GLADE_HOOKUP_OBJECT (netswitch, image210, "image210");
  GLADE_HOOKUP_OBJECT (netswitch, sep2, "sep2");
  GLADE_HOOKUP_OBJECT (netswitch, import, "import");
  GLADE_HOOKUP_OBJECT (netswitch, image211, "image211");
  GLADE_HOOKUP_OBJECT (netswitch, export, "export");
  GLADE_HOOKUP_OBJECT (netswitch, image212, "image212");
  GLADE_HOOKUP_OBJECT (netswitch, sep1, "sep1");
  GLADE_HOOKUP_OBJECT (netswitch, quitter, "quitter");
  GLADE_HOOKUP_OBJECT (netswitch, menuitem4, "menuitem4");
  GLADE_HOOKUP_OBJECT (netswitch, menuitem4_menu, "menuitem4_menu");
  GLADE_HOOKUP_OBJECT (netswitch, ___propos1, "___propos1");
  GLADE_HOOKUP_OBJECT (netswitch, notebook, "notebook");
  GLADE_HOOKUP_OBJECT (netswitch, activation_vert, "activation_vert");
  GLADE_HOOKUP_OBJECT (netswitch, table_netswitch, "table_netswitch");
  GLADE_HOOKUP_OBJECT (netswitch, pppbox, "pppbox");
  GLADE_HOOKUP_OBJECT (netswitch, label123, "label123");
  GLADE_HOOKUP_OBJECT (netswitch, scrolledwindow4, "scrolledwindow4");
  GLADE_HOOKUP_OBJECT (netswitch, treeview1, "treeview1");
  GLADE_HOOKUP_OBJECT (netswitch, toolbarppp, "toolbarppp");
  GLADE_HOOKUP_OBJECT (netswitch, addppp, "addppp");
  GLADE_HOOKUP_OBJECT (netswitch, editppp, "editppp");
  GLADE_HOOKUP_OBJECT (netswitch, deleteppp, "deleteppp");
  GLADE_HOOKUP_OBJECT (netswitch, hbox2, "hbox2");
  GLADE_HOOKUP_OBJECT (netswitch, progres, "progres");
  GLADE_HOOKUP_OBJECT (netswitch, label42, "label42");
  GLADE_HOOKUP_OBJECT (netswitch, recherche_box, "recherche_box");
  GLADE_HOOKUP_OBJECT (netswitch, hbox9, "hbox9");
  GLADE_HOOKUP_OBJECT (netswitch, fermer2, "fermer2");
  GLADE_HOOKUP_OBJECT (netswitch, refresh_scan, "refresh_scan");
  GLADE_HOOKUP_OBJECT (netswitch, scrolledwindow1, "scrolledwindow1");
  GLADE_HOOKUP_OBJECT (netswitch, treescan, "treescan");
  GLADE_HOOKUP_OBJECT (netswitch, label43, "label43");

  gtk_window_add_accel_group (GTK_WINDOW (netswitch), accel_group);

  return netswitch;
}

GtkWidget*
create_PassDialog (void)
{
  GtkWidget *PassDialog;
  GdkPixbuf *PassDialog_icon_pixbuf;
  GtkWidget *dialog_vbox1;
  GtkWidget *table8;
  GtkWidget *lbl_title;
  GtkWidget *lbl_msg;
  GtkWidget *image173;
  GtkWidget *pwd_entry;
  GtkWidget *label70;
  GtkWidget *dialog_action_area1;
  GtkWidget *cancelbutton1;
  GtkWidget *okbutton1;
  GtkAccelGroup *accel_group;

  accel_group = gtk_accel_group_new ();

  PassDialog = gtk_dialog_new ();
  gtk_widget_set_name (PassDialog, "PassDialog");
  gtk_window_set_title (GTK_WINDOW (PassDialog), _("Enter Password"));
  gtk_window_set_modal (GTK_WINDOW (PassDialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (PassDialog), FALSE);
  PassDialog_icon_pixbuf = create_pixbuf ("netswitch-16x16.png");
  if (PassDialog_icon_pixbuf)
    {
      gtk_window_set_icon (GTK_WINDOW (PassDialog), PassDialog_icon_pixbuf);
      gdk_pixbuf_unref (PassDialog_icon_pixbuf);
    }
  gtk_window_set_type_hint (GTK_WINDOW (PassDialog), GDK_WINDOW_TYPE_HINT_DIALOG);
  gtk_dialog_set_has_separator (GTK_DIALOG (PassDialog), FALSE);

  dialog_vbox1 = GTK_DIALOG (PassDialog)->vbox;
  gtk_widget_set_name (dialog_vbox1, "dialog_vbox1");
  gtk_widget_show (dialog_vbox1);

  table8 = gtk_table_new (3, 6, FALSE);
  gtk_widget_set_name (table8, "table8");
  gtk_widget_show (table8);
  gtk_box_pack_end (GTK_BOX (dialog_vbox1), table8, TRUE, FALSE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table8), 15);
  gtk_table_set_col_spacings (GTK_TABLE (table8), 15);

  lbl_title = gtk_label_new (_("<big><b>Please enter your root password</b></big>"));
  gtk_widget_set_name (lbl_title, "lbl_title");
  gtk_widget_show (lbl_title);
  gtk_table_attach (GTK_TABLE (table8), lbl_title, 2, 5, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (lbl_title), TRUE);
  gtk_misc_set_alignment (GTK_MISC (lbl_title), 0, 0.5);

  lbl_msg = gtk_label_new (_("You need administrator privileges to use\nthis tool. Enter a password to modify\nyour system configuration."));
  gtk_widget_set_name (lbl_msg, "lbl_msg");
  gtk_widget_show (lbl_msg);
  gtk_table_attach (GTK_TABLE (table8), lbl_msg, 2, 5, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_line_wrap (GTK_LABEL (lbl_msg), TRUE);
  gtk_misc_set_alignment (GTK_MISC (lbl_msg), 0, 0.5);

  image173 = gtk_image_new_from_icon_name ("gtk-dialog-authentication", GTK_ICON_SIZE_DIALOG);
  gtk_widget_set_name (image173, "image173");
  gtk_widget_show (image173);
  gtk_table_attach (GTK_TABLE (table8), image173, 1, 2, 0, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  pwd_entry = gtk_entry_new ();
  gtk_widget_set_name (pwd_entry, "pwd_entry");
  gtk_widget_show (pwd_entry);
  gtk_table_attach (GTK_TABLE (table8), pwd_entry, 3, 4, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_visibility (GTK_ENTRY (pwd_entry), FALSE);

  label70 = gtk_label_new_with_mnemonic (_("_Password:"));
  gtk_widget_set_name (label70, "label70");
  gtk_widget_show (label70);
  gtk_table_attach (GTK_TABLE (table8), label70, 2, 3, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label70), 0, 0.5);

  dialog_action_area1 = GTK_DIALOG (PassDialog)->action_area;
  gtk_widget_set_name (dialog_action_area1, "dialog_action_area1");
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_set_name (cancelbutton1, "cancelbutton1");
  gtk_widget_show (cancelbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (PassDialog), cancelbutton1, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);
  gtk_widget_add_accelerator (cancelbutton1, "clicked", accel_group,
                              GDK_Escape, (GdkModifierType) 0,
                              GTK_ACCEL_VISIBLE);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_set_name (okbutton1, "okbutton1");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (PassDialog), okbutton1, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);
  gtk_widget_add_accelerator (okbutton1, "clicked", accel_group,
                              GDK_Return, (GdkModifierType) 0,
                              GTK_ACCEL_VISIBLE);

  gtk_label_set_mnemonic_widget (GTK_LABEL (label70), pwd_entry);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (PassDialog, PassDialog, "PassDialog");
  GLADE_HOOKUP_OBJECT_NO_REF (PassDialog, dialog_vbox1, "dialog_vbox1");
  GLADE_HOOKUP_OBJECT (PassDialog, table8, "table8");
  GLADE_HOOKUP_OBJECT (PassDialog, lbl_title, "lbl_title");
  GLADE_HOOKUP_OBJECT (PassDialog, lbl_msg, "lbl_msg");
  GLADE_HOOKUP_OBJECT (PassDialog, image173, "image173");
  GLADE_HOOKUP_OBJECT (PassDialog, pwd_entry, "pwd_entry");
  GLADE_HOOKUP_OBJECT (PassDialog, label70, "label70");
  GLADE_HOOKUP_OBJECT_NO_REF (PassDialog, dialog_action_area1, "dialog_action_area1");
  GLADE_HOOKUP_OBJECT (PassDialog, cancelbutton1, "cancelbutton1");
  GLADE_HOOKUP_OBJECT (PassDialog, okbutton1, "okbutton1");

  gtk_window_add_accel_group (GTK_WINDOW (PassDialog), accel_group);

  return PassDialog;
}

GtkWidget*
create_properties (void)
{
  GtkWidget *properties;
  GdkPixbuf *properties_icon_pixbuf;
  GtkWidget *dialog_vbox2;
  GtkWidget *vbox5;
  GtkWidget *hbox16;
  GtkWidget *label119;
  GtkWidget *nom;
  GtkWidget *notebook1;
  GtkWidget *vbox6;
  GtkWidget *hbox14;
  GtkWidget *label80;
  GtkWidget *device;
  GtkWidget *type;
  GtkWidget *bootproto;
  GtkWidget *table10;
  GtkWidget *label81;
  GtkWidget *label82;
  GtkWidget *label83;
  GtkWidget *label84;
  GtkWidget *ipaddr;
  GtkObject *netmask_adj;
  GtkWidget *netmask;
  GtkWidget *broadcast;
  GtkWidget *gateway;
  GtkWidget *expander2;
  GtkWidget *table16;
  GtkWidget *label121;
  GtkWidget *hwaddr;
  GtkWidget *label85;
  GtkObject *metric_adj;
  GtkWidget *metric;
  GtkWidget *label122;
  GtkWidget *netmask2;
  GtkWidget *label86;
  GtkWidget *vbox7;
  GtkWidget *peerdns;
  GtkWidget *hbox15;
  GtkWidget *label87;
  GtkWidget *domain;
  GtkWidget *resolv;
  GtkWidget *table11;
  GtkWidget *label88;
  GtkWidget *label89;
  GtkWidget *label90;
  GtkWidget *label91;
  GtkWidget *nameserver1;
  GtkWidget *nameserver2;
  GtkWidget *nameserver3;
  GtkWidget *nameserver4;
  GtkWidget *label92;
  GtkWidget *email;
  GtkWidget *label93;
  GtkWidget *label94;
  GtkWidget *label95;
  GtkWidget *label96;
  GtkWidget *smtp_server;
  GtkObject *smtp_port_adj;
  GtkWidget *smtp_port;
  GtkWidget *smtp_domain;
  GtkWidget *hseparator2;
  GtkWidget *label97;
  GtkWidget *label98;
  GtkWidget *requires_auth;
  GtkWidget *smtp_user;
  GtkWidget *smtp_pass;
  GtkWidget *label99;
  GtkWidget *notebook5;
  GtkWidget *table13;
  GtkWidget *label100;
  GtkWidget *label101;
  GtkWidget *label102;
  GtkWidget *label103;
  GtkWidget *nickname;
  GtkWidget *essid;
  GtkWidget *channel;
  GtkWidget *mode;
  GtkWidget *expander1;
  GtkWidget *table14;
  GtkWidget *label104;
  GtkWidget *label105;
  GtkWidget *label106;
  GtkWidget *label107;
  GtkWidget *label108;
  GtkWidget *label109;
  GtkWidget *nwid;
  GtkWidget *rts;
  GtkWidget *frag;
  GtkWidget *rate;
  GtkWidget *frequency;
  GtkWidget *sensibility;
  GtkWidget *label110;
  GtkWidget *label111;
  GtkWidget *vbox8;
  GtkWidget *hbox17;
  GtkWidget *label126;
  GtkWidget *encryption_type;
  GtkWidget *encrypt_notebook;
  GtkWidget *label128;
  GtkWidget *label127;
  GtkWidget *table15;
  GtkWidget *label112;
  GtkWidget *key4;
  GtkWidget *cle4;
  GSList *cle4_group = NULL;
  GtkWidget *label113;
  GtkWidget *label114;
  GtkWidget *label115;
  GtkWidget *key3;
  GtkWidget *key2;
  GtkWidget *key1;
  GtkWidget *cle3;
  GtkWidget *cle2;
  GtkWidget *cle1;
  GtkWidget *label116;
  GtkWidget *label124;
  GtkWidget *encryption_table;
  GtkWidget *label129;
  GtkWidget *label130;
  GtkWidget *wpa_protocol;
  GtkWidget *wpa_driver;
  GtkWidget *label132;
  GtkWidget *wpa_passphrase1;
  GtkWidget *label125;
  GtkWidget *label117;
  GtkWidget *label118;
  GtkWidget *services_pane;
  GtkWidget *services;
  GtkWidget *label120;
  GtkWidget *dialog_action_area2;
  GtkWidget *cancelbutton2;
  GtkWidget *okbutton2;

  properties = gtk_dialog_new ();
  gtk_widget_set_name (properties, "properties");
  gtk_window_set_title (GTK_WINDOW (properties), _("New network profile"));
  gtk_window_set_position (GTK_WINDOW (properties), GTK_WIN_POS_CENTER_ALWAYS);
  gtk_window_set_modal (GTK_WINDOW (properties), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (properties), FALSE);
  properties_icon_pixbuf = create_pixbuf ("netswitch-16x16.png");
  if (properties_icon_pixbuf)
    {
      gtk_window_set_icon (GTK_WINDOW (properties), properties_icon_pixbuf);
      gdk_pixbuf_unref (properties_icon_pixbuf);
    }
  gtk_window_set_type_hint (GTK_WINDOW (properties), GDK_WINDOW_TYPE_HINT_DIALOG);
  gtk_dialog_set_has_separator (GTK_DIALOG (properties), FALSE);

  dialog_vbox2 = GTK_DIALOG (properties)->vbox;
  gtk_widget_set_name (dialog_vbox2, "dialog_vbox2");
  gtk_widget_show (dialog_vbox2);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox5, "vbox5");
  gtk_widget_show (vbox5);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), vbox5, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox5), 5);

  hbox16 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox16, "hbox16");
  gtk_widget_show (hbox16);
  gtk_box_pack_start (GTK_BOX (vbox5), hbox16, TRUE, TRUE, 0);

  label119 = gtk_label_new (_("Profile name:"));
  gtk_widget_set_name (label119, "label119");
  gtk_widget_show (label119);
  gtk_box_pack_start (GTK_BOX (hbox16), label119, FALSE, FALSE, 0);

  nom = gtk_entry_new ();
  gtk_widget_set_name (nom, "nom");
  gtk_widget_show (nom);
  gtk_box_pack_start (GTK_BOX (hbox16), nom, TRUE, TRUE, 0);
  gtk_entry_set_text (GTK_ENTRY (nom), _("New-Profile"));

  notebook1 = gtk_notebook_new ();
  gtk_widget_set_name (notebook1, "notebook1");
  gtk_widget_show (notebook1);
  gtk_box_pack_start (GTK_BOX (vbox5), notebook1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (notebook1), 5);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox6, "vbox6");
  gtk_widget_show (vbox6);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox6);
  gtk_container_set_border_width (GTK_CONTAINER (vbox6), 5);

  hbox14 = gtk_hbox_new (FALSE, 7);
  gtk_widget_set_name (hbox14, "hbox14");
  gtk_widget_show (hbox14);
  gtk_box_pack_start (GTK_BOX (vbox6), hbox14, FALSE, FALSE, 0);

  label80 = gtk_label_new (_("Device"));
  gtk_widget_set_name (label80, "label80");
  gtk_widget_show (label80);
  gtk_box_pack_start (GTK_BOX (hbox14), label80, FALSE, FALSE, 0);

  device = gtk_entry_new ();
  gtk_widget_set_name (device, "device");
  gtk_widget_show (device);
  gtk_box_pack_start (GTK_BOX (hbox14), device, TRUE, TRUE, 0);

  type = gtk_check_button_new_with_mnemonic (_("WiFi device"));
  gtk_widget_set_name (type, "type");
  gtk_box_pack_end (GTK_BOX (hbox14), type, FALSE, FALSE, 0);

  bootproto = gtk_check_button_new_with_mnemonic (_("Use DHCP to get the configuration"));
  gtk_widget_set_name (bootproto, "bootproto");
  gtk_widget_show (bootproto);
  gtk_box_pack_start (GTK_BOX (vbox6), bootproto, FALSE, FALSE, 0);

  table10 = gtk_table_new (5, 3, FALSE);
  gtk_widget_set_name (table10, "table10");
  gtk_widget_show (table10);
  gtk_box_pack_start (GTK_BOX (vbox6), table10, TRUE, TRUE, 0);
  gtk_table_set_col_spacings (GTK_TABLE (table10), 5);

  label81 = gtk_label_new (_("IP address"));
  gtk_widget_set_name (label81, "label81");
  gtk_widget_show (label81);
  gtk_table_attach (GTK_TABLE (table10), label81, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label81), 0, 0.5);

  label82 = gtk_label_new (_("Number of bits in netmask"));
  gtk_widget_set_name (label82, "label82");
  gtk_widget_show (label82);
  gtk_table_attach (GTK_TABLE (table10), label82, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label82), 0, 0.5);

  label83 = gtk_label_new (_("Broadcast"));
  gtk_widget_set_name (label83, "label83");
  gtk_widget_show (label83);
  gtk_table_attach (GTK_TABLE (table10), label83, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label83), 0, 0.5);

  label84 = gtk_label_new (_("Gateway"));
  gtk_widget_set_name (label84, "label84");
  gtk_widget_show (label84);
  gtk_table_attach (GTK_TABLE (table10), label84, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label84), 0, 0.5);

  ipaddr = gtk_entry_new ();
  gtk_widget_set_name (ipaddr, "ipaddr");
  gtk_widget_show (ipaddr);
  gtk_table_attach (GTK_TABLE (table10), ipaddr, 1, 3, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_activates_default (GTK_ENTRY (ipaddr), TRUE);

  netmask_adj = gtk_adjustment_new (24, 1, 32, 1, 8, 8);
  netmask = gtk_spin_button_new (GTK_ADJUSTMENT (netmask_adj), 1, 0);
  gtk_widget_set_name (netmask, "netmask");
  gtk_widget_show (netmask);
  gtk_table_attach (GTK_TABLE (table10), netmask, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (netmask), TRUE);
  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (netmask), GTK_UPDATE_IF_VALID);
  gtk_spin_button_set_snap_to_ticks (GTK_SPIN_BUTTON (netmask), TRUE);

  broadcast = gtk_entry_new ();
  gtk_widget_set_name (broadcast, "broadcast");
  gtk_widget_show (broadcast);
  gtk_table_attach (GTK_TABLE (table10), broadcast, 1, 3, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  gateway = gtk_entry_new ();
  gtk_widget_set_name (gateway, "gateway");
  gtk_widget_show (gateway);
  gtk_table_attach (GTK_TABLE (table10), gateway, 1, 3, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  expander2 = gtk_expander_new (NULL);
  gtk_widget_set_name (expander2, "expander2");
  gtk_widget_show (expander2);
  gtk_table_attach (GTK_TABLE (table10), expander2, 0, 3, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  table16 = gtk_table_new (2, 2, TRUE);
  gtk_widget_set_name (table16, "table16");
  gtk_widget_show (table16);
  gtk_container_add (GTK_CONTAINER (expander2), table16);

  label121 = gtk_label_new (_("MAC address"));
  gtk_widget_set_name (label121, "label121");
  gtk_widget_show (label121);
  gtk_table_attach (GTK_TABLE (table16), label121, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label121), 0, 0.5);

  hwaddr = gtk_entry_new ();
  gtk_widget_set_name (hwaddr, "hwaddr");
  gtk_widget_show (hwaddr);
  gtk_table_attach (GTK_TABLE (table16), hwaddr, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label85 = gtk_label_new (_("Metric"));
  gtk_widget_set_name (label85, "label85");
  gtk_widget_show (label85);
  gtk_table_attach (GTK_TABLE (table16), label85, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label85), 0, 0.5);

  metric_adj = gtk_adjustment_new (0, 0, 100, 1, 10, 10);
  metric = gtk_spin_button_new (GTK_ADJUSTMENT (metric_adj), 1, 0);
  gtk_widget_set_name (metric, "metric");
  gtk_widget_show (metric);
  gtk_table_attach (GTK_TABLE (table16), metric, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (metric), TRUE);
  gtk_spin_button_set_snap_to_ticks (GTK_SPIN_BUTTON (metric), TRUE);

  label122 = gtk_label_new (_("Advanced configuration"));
  gtk_widget_set_name (label122, "label122");
  gtk_widget_show (label122);
  gtk_expander_set_label_widget (GTK_EXPANDER (expander2), label122);

  netmask2 = gtk_entry_new ();
  gtk_widget_set_name (netmask2, "netmask2");
  gtk_widget_show (netmask2);
  gtk_table_attach (GTK_TABLE (table10), netmask2, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_editable_set_editable (GTK_EDITABLE (netmask2), FALSE);

  label86 = gtk_label_new (_("Network"));
  gtk_widget_set_name (label86, "label86");
  gtk_widget_show (label86);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), label86);

  vbox7 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox7, "vbox7");
  gtk_widget_show (vbox7);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox7);
  gtk_container_set_border_width (GTK_CONTAINER (vbox7), 5);

  peerdns = gtk_check_button_new_with_mnemonic (_("Preserve local configuration\n(Ignore modifications from DHCP)"));
  gtk_widget_set_name (peerdns, "peerdns");
  gtk_widget_show (peerdns);
  gtk_box_pack_start (GTK_BOX (vbox7), peerdns, FALSE, FALSE, 0);

  hbox15 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox15, "hbox15");
  gtk_widget_show (hbox15);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox15, TRUE, FALSE, 0);

  label87 = gtk_label_new (_("Domain:"));
  gtk_widget_set_name (label87, "label87");
  gtk_widget_show (label87);
  gtk_box_pack_start (GTK_BOX (hbox15), label87, FALSE, FALSE, 0);

  domain = gtk_entry_new ();
  gtk_widget_set_name (domain, "domain");
  gtk_widget_show (domain);
  gtk_box_pack_start (GTK_BOX (hbox15), domain, TRUE, TRUE, 0);

  resolv = gtk_check_button_new_with_mnemonic (_("Precise the resolution parameters"));
  gtk_widget_set_name (resolv, "resolv");
  gtk_widget_show (resolv);
  gtk_box_pack_start (GTK_BOX (vbox7), resolv, FALSE, FALSE, 0);

  table11 = gtk_table_new (4, 2, FALSE);
  gtk_widget_set_name (table11, "table11");
  gtk_widget_show (table11);
  gtk_box_pack_start (GTK_BOX (vbox7), table11, TRUE, TRUE, 0);
  gtk_table_set_col_spacings (GTK_TABLE (table11), 5);

  label88 = gtk_label_new (_("Primary name server"));
  gtk_widget_set_name (label88, "label88");
  gtk_widget_show (label88);
  gtk_table_attach (GTK_TABLE (table11), label88, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label88), 0, 0.5);

  label89 = gtk_label_new (_("Secondary name server"));
  gtk_widget_set_name (label89, "label89");
  gtk_widget_show (label89);
  gtk_table_attach (GTK_TABLE (table11), label89, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label89), 0, 0.5);

  label90 = gtk_label_new (_("Name server #3"));
  gtk_widget_set_name (label90, "label90");
  gtk_widget_show (label90);
  gtk_table_attach (GTK_TABLE (table11), label90, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label90), 0, 0.5);

  label91 = gtk_label_new (_("Name server #4"));
  gtk_widget_set_name (label91, "label91");
  gtk_widget_show (label91);
  gtk_table_attach (GTK_TABLE (table11), label91, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label91), 0, 0.5);

  nameserver1 = gtk_entry_new ();
  gtk_widget_set_name (nameserver1, "nameserver1");
  gtk_widget_show (nameserver1);
  gtk_table_attach (GTK_TABLE (table11), nameserver1, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  nameserver2 = gtk_entry_new ();
  gtk_widget_set_name (nameserver2, "nameserver2");
  gtk_widget_show (nameserver2);
  gtk_table_attach (GTK_TABLE (table11), nameserver2, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  nameserver3 = gtk_entry_new ();
  gtk_widget_set_name (nameserver3, "nameserver3");
  gtk_widget_show (nameserver3);
  gtk_table_attach (GTK_TABLE (table11), nameserver3, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  nameserver4 = gtk_entry_new ();
  gtk_widget_set_name (nameserver4, "nameserver4");
  gtk_widget_show (nameserver4);
  gtk_table_attach (GTK_TABLE (table11), nameserver4, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label92 = gtk_label_new (_("Name server"));
  gtk_widget_set_name (label92, "label92");
  gtk_widget_show (label92);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 1), label92);

  email = gtk_table_new (8, 2, FALSE);
  gtk_widget_set_name (email, "email");
  gtk_widget_show (email);
  gtk_container_add (GTK_CONTAINER (notebook1), email);
  gtk_container_set_border_width (GTK_CONTAINER (email), 5);

  label93 = gtk_label_new (_("This option only works if you use Nullmailer to send your emails (Use sendmail in many Mail Clients)"));
  gtk_widget_set_name (label93, "label93");
  gtk_widget_show (label93);
  gtk_table_attach (GTK_TABLE (email), label93, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_line_wrap (GTK_LABEL (label93), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label93), 0, 0.5);

  label94 = gtk_label_new (_("SMTP Server:"));
  gtk_widget_set_name (label94, "label94");
  gtk_widget_show (label94);
  gtk_table_attach (GTK_TABLE (email), label94, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label94), 0, 0.5);

  label95 = gtk_label_new (_("SMTP Port:"));
  gtk_widget_set_name (label95, "label95");
  gtk_widget_show (label95);
  gtk_table_attach (GTK_TABLE (email), label95, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label95), 0, 0.5);

  label96 = gtk_label_new (_("Domain:"));
  gtk_widget_set_name (label96, "label96");
  gtk_widget_show (label96);
  gtk_table_attach (GTK_TABLE (email), label96, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label96), 0, 0.5);

  smtp_server = gtk_entry_new ();
  gtk_widget_set_name (smtp_server, "smtp_server");
  gtk_widget_show (smtp_server);
  gtk_table_attach (GTK_TABLE (email), smtp_server, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  smtp_port_adj = gtk_adjustment_new (25, 1, 65535, 1, 10, 10);
  smtp_port = gtk_spin_button_new (GTK_ADJUSTMENT (smtp_port_adj), 1, 0);
  gtk_widget_set_name (smtp_port, "smtp_port");
  gtk_widget_show (smtp_port);
  gtk_table_attach (GTK_TABLE (email), smtp_port, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (smtp_port), TRUE);

  smtp_domain = gtk_entry_new ();
  gtk_widget_set_name (smtp_domain, "smtp_domain");
  gtk_widget_show (smtp_domain);
  gtk_table_attach (GTK_TABLE (email), smtp_domain, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  hseparator2 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator2, "hseparator2");
  gtk_widget_show (hseparator2);
  gtk_table_attach (GTK_TABLE (email), hseparator2, 0, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 15);

  label97 = gtk_label_new (_("Password:"));
  gtk_widget_set_name (label97, "label97");
  gtk_widget_show (label97);
  gtk_table_attach (GTK_TABLE (email), label97, 0, 1, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label97), 0, 0.5);

  label98 = gtk_label_new (_("User:"));
  gtk_widget_set_name (label98, "label98");
  gtk_widget_show (label98);
  gtk_table_attach (GTK_TABLE (email), label98, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label98), 0, 0.5);

  requires_auth = gtk_check_button_new_with_mnemonic (_("SMTP requires authentication"));
  gtk_widget_set_name (requires_auth, "requires_auth");
  gtk_widget_show (requires_auth);
  gtk_table_attach (GTK_TABLE (email), requires_auth, 0, 2, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  smtp_user = gtk_entry_new ();
  gtk_widget_set_name (smtp_user, "smtp_user");
  gtk_widget_show (smtp_user);
  gtk_table_attach (GTK_TABLE (email), smtp_user, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_sensitive (smtp_user, FALSE);

  smtp_pass = gtk_entry_new ();
  gtk_widget_set_name (smtp_pass, "smtp_pass");
  gtk_widget_show (smtp_pass);
  gtk_table_attach (GTK_TABLE (email), smtp_pass, 1, 2, 7, 8,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_sensitive (smtp_pass, FALSE);
  gtk_entry_set_visibility (GTK_ENTRY (smtp_pass), FALSE);

  label99 = gtk_label_new (_("E-mail"));
  gtk_widget_set_name (label99, "label99");
  gtk_widget_show (label99);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 2), label99);

  notebook5 = gtk_notebook_new ();
  gtk_widget_set_name (notebook5, "notebook5");
  gtk_container_add (GTK_CONTAINER (notebook1), notebook5);
  gtk_container_set_border_width (GTK_CONTAINER (notebook5), 5);

  table13 = gtk_table_new (5, 2, FALSE);
  gtk_widget_set_name (table13, "table13");
  gtk_widget_show (table13);
  gtk_container_add (GTK_CONTAINER (notebook5), table13);
  gtk_container_set_border_width (GTK_CONTAINER (table13), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table13), 5);

  label100 = gtk_label_new (_("Nickname"));
  gtk_widget_set_name (label100, "label100");
  gtk_widget_show (label100);
  gtk_table_attach (GTK_TABLE (table13), label100, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label100), 0, 0.5);

  label101 = gtk_label_new (_("ESSID"));
  gtk_widget_set_name (label101, "label101");
  gtk_widget_show (label101);
  gtk_table_attach (GTK_TABLE (table13), label101, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label101), 0, 0.5);

  label102 = gtk_label_new (_("Mode"));
  gtk_widget_set_name (label102, "label102");
  gtk_widget_show (label102);
  gtk_table_attach (GTK_TABLE (table13), label102, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label102), 0, 0.5);

  label103 = gtk_label_new (_("Channel"));
  gtk_widget_set_name (label103, "label103");
  gtk_widget_show (label103);
  gtk_table_attach (GTK_TABLE (table13), label103, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label103), 0, 0.5);

  nickname = gtk_entry_new ();
  gtk_widget_set_name (nickname, "nickname");
  gtk_widget_show (nickname);
  gtk_table_attach (GTK_TABLE (table13), nickname, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  essid = gtk_entry_new ();
  gtk_widget_set_name (essid, "essid");
  gtk_widget_show (essid);
  gtk_table_attach (GTK_TABLE (table13), essid, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  channel = gtk_entry_new ();
  gtk_widget_set_name (channel, "channel");
  gtk_widget_show (channel);
  gtk_table_attach (GTK_TABLE (table13), channel, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  mode = gtk_combo_box_new_text ();
  gtk_widget_set_name (mode, "mode");
  gtk_widget_show (mode);
  gtk_table_attach (GTK_TABLE (table13), mode, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_combo_box_append_text (GTK_COMBO_BOX (mode), _("Auto"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (mode), _("Managed"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (mode), _("Ad-Hoc"));

  expander1 = gtk_expander_new (NULL);
  gtk_widget_set_name (expander1, "expander1");
  gtk_widget_show (expander1);
  gtk_table_attach (GTK_TABLE (table13), expander1, 0, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  table14 = gtk_table_new (6, 2, FALSE);
  gtk_widget_set_name (table14, "table14");
  gtk_widget_show (table14);
  gtk_container_add (GTK_CONTAINER (expander1), table14);
  gtk_table_set_col_spacings (GTK_TABLE (table14), 5);

  label104 = gtk_label_new (_("NWID"));
  gtk_widget_set_name (label104, "label104");
  gtk_widget_show (label104);
  gtk_table_attach (GTK_TABLE (table14), label104, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label104), 0, 0.5);

  label105 = gtk_label_new (_("RTS"));
  gtk_widget_set_name (label105, "label105");
  gtk_widget_show (label105);
  gtk_table_attach (GTK_TABLE (table14), label105, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label105), 0, 0.5);

  label106 = gtk_label_new (_("Frag"));
  gtk_widget_set_name (label106, "label106");
  gtk_widget_show (label106);
  gtk_table_attach (GTK_TABLE (table14), label106, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label106), 0, 0.5);

  label107 = gtk_label_new (_("Rate"));
  gtk_widget_set_name (label107, "label107");
  gtk_widget_show (label107);
  gtk_table_attach (GTK_TABLE (table14), label107, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label107), 0, 0.5);

  label108 = gtk_label_new (_("Frequency"));
  gtk_widget_set_name (label108, "label108");
  gtk_widget_show (label108);
  gtk_table_attach (GTK_TABLE (table14), label108, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label108), 0, 0.5);

  label109 = gtk_label_new (_("Sensibility"));
  gtk_widget_set_name (label109, "label109");
  gtk_widget_show (label109);
  gtk_table_attach (GTK_TABLE (table14), label109, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label109), 0, 0.5);

  nwid = gtk_entry_new ();
  gtk_widget_set_name (nwid, "nwid");
  gtk_widget_show (nwid);
  gtk_table_attach (GTK_TABLE (table14), nwid, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  rts = gtk_entry_new ();
  gtk_widget_set_name (rts, "rts");
  gtk_widget_show (rts);
  gtk_table_attach (GTK_TABLE (table14), rts, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  frag = gtk_entry_new ();
  gtk_widget_set_name (frag, "frag");
  gtk_widget_show (frag);
  gtk_table_attach (GTK_TABLE (table14), frag, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  rate = gtk_entry_new ();
  gtk_widget_set_name (rate, "rate");
  gtk_widget_show (rate);
  gtk_table_attach (GTK_TABLE (table14), rate, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  frequency = gtk_entry_new ();
  gtk_widget_set_name (frequency, "frequency");
  gtk_widget_show (frequency);
  gtk_table_attach (GTK_TABLE (table14), frequency, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  sensibility = gtk_entry_new ();
  gtk_widget_set_name (sensibility, "sensibility");
  gtk_widget_show (sensibility);
  gtk_table_attach (GTK_TABLE (table14), sensibility, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label110 = gtk_label_new (_("Advanced configuration"));
  gtk_widget_set_name (label110, "label110");
  gtk_widget_show (label110);
  gtk_expander_set_label_widget (GTK_EXPANDER (expander1), label110);

  label111 = gtk_label_new (_("Normal"));
  gtk_widget_set_name (label111, "label111");
  gtk_widget_show (label111);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook5), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook5), 0), label111);

  vbox8 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox8, "vbox8");
  gtk_widget_show (vbox8);
  gtk_container_add (GTK_CONTAINER (notebook5), vbox8);
  gtk_container_set_border_width (GTK_CONTAINER (vbox8), 5);

  hbox17 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox17, "hbox17");
  gtk_widget_show (hbox17);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox17, FALSE, FALSE, 0);

  label126 = gtk_label_new (_("Encryption type:"));
  gtk_widget_set_name (label126, "label126");
  gtk_widget_show (label126);
  gtk_box_pack_start (GTK_BOX (hbox17), label126, FALSE, FALSE, 0);

  encryption_type = gtk_combo_box_new_text ();
  gtk_widget_set_name (encryption_type, "encryption_type");
  gtk_widget_show (encryption_type);
  gtk_box_pack_start (GTK_BOX (hbox17), encryption_type, TRUE, TRUE, 0);
  gtk_combo_box_append_text (GTK_COMBO_BOX (encryption_type), _("Off"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (encryption_type), _("Wired Equivalent Privacy (Open)"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (encryption_type), _("Wired Equivalent Privacy (Restricted)"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (encryption_type), _("WiFi Protected Area"));

  encrypt_notebook = gtk_notebook_new ();
  gtk_widget_set_name (encrypt_notebook, "encrypt_notebook");
  gtk_widget_show (encrypt_notebook);
  gtk_box_pack_start (GTK_BOX (vbox8), encrypt_notebook, TRUE, TRUE, 0);
  GTK_WIDGET_UNSET_FLAGS (encrypt_notebook, GTK_CAN_FOCUS);
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (encrypt_notebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (encrypt_notebook), FALSE);

  label128 = gtk_label_new (_("It is highly recommended to encrypt your wireless\ncommunications.\n\nThe current choice is not to encrypt anything.\n\nWired Equivalent Privacy is the first method to encrypt your\nnetwork. This is the base of what you can do.\n\nWiFi Protected Area is the best encryption system available\n(not on every computer / hardware). Notice that it is the\n<span color=\"red\"><b>only</b></span> system that hasn't been already cracked."));
  gtk_widget_set_name (label128, "label128");
  gtk_widget_show (label128);
  gtk_container_add (GTK_CONTAINER (encrypt_notebook), label128);
  gtk_label_set_use_markup (GTK_LABEL (label128), TRUE);
  gtk_label_set_justify (GTK_LABEL (label128), GTK_JUSTIFY_FILL);
  gtk_label_set_line_wrap (GTK_LABEL (label128), TRUE);

  label127 = gtk_label_new (_("Off"));
  gtk_widget_set_name (label127, "label127");
  gtk_widget_show (label127);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (encrypt_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (encrypt_notebook), 0), label127);

  table15 = gtk_table_new (5, 3, FALSE);
  gtk_widget_set_name (table15, "table15");
  gtk_widget_show (table15);
  gtk_container_add (GTK_CONTAINER (encrypt_notebook), table15);
  gtk_table_set_col_spacings (GTK_TABLE (table15), 5);

  label112 = gtk_label_new (_("Key 4"));
  gtk_widget_set_name (label112, "label112");
  gtk_widget_show (label112);
  gtk_table_attach (GTK_TABLE (table15), label112, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label112), 0, 0.5);

  key4 = gtk_entry_new ();
  gtk_widget_set_name (key4, "key4");
  gtk_widget_show (key4);
  gtk_table_attach (GTK_TABLE (table15), key4, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_visibility (GTK_ENTRY (key4), FALSE);

  cle4 = gtk_radio_button_new_with_mnemonic (NULL, "");
  gtk_widget_set_name (cle4, "cle4");
  gtk_widget_show (cle4);
  gtk_table_attach (GTK_TABLE (table15), cle4, 2, 3, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_button_set_focus_on_click (GTK_BUTTON (cle4), FALSE);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (cle4), cle4_group);
  cle4_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (cle4));

  label113 = gtk_label_new (_("Key 3"));
  gtk_widget_set_name (label113, "label113");
  gtk_widget_show (label113);
  gtk_table_attach (GTK_TABLE (table15), label113, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label113), 0, 0.5);

  label114 = gtk_label_new (_("Key 2"));
  gtk_widget_set_name (label114, "label114");
  gtk_widget_show (label114);
  gtk_table_attach (GTK_TABLE (table15), label114, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label114), 0, 0.5);

  label115 = gtk_label_new (_("Key 1"));
  gtk_widget_set_name (label115, "label115");
  gtk_widget_show (label115);
  gtk_table_attach (GTK_TABLE (table15), label115, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label115), 0, 0.5);

  key3 = gtk_entry_new ();
  gtk_widget_set_name (key3, "key3");
  gtk_widget_show (key3);
  gtk_table_attach (GTK_TABLE (table15), key3, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_visibility (GTK_ENTRY (key3), FALSE);

  key2 = gtk_entry_new ();
  gtk_widget_set_name (key2, "key2");
  gtk_widget_show (key2);
  gtk_table_attach (GTK_TABLE (table15), key2, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_visibility (GTK_ENTRY (key2), FALSE);

  key1 = gtk_entry_new ();
  gtk_widget_set_name (key1, "key1");
  gtk_widget_show (key1);
  gtk_table_attach (GTK_TABLE (table15), key1, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_visibility (GTK_ENTRY (key1), FALSE);

  cle3 = gtk_radio_button_new_with_mnemonic (NULL, "");
  gtk_widget_set_name (cle3, "cle3");
  gtk_widget_show (cle3);
  gtk_table_attach (GTK_TABLE (table15), cle3, 2, 3, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_button_set_focus_on_click (GTK_BUTTON (cle3), FALSE);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (cle3), cle4_group);
  cle4_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (cle3));

  cle2 = gtk_radio_button_new_with_mnemonic (NULL, "");
  gtk_widget_set_name (cle2, "cle2");
  gtk_widget_show (cle2);
  gtk_table_attach (GTK_TABLE (table15), cle2, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_button_set_focus_on_click (GTK_BUTTON (cle2), FALSE);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (cle2), cle4_group);
  cle4_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (cle2));

  cle1 = gtk_radio_button_new_with_mnemonic (NULL, "");
  gtk_widget_set_name (cle1, "cle1");
  gtk_widget_show (cle1);
  gtk_table_attach (GTK_TABLE (table15), cle1, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_button_set_focus_on_click (GTK_BUTTON (cle1), FALSE);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (cle1), cle4_group);
  cle4_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (cle1));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cle1), TRUE);

  label116 = gtk_label_new (_("WEP keys can be specified in two different ways:\n\n<b>Hexadecimal</b> case: Enter the key directly\n(between 16 and 32 caracters)\n\n<b>ASCII string</b> case: Prepend \"s:\" string before your key (between 8 and 16 caracters)\nExample: s:E7fdgYKf"));
  gtk_widget_set_name (label116, "label116");
  gtk_widget_show (label116);
  gtk_table_attach (GTK_TABLE (table15), label116, 1, 3, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_use_markup (GTK_LABEL (label116), TRUE);
  gtk_label_set_justify (GTK_LABEL (label116), GTK_JUSTIFY_FILL);
  gtk_label_set_line_wrap (GTK_LABEL (label116), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label116), 0, 0.5);

  label124 = gtk_label_new (_("WEP Keys"));
  gtk_widget_set_name (label124, "label124");
  gtk_widget_show (label124);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (encrypt_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (encrypt_notebook), 1), label124);

  encryption_table = gtk_table_new (3, 2, FALSE);
  gtk_widget_set_name (encryption_table, "encryption_table");
  gtk_widget_show (encryption_table);
  gtk_container_add (GTK_CONTAINER (encrypt_notebook), encryption_table);
  gtk_container_set_border_width (GTK_CONTAINER (encryption_table), 5);

  label129 = gtk_label_new (_("Device type:"));
  gtk_widget_set_name (label129, "label129");
  gtk_widget_show (label129);
  gtk_table_attach (GTK_TABLE (encryption_table), label129, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label129), 0, 0.5);

  label130 = gtk_label_new (_("Protocols:"));
  gtk_widget_set_name (label130, "label130");
  gtk_widget_show (label130);
  gtk_table_attach (GTK_TABLE (encryption_table), label130, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label130), 0, 0.5);

  wpa_protocol = gtk_combo_box_entry_new_text ();
  gtk_widget_set_name (wpa_protocol, "wpa_protocol");
  gtk_widget_show (wpa_protocol);
  gtk_table_attach (GTK_TABLE (encryption_table), wpa_protocol, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_combo_box_append_text (GTK_COMBO_BOX (wpa_protocol), _("WPA-PSK"));

  wpa_driver = gtk_combo_box_new_text ();
  gtk_widget_set_name (wpa_driver, "wpa_driver");
  gtk_widget_show (wpa_driver);
  gtk_table_attach (GTK_TABLE (encryption_table), wpa_driver, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_combo_box_append_text (GTK_COMBO_BOX (wpa_driver), _("Host AP (Prism2/2.5/3"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (wpa_driver), _("Linuxant with NDIS wrapper"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (wpa_driver), _("Windows NDIS driver"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (wpa_driver), _("Hermes-I/II"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (wpa_driver), _("madwifi"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (wpa_driver), _("ATMEL AT76C5XXx"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (wpa_driver), _("Broadcom"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (wpa_driver), _("Intel Centrino"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (wpa_driver), _("Generic Linux wireless extensions"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (wpa_driver), _("Wired Ethernet"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (wpa_driver), _("BSD 802.11 support"));

  label132 = gtk_label_new (_("Passphrase:"));
  gtk_widget_set_name (label132, "label132");
  gtk_widget_show (label132);
  gtk_table_attach (GTK_TABLE (encryption_table), label132, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label132), 0, 0.5);

  wpa_passphrase1 = gtk_entry_new ();
  gtk_widget_set_name (wpa_passphrase1, "wpa_passphrase1");
  gtk_widget_show (wpa_passphrase1);
  gtk_table_attach (GTK_TABLE (encryption_table), wpa_passphrase1, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_visibility (GTK_ENTRY (wpa_passphrase1), FALSE);

  label125 = gtk_label_new (_("WPA Key"));
  gtk_widget_set_name (label125, "label125");
  gtk_widget_show (label125);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (encrypt_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (encrypt_notebook), 2), label125);

  label117 = gtk_label_new (_("Key management"));
  gtk_widget_set_name (label117, "label117");
  gtk_widget_show (label117);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook5), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook5), 1), label117);

  label118 = gtk_label_new (_("Wireless network"));
  gtk_widget_set_name (label118, "label118");
  gtk_widget_show (label118);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 3), label118);

  services_pane = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (services_pane, "services_pane");
  gtk_widget_show (services_pane);
  gtk_container_add (GTK_CONTAINER (notebook1), services_pane);
  gtk_container_set_border_width (GTK_CONTAINER (services_pane), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (services_pane), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (services_pane), GTK_SHADOW_IN);

  services = gtk_tree_view_new ();
  gtk_widget_set_name (services, "services");
  gtk_widget_show (services);
  gtk_container_add (GTK_CONTAINER (services_pane), services);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (services), TRUE);

  label120 = gtk_label_new (_("Services"));
  gtk_widget_set_name (label120, "label120");
  gtk_widget_show (label120);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 4), label120);

  dialog_action_area2 = GTK_DIALOG (properties)->action_area;
  gtk_widget_set_name (dialog_action_area2, "dialog_action_area2");
  gtk_widget_show (dialog_action_area2);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area2), GTK_BUTTONBOX_END);

  cancelbutton2 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_set_name (cancelbutton2, "cancelbutton2");
  gtk_widget_show (cancelbutton2);
  gtk_dialog_add_action_widget (GTK_DIALOG (properties), cancelbutton2, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton2, GTK_CAN_DEFAULT);

  okbutton2 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_set_name (okbutton2, "okbutton2");
  gtk_widget_show (okbutton2);
  gtk_dialog_add_action_widget (GTK_DIALOG (properties), okbutton2, GTK_RESPONSE_OK);
  gtk_widget_set_sensitive (okbutton2, FALSE);
  GTK_WIDGET_SET_FLAGS (okbutton2, GTK_CAN_DEFAULT);

  g_signal_connect_swapped ((gpointer) nom, "changed",
                            G_CALLBACK (on_nom_changed),
                            GTK_OBJECT (okbutton2));
  g_signal_connect ((gpointer) type, "toggled",
                    G_CALLBACK (wireless_toggle),
                    NULL);
  g_signal_connect ((gpointer) bootproto, "toggled",
                    G_CALLBACK (dhcp_toggle),
                    NULL);
  g_signal_connect_swapped ((gpointer) ipaddr, "changed",
                            G_CALLBACK (on_ipaddr_changed),
                            GTK_OBJECT (netmask));
  g_signal_connect ((gpointer) netmask, "value_changed",
                    G_CALLBACK (on_netmask_change_value),
                    NULL);
  g_signal_connect ((gpointer) resolv, "toggled",
                    G_CALLBACK (resolv_toggle),
                    NULL);
  g_signal_connect ((gpointer) requires_auth, "toggled",
                    G_CALLBACK (toggle_user_smtp),
                    NULL);
  g_signal_connect_swapped ((gpointer) encryption_type, "changed",
                            G_CALLBACK (on_encryption_type_changed),
                            GTK_OBJECT (encrypt_notebook));

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (properties, properties, "properties");
  GLADE_HOOKUP_OBJECT_NO_REF (properties, dialog_vbox2, "dialog_vbox2");
  GLADE_HOOKUP_OBJECT (properties, vbox5, "vbox5");
  GLADE_HOOKUP_OBJECT (properties, hbox16, "hbox16");
  GLADE_HOOKUP_OBJECT (properties, label119, "label119");
  GLADE_HOOKUP_OBJECT (properties, nom, "nom");
  GLADE_HOOKUP_OBJECT (properties, notebook1, "notebook1");
  GLADE_HOOKUP_OBJECT (properties, vbox6, "vbox6");
  GLADE_HOOKUP_OBJECT (properties, hbox14, "hbox14");
  GLADE_HOOKUP_OBJECT (properties, label80, "label80");
  GLADE_HOOKUP_OBJECT (properties, device, "device");
  GLADE_HOOKUP_OBJECT (properties, type, "type");
  GLADE_HOOKUP_OBJECT (properties, bootproto, "bootproto");
  GLADE_HOOKUP_OBJECT (properties, table10, "table10");
  GLADE_HOOKUP_OBJECT (properties, label81, "label81");
  GLADE_HOOKUP_OBJECT (properties, label82, "label82");
  GLADE_HOOKUP_OBJECT (properties, label83, "label83");
  GLADE_HOOKUP_OBJECT (properties, label84, "label84");
  GLADE_HOOKUP_OBJECT (properties, ipaddr, "ipaddr");
  GLADE_HOOKUP_OBJECT (properties, netmask, "netmask");
  GLADE_HOOKUP_OBJECT (properties, broadcast, "broadcast");
  GLADE_HOOKUP_OBJECT (properties, gateway, "gateway");
  GLADE_HOOKUP_OBJECT (properties, expander2, "expander2");
  GLADE_HOOKUP_OBJECT (properties, table16, "table16");
  GLADE_HOOKUP_OBJECT (properties, label121, "label121");
  GLADE_HOOKUP_OBJECT (properties, hwaddr, "hwaddr");
  GLADE_HOOKUP_OBJECT (properties, label85, "label85");
  GLADE_HOOKUP_OBJECT (properties, metric, "metric");
  GLADE_HOOKUP_OBJECT (properties, label122, "label122");
  GLADE_HOOKUP_OBJECT (properties, netmask2, "netmask2");
  GLADE_HOOKUP_OBJECT (properties, label86, "label86");
  GLADE_HOOKUP_OBJECT (properties, vbox7, "vbox7");
  GLADE_HOOKUP_OBJECT (properties, peerdns, "peerdns");
  GLADE_HOOKUP_OBJECT (properties, hbox15, "hbox15");
  GLADE_HOOKUP_OBJECT (properties, label87, "label87");
  GLADE_HOOKUP_OBJECT (properties, domain, "domain");
  GLADE_HOOKUP_OBJECT (properties, resolv, "resolv");
  GLADE_HOOKUP_OBJECT (properties, table11, "table11");
  GLADE_HOOKUP_OBJECT (properties, label88, "label88");
  GLADE_HOOKUP_OBJECT (properties, label89, "label89");
  GLADE_HOOKUP_OBJECT (properties, label90, "label90");
  GLADE_HOOKUP_OBJECT (properties, label91, "label91");
  GLADE_HOOKUP_OBJECT (properties, nameserver1, "nameserver1");
  GLADE_HOOKUP_OBJECT (properties, nameserver2, "nameserver2");
  GLADE_HOOKUP_OBJECT (properties, nameserver3, "nameserver3");
  GLADE_HOOKUP_OBJECT (properties, nameserver4, "nameserver4");
  GLADE_HOOKUP_OBJECT (properties, label92, "label92");
  GLADE_HOOKUP_OBJECT (properties, email, "email");
  GLADE_HOOKUP_OBJECT (properties, label93, "label93");
  GLADE_HOOKUP_OBJECT (properties, label94, "label94");
  GLADE_HOOKUP_OBJECT (properties, label95, "label95");
  GLADE_HOOKUP_OBJECT (properties, label96, "label96");
  GLADE_HOOKUP_OBJECT (properties, smtp_server, "smtp_server");
  GLADE_HOOKUP_OBJECT (properties, smtp_port, "smtp_port");
  GLADE_HOOKUP_OBJECT (properties, smtp_domain, "smtp_domain");
  GLADE_HOOKUP_OBJECT (properties, hseparator2, "hseparator2");
  GLADE_HOOKUP_OBJECT (properties, label97, "label97");
  GLADE_HOOKUP_OBJECT (properties, label98, "label98");
  GLADE_HOOKUP_OBJECT (properties, requires_auth, "requires_auth");
  GLADE_HOOKUP_OBJECT (properties, smtp_user, "smtp_user");
  GLADE_HOOKUP_OBJECT (properties, smtp_pass, "smtp_pass");
  GLADE_HOOKUP_OBJECT (properties, label99, "label99");
  GLADE_HOOKUP_OBJECT (properties, notebook5, "notebook5");
  GLADE_HOOKUP_OBJECT (properties, table13, "table13");
  GLADE_HOOKUP_OBJECT (properties, label100, "label100");
  GLADE_HOOKUP_OBJECT (properties, label101, "label101");
  GLADE_HOOKUP_OBJECT (properties, label102, "label102");
  GLADE_HOOKUP_OBJECT (properties, label103, "label103");
  GLADE_HOOKUP_OBJECT (properties, nickname, "nickname");
  GLADE_HOOKUP_OBJECT (properties, essid, "essid");
  GLADE_HOOKUP_OBJECT (properties, channel, "channel");
  GLADE_HOOKUP_OBJECT (properties, mode, "mode");
  GLADE_HOOKUP_OBJECT (properties, expander1, "expander1");
  GLADE_HOOKUP_OBJECT (properties, table14, "table14");
  GLADE_HOOKUP_OBJECT (properties, label104, "label104");
  GLADE_HOOKUP_OBJECT (properties, label105, "label105");
  GLADE_HOOKUP_OBJECT (properties, label106, "label106");
  GLADE_HOOKUP_OBJECT (properties, label107, "label107");
  GLADE_HOOKUP_OBJECT (properties, label108, "label108");
  GLADE_HOOKUP_OBJECT (properties, label109, "label109");
  GLADE_HOOKUP_OBJECT (properties, nwid, "nwid");
  GLADE_HOOKUP_OBJECT (properties, rts, "rts");
  GLADE_HOOKUP_OBJECT (properties, frag, "frag");
  GLADE_HOOKUP_OBJECT (properties, rate, "rate");
  GLADE_HOOKUP_OBJECT (properties, frequency, "frequency");
  GLADE_HOOKUP_OBJECT (properties, sensibility, "sensibility");
  GLADE_HOOKUP_OBJECT (properties, label110, "label110");
  GLADE_HOOKUP_OBJECT (properties, label111, "label111");
  GLADE_HOOKUP_OBJECT (properties, vbox8, "vbox8");
  GLADE_HOOKUP_OBJECT (properties, hbox17, "hbox17");
  GLADE_HOOKUP_OBJECT (properties, label126, "label126");
  GLADE_HOOKUP_OBJECT (properties, encryption_type, "encryption_type");
  GLADE_HOOKUP_OBJECT (properties, encrypt_notebook, "encrypt_notebook");
  GLADE_HOOKUP_OBJECT (properties, label128, "label128");
  GLADE_HOOKUP_OBJECT (properties, label127, "label127");
  GLADE_HOOKUP_OBJECT (properties, table15, "table15");
  GLADE_HOOKUP_OBJECT (properties, label112, "label112");
  GLADE_HOOKUP_OBJECT (properties, key4, "key4");
  GLADE_HOOKUP_OBJECT (properties, cle4, "cle4");
  GLADE_HOOKUP_OBJECT (properties, label113, "label113");
  GLADE_HOOKUP_OBJECT (properties, label114, "label114");
  GLADE_HOOKUP_OBJECT (properties, label115, "label115");
  GLADE_HOOKUP_OBJECT (properties, key3, "key3");
  GLADE_HOOKUP_OBJECT (properties, key2, "key2");
  GLADE_HOOKUP_OBJECT (properties, key1, "key1");
  GLADE_HOOKUP_OBJECT (properties, cle3, "cle3");
  GLADE_HOOKUP_OBJECT (properties, cle2, "cle2");
  GLADE_HOOKUP_OBJECT (properties, cle1, "cle1");
  GLADE_HOOKUP_OBJECT (properties, label116, "label116");
  GLADE_HOOKUP_OBJECT (properties, label124, "label124");
  GLADE_HOOKUP_OBJECT (properties, encryption_table, "encryption_table");
  GLADE_HOOKUP_OBJECT (properties, label129, "label129");
  GLADE_HOOKUP_OBJECT (properties, label130, "label130");
  GLADE_HOOKUP_OBJECT (properties, wpa_protocol, "wpa_protocol");
  GLADE_HOOKUP_OBJECT (properties, wpa_driver, "wpa_driver");
  GLADE_HOOKUP_OBJECT (properties, label132, "label132");
  GLADE_HOOKUP_OBJECT (properties, wpa_passphrase1, "wpa_passphrase1");
  GLADE_HOOKUP_OBJECT (properties, label125, "label125");
  GLADE_HOOKUP_OBJECT (properties, label117, "label117");
  GLADE_HOOKUP_OBJECT (properties, label118, "label118");
  GLADE_HOOKUP_OBJECT (properties, services_pane, "services_pane");
  GLADE_HOOKUP_OBJECT (properties, services, "services");
  GLADE_HOOKUP_OBJECT (properties, label120, "label120");
  GLADE_HOOKUP_OBJECT_NO_REF (properties, dialog_action_area2, "dialog_action_area2");
  GLADE_HOOKUP_OBJECT (properties, cancelbutton2, "cancelbutton2");
  GLADE_HOOKUP_OBJECT (properties, okbutton2, "okbutton2");

  return properties;
}

