/*
 * Copyright (C) 2004,2005 Olivier Rossiny <mrfreeze@tuxfamily.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include <gtk/gtk.h>
#include <glib.h>

#include "interface.h"
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <eggtrayicon.h>

#include <netswitch.h>

extern GtkWidget *mainW;
static GtkWidget *image;
char inLoop;
extern GtkWidget *boite;
extern GtkWidget *auto_menu;

/* Definition of the callbacks for the menu */
int on_btn_about_clicked (GtkMenuItem *button, gpointer user_data);
int on_autoconnect_activate (GtkMenuItem *button, gpointer user_data);

void sig_show(int c)
{
  gtk_widget_show(mainW);
}

void on_autoconnect_show (GtkWidget *menu, gpointer data)
{
  gtk_widget_show(GTK_WIDGET(data));
}

void on_autoconnect_hide (GtkWidget *menu, gpointer data)
{
  gtk_widget_hide(GTK_WIDGET(data));
}

void ask_pwd(char **text, enum CONN_TYPE type)
{
  GtkWidget *dialog = create_PassDialog();
  if (type == SUDO) {
    gtk_label_set_text(GTK_LABEL(lookup_widget(dialog, "lbl_title")), _("<big><b>Please enter your password</b></big>"));
    gtk_label_set_use_markup (GTK_LABEL (lookup_widget(dialog, "lbl_title")), TRUE);
  }
  gint res = gtk_dialog_run(GTK_DIALOG(dialog));
  if (res == GTK_RESPONSE_OK) {
    const char *tmp = gtk_entry_get_text(GTK_ENTRY(lookup_widget(dialog, "pwd_entry")));
    *text = malloc(1 + strlen(tmp));
    strcpy(*text, tmp);
  } else
      exit(0);
  gtk_widget_destroy(dialog);
  while (gtk_events_pending ())
    gtk_main_iteration_do (FALSE);
}

static int fin(GtkWidget *widget, gpointer user_data)
{
  if (!GTK_WIDGET_VISIBLE(GTK_WIDGET(user_data)))
    gtk_main_quit();
}

static void toggle_window()
{
  if (GTK_WIDGET_VISIBLE(mainW))
    gtk_widget_hide(mainW);
  else
    gtk_widget_show(mainW);
}

static void pressed(GtkWidget *button, GdkEventButton *event, void *data)
{
  if (event->type != GDK_BUTTON_PRESS)
    return;
  if (event->button == 1)
    toggle_window();
  else if (event->button == 3)
   gtk_menu_popup(GTK_MENU(data), NULL, NULL, NULL, NULL, 3, event->time);
}

static void embedded(GtkWidget *object, void *data)
{
  boite = GTK_WIDGET(data);
}

int
main (int argc, char *argv[])
{
  signal(12, sig_show);

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  g_thread_init(NULL);
  gdk_threads_init();
  gdk_threads_enter();
  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

  inLoop=0;
  EggTrayIcon *docklet = egg_tray_icon_new("netswitch");
  GtkWidget *boite = gtk_event_box_new();
  GtkWidget *menu = gtk_menu_new();
  GtkWidget *item;
  auto_menu = gtk_image_menu_item_new_with_label (_("Autoconnection"));
  gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(auto_menu), gtk_image_new_from_stock("gtk-network", GTK_ICON_SIZE_MENU));
  g_signal_connect(G_OBJECT(auto_menu), "activate", G_CALLBACK(on_autoconnect_activate), docklet);
  gtk_menu_attach(GTK_MENU(menu), auto_menu, 0,1,0,1);
  item = gtk_separator_menu_item_new();
  gtk_menu_attach(GTK_MENU(menu), item, 0,1,1,2);
  g_signal_connect(G_OBJECT(auto_menu), "hide", G_CALLBACK(on_autoconnect_hide), item);
  g_signal_connect(G_OBJECT(auto_menu), "show", G_CALLBACK(on_autoconnect_show), item);
  item = gtk_menu_item_new_with_label (_("Show / Hide the window"));
  g_signal_connect(G_OBJECT(item), "activate", G_CALLBACK(toggle_window), NULL);
  gtk_menu_attach(GTK_MENU(menu), item, 0,1,2,3);
  item = gtk_separator_menu_item_new();
  gtk_menu_attach(GTK_MENU(menu), item, 0,1,3,4);
  item = gtk_image_menu_item_new_from_stock ("gtk-about", NULL);
  g_signal_connect(G_OBJECT(item), "activate", G_CALLBACK(on_btn_about_clicked), docklet);
  gtk_menu_attach(GTK_MENU(menu), item, 0,1,4,5);
  item = gtk_image_menu_item_new_from_stock ("gtk-quit", NULL);
  g_signal_connect(G_OBJECT(item), "activate", G_CALLBACK(gtk_main_quit), NULL);
  gtk_menu_attach(GTK_MENU(menu), item, 0,1,5,6);
  gtk_widget_show_all(menu);
  g_signal_connect(G_OBJECT(docklet), "embedded", G_CALLBACK(embedded), boite);
  g_signal_connect(G_OBJECT(docklet), "destroy", G_CALLBACK(fin), mainW);
  g_signal_connect(G_OBJECT(boite), "button-press-event", G_CALLBACK(pressed), menu);
  //image = create_pixmap(NULL, "netswitch-16x16.png");
  image = gtk_image_new_from_stock(GTK_STOCK_NETWORK, GTK_ICON_SIZE_BUTTON);
  gtk_container_add(GTK_CONTAINER(boite), image);
  gtk_container_add(GTK_CONTAINER(docklet), boite);
  g_object_ref(G_OBJECT(docklet));
  int i = netswitch_init(ask_pwd);
  if (i == -1)
    return 0;
  else if (i == 0) {
    GtkWidget *dialog = gtk_message_dialog_new(0, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _("The password you gave is wrong.\nThe application will finish."));
    gtk_dialog_run(GTK_DIALOG(dialog));
    exit(1);
  }
  mainW = create_netswitch ();
  // Terrible hacks
  if (1 || !NETSWITCH_HAS_PPP) gtk_widget_hide(lookup_widget(mainW, "pppbox"));
  gtk_widget_hide(lookup_widget(mainW, "import"));
  gtk_widget_hide(lookup_widget(mainW, "export"));
  gtk_widget_hide(lookup_widget(mainW, "sep2"));
  // hacks are finished ....in this file
  gtk_widget_show (mainW);

  inLoop=1;
  gtk_widget_show_all(GTK_WIDGET(docklet));
  gtk_main ();
  gdk_threads_leave();
  return 0;
}

