/******************************************************************************\
 gnofin/dialog-question.c   $Revision: 1.3 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <libgnomeui/gnome-dialog.h>
#include <libgnomeui/gnome-messagebox.h>
#include <libgnomeui/gnome-stock.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkcheckbutton.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtksignal.h>
#include "dialogs.h"

gint
dialog_question_yes_no (GtkWindow   *parent,
			const gchar *message)
{
  GnomeDialog *dialog;

  trace("");
  g_return_val_if_fail (message, -1);

  dialog = GNOME_DIALOG (gnome_message_box_new (message,
					        GNOME_MESSAGE_BOX_QUESTION,
					        GNOME_STOCK_BUTTON_YES,
					        GNOME_STOCK_BUTTON_NO,
					        NULL));
  
  if (parent)
    gnome_dialog_set_parent (dialog, parent);

  gnome_dialog_set_default (dialog, 0);
  return gnome_dialog_run_and_close (dialog);
}

gint
dialog_question_yes_no_cancel (GtkWindow   *parent,
			       const gchar *message)
{
  GnomeDialog *dialog;

  trace("");
  g_return_val_if_fail (message, -1);

  dialog = GNOME_DIALOG (gnome_message_box_new (message,
					        GNOME_MESSAGE_BOX_QUESTION,
					        GNOME_STOCK_BUTTON_YES,
					        GNOME_STOCK_BUTTON_NO,
					        GNOME_STOCK_BUTTON_CANCEL,
					        NULL));
  
  if (parent)
    gnome_dialog_set_parent (dialog, parent);

  gnome_dialog_set_default (dialog, 0);
  return gnome_dialog_run_and_close (dialog);
}

/*
 * Function: on_toggled_button
 * Description:
 *   This event is called when the toggle button state must be changed
 * Input:
 *   togglebutton: The widget associated
 *   checked: The state when the changed occur
 * Output:
 *   checked is modified
 * Notes:
 */
static void
on_toggled_button (GtkToggleButton *togglebutton, gboolean *checked)
{
  trace ("");

  *checked=!*checked;
}

/*
 * Function: dialog_question_yes_no_with_checkbutton
 * Description:
 *   Popup a question dialog box with 2 buttons (Yes/No) and check
 *   button state like [X] See this dialog next time.
 * Input:
 *   parent: The widget parent of this dialog
 *   message: Text display in the dialog box
 *   check_message: Text display for the check button
 *   check_flag: The state of the check button
 * Output:
 *   return If a button was pressed, the button number is returned.
 *          If not -1 is returned
 *   check_flag is modified if check button was pressed
 * Notes:
 */
gint
dialog_question_yes_no_with_checkbutton (GtkWindow   *parent,
					 const gchar *message,
					 const gchar *check_message,
					 gboolean    *check_flag)
{
  GnomeDialog *dialog;
  GtkWidget *vbox, *hbox, *toggle;

  trace("");
  g_return_val_if_fail (message, -1);
  g_return_val_if_fail (check_message, -1);
  g_return_val_if_fail (check_flag, -1);

  dialog = GNOME_DIALOG (gnome_message_box_new (message,
						GNOME_MESSAGE_BOX_QUESTION,
						GNOME_STOCK_BUTTON_YES,
					        GNOME_STOCK_BUTTON_NO,
					        NULL));
  vbox = dialog->vbox;
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show(hbox);

  toggle = gtk_check_button_new_with_label (check_message);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle), *check_flag);
  gtk_box_pack_start (GTK_BOX (hbox), toggle, TRUE, TRUE, 56);  // FIXME: dont hardcode
  gtk_signal_connect (GTK_OBJECT (toggle), "toggled",
      GTK_SIGNAL_FUNC (on_toggled_button), (gpointer) check_flag);
  gtk_widget_show (toggle);

  if (parent)
    gnome_dialog_set_parent (dialog, parent);

  gnome_dialog_set_default (dialog, 0);
  return gnome_dialog_run_and_close (dialog);
}
