/******************************************************************************\
 gnofin/preferences.h   $Revision: 1.4 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef PREFERENCES_H
#define PREFERENCES_H

GNOFIN_API_BEGIN

#include <gtk/gtkwindow.h>

typedef struct _PreferencesPage PreferencesPage;

typedef GtkWidget * (*PreferencesPageMakeFunc)  (gpointer user_data);
typedef void        (*PreferencesPageInitFunc)  (gpointer user_data);
typedef gboolean    (*PreferencesPageApplyFunc) (GtkWindow *parent, gpointer user_data);

struct _PreferencesPage
{
  const gchar              *category;
  const gchar              *label;
  PreferencesPageMakeFunc   make;	/* Make page (create widget) */
  PreferencesPageInitFunc   init;	/* Initialize page */
  PreferencesPageApplyFunc  apply;	/* Apply changes made to page */
  gpointer                  user_data;	/* Argument to init() and apply() */
};

/* Each preferences page is registered separately under a specific category/label
 * identifier.  An initialization function is specified that is called to create
 * the widget associated with the preferences dialog.  The registration function
 * returns a pointer key value that can be used to later reference the page. The
 * page argument is not referenced internally (so it may be allocated on the stack).
 */
gpointer preferences_page_register   (const PreferencesPage *page);
void     preferences_page_unregister (gpointer key);

/* A page may call this function to indicate that its contents have been changed. */
void     preferences_page_changed    (gpointer key);

/* Call this function to launch the preferences dialog. */
void     preferences_dialog_run      (GtkWindow *parent);

GNOFIN_API_END

#endif
