/******************************************************************************\
 gnofin/record-parser.c   $Revision: 1.7 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "data-if.h"
#include "record-parser.h"
#include "numeric-parser.h"
#include "date.h"
#include "money.h"

gboolean
parse_record_field (const Bankbook *book, guint field, const gchar *text, RecordInfo *info)
{
  trace ("");
  g_return_val_if_fail (text, FALSE);

  switch (field)
  {
  case RECORD_FIELD_DATE:
    return date_parse (text, &info->date);
  case RECORD_FIELD_NUMBER:
    return uint_parse (text, &info->number);
  case RECORD_FIELD_EXCHANGE_RATE:
    return float_parse (text, &info->exchange_rate);
  case RECORD_FIELD_AMOUNT:
    return money_parse (text, &info->amount);
  case RECORD_FIELD_TYPE:
    info->type = if_bankbook_get_record_type_by_name (book, text);
    return (info->type != NULL);
  case RECORD_FIELD_CATEGORY:
    info->category = (gchar *) text;
    return TRUE;
  case RECORD_FIELD_PAYEE:
    info->payee = (gchar *) text;
    return TRUE;
  case RECORD_FIELD_MEMO:
    info->memo = (gchar *) text;
    return TRUE;
  case RECORD_FIELD_CLEARED:
    info->cleared = (text[0] == 'c' ? 1 : 0);
    return TRUE;
  case RECORD_FIELD_LINKED_ACC_NAME:
    info->linked_acc_name = (gchar *) text;
    return TRUE;
  }
  return FALSE;
}
