/*
 * GNoise
 *
 * Copyright (C) 1999-2001 Dwight Engen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: display_cache.h,v 1.3 2001/01/20 19:40:11 dengen Exp $
 *
 */

#ifndef _DISPLAY_CACHE_H
#define _DISPLAY_CACHE_H

#include <gtk/gtk.h>
#include "gnoise.h"
#include "snd_buf.h"

typedef struct _dcache_header	dcache_header_t;
typedef struct _dcache		dcache_t;

struct _dcache_header
{
    /* display cache file header */
    char	id[6];			/* "DCACHE" */
    char	version[10];		/* "v1.0\0\0\0\0\0\0" */
    int		zoom_level;
};

struct _dcache
{
    guint8	*data[ZOOM_LEVELS];	/* 0-255 min-max volume */
    guint32	size[ZOOM_LEVELS];	/* size in bytes of each level */
    gint8	zoom_level;		/* first zoom level cached */
    smpl_indx	samples;		/* samples cache represents */
    gboolean	dirty;			/* does it need to be saved? */
};

void *	  dcache_attach	(void *sb);	/* dcache load/create thread */
void	  dcache_free	(snd_buf_t *sb);
gboolean  dcache_load	(snd_buf_t *sb);
gboolean  dcache_resize	(snd_buf_t *sb);
gboolean  dcache_save	(snd_buf_t *sb);
gboolean  dcache_update	(snd_buf_t *sb, guint32 smp_start, guint32 smp_end,
			 gboolean allow_cancel);

#endif /* _DISPLAY_CACHE_H */
