/* -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4 ts=4:
 *
 * Gnome Apt package cache handling class
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2003-2005 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef GNOME_APT_PKGLIST_H
#define GNOME_APT_PKGLIST_H

#include <libgnomeui/gnome-appbar.h>

#include "cachecontrol.h"
#include "details.h"

class GAptFilterBar;
class GAptInfoPanes;
class DrawTree;

class GAptPkgList {
public:
	GAptPkgList (DrawTree*, GnomeAppBar*, gboolean);
	~GAptPkgList (void);

	GtkWidget* widget (void) { return pl_wdg; }
	DrawTree* getView (void) { return pl_treeview; }
	GAptCacheControl* getCacheControl (void) { return pl_cachectrl; }

  void set_selection(pkgCache::Package* pkg);

  // Menu items
  void install();
  void remove();
	void keep (void);
	void details (bool);

private:
	GtkWidget* pl_wdg;
	DrawTree* pl_treeview;
	GAptCacheControl* pl_cachectrl;

	/* Filter */
  GAptFilterBar* filterbar_;

  pkgCache::Package* selection_;

  // Details window
  Details details_;
};

#endif
