/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4 ts=4:
 *
 * Gnome Apt utility helper class
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2003, 2004 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef GNOME_APT_PKGUTIL_H
#define GNOME_APT_PKGUTIL_H

#include <apt-pkg/pkgcache.h>

class GAptCache;
class GAptPkgTree;

class Util {
public:
  // return iterator for the version we want to display the
  // description of, etc. Kind of arbitarily decided.
  static pkgCache::VerIterator display_version(pkgCache::PkgIterator & i,
                                               GAptCache* cache);

  // Operations on packages: these wrap apt-pkg routines,
  //  but also notify any parts of the GUI that need to react,
  //  and maybe throw up dialogs to ask the user questions.

  // current state 

  static bool installed(pkgCache::Package* p, GAptPkgTree* tree);

  static bool installed(pkgCache::PkgIterator& i, GAptPkgTree* tree);

  static bool removed(pkgCache::Package* p, GAptPkgTree* tree);

  static bool removed(pkgCache::PkgIterator& i, GAptPkgTree* tree);

  // whether to give user the option of toggling state

  static bool can_change_install(pkgCache::Package* p, GAptPkgTree* tree);

  static bool can_change_install(pkgCache::PkgIterator& i, GAptPkgTree* tree);

  static bool can_change_remove(pkgCache::Package* p, GAptPkgTree* tree);

  static bool can_change_remove(pkgCache::PkgIterator& i, GAptPkgTree* tree);

  static bool can_change_keep(pkgCache::PkgIterator& i, GAptPkgTree* tree);

private:


};

#endif
