/* history.c generated by valac 0.20.0, the Vala compiler
 * generated from history.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
typedef struct _HistoryPrivate HistoryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_PGN (pgn_get_type ())
#define PGN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN, PGN))
#define PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN, PGNClass))
#define IS_PGN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN))
#define IS_PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN))
#define PGN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN, PGNClass))

typedef struct _PGN PGN;
typedef struct _PGNClass PGNClass;
typedef struct _PGNPrivate PGNPrivate;

#define TYPE_PGN_GAME (pgn_game_get_type ())
#define PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN_GAME, PGNGame))
#define PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN_GAME, PGNGameClass))
#define IS_PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN_GAME))
#define IS_PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN_GAME))
#define PGN_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN_GAME, PGNGameClass))

typedef struct _PGNGame PGNGame;
typedef struct _PGNGameClass PGNGameClass;
#define _pgn_game_unref0(var) ((var == NULL) ? NULL : (var = (pgn_game_unref (var), NULL)))
#define _pgn_unref0(var) ((var == NULL) ? NULL : (var = (pgn_unref (var), NULL)))
typedef struct _ParamSpecHistory ParamSpecHistory;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _History {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryPrivate * priv;
};

struct _HistoryClass {
	GTypeClass parent_class;
	void (*finalize) (History *self);
};

struct _HistoryPrivate {
	GFile* history_dir;
	gboolean loaded;
	sqlite3* db;
};

struct _PGN {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNPrivate * priv;
	GList* games;
};

struct _PGNClass {
	GTypeClass parent_class;
	void (*finalize) (PGN *self);
};

struct _ParamSpecHistory {
	GParamSpec parent_instance;
};


static gpointer history_parent_class = NULL;

gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
void value_take_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST;
#define HISTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HISTORY, HistoryPrivate))
enum  {
	HISTORY_DUMMY_PROPERTY
};
History* history_new (GFile* data_dir);
History* history_construct (GType object_type, GFile* data_dir);
GFile* history_add (History* self, const gchar* date, const gchar* _result_, GError** error);
static void history_load (History* self);
void history_remove (History* self, GFile* file);
void history_update (History* self, GFile* file, const gchar* fen, const gchar* _result_);
GList* history_get_unfinished (History* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void history_load_history_recursive (History* self, GFile* base_dir, GFile* dir, gboolean load_files, GError** error);
PGN* pgn_new_from_file (GFile* file, GError** error);
PGN* pgn_construct_from_file (GType object_type, GFile* file, GError** error);
gpointer pgn_ref (gpointer instance);
void pgn_unref (gpointer instance);
GParamSpec* param_spec_pgn (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn (GValue* value, gpointer v_object);
void value_take_pgn (GValue* value, gpointer v_object);
gpointer value_get_pgn (const GValue* value);
GType pgn_get_type (void) G_GNUC_CONST;
gpointer pgn_game_ref (gpointer instance);
void pgn_game_unref (gpointer instance);
GParamSpec* param_spec_pgn_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn_game (GValue* value, gpointer v_object);
void value_take_pgn_game (GValue* value, gpointer v_object);
gpointer value_get_pgn_game (const GValue* value);
GType pgn_game_get_type (void) G_GNUC_CONST;
const gchar* pgn_game_get_date (PGNGame* self);
const gchar* pgn_game_get_result (PGNGame* self);
static void history_finalize (History* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


History* history_construct (GType object_type, GFile* data_dir) {
	History* self = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GFile* _tmp5_ = NULL;
	g_return_val_if_fail (data_dir != NULL, NULL);
	self = (History*) g_type_create_instance (object_type);
	_tmp0_ = data_dir;
	_tmp1_ = g_file_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_build_filename (_tmp2_, "history", NULL, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	_g_object_unref0 (self->priv->history_dir);
	self->priv->history_dir = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	return self;
}


History* history_new (GFile* data_dir) {
	return history_construct (TYPE_HISTORY, data_dir);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


GFile* history_add (History* self, const gchar* date, const gchar* _result_, GError** error) {
	GFile* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gchar* _tmp3_;
	gchar* year;
	gchar* _tmp4_;
	gchar* month;
	gchar* _tmp5_;
	gchar* day;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* relative_path = NULL;
	GFile* file = NULL;
	gint version;
	sqlite3_stmt* statement = NULL;
	sqlite3* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_;
	sqlite3_stmt* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	sqlite3_stmt* _tmp57_;
	gint _tmp58_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (date != NULL, NULL);
	g_return_val_if_fail (_result_ != NULL, NULL);
	history_load (self);
	_tmp0_ = date;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ".", 0);
	tokens = _tmp2_;
	tokens_length1 = _vala_array_length (_tmp1_);
	_tokens_size_ = tokens_length1;
	_tmp3_ = g_strdup ("????");
	year = _tmp3_;
	_tmp4_ = g_strdup ("??");
	month = _tmp4_;
	_tmp5_ = g_strdup ("??");
	day = _tmp5_;
	_tmp6_ = tokens;
	_tmp6__length1 = tokens_length1;
	if (_tmp6__length1 == 3) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp7_ = tokens;
		_tmp7__length1 = tokens_length1;
		_tmp8_ = _tmp7_[0];
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (year);
		year = _tmp9_;
		_tmp10_ = tokens;
		_tmp10__length1 = tokens_length1;
		_tmp11_ = _tmp10_[1];
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (month);
		month = _tmp12_;
		_tmp13_ = tokens;
		_tmp13__length1 = tokens_length1;
		_tmp14_ = _tmp13_[2];
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (day);
		day = _tmp15_;
	}
	version = 0;
	while (TRUE) {
		gchar* filename = NULL;
		gint _tmp16_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_ = NULL;
		GFile* _tmp31_;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		GFile* _tmp37_ = NULL;
		GFile* _tmp38_;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_;
		gint _tmp49_;
		_tmp16_ = version;
		if (_tmp16_ == 0) {
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_ = NULL;
			_tmp17_ = year;
			_tmp18_ = month;
			_tmp19_ = day;
			_tmp20_ = g_strdup_printf ("%s-%s-%s.pgn", _tmp17_, _tmp18_, _tmp19_);
			_g_free0 (filename);
			filename = _tmp20_;
		} else {
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gint _tmp24_;
			gchar* _tmp25_ = NULL;
			_tmp21_ = year;
			_tmp22_ = month;
			_tmp23_ = day;
			_tmp24_ = version;
			_tmp25_ = g_strdup_printf ("%s-%s-%s-%d.pgn", _tmp21_, _tmp22_, _tmp23_, _tmp24_);
			_g_free0 (filename);
			filename = _tmp25_;
		}
		_tmp26_ = year;
		_tmp27_ = month;
		_tmp28_ = day;
		_tmp29_ = filename;
		_tmp30_ = g_build_filename (_tmp26_, _tmp27_, _tmp28_, _tmp29_, NULL, NULL);
		_g_free0 (relative_path);
		relative_path = _tmp30_;
		_tmp31_ = self->priv->history_dir;
		_tmp32_ = g_file_get_path (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = relative_path;
		_tmp35_ = g_build_filename (_tmp33_, _tmp34_, NULL, NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_file_new_for_path (_tmp36_);
		_g_object_unref0 (file);
		file = _tmp37_;
		_g_free0 (_tmp36_);
		_g_free0 (_tmp33_);
		_tmp38_ = file;
		_tmp39_ = g_file_get_path (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_path_get_dirname (_tmp40_);
		_tmp42_ = _tmp41_;
		g_mkdir_with_parents (_tmp42_, 0755);
		_g_free0 (_tmp42_);
		_g_free0 (_tmp40_);
		{
			GFile* _tmp43_;
			GFileOutputStream* _tmp44_ = NULL;
			GFileOutputStream* _tmp45_;
			_tmp43_ = file;
			_tmp44_ = g_file_create (_tmp43_, G_FILE_CREATE_NONE, NULL, &_inner_error_);
			_tmp45_ = _tmp44_;
			_g_object_unref0 (_tmp45_);
			if (_inner_error_ != NULL) {
				goto __catch19_g_error;
			}
			_g_free0 (filename);
			break;
		}
		goto __finally19;
		__catch19_g_error:
		{
			GError* e = NULL;
			GError* _tmp46_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp46_ = e;
			if (!g_error_matches (_tmp46_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				GError* _tmp47_;
				GError* _tmp48_;
				_tmp47_ = e;
				_tmp48_ = _g_error_copy0 (_tmp47_);
				_inner_error_ = _tmp48_;
				_g_error_free0 (e);
				goto __finally19;
			}
			_g_error_free0 (e);
		}
		__finally19:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (filename);
			_g_object_unref0 (file);
			_g_free0 (relative_path);
			_g_free0 (day);
			_g_free0 (month);
			_g_free0 (year);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp49_ = version;
		version = _tmp49_ + 1;
		_g_free0 (filename);
	}
	_tmp50_ = self->priv->db;
	_tmp51_ = relative_path;
	_tmp52_ = _result_;
	_tmp53_ = g_strdup_printf ("INSERT INTO GameTable (date, path, result) VALUES (0, \"%s\", \"%s\")", _tmp51_, _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp56_ = sqlite3_prepare_v2 (_tmp50_, _tmp54_, -1, &_tmp55_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp55_;
	_vala_assert (_tmp56_ == SQLITE_OK, "db.prepare_v2 (\"INSERT INTO GameTable (date, path, result) VALUES (0, \\\"%s\\\", \\\"%s\\\")\".printf (relative_path, result), -1, out statement) == Sqlite.OK");
	_g_free0 (_tmp54_);
	_tmp57_ = statement;
	_tmp58_ = sqlite3_step (_tmp57_);
	if (_tmp58_ != SQLITE_DONE) {
		sqlite3* _tmp59_;
		const gchar* _tmp60_ = NULL;
		_tmp59_ = self->priv->db;
		_tmp60_ = sqlite3_errmsg (_tmp59_);
		g_warning ("history.vala:56: Failed to insert game into history index: %s", _tmp60_);
	}
	result = file;
	_sqlite3_finalize0 (statement);
	_g_free0 (relative_path);
	_g_free0 (day);
	_g_free0 (month);
	_g_free0 (year);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


void history_remove (History* self, GFile* file) {
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* relative_path;
	sqlite3_stmt* statement = NULL;
	sqlite3* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	sqlite3_stmt* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	sqlite3_stmt* _tmp9_;
	gint _tmp10_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->history_dir;
	_tmp1_ = file;
	_tmp2_ = g_file_get_relative_path (_tmp0_, _tmp1_);
	relative_path = _tmp2_;
	_tmp3_ = self->priv->db;
	_tmp4_ = relative_path;
	_tmp5_ = g_strdup_printf ("DELETE FROM GameTable WHERE path=\"%s\"", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp8_ = sqlite3_prepare_v2 (_tmp3_, _tmp6_, -1, &_tmp7_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp7_;
	_vala_assert (_tmp8_ == SQLITE_OK, "db.prepare_v2 (\"DELETE FROM GameTable WHERE path=\\\"%s\\\"\".printf (relative_path), -1, out statement) == Sqlite.OK");
	_g_free0 (_tmp6_);
	_tmp9_ = statement;
	_tmp10_ = sqlite3_step (_tmp9_);
	if (_tmp10_ != SQLITE_DONE) {
		sqlite3* _tmp11_;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = self->priv->db;
		_tmp12_ = sqlite3_errmsg (_tmp11_);
		g_warning ("history.vala:68: Failed to remove game from history index: %s", _tmp12_);
	}
	_sqlite3_finalize0 (statement);
	_g_free0 (relative_path);
}


void history_update (History* self, GFile* file, const gchar* fen, const gchar* _result_) {
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* relative_path;
	sqlite3_stmt* statement = NULL;
	sqlite3* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	sqlite3_stmt* _tmp11_;
	gint _tmp12_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (fen != NULL);
	g_return_if_fail (_result_ != NULL);
	_tmp0_ = self->priv->history_dir;
	_tmp1_ = file;
	_tmp2_ = g_file_get_relative_path (_tmp0_, _tmp1_);
	relative_path = _tmp2_;
	_tmp3_ = self->priv->db;
	_tmp4_ = fen;
	_tmp5_ = _result_;
	_tmp6_ = relative_path;
	_tmp7_ = g_strdup_printf ("UPDATE GameTable SET fen=\"%s\", result=\"%s\" WHERE path=\"%s\"", _tmp4_, _tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp10_ = sqlite3_prepare_v2 (_tmp3_, _tmp8_, -1, &_tmp9_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp9_;
	_vala_assert (_tmp10_ == SQLITE_OK, "db.prepare_v2 (\"UPDATE GameTable SET fen=\\\"%s\\\", result=\\\"%s\\\" WHERE path=\\\"%s\\\"\".printf (fen, result, relative_path), -1, out statement) == Sqlite.OK");
	_g_free0 (_tmp8_);
	_tmp11_ = statement;
	_tmp12_ = sqlite3_step (_tmp11_);
	if (_tmp12_ != SQLITE_DONE) {
		sqlite3* _tmp13_;
		const gchar* _tmp14_ = NULL;
		_tmp13_ = self->priv->db;
		_tmp14_ = sqlite3_errmsg (_tmp13_);
		g_warning ("history.vala:78: Failed to update game in history index: %s", _tmp14_);
	}
	_sqlite3_finalize0 (statement);
	_g_free0 (relative_path);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GList* history_get_unfinished (History* self) {
	GList* result = NULL;
	GList* values;
	sqlite3_stmt* statement = NULL;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _result_;
	gint _tmp3_;
	gint _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	history_load (self);
	values = NULL;
	_tmp0_ = self->priv->db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT path FROM GameTable WHERE result=\"*\"", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp1_;
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	_vala_assert (_tmp3_ == SQLITE_OK, "result == Sqlite.OK");
	while (TRUE) {
		sqlite3_stmt* _tmp4_;
		gint _tmp5_ = 0;
		gint _tmp6_;
		sqlite3_stmt* _tmp7_;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* path;
		const gchar* _tmp10_;
		GFile* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		GFile* _tmp17_ = NULL;
		_tmp4_ = statement;
		_tmp5_ = sqlite3_step (_tmp4_);
		_result_ = _tmp5_;
		_tmp6_ = _result_;
		if (!(_tmp6_ == SQLITE_ROW)) {
			break;
		}
		_tmp7_ = statement;
		_tmp8_ = sqlite3_column_text (_tmp7_, 0);
		_tmp9_ = g_strdup (_tmp8_);
		path = _tmp9_;
		_tmp10_ = path;
		g_debug ("history.vala:94: %s is unfinished", _tmp10_);
		_tmp11_ = self->priv->history_dir;
		_tmp12_ = g_file_get_path (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = path;
		_tmp15_ = g_build_filename (_tmp13_, _tmp14_, NULL, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_file_new_for_path (_tmp16_);
		values = g_list_append (values, _tmp17_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp13_);
		_g_free0 (path);
	}
	_tmp18_ = _result_;
	if (_tmp18_ != SQLITE_DONE) {
		sqlite3* _tmp19_;
		const gchar* _tmp20_ = NULL;
		_tmp19_ = self->priv->db;
		_tmp20_ = sqlite3_errmsg (_tmp19_);
		g_warning ("history.vala:99: Failed to get unfinished games: %s", _tmp20_);
	}
	result = values;
	_sqlite3_finalize0 (statement);
	return result;
}


static void history_load (History* self) {
	gboolean _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean have_history;
	GFile* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GFile* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	sqlite3* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gboolean _tmp13_;
	sqlite3_stmt* statement = NULL;
	sqlite3* _tmp16_;
	sqlite3_stmt* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _result_;
	gint _tmp19_;
	sqlite3_stmt* _tmp20_;
	gint _tmp21_ = 0;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	GFile* _tmp27_ = NULL;
	GFile* _tmp28_;
	GFile* old_history_dir;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_;
	gboolean _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->loaded;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->history_dir;
	_tmp2_ = g_file_query_exists (_tmp1_, NULL);
	have_history = _tmp2_;
	_tmp3_ = self->priv->history_dir;
	_tmp4_ = g_file_get_path (_tmp3_);
	_tmp5_ = _tmp4_;
	g_mkdir_with_parents (_tmp5_, 0755);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->history_dir;
	_tmp7_ = g_file_get_path (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_build_filename (_tmp8_, "index.db", NULL);
	_tmp10_ = _tmp9_;
	_tmp12_ = sqlite3_open_v2 (_tmp10_, &_tmp11_, SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
	_sqlite3_close0 (self->priv->db);
	self->priv->db = _tmp11_;
	_tmp13_ = _tmp12_ != SQLITE_OK;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	if (_tmp13_) {
		sqlite3* _tmp14_;
		const gchar* _tmp15_ = NULL;
		_tmp14_ = self->priv->db;
		_tmp15_ = sqlite3_errmsg (_tmp14_);
		g_warning ("history.vala:114: Failed to load history index: %s", _tmp15_);
	}
	_tmp16_ = self->priv->db;
	_tmp18_ = sqlite3_prepare_v2 (_tmp16_, "CREATE TABLE IF NOT EXISTS GameTable (id INTEGER PRIMARY KEY, date INT" \
"EGER, path TEXT, fen TEXT, result TEXT)", -1, &_tmp17_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp17_;
	_result_ = _tmp18_;
	_tmp19_ = _result_;
	_vala_assert (_tmp19_ == SQLITE_OK, "result == Sqlite.OK");
	_tmp20_ = statement;
	_tmp21_ = sqlite3_step (_tmp20_);
	if (_tmp21_ != SQLITE_DONE) {
		sqlite3* _tmp22_;
		const gchar* _tmp23_ = NULL;
		_tmp22_ = self->priv->db;
		_tmp23_ = sqlite3_errmsg (_tmp22_);
		g_warning ("history.vala:121: Failed to create game table: %s", _tmp23_);
	}
	_tmp24_ = g_get_home_dir ();
	_tmp25_ = g_build_filename (_tmp24_, ".gnome2", "glchess", "history", NULL, NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_file_new_for_path (_tmp26_);
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp26_);
	old_history_dir = _tmp28_;
	_tmp30_ = have_history;
	if (!_tmp30_) {
		GFile* _tmp31_;
		gboolean _tmp32_ = FALSE;
		_tmp31_ = old_history_dir;
		_tmp32_ = g_file_query_exists (_tmp31_, NULL);
		_tmp29_ = _tmp32_;
	} else {
		_tmp29_ = FALSE;
	}
	_tmp33_ = _tmp29_;
	if (_tmp33_) {
		GFile* _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		GFile* _tmp37_;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_;
		_tmp34_ = old_history_dir;
		_tmp35_ = g_file_get_path (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = self->priv->history_dir;
		_tmp38_ = g_file_get_path (_tmp37_);
		_tmp39_ = _tmp38_;
		g_debug ("history.vala:127: Migrating history from %s to %s", _tmp36_, _tmp39_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp36_);
		{
			GFile* _tmp40_;
			GFile* _tmp41_;
			_tmp40_ = old_history_dir;
			_tmp41_ = old_history_dir;
			history_load_history_recursive (self, _tmp40_, _tmp41_, FALSE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch20_g_error;
			}
		}
		goto __finally20;
		__catch20_g_error:
		{
			GError* e = NULL;
			GError* _tmp42_;
			const gchar* _tmp43_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp42_ = e;
			_tmp43_ = _tmp42_->message;
			g_warning ("history.vala:134: Failed to migrate history: %s", _tmp43_);
			_g_error_free0 (e);
		}
		__finally20:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (old_history_dir);
			_sqlite3_finalize0 (statement);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->loaded = TRUE;
	_g_object_unref0 (old_history_dir);
	_sqlite3_finalize0 (statement);
}


static gpointer _pgn_game_ref0 (gpointer self) {
	return self ? pgn_game_ref (self) : NULL;
}


static void history_load_history_recursive (History* self, GFile* base_dir, GFile* dir, gboolean load_files, GError** error) {
	GFile* _tmp0_;
	GFileEnumerator* _tmp1_ = NULL;
	GFileEnumerator* children;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (base_dir != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = dir;
	_tmp1_ = g_file_enumerate_children (_tmp0_, "standard::*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
	children = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	while (TRUE) {
		GFileEnumerator* _tmp2_;
		GFileInfo* _tmp3_ = NULL;
		GFileInfo* info;
		GFileInfo* _tmp4_;
		GFileInfo* _tmp5_;
		GFileType _tmp6_ = 0;
		_tmp2_ = children;
		_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error_);
		info = _tmp3_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (children);
			return;
		}
		_tmp4_ = info;
		if (_tmp4_ == NULL) {
			_g_object_unref0 (info);
			_g_object_unref0 (children);
			return;
		}
		_tmp5_ = info;
		_tmp6_ = g_file_info_get_file_type (_tmp5_);
		switch (_tmp6_) {
			case G_FILE_TYPE_REGULAR:
			{
				gboolean _tmp7_;
				GFile* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				GFileInfo* _tmp11_;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				GFile* _tmp15_ = NULL;
				GFile* _tmp16_;
				GFile* f;
				GFile* _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				_tmp7_ = load_files;
				if (!_tmp7_) {
					break;
				}
				_tmp8_ = dir;
				_tmp9_ = g_file_get_path (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = info;
				_tmp12_ = g_file_info_get_name (_tmp11_);
				_tmp13_ = g_build_filename (_tmp10_, _tmp12_, NULL, NULL);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_file_new_for_path (_tmp14_);
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp14_);
				_g_free0 (_tmp10_);
				f = _tmp16_;
				_tmp17_ = f;
				_tmp18_ = g_file_get_path (_tmp17_);
				_tmp19_ = _tmp18_;
				g_debug ("history.vala:158: Migrating %s", _tmp19_);
				_g_free0 (_tmp19_);
				{
					GFile* _tmp20_;
					PGN* _tmp21_;
					PGN* pgn;
					PGN* _tmp22_;
					GList* _tmp23_;
					gconstpointer _tmp24_ = NULL;
					PGNGame* _tmp25_;
					PGNGame* game;
					PGNGame* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					PGNGame* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					GFile* _tmp32_ = NULL;
					GFile* new_file;
					GFile* _tmp33_;
					GFile* _tmp34_;
					_tmp20_ = f;
					_tmp21_ = pgn_new_from_file (_tmp20_, &_inner_error_);
					pgn = _tmp21_;
					if (_inner_error_ != NULL) {
						goto __catch21_g_error;
					}
					_tmp22_ = pgn;
					_tmp23_ = _tmp22_->games;
					_tmp24_ = g_list_nth_data (_tmp23_, (guint) 0);
					_tmp25_ = _pgn_game_ref0 ((PGNGame*) _tmp24_);
					game = _tmp25_;
					_tmp26_ = game;
					_tmp27_ = pgn_game_get_date (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = game;
					_tmp30_ = pgn_game_get_result (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = history_add (self, _tmp28_, _tmp31_, &_inner_error_);
					new_file = _tmp32_;
					if (_inner_error_ != NULL) {
						_pgn_game_unref0 (game);
						_pgn_unref0 (pgn);
						goto __catch21_g_error;
					}
					_tmp33_ = f;
					_tmp34_ = new_file;
					g_file_copy (_tmp33_, _tmp34_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (new_file);
						_pgn_game_unref0 (game);
						_pgn_unref0 (pgn);
						goto __catch21_g_error;
					}
					_g_object_unref0 (new_file);
					_pgn_game_unref0 (game);
					_pgn_unref0 (pgn);
				}
				goto __finally21;
				__catch21_g_error:
				{
					GError* e = NULL;
					GError* _tmp35_;
					const gchar* _tmp36_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp35_ = e;
					_tmp36_ = _tmp35_->message;
					g_warning ("history.vala:171: Failed to migrate file: %s", _tmp36_);
					_g_error_free0 (e);
				}
				__finally21:
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_object_unref0 (info);
					_g_object_unref0 (children);
					return;
				}
				_g_object_unref0 (f);
				break;
			}
			case G_FILE_TYPE_DIRECTORY:
			{
				GFile* _tmp37_;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_;
				GFileInfo* _tmp40_;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_;
				gchar* path;
				_tmp37_ = dir;
				_tmp38_ = g_file_get_path (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = info;
				_tmp41_ = g_file_info_get_name (_tmp40_);
				_tmp42_ = g_build_filename (_tmp39_, _tmp41_, NULL, NULL);
				_tmp43_ = _tmp42_;
				_g_free0 (_tmp39_);
				path = _tmp43_;
				{
					GFile* _tmp44_;
					const gchar* _tmp45_;
					GFile* _tmp46_ = NULL;
					GFile* _tmp47_;
					_tmp44_ = base_dir;
					_tmp45_ = path;
					_tmp46_ = g_file_new_for_path (_tmp45_);
					_tmp47_ = _tmp46_;
					history_load_history_recursive (self, _tmp44_, _tmp47_, TRUE, &_inner_error_);
					_g_object_unref0 (_tmp47_);
					if (_inner_error_ != NULL) {
						goto __catch22_g_error;
					}
				}
				goto __finally22;
				__catch22_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp48_;
					GError* _tmp49_;
					const gchar* _tmp50_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp48_ = path;
					_tmp49_ = e;
					_tmp50_ = _tmp49_->message;
					g_warning ("history.vala:182: Couldn't open directory %s: %s", _tmp48_, _tmp50_);
					_g_error_free0 (e);
				}
				__finally22:
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (path);
					_g_object_unref0 (info);
					_g_object_unref0 (children);
					return;
				}
				_g_free0 (path);
				break;
			}
			default:
			{
				break;
			}
		}
		_g_object_unref0 (info);
	}
	_g_object_unref0 (children);
}


static void value_history_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_history_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		history_unref (value->data[0].v_pointer);
	}
}


static void value_history_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = history_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_history_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_history_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		History* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = history_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_history_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	History** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = history_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHistory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HISTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_history (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY), NULL);
	return value->data[0].v_pointer;
}


void value_set_history (GValue* value, gpointer v_object) {
	History* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		history_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_unref (old);
	}
}


void value_take_history (GValue* value, gpointer v_object) {
	History* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_unref (old);
	}
}


static void history_class_init (HistoryClass * klass) {
	history_parent_class = g_type_class_peek_parent (klass);
	HISTORY_CLASS (klass)->finalize = history_finalize;
	g_type_class_add_private (klass, sizeof (HistoryPrivate));
}


static void history_instance_init (History * self) {
	self->priv = HISTORY_GET_PRIVATE (self);
	self->priv->loaded = FALSE;
	self->ref_count = 1;
}


static void history_finalize (History* obj) {
	History * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY, History);
	_g_object_unref0 (self->priv->history_dir);
	_sqlite3_close0 (self->priv->db);
}


GType history_get_type (void) {
	static volatile gsize history_type_id__volatile = 0;
	if (g_once_init_enter (&history_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_history_init, value_history_free_value, value_history_copy_value, value_history_peek_pointer, "p", value_history_collect_value, "p", value_history_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HistoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (History), 0, (GInstanceInitFunc) history_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType history_type_id;
		history_type_id = g_type_register_fundamental (g_type_fundamental_next (), "History", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&history_type_id__volatile, history_type_id);
	}
	return history_type_id__volatile;
}


gpointer history_ref (gpointer instance) {
	History* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void history_unref (gpointer instance) {
	History* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HISTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



