/* Scanner.c generated by valac 0.11.3, the Vala compiler
 * generated from Scanner.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gio/gio.h>
#include <cstuff.h>
#include <float.h>
#include <math.h>


#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
typedef struct _DVBScannerPrivate DVBScannerPrivate;

#define DVB_TYPE_SCANNED_ITEM (dvb_scanned_item_get_type ())
#define DVB_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItem))
#define DVB_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))
#define DVB_IS_SCANNED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNED_ITEM))
#define DVB_IS_SCANNED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNED_ITEM))
#define DVB_SCANNED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNED_ITEM, DVBScannedItemClass))

typedef struct _DVBScannedItem DVBScannedItem;
typedef struct _DVBScannedItemClass DVBScannedItemClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_IO_TYPE_CHANNEL_LIST_WRITER (dvb_io_channel_list_writer_get_type ())
#define DVB_IO_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriter))
#define DVB_IO_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterClass))
#define DVB_IO_IS_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER))
#define DVB_IO_IS_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_CHANNEL_LIST_WRITER))
#define DVB_IO_CHANNEL_LIST_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterClass))

typedef struct _DVBioChannelListWriter DVBioChannelListWriter;
typedef struct _DVBioChannelListWriterClass DVBioChannelListWriterClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _DVBScanner {
	GObject parent_instance;
	DVBScannerPrivate * priv;
	DVBChannelList* channels;
	GstElement* pipeline;
	GQueue* frequencies;
	GstStructure* current_tuning_params;
	GeeHashSet* scanned_frequencies;
};

struct _DVBScannerClass {
	GObjectClass parent_class;
	void (*prepare) (DVBScanner* self);
	DVBScannedItem* (*get_scanned_item) (DVBScanner* self, const GstStructure* structure);
	DVBChannel* (*get_new_channel) (DVBScanner* self);
	void (*add_values_from_structure_to_channel) (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
	void (*add_scanning_data_from_string) (DVBScanner* self, const gchar* line);
};

struct _DVBScannerPrivate {
	DVBDevice* _Device;
	GeeArrayList* new_channels;
	GStaticRecMutex __lock_new_channels;
	GSource* check_for_lock_source;
	GSource* wait_for_tables_source;
	GSource* start_scan_source;
	gboolean nit_arrived;
	gboolean sdt_arrived;
	gboolean pat_arrived;
	gboolean pmt_arrived;
	gboolean locked;
	GMainContext* context;
	GMainLoop* loop;
	GThread* worker_thread;
	gboolean running;
	guint bus_watch_id;
};


static gpointer dvb_scanner_parent_class = NULL;

GType dvb_scanner_get_type (void) G_GNUC_CONST;
GType dvb_scanned_item_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_device_get_type (void) G_GNUC_CONST;
#define DVB_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCANNER, DVBScannerPrivate))
enum  {
	DVB_SCANNER_DUMMY_PROPERTY,
	DVB_SCANNER_DEVICE,
	DVB_SCANNER_CHANNELS
};
#define DVB_SCANNER_BASE_PIDS "16:17"
#define DVB_SCANNER_PIPELINE_TEMPLATE "dvbsrc name=dvbsrc adapter=%u frontend=%u pids=%s stats-reporting-inte" \
"rval=100 ! mpegtsparse ! fakesink silent=true"
void dvb_scanner_prepare (DVBScanner* self);
static void dvb_scanner_real_prepare (DVBScanner* self);
DVBScannedItem* dvb_scanner_get_scanned_item (DVBScanner* self, const GstStructure* structure);
static DVBScannedItem* dvb_scanner_real_get_scanned_item (DVBScanner* self, const GstStructure* structure);
DVBChannel* dvb_scanner_get_new_channel (DVBScanner* self);
static DVBChannel* dvb_scanner_real_get_new_channel (DVBScanner* self);
void dvb_scanner_add_values_from_structure_to_channel (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
static void dvb_scanner_real_add_values_from_structure_to_channel (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel);
void dvb_scanner_add_scanning_data_from_string (DVBScanner* self, const gchar* line);
static void dvb_scanner_real_add_scanning_data_from_string (DVBScanner* self, const gchar* line);
void dvb_scanner_Run (DVBScanner* self, GError** error);
static gboolean dvb_scanner_worker (DVBScanner* self);
static gpointer _dvb_scanner_worker_gthread_func (gpointer self);
DVBChannelList* dvb_channel_list_new (GFile* channels);
DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels);
DVBDevice* dvb_scanner_get_Device (DVBScanner* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
gboolean dvb_scanner_bus_watch_func (DVBScanner* self, GstBus* bus, GstMessage* message);
static gboolean _dvb_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
void dvb_scanner_queue_start_scan (DVBScanner* self);
void dvb_scanner_Destroy (DVBScanner* self, GError** error);
void dvb_scanner_do_destroy (DVBScanner* self);
void dvb_scanner_destroy_start_scan_source (DVBScanner* self);
void dvb_scanner_remove_check_for_lock_timeout (DVBScanner* self);
void dvb_scanner_remove_wait_for_tables_timeout (DVBScanner* self);
void dvb_scanner_clear_and_reset_all (DVBScanner* self);
void dvb_channel_list_clear (DVBChannelList* self);
gboolean dvb_scanner_WriteAllChannelsToFile (DVBScanner* self, const gchar* path, GError** error);
DVBioChannelListWriter* dvb_io_channel_list_writer_new (GFile* file);
DVBioChannelListWriter* dvb_io_channel_list_writer_construct (GType object_type, GFile* file);
GType dvb_io_channel_list_writer_get_type (void) G_GNUC_CONST;
void dvb_io_channel_list_writer_write (DVBioChannelListWriter* self, DVBChannel* channel, GError** error);
gboolean dvb_io_channel_list_writer_close (DVBioChannelListWriter* self, GError** error);
gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
gboolean dvb_scanner_AddScanningDataFromFile (DVBScanner* self, const gchar* path, GError** error);
gboolean dvb_utils_is_readable_file (GFile* file);
void dvb_scanner_clear_frequencies (DVBScanner* self);
void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure);
guint dvb_scanned_item_get_Frequency (DVBScannedItem* self);
gboolean dvb_scanner_start_scan (DVBScanner* self);
void dvb_channel_list_remove (DVBChannelList* self, guint sid);
gboolean dvb_scanner_check_for_lock (DVBScanner* self);
static gboolean _dvb_scanner_check_for_lock_gsource_func (gpointer self);
gboolean dvb_scanner_wait_for_tables (DVBScanner* self);
static gboolean _dvb_scanner_start_scan_gsource_func (gpointer self);
void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const gchar* key);
void dvb_scanner_on_dvb_frontend_stats_structure (DVBScanner* self, const GstStructure* structure);
static gboolean _dvb_scanner_wait_for_tables_gsource_func (gpointer self);
void dvb_scanner_on_dvb_read_failure_structure (DVBScanner* self);
void dvb_scanner_on_pat_structure (DVBScanner* self, const GstStructure* structure);
void dvb_scanner_on_sdt_structure (DVBScanner* self, const GstStructure* structure);
gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid);
void dvb_scanner_add_new_channel (DVBScanner* self, guint sid);
void dvb_channel_set_Scrambled (DVBChannel* self, gboolean value);
void dvb_channel_set_Name (DVBChannel* self, const gchar* value);
void dvb_channel_set_TransportStreamId (DVBChannel* self, guint value);
void dvb_channel_set_Network (DVBChannel* self, const gchar* value);
const gchar* dvb_channel_get_Name (DVBChannel* self);
gboolean dvb_channel_get_Scrambled (DVBChannel* self);
void dvb_scanner_on_nit_structure (DVBScanner* self, const GstStructure* structure);
void dvb_channel_set_LogicalChannelNumber (DVBChannel* self, guint* value);
void dvb_scanner_on_pmt_structure (DVBScanner* self, const GstStructure* structure);
void dvb_channel_set_VideoPID (DVBChannel* self, guint value);
GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self);
gboolean dvb_channel_is_valid (DVBChannel* self);
gboolean dvb_channel_is_radio (DVBChannel* self);
gchar* dvb_channel_to_string (DVBChannel* self);
guint dvb_channel_get_Frequency (DVBChannel* self);
const gchar* dvb_channel_get_Network (DVBChannel* self);
void dvb_channel_set_Sid (DVBChannel* self, guint value);
void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel);
DVBScanner* dvb_scanner_construct (GType object_type);
static void dvb_scanner_set_Device (DVBScanner* self, DVBDevice* value);
DVBChannelList* dvb_scanner_get_Channels (DVBScanner* self);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * dvb_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
guint dvb_scanned_item_hash (DVBScannedItem* o);
static guint _dvb_scanned_item_hash_ghash_func (gconstpointer key);
gboolean dvb_scanned_item_equal (DVBScannedItem* o1, DVBScannedItem* o2);
static gboolean _dvb_scanned_item_equal_gequal_func (gconstpointer a, gconstpointer b);
static void dvb_scanner_finalize (GObject* obj);
static void _vala_dvb_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
         * Setup the pipeline correctly
         */
static void dvb_scanner_real_prepare (DVBScanner* self) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_scanner_prepare'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_scanner_prepare (DVBScanner* self) {
	DVB_SCANNER_GET_CLASS (self)->prepare (self);
}


/**
         * Use the frequency and possibly other data to
         * mark the tuning paramters as already used
         */
static DVBScannedItem* dvb_scanner_real_get_scanned_item (DVBScanner* self, const GstStructure* structure) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_scanner_get_scanned_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DVBScannedItem* dvb_scanner_get_scanned_item (DVBScanner* self, const GstStructure* structure) {
	return DVB_SCANNER_GET_CLASS (self)->get_scanned_item (self, structure);
}


/**
         * Return a new empty channel
         */
static DVBChannel* dvb_scanner_real_get_new_channel (DVBScanner* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_scanner_get_new_channel'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DVBChannel* dvb_scanner_get_new_channel (DVBScanner* self) {
	return DVB_SCANNER_GET_CLASS (self)->get_new_channel (self);
}


/**
         * Retrieve the data from structure and add it to the Channel
         */
static void dvb_scanner_real_add_values_from_structure_to_channel (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_scanner_add_values_from_structure_to_channel'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_scanner_add_values_from_structure_to_channel (DVBScanner* self, const GstStructure* delivery, DVBChannel* channel) {
	DVB_SCANNER_GET_CLASS (self)->add_values_from_structure_to_channel (self, delivery, channel);
}


/**
         * Called to parse a line from the initial tuning data
         */
static void dvb_scanner_real_add_scanning_data_from_string (DVBScanner* self, const gchar* line) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_scanner_add_scanning_data_from_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_scanner_add_scanning_data_from_string (DVBScanner* self, const gchar* line) {
	DVB_SCANNER_GET_CLASS (self)->add_scanning_data_from_string (self, line);
}


/**
         * Start the scanner
         */
static gpointer _dvb_scanner_worker_gthread_func (gpointer self) {
	gpointer result;
	result = dvb_scanner_worker (self);
	return result;
}


static gboolean _dvb_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = dvb_scanner_bus_watch_func (self, bus, message);
	return result;
}


void dvb_scanner_Run (DVBScanner* self, GError** error) {
	GMainLoop* _tmp0_ = NULL;
	GMainLoop* _tmp1_;
	GThread* _tmp2_ = NULL;
	GThread* _tmp3_;
	DVBChannelList* _tmp4_ = NULL;
	DVBChannelList* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GstElement* _tmp10_ = NULL;
	GstElement* _tmp11_;
	GstElement* _tmp12_;
	GstElement* _tmp13_;
	GstBus* _tmp14_ = NULL;
	GstBus* bus;
	guint _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->running) {
		return;
	}
	self->priv->running = TRUE;
	_tmp0_ = g_main_loop_new (self->priv->context, FALSE);
	_tmp1_ = _tmp0_;
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp1_;
	_tmp2_ = g_thread_create (_dvb_scanner_worker_gthread_func, self, TRUE, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_THREAD_ERROR) {
			goto __catch138_g_thread_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->worker_thread = _tmp3_;
	goto __finally138;
	__catch138_g_thread_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Scanner.vala:160: Could not create thread: %s", e->message);
		_g_error_free0 (e);
		return;
	}
	__finally138:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = dvb_channel_list_new (NULL);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->channels);
	self->channels = _tmp5_;
	_tmp6_ = dvb_device_get_Adapter (self->priv->_Device);
	_tmp7_ = dvb_device_get_Frontend (self->priv->_Device);
	_tmp8_ = g_strdup_printf (DVB_SCANNER_PIPELINE_TEMPLATE, _tmp6_, _tmp7_, DVB_SCANNER_BASE_PIDS);
	_tmp9_ = _tmp8_;
	_tmp10_ = gst_parse_launch (_tmp9_, &_inner_error_);
	_tmp12_ = (_tmp11_ = _tmp10_, _g_free0 (_tmp9_), _tmp11_);
	if (_inner_error_ != NULL) {
		goto __catch139_g_error;
	}
	_tmp13_ = _tmp12_;
	_gst_object_unref0 (self->pipeline);
	self->pipeline = _tmp13_;
	goto __finally139;
	__catch139_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Scanner.vala:171: Could not create pipeline: %s", e->message);
		_g_error_free0 (e);
		return;
	}
	__finally139:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = gst_element_get_bus (self->pipeline);
	bus = _tmp14_;
	_tmp15_ = gst_bus_add_watch_context (bus, _dvb_scanner_bus_watch_func_gst_bus_func, self, self->priv->context);
	self->priv->bus_watch_id = _tmp15_;
	gst_element_set_state (self->pipeline, GST_STATE_READY);
	dvb_scanner_queue_start_scan (self);
	_gst_object_unref0 (bus);
}


/**
         * Abort scanning and cleanup
         */
void dvb_scanner_Destroy (DVBScanner* self, GError** error) {
	g_return_if_fail (self != NULL);
	dvb_scanner_do_destroy (self);
}


void dvb_scanner_do_destroy (DVBScanner* self) {
	DVBChannelList* _tmp0_;
	g_return_if_fail (self != NULL);
	dvb_scanner_destroy_start_scan_source (self);
	dvb_scanner_remove_check_for_lock_timeout (self);
	dvb_scanner_remove_wait_for_tables_timeout (self);
	dvb_scanner_clear_and_reset_all (self);
	dvb_channel_list_clear (self->channels);
	_tmp0_ = NULL;
	_g_object_unref0 (self->channels);
	self->channels = _tmp0_;
	if (self->priv->loop != NULL) {
		GMainLoop* _tmp1_;
		g_main_loop_quit (self->priv->loop);
		_tmp1_ = NULL;
		_g_main_loop_unref0 (self->priv->loop);
		self->priv->loop = _tmp1_;
		g_thread_join (self->priv->worker_thread);
		self->priv->worker_thread = NULL;
	}
	g_signal_emit_by_name (self, "destroyed");
}


/** 
         * @path: Location where the file will be stored
         *
         * Write all the channels stored in this.Channels to file
         */
gboolean dvb_scanner_WriteAllChannelsToFile (DVBScanner* self, const gchar* path, GError** error) {
	gboolean result = FALSE;
	gboolean success;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	DVBioChannelListWriter* _tmp2_ = NULL;
	DVBioChannelListWriter* _tmp3_;
	DVBioChannelListWriter* writer;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	success = TRUE;
	_tmp0_ = g_file_new_for_path (path);
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_io_channel_list_writer_new (_tmp1_);
	writer = (_tmp3_ = _tmp2_, _g_object_unref0 (_tmp1_), _tmp3_);
	{
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _c_it;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) self->channels);
		_c_it = _tmp4_;
		while (TRUE) {
			gboolean _tmp5_;
			gpointer _tmp6_ = NULL;
			DVBChannel* c;
			_tmp5_ = gee_iterator_next (_c_it);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = gee_iterator_get (_c_it);
			c = (DVBChannel*) _tmp6_;
			dvb_io_channel_list_writer_write (writer, c, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch140_g_error;
			}
			goto __finally140;
			__catch140_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				g_critical ("Scanner.vala:220: Could not write to file: %s", e->message);
				success = FALSE;
				_g_error_free0 (e);
			}
			__finally140:
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DBUS_GERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (c);
					_g_object_unref0 (_c_it);
					_g_object_unref0 (writer);
					return FALSE;
				} else {
					_g_object_unref0 (c);
					_g_object_unref0 (_c_it);
					_g_object_unref0 (writer);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_it);
	}
	dvb_io_channel_list_writer_close (writer, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch141_g_error;
	}
	goto __finally141;
	__catch141_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Scanner.vala:228: Could not close file handle: %s", e->message);
		success = FALSE;
		_g_error_free0 (e);
	}
	__finally141:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (writer);
			return FALSE;
		} else {
			_g_object_unref0 (writer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (writer);
	return result;
}


/**
         * @channel_sids: A list of channels' SIDs
         * @path: Location where the file will be stored
         *
         * Write the channels with the given SIDs to file @path
         */
gboolean dvb_scanner_WriteChannelsToFile (DVBScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error) {
	gboolean result = FALSE;
	gboolean success;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_;
	DVBioChannelListWriter* _tmp2_ = NULL;
	DVBioChannelListWriter* _tmp3_;
	DVBioChannelListWriter* writer;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	success = TRUE;
	_tmp0_ = g_file_new_for_path (path);
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_io_channel_list_writer_new (_tmp1_);
	writer = (_tmp3_ = _tmp2_, _g_object_unref0 (_tmp1_), _tmp3_);
	{
		guint* sid_collection;
		int sid_collection_length1;
		int sid_it;
		sid_collection = channel_sids;
		sid_collection_length1 = channel_sids_length1;
		for (sid_it = 0; sid_it < channel_sids_length1; sid_it = sid_it + 1) {
			guint sid;
			sid = sid_collection[sid_it];
			{
				DVBChannel* _tmp4_ = NULL;
				DVBChannel* c;
				_tmp4_ = dvb_channel_list_get_channel (self->channels, sid);
				c = _tmp4_;
				if (c == NULL) {
					g_warning ("Scanner.vala:249: Channel with SID 0x%x does not exist", sid);
					_g_object_unref0 (c);
					continue;
				}
				dvb_io_channel_list_writer_write (writer, c, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch142_g_error;
				}
				goto __finally142;
				__catch142_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_critical ("Scanner.vala:255: Could not write to file: %s", e->message);
					success = FALSE;
					_g_error_free0 (e);
				}
				__finally142:
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DBUS_GERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (c);
						_g_object_unref0 (writer);
						return FALSE;
					} else {
						_g_object_unref0 (c);
						_g_object_unref0 (writer);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				_g_object_unref0 (c);
			}
		}
	}
	dvb_io_channel_list_writer_close (writer, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch143_g_error;
	}
	goto __finally143;
	__catch143_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Scanner.vala:263: Could not close file handle: %s", e->message);
		success = FALSE;
		_g_error_free0 (e);
	}
	__finally143:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (writer);
			return FALSE;
		} else {
			_g_object_unref0 (writer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_object_unref0 (writer);
	return result;
}


static gchar* string_chug (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}


gboolean dvb_scanner_AddScanningDataFromFile (DVBScanner* self, const gchar* path, GError** error) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* datafile;
	gboolean _tmp1_;
	GDataInputStream* reader;
	GFileInputStream* _tmp2_ = NULL;
	GFileInputStream* _tmp3_;
	GFileInputStream* _tmp4_;
	GDataInputStream* _tmp5_ = NULL;
	GDataInputStream* _tmp6_;
	gchar* line;
	gsize len = 0UL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (path);
	datafile = _tmp0_;
	g_debug ("Scanner.vala:273: Reading scanning data from %s", path);
	_tmp1_ = dvb_utils_is_readable_file (datafile);
	if (!_tmp1_) {
		result = FALSE;
		_g_object_unref0 (datafile);
		return result;
	}
	reader = NULL;
	_tmp2_ = g_file_read (datafile, NULL, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		goto __catch144_g_error;
	}
	_tmp4_ = _tmp3_;
	_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (reader);
	reader = _tmp6_;
	_g_object_unref0 (_tmp4_);
	goto __finally144;
	__catch144_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Scanner.vala:281: Could not open %s: %s", path, e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (reader);
		_g_object_unref0 (datafile);
		return result;
	}
	__finally144:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			return FALSE;
		} else {
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	line = NULL;
	while (TRUE) {
		gsize _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp8_ = g_data_input_stream_read_line (reader, &_tmp7_, NULL, &_inner_error_);
		len = _tmp7_;
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			goto __catch145_g_error;
		}
		_tmp10_ = _tmp9_;
		_g_free0 (line);
		line = _tmp10_;
		if (!(line != NULL)) {
			break;
		}
		if (len == 0) {
			continue;
		}
		_tmp11_ = string_chug (line);
		_tmp12_ = _tmp11_;
		_g_free0 (line);
		line = _tmp12_;
		_tmp13_ = g_str_has_prefix (line, "#");
		if (_tmp13_) {
			continue;
		}
		dvb_scanner_add_scanning_data_from_string (self, line);
	}
	goto __finally145;
	__catch145_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Scanner.vala:297: Could not read %s: %s", path, e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (line);
		_g_object_unref0 (reader);
		_g_object_unref0 (datafile);
		return result;
	}
	__finally145:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			return FALSE;
		} else {
			_g_free0 (line);
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	g_input_stream_close ((GInputStream*) reader, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch146_g_error;
	}
	goto __finally146;
	__catch146_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Scanner.vala:304: Could not close file handle: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (line);
		_g_object_unref0 (reader);
		_g_object_unref0 (datafile);
		return result;
	}
	__finally146:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			return FALSE;
		} else {
			_g_free0 (line);
			_g_object_unref0 (reader);
			_g_object_unref0 (datafile);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_free0 (line);
	_g_object_unref0 (reader);
	_g_object_unref0 (datafile);
	return result;
}


static gboolean dvb_scanner_worker (DVBScanner* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_main_loop_run (self->priv->loop);
	result = TRUE;
	return result;
}


static gpointer _g_source_ref0 (gpointer self) {
	return self ? g_source_ref (self) : NULL;
}


void dvb_scanner_clear_and_reset_all (DVBScanner* self) {
	GstStructure* _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->pipeline != NULL) {
		GSource* _tmp0_ = NULL;
		GSource* _tmp1_;
		GSource* bus_watch_source;
		GstElement* _tmp2_;
		_tmp0_ = g_main_context_find_source_by_id (self->priv->context, self->priv->bus_watch_id);
		_tmp1_ = _g_source_ref0 (_tmp0_);
		bus_watch_source = _tmp1_;
		if (bus_watch_source != NULL) {
			g_source_destroy (bus_watch_source);
			self->priv->bus_watch_id = (guint) 0;
		}
		g_debug ("Scanner.vala:326: Disposing pipeline");
		gst_element_set_state (self->pipeline, GST_STATE_NULL);
		_tmp2_ = NULL;
		_gst_object_unref0 (self->pipeline);
		self->pipeline = _tmp2_;
		_g_source_unref0 (bus_watch_source);
	}
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->scanned_frequencies);
	dvb_scanner_clear_frequencies (self);
	_tmp3_ = NULL;
	_gst_structure_free0 (self->current_tuning_params);
	self->current_tuning_params = _tmp3_;
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->new_channels);
	self->priv->running = FALSE;
}


void dvb_scanner_clear_frequencies (DVBScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_;
		gpointer _tmp1_ = NULL;
		GstStructure* s;
		GstStructure* _tmp2_;
		_tmp0_ = g_queue_is_empty (self->frequencies);
		if (!(!_tmp0_)) {
			break;
		}
		_tmp1_ = g_queue_pop_head (self->frequencies);
		s = (GstStructure*) _tmp1_;
		_tmp2_ = NULL;
		_gst_structure_free0 (s);
		s = _tmp2_;
		_gst_structure_free0 (s);
	}
	g_queue_clear (self->frequencies);
}


static gpointer _gst_structure_copy0 (gpointer self) {
	return self ? gst_structure_copy (self) : NULL;
}


void dvb_scanner_add_structure_to_scan (DVBScanner* self, GstStructure* structure) {
	DVBScannedItem* _tmp0_ = NULL;
	DVBScannedItem* item;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	if (structure == NULL) {
		_gst_structure_free0 (structure);
		return;
	}
	_tmp0_ = dvb_scanner_get_scanned_item (self, structure);
	item = _tmp0_;
	_tmp1_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->scanned_frequencies, item);
	if (!_tmp1_) {
		guint _tmp2_;
		GstStructure* _tmp3_;
		_tmp2_ = dvb_scanned_item_get_Frequency (item);
		g_debug ("Scanner.vala:354: Queueing new frequency %u", _tmp2_);
		_tmp3_ = _gst_structure_copy0 (structure);
		g_queue_push_tail (self->frequencies, _tmp3_);
		gee_abstract_collection_add ((GeeAbstractCollection*) self->scanned_frequencies, item);
	}
	_g_object_unref0 (item);
	_gst_structure_free0 (structure);
}


/**
         * Pick up the next tuning paramters from the queue
         * and start scanning with them
         */
static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _dvb_scanner_check_for_lock_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_scanner_check_for_lock (self);
	return result;
}


gboolean dvb_scanner_start_scan (DVBScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean all_tables;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gboolean _tmp14_;
	gpointer _tmp19_ = NULL;
	GstStructure* _tmp20_;
	guint freq = 0U;
	guint _tmp21_;
	guint _tmp22_;
	GstElement* _tmp23_ = NULL;
	GstElement* dvbsrc;
	GSource* _tmp24_ = NULL;
	GSource* _tmp25_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->sdt_arrived) {
		_tmp2_ = self->priv->nit_arrived;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = self->priv->pat_arrived;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->pmt_arrived;
	} else {
		_tmp0_ = FALSE;
	}
	all_tables = _tmp0_;
	_tmp3_ = bool_to_string (all_tables);
	_tmp4_ = _tmp3_;
	_tmp5_ = bool_to_string (self->priv->pat_arrived);
	_tmp6_ = _tmp5_;
	_tmp7_ = bool_to_string (self->priv->sdt_arrived);
	_tmp8_ = _tmp7_;
	_tmp9_ = bool_to_string (self->priv->nit_arrived);
	_tmp10_ = _tmp9_;
	_tmp11_ = bool_to_string (self->priv->pmt_arrived);
	_tmp12_ = _tmp11_;
	g_debug ("Scanner.vala:367: Received all tables: %s (pat: %s, sdt: %s, nit: %s, " \
"pmt: %s)", _tmp4_, _tmp6_, _tmp8_, _tmp10_, _tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	self->priv->nit_arrived = FALSE;
	self->priv->sdt_arrived = FALSE;
	self->priv->pat_arrived = FALSE;
	self->priv->pmt_arrived = FALSE;
	self->priv->locked = FALSE;
	if (self->current_tuning_params != NULL) {
		guint old_freq = 0U;
		guint _tmp13_;
		gst_structure_get_uint (self->current_tuning_params, "frequency", &_tmp13_);
		old_freq = _tmp13_;
		g_signal_emit_by_name (self, "frequency-scanned", old_freq, self->frequencies->length);
	}
	_tmp14_ = g_queue_is_empty (self->frequencies);
	if (_tmp14_) {
		g_message ("Scanner.vala:385: Finished scanning");
		{
			gint _tmp15_;
			g_static_rec_mutex_lock (&self->priv->__lock_new_channels);
			_tmp15_ = gee_collection_get_size ((GeeCollection*) self->priv->new_channels);
			g_debug ("Scanner.vala:389: %u channels still have missing or invalid informatio" \
"n", (guint) _tmp15_);
			{
				GeeArrayList* _tmp16_;
				GeeArrayList* _sid_list;
				gint _tmp17_;
				gint _sid_size;
				gint _sid_index;
				_tmp16_ = _g_object_ref0 (self->priv->new_channels);
				_sid_list = _tmp16_;
				_tmp17_ = gee_collection_get_size ((GeeCollection*) _sid_list);
				_sid_size = _tmp17_;
				_sid_index = -1;
				while (TRUE) {
					gpointer _tmp18_ = NULL;
					guint sid;
					_sid_index = _sid_index + 1;
					if (!(_sid_index < _sid_size)) {
						break;
					}
					_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _sid_list, _sid_index);
					sid = GPOINTER_TO_UINT (_tmp18_);
					dvb_channel_list_remove (self->channels, sid);
				}
				_g_object_unref0 (_sid_list);
			}
			__finally147:
			g_static_rec_mutex_unlock (&self->priv->__lock_new_channels);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		dvb_scanner_clear_and_reset_all (self);
		g_signal_emit_by_name (self, "finished");
		result = FALSE;
		return result;
	}
	_tmp19_ = g_queue_pop_head (self->frequencies);
	_tmp20_ = (GstStructure*) _tmp19_;
	_gst_structure_free0 (self->current_tuning_params);
	self->current_tuning_params = _tmp20_;
	gst_structure_get_uint (self->current_tuning_params, "frequency", &_tmp21_);
	freq = _tmp21_;
	_tmp22_ = g_queue_get_length (self->frequencies);
	g_debug ("Scanner.vala:406: Starting scanning frequency %u (%u left)", freq, _tmp22_);
	gst_element_set_state (self->pipeline, GST_STATE_READY);
	dvb_scanner_prepare (self);
	_tmp23_ = gst_bin_get_by_name (GST_BIN (self->pipeline), "dvbsrc");
	dvbsrc = _tmp23_;
	g_object_set ((GObject*) dvbsrc, "pids", DVB_SCANNER_BASE_PIDS, NULL);
	_tmp24_ = g_timeout_source_new_seconds ((guint) 5);
	_tmp25_ = _tmp24_;
	_g_source_unref0 (self->priv->check_for_lock_source);
	self->priv->check_for_lock_source = _tmp25_;
	g_source_set_callback (self->priv->check_for_lock_source, _dvb_scanner_check_for_lock_gsource_func, g_object_ref (self), g_object_unref);
	g_source_attach (self->priv->check_for_lock_source, self->priv->context);
	gst_element_set_state (self->pipeline, GST_STATE_PLAYING);
	result = FALSE;
	_gst_object_unref0 (dvbsrc);
	return result;
}


/**
         * Check if we received a lock with the currently
         * used tuning parameters
         */
gboolean dvb_scanner_check_for_lock (DVBScanner* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->locked) {
		gst_element_set_state (self->pipeline, GST_STATE_READY);
		dvb_scanner_queue_start_scan (self);
	}
	result = FALSE;
	return result;
}


gboolean dvb_scanner_wait_for_tables (DVBScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->sdt_arrived) {
		_tmp2_ = self->priv->nit_arrived;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = self->priv->pat_arrived;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->pmt_arrived;
	} else {
		_tmp0_ = FALSE;
	}
	if (!_tmp0_) {
		gst_element_set_state (self->pipeline, GST_STATE_READY);
		dvb_scanner_queue_start_scan (self);
	}
	result = FALSE;
	return result;
}


void dvb_scanner_destroy_start_scan_source (DVBScanner* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->start_scan_source != NULL) {
		gboolean _tmp1_;
		_tmp1_ = g_source_is_destroyed (self->priv->start_scan_source);
		_tmp0_ = !_tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GSource* _tmp2_;
		g_source_destroy (self->priv->start_scan_source);
		_tmp2_ = NULL;
		_g_source_unref0 (self->priv->start_scan_source);
		self->priv->start_scan_source = _tmp2_;
	}
}


void dvb_scanner_remove_check_for_lock_timeout (DVBScanner* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->check_for_lock_source != NULL) {
		gboolean _tmp1_;
		_tmp1_ = g_source_is_destroyed (self->priv->check_for_lock_source);
		_tmp0_ = !_tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GSource* _tmp2_;
		g_source_destroy (self->priv->check_for_lock_source);
		_tmp2_ = NULL;
		_g_source_unref0 (self->priv->check_for_lock_source);
		self->priv->check_for_lock_source = _tmp2_;
	}
}


void dvb_scanner_remove_wait_for_tables_timeout (DVBScanner* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->wait_for_tables_source != NULL) {
		gboolean _tmp1_;
		_tmp1_ = g_source_is_destroyed (self->priv->wait_for_tables_source);
		_tmp0_ = !_tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GSource* _tmp2_;
		g_source_destroy (self->priv->wait_for_tables_source);
		_tmp2_ = NULL;
		_g_source_unref0 (self->priv->wait_for_tables_source);
		self->priv->wait_for_tables_source = _tmp2_;
	}
}


static gboolean _dvb_scanner_start_scan_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_scanner_start_scan (self);
	return result;
}


void dvb_scanner_queue_start_scan (DVBScanner* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->start_scan_source == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_;
		_tmp1_ = g_source_is_destroyed (self->priv->start_scan_source);
		_tmp0_ = _tmp1_;
	}
	if (_tmp0_) {
		GSource* _tmp2_ = NULL;
		GSource* _tmp3_;
		g_debug ("Scanner.vala:476: Queueing start_scan");
		_tmp2_ = g_idle_source_new ();
		_tmp3_ = _tmp2_;
		_g_source_unref0 (self->priv->start_scan_source);
		self->priv->start_scan_source = _tmp3_;
		g_source_set_callback (self->priv->start_scan_source, _dvb_scanner_start_scan_gsource_func, g_object_ref (self), g_object_unref);
		g_source_attach (self->priv->start_scan_source, self->priv->context);
	}
}


void dvb_scanner_set_uint_property (GstElement* src, const GstStructure* params, const gchar* key) {
	guint val = 0U;
	guint _tmp0_;
	g_return_if_fail (src != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (key != NULL);
	gst_structure_get_uint (params, key, &_tmp0_);
	val = _tmp0_;
	g_object_set ((GObject*) src, key, val, NULL);
}


static gboolean _dvb_scanner_wait_for_tables_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_scanner_wait_for_tables (self);
	return result;
}


void dvb_scanner_on_dvb_frontend_stats_structure (DVBScanner* self, const GstStructure* structure) {
	gboolean has_lock = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _signal = 0;
	gint _tmp4_;
	gint _snr = 0;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	gst_structure_get_boolean (structure, "lock", &_tmp0_);
	has_lock = _tmp0_;
	if (has_lock) {
		_tmp1_ = !self->priv->locked;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GSource* _tmp2_ = NULL;
		GSource* _tmp3_;
		g_debug ("Scanner.vala:494: Got lock");
		dvb_scanner_remove_check_for_lock_timeout (self);
		_tmp2_ = g_timeout_source_new_seconds ((guint) 10);
		_tmp3_ = _tmp2_;
		_g_source_unref0 (self->priv->wait_for_tables_source);
		self->priv->wait_for_tables_source = _tmp3_;
		g_source_set_callback (self->priv->wait_for_tables_source, _dvb_scanner_wait_for_tables_gsource_func, g_object_ref (self), g_object_unref);
		g_source_attach (self->priv->wait_for_tables_source, self->priv->context);
	}
	gst_structure_get_int (structure, "signal", &_tmp4_);
	_signal = _tmp4_;
	gst_structure_get_int (structure, "snr", &_tmp5_);
	_snr = _tmp5_;
	g_signal_emit_by_name (self, "frontend-stats", _signal / ((gdouble) 0xffff), _snr / ((gdouble) 0xffff));
}


void dvb_scanner_on_dvb_read_failure_structure (DVBScanner* self) {
	g_return_if_fail (self != NULL);
	g_warning ("Scanner.vala:510: Read failure");
}


void dvb_scanner_on_pat_structure (DVBScanner* self, const GstStructure* structure) {
	GeeHashSet* _tmp0_ = NULL;
	GeeSet* pid_set;
	GValue* _tmp1_ = NULL;
	GValue programs;
	guint _tmp2_;
	guint size;
	GValue val = {0};
	const GstStructure* program;
	GString* _tmp8_ = NULL;
	GString* new_pids;
	gint i;
	gint _tmp17_;
	GstElement* _tmp18_ = NULL;
	GstElement* dvbsrc;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	g_debug ("Scanner.vala:517: Received PAT");
	_tmp0_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL);
	pid_set = (GeeSet*) _tmp0_;
	gee_collection_add ((GeeCollection*) pid_set, GUINT_TO_POINTER ((guint) 16));
	gee_collection_add ((GeeCollection*) pid_set, GUINT_TO_POINTER ((guint) 17));
	_tmp1_ = gst_structure_get_value (structure, "programs");
	programs = *_tmp1_;
	_tmp2_ = gst_value_list_get_size (&programs);
	size = _tmp2_;
	program = NULL;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				GValue* _tmp4_ = NULL;
				const GstStructure* _tmp5_ = NULL;
				guint sid = 0U;
				guint _tmp6_;
				guint pmt = 0U;
				guint _tmp7_;
				if (!_tmp3_) {
					i++;
				}
				_tmp3_ = FALSE;
				if (!(i < size)) {
					break;
				}
				_tmp4_ = gst_value_list_get_value (&programs, i);
				val = *_tmp4_;
				_tmp5_ = gst_value_get_structure (&val);
				program = _tmp5_;
				gst_structure_get_uint (program, "program-number", &_tmp6_);
				sid = _tmp6_;
				gst_structure_get_uint (program, "pid", &_tmp7_);
				pmt = _tmp7_;
				gee_collection_add ((GeeCollection*) pid_set, GUINT_TO_POINTER (pmt));
			}
		}
	}
	_tmp8_ = g_string_new ("");
	new_pids = _tmp8_;
	i = 0;
	{
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _pid_it;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) pid_set);
		_pid_it = _tmp9_;
		while (TRUE) {
			gboolean _tmp10_;
			gpointer _tmp11_ = NULL;
			guint pid;
			gint _tmp12_;
			_tmp10_ = gee_iterator_next (_pid_it);
			if (!_tmp10_) {
				break;
			}
			_tmp11_ = gee_iterator_get (_pid_it);
			pid = GPOINTER_TO_UINT (_tmp11_);
			_tmp12_ = gee_collection_get_size ((GeeCollection*) pid_set);
			if ((i + 1) == _tmp12_) {
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				_tmp13_ = g_strdup_printf ("%u", pid);
				_tmp14_ = _tmp13_;
				g_string_append (new_pids, _tmp14_);
				_g_free0 (_tmp14_);
			} else {
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				_tmp15_ = g_strdup_printf ("%u:", pid);
				_tmp16_ = _tmp15_;
				g_string_append (new_pids, _tmp16_);
				_g_free0 (_tmp16_);
			}
			i++;
		}
		_g_object_unref0 (_pid_it);
	}
	_tmp17_ = gee_collection_get_size ((GeeCollection*) pid_set);
	g_debug ("Scanner.vala:552: Setting %d pids: %s", _tmp17_, new_pids->str);
	_tmp18_ = gst_bin_get_by_name (GST_BIN (self->pipeline), "dvbsrc");
	dvbsrc = _tmp18_;
	g_object_set ((GObject*) dvbsrc, "pids", new_pids->str, NULL);
	self->priv->pat_arrived = TRUE;
	_gst_object_unref0 (dvbsrc);
	_g_string_free0 (new_pids);
	_g_object_unref0 (pid_set);
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	const gchar* _tmp1_ = NULL;
	const gchar* start;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = string_offset (self, offset);
	start = _tmp1_;
	_tmp2_ = string_offset (start, len);
	_tmp3_ = g_strndup (start, ((gchar*) _tmp2_) - ((gchar*) start));
	result = _tmp3_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	regex = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch148_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch148_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally148;
	__catch148_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally148:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void dvb_scanner_on_sdt_structure (DVBScanner* self, const GstStructure* structure) {
	guint tsid = 0U;
	guint _tmp0_;
	GValue* _tmp1_ = NULL;
	GValue services;
	guint _tmp2_;
	guint size;
	GValue val = {0};
	const GstStructure* service;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	gst_structure_get_uint (structure, "transport-stream-id", &_tmp0_);
	tsid = _tmp0_;
	g_debug ("Scanner.vala:564: Received SDT (0x%x)", tsid);
	_tmp1_ = gst_structure_get_value (structure, "services");
	services = *_tmp1_;
	_tmp2_ = gst_value_list_get_size (&services);
	size = _tmp2_;
	service = NULL;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				GValue* _tmp4_ = NULL;
				const GstStructure* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* name;
				gint _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint sid;
				gboolean _tmp13_;
				gboolean _tmp17_;
				DVBChannel* _tmp18_ = NULL;
				DVBChannel* channel;
				gboolean _tmp19_;
				gboolean _tmp21_;
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				gchar* provider;
				gboolean _tmp26_ = FALSE;
				const gchar* _tmp28_ = NULL;
				gboolean _tmp29_;
				gchar* _tmp30_ = NULL;
				gchar* _tmp31_;
				if (!_tmp3_) {
					i++;
				}
				_tmp3_ = FALSE;
				if (!(i < size)) {
					break;
				}
				_tmp4_ = gst_value_list_get_value (&services, i);
				val = *_tmp4_;
				_tmp5_ = gst_value_get_structure (&val);
				service = _tmp5_;
				_tmp6_ = gst_structure_get_name (service);
				_tmp7_ = g_strdup (_tmp6_);
				name = _tmp7_;
				_tmp8_ = strlen (name);
				_tmp9_ = string_substring (name, (glong) 8, (glong) (_tmp8_ - 8));
				_tmp10_ = _tmp9_;
				_tmp11_ = atoi (_tmp10_);
				sid = (_tmp12_ = _tmp11_, _g_free0 (_tmp10_), _tmp12_);
				_tmp13_ = gst_structure_has_field (service, "name");
				if (_tmp13_) {
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp14_ = gst_structure_get_string (service, "name");
					_tmp15_ = g_strdup (_tmp14_);
					_tmp16_ = _tmp15_;
					_g_free0 (name);
					name = _tmp16_;
				}
				_tmp17_ = dvb_channel_list_contains (self->channels, (guint) sid);
				if (!_tmp17_) {
					dvb_scanner_add_new_channel (self, (guint) sid);
				}
				_tmp18_ = dvb_channel_list_get_channel (self->channels, (guint) sid);
				channel = _tmp18_;
				_tmp19_ = gst_structure_has_field (service, "scrambled");
				if (_tmp19_) {
					gboolean scrambled = FALSE;
					gboolean _tmp20_;
					gst_structure_get_boolean (service, "scrambled", &_tmp20_);
					scrambled = _tmp20_;
					dvb_channel_set_Scrambled (channel, scrambled);
				} else {
					dvb_channel_set_Scrambled (channel, FALSE);
				}
				_tmp21_ = g_utf8_validate (name, (gssize) (-1), NULL);
				if (_tmp21_) {
					gchar* _tmp22_ = NULL;
					gchar* _tmp23_;
					_tmp22_ = string_replace (name, "\\s", " ");
					_tmp23_ = _tmp22_;
					dvb_channel_set_Name (channel, _tmp23_);
					_g_free0 (_tmp23_);
				}
				dvb_channel_set_TransportStreamId (channel, tsid);
				_tmp24_ = gst_structure_get_string (service, "provider-name");
				_tmp25_ = g_strdup (_tmp24_);
				provider = _tmp25_;
				if (provider != NULL) {
					gboolean _tmp27_;
					_tmp27_ = g_utf8_validate (provider, (gssize) (-1), NULL);
					_tmp26_ = _tmp27_;
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					dvb_channel_set_Network (channel, provider);
				} else {
					dvb_channel_set_Network (channel, "");
				}
				_tmp28_ = dvb_channel_get_Name (channel);
				_tmp29_ = dvb_channel_get_Scrambled (channel);
				_tmp30_ = bool_to_string (_tmp29_);
				_tmp31_ = _tmp30_;
				g_debug ("Scanner.vala:610: Found service 0x%x, %s, scrambled: %s", (guint) sid, _tmp28_, _tmp31_);
				_g_free0 (_tmp31_);
				_g_free0 (provider);
				_g_object_unref0 (channel);
				_g_free0 (name);
			}
		}
	}
	self->priv->sdt_arrived = TRUE;
}


void dvb_scanner_on_nit_structure (DVBScanner* self, const GstStructure* structure) {
	gboolean actual = FALSE;
	gboolean _tmp0_;
	gchar* name;
	gboolean _tmp1_;
	GValue* _tmp8_ = NULL;
	GValue transports;
	guint _tmp9_;
	guint size;
	GValue val = {0};
	const GstStructure* transport;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	gst_structure_get_boolean (structure, "actual-network", &_tmp0_);
	actual = _tmp0_;
	if (!actual) {
		return;
	}
	g_debug ("Scanner.vala:623: Received NIT");
	name = NULL;
	_tmp1_ = gst_structure_has_field (structure, "network-name");
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = gst_structure_get_string (structure, "network-name");
		_tmp3_ = g_strdup (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (name);
		name = _tmp4_;
	} else {
		guint nid = 0U;
		guint _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gst_structure_get_uint (structure, "network-id", &_tmp5_);
		nid = _tmp5_;
		_tmp6_ = g_strdup_printf ("%u", nid);
		_tmp7_ = _tmp6_;
		_g_free0 (name);
		name = _tmp7_;
	}
	g_debug ("Scanner.vala:633: Network name '%s'", name);
	_tmp8_ = gst_structure_get_value (structure, "transports");
	transports = *_tmp8_;
	_tmp9_ = gst_value_list_get_size (&transports);
	size = _tmp9_;
	transport = NULL;
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				GValue* _tmp11_ = NULL;
				const GstStructure* _tmp12_ = NULL;
				guint tsid = 0U;
				guint _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp19_;
				if (!_tmp10_) {
					i++;
				}
				_tmp10_ = FALSE;
				if (!(i < size)) {
					break;
				}
				_tmp11_ = gst_value_list_get_value (&transports, i);
				val = *_tmp11_;
				_tmp12_ = gst_value_get_structure (&val);
				transport = _tmp12_;
				gst_structure_get_uint (transport, "transport-stream-id", &_tmp13_);
				tsid = _tmp13_;
				_tmp14_ = gst_structure_has_field (transport, "delivery");
				if (_tmp14_) {
					GValue* _tmp15_ = NULL;
					GValue delivery_val;
					const GstStructure* _tmp16_ = NULL;
					const GstStructure* delivery;
					guint freq = 0U;
					guint _tmp17_;
					GstStructure* _tmp18_;
					_tmp15_ = gst_structure_get_value (transport, "delivery");
					delivery_val = *_tmp15_;
					_tmp16_ = gst_value_get_structure (&delivery_val);
					delivery = _tmp16_;
					g_debug ("Scanner.vala:652: Received TS 0x%x", tsid);
					gst_structure_get_uint (delivery, "frequency", &_tmp17_);
					freq = _tmp17_;
					_tmp18_ = _gst_structure_copy0 (delivery);
					dvb_scanner_add_structure_to_scan (self, _tmp18_);
				}
				_tmp19_ = gst_structure_has_field (transport, "channels");
				if (_tmp19_) {
					GValue* _tmp20_ = NULL;
					GValue channels;
					guint _tmp21_;
					guint channels_size;
					GValue channel_val = {0};
					const GstStructure* channel_struct;
					_tmp20_ = gst_structure_get_value (transport, "channels");
					channels = *_tmp20_;
					_tmp21_ = gst_value_list_get_size (&channels);
					channels_size = _tmp21_;
					channel_struct = NULL;
					{
						gint j;
						j = 0;
						{
							gboolean _tmp22_;
							_tmp22_ = TRUE;
							while (TRUE) {
								GValue* _tmp23_ = NULL;
								const GstStructure* _tmp24_ = NULL;
								guint sid = 0U;
								guint _tmp25_;
								gboolean _tmp26_;
								DVBChannel* _tmp27_ = NULL;
								DVBChannel* dvb_channel;
								gboolean _tmp28_;
								guint lcnumber = 0U;
								guint _tmp29_;
								if (!_tmp22_) {
									j++;
								}
								_tmp22_ = FALSE;
								if (!(j < channels_size)) {
									break;
								}
								_tmp23_ = gst_value_list_get_value (&channels, (guint) j);
								channel_val = *_tmp23_;
								_tmp24_ = gst_value_get_structure (&channel_val);
								channel_struct = _tmp24_;
								gst_structure_get_uint (channel_struct, "service-id", &_tmp25_);
								sid = _tmp25_;
								_tmp26_ = dvb_channel_list_contains (self->channels, sid);
								if (!_tmp26_) {
									dvb_scanner_add_new_channel (self, sid);
								}
								_tmp27_ = dvb_channel_list_get_channel (self->channels, sid);
								dvb_channel = _tmp27_;
								_tmp28_ = g_utf8_validate (name, (gssize) (-1), NULL);
								if (_tmp28_) {
									dvb_channel_set_Network (dvb_channel, name);
								} else {
									dvb_channel_set_Network (dvb_channel, "");
								}
								gst_structure_get_uint (channel_struct, "logical-channel-number", &_tmp29_);
								lcnumber = _tmp29_;
								dvb_channel_set_LogicalChannelNumber (dvb_channel, &lcnumber);
								_g_object_unref0 (dvb_channel);
							}
						}
					}
				}
			}
		}
	}
	self->priv->nit_arrived = TRUE;
	_g_free0 (name);
}


void dvb_scanner_on_pmt_structure (DVBScanner* self, const GstStructure* structure) {
	guint program_number = 0U;
	guint _tmp0_;
	gboolean _tmp1_;
	DVBChannel* _tmp2_ = NULL;
	DVBChannel* dvb_channel;
	GValue* _tmp3_ = NULL;
	GValue streams;
	guint _tmp4_;
	guint size;
	GValue stream_val = {0};
	const GstStructure* stream;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	g_debug ("Scanner.vala:697: Received PMT");
	gst_structure_get_uint (structure, "program-number", &_tmp0_);
	program_number = _tmp0_;
	_tmp1_ = dvb_channel_list_contains (self->channels, program_number);
	if (!_tmp1_) {
		dvb_scanner_add_new_channel (self, program_number);
	}
	_tmp2_ = dvb_channel_list_get_channel (self->channels, program_number);
	dvb_channel = _tmp2_;
	_tmp3_ = gst_structure_get_value (structure, "streams");
	streams = *_tmp3_;
	_tmp4_ = gst_value_list_get_size (&streams);
	size = _tmp4_;
	stream = NULL;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				GValue* _tmp6_ = NULL;
				const GstStructure* _tmp7_ = NULL;
				guint pid = 0U;
				guint _tmp8_;
				guint stream_type = 0U;
				guint _tmp9_;
				if (!_tmp5_) {
					i++;
				}
				_tmp5_ = FALSE;
				if (!(i < size)) {
					break;
				}
				_tmp6_ = gst_value_list_get_value (&streams, (guint) i);
				stream_val = *_tmp6_;
				_tmp7_ = gst_value_get_structure (&stream_val);
				stream = _tmp7_;
				gst_structure_get_uint (stream, "pid", &_tmp8_);
				pid = _tmp8_;
				gst_structure_get_uint (stream, "stream-type", &_tmp9_);
				stream_type = _tmp9_;
				switch (stream_type) {
					case 0x01:
					case 0x02:
					case 0x1b:
					{
						g_debug ("Scanner.vala:729: Found video PID 0x%x for channel 0x%x", pid, program_number);
						dvb_channel_set_VideoPID (dvb_channel, pid);
						break;
					}
					case 0x03:
					case 0x04:
					case 0x0f:
					case 0x11:
					{
						GeeList* _tmp10_ = NULL;
						g_debug ("Scanner.vala:737: Found audio PID 0x%x for channel 0x%x", pid, program_number);
						_tmp10_ = dvb_channel_get_AudioPIDs (dvb_channel);
						gee_collection_add ((GeeCollection*) _tmp10_, GUINT_TO_POINTER (pid));
						break;
					}
					default:
					{
						g_debug ("Scanner.vala:742: Other stream type: 0x%02x", stream_type);
						break;
					}
				}
			}
		}
	}
	self->priv->pmt_arrived = TRUE;
	_g_object_unref0 (dvb_channel);
}


gboolean dvb_scanner_bus_watch_func (DVBScanner* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	switch (message->type) {
		case GST_MESSAGE_ELEMENT:
		{
			{
				const GstStructure* _tmp0_ = NULL;
				GstStructure* _tmp1_;
				GstStructure* structure;
				const gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				gchar* structure_name;
				_tmp0_ = gst_message_get_structure (message);
				_tmp1_ = _gst_structure_copy0 (_tmp0_);
				structure = _tmp1_;
				_tmp2_ = gst_structure_get_name (structure);
				_tmp3_ = g_strdup (_tmp2_);
				structure_name = _tmp3_;
				if (g_strcmp0 (structure_name, "dvb-frontend-stats") == 0) {
					dvb_scanner_on_dvb_frontend_stats_structure (self, structure);
				} else {
					if (g_strcmp0 (structure_name, "dvb-read-failure") == 0) {
						dvb_scanner_on_dvb_read_failure_structure (self);
					} else {
						if (g_strcmp0 (structure_name, "sdt") == 0) {
							dvb_scanner_on_sdt_structure (self, structure);
						} else {
							if (g_strcmp0 (structure_name, "nit") == 0) {
								dvb_scanner_on_nit_structure (self, structure);
							} else {
								if (g_strcmp0 (structure_name, "pat") == 0) {
									dvb_scanner_on_pat_structure (self, structure);
								} else {
									if (g_strcmp0 (structure_name, "pmt") == 0) {
										dvb_scanner_on_pmt_structure (self, structure);
									} else {
										result = TRUE;
										_g_free0 (structure_name);
										_gst_structure_free0 (structure);
										return result;
									}
								}
							}
						}
					}
				}
				_g_free0 (structure_name);
				_gst_structure_free0 (structure);
				break;
			}
		}
		case GST_MESSAGE_ERROR:
		{
			{
				GError* gerror;
				gchar* debug;
				GError* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				gerror = NULL;
				debug = NULL;
				gst_message_parse_error (message, &_tmp4_, &_tmp5_);
				_g_error_free0 (gerror);
				gerror = _tmp4_;
				_g_free0 (debug);
				debug = _tmp5_;
				g_warning ("Scanner.vala:775: %s %s", gerror->message, debug);
				result = TRUE;
				_g_free0 (debug);
				_g_error_free0 (gerror);
				return result;
			}
		}
		default:
		{
			result = TRUE;
			return result;
		}
	}
	if (self->priv->nit_arrived) {
		_tmp7_ = self->priv->sdt_arrived;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = self->priv->pat_arrived;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		{
			GeeArrayList* _tmp8_ = NULL;
			GeeArrayList* del_channels;
			g_static_rec_mutex_lock (&self->priv->__lock_new_channels);
			_tmp8_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL);
			del_channels = _tmp8_;
			{
				GeeArrayList* _tmp9_;
				GeeArrayList* _sid_list;
				gint _tmp10_;
				gint _sid_size;
				gint _sid_index;
				_tmp9_ = _g_object_ref0 (self->priv->new_channels);
				_sid_list = _tmp9_;
				_tmp10_ = gee_collection_get_size ((GeeCollection*) _sid_list);
				_sid_size = _tmp10_;
				_sid_index = -1;
				while (TRUE) {
					gpointer _tmp11_ = NULL;
					guint sid;
					DVBChannel* _tmp12_ = NULL;
					DVBChannel* channel;
					gboolean _tmp13_;
					_sid_index = _sid_index + 1;
					if (!(_sid_index < _sid_size)) {
						break;
					}
					_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _sid_list, _sid_index);
					sid = GPOINTER_TO_UINT (_tmp11_);
					_tmp12_ = dvb_channel_list_get_channel (self->channels, sid);
					channel = _tmp12_;
					_tmp13_ = dvb_channel_is_valid (channel);
					if (_tmp13_) {
						const gchar* _tmp14_;
						gboolean _tmp15_;
						gchar* _tmp16_;
						gchar* type;
						gchar* _tmp17_ = NULL;
						gchar* _tmp18_;
						guint _tmp19_;
						const gchar* _tmp20_ = NULL;
						const gchar* _tmp21_ = NULL;
						gboolean _tmp22_;
						_tmp14_ = NULL;
						_tmp15_ = dvb_channel_is_radio (channel);
						if (_tmp15_) {
							_tmp14_ = "Radio";
						} else {
							_tmp14_ = "TV";
						}
						_tmp16_ = g_strdup (_tmp14_);
						type = _tmp16_;
						_tmp17_ = dvb_channel_to_string (channel);
						_tmp18_ = _tmp17_;
						g_debug ("Scanner.vala:794: Channel added: %s", _tmp18_);
						_g_free0 (_tmp18_);
						_tmp19_ = dvb_channel_get_Frequency (channel);
						_tmp20_ = dvb_channel_get_Name (channel);
						_tmp21_ = dvb_channel_get_Network (channel);
						_tmp22_ = dvb_channel_get_Scrambled (channel);
						g_signal_emit_by_name (self, "channel-added", _tmp19_, sid, _tmp20_, _tmp21_, type, _tmp22_);
						gee_abstract_collection_add ((GeeAbstractCollection*) del_channels, GUINT_TO_POINTER (sid));
						_g_free0 (type);
					} else {
						gchar* _tmp23_ = NULL;
						gchar* _tmp24_;
						_tmp23_ = dvb_channel_to_string (channel);
						_tmp24_ = _tmp23_;
						g_debug ("Scanner.vala:801: Channel 0x%x is not valid: %s", sid, _tmp24_);
						_g_free0 (_tmp24_);
						self->priv->pmt_arrived = FALSE;
					}
					_g_object_unref0 (channel);
				}
				_g_object_unref0 (_sid_list);
			}
			{
				GeeArrayList* _tmp25_;
				GeeArrayList* _sid_list;
				gint _tmp26_;
				gint _sid_size;
				gint _sid_index;
				_tmp25_ = _g_object_ref0 (del_channels);
				_sid_list = _tmp25_;
				_tmp26_ = gee_collection_get_size ((GeeCollection*) _sid_list);
				_sid_size = _tmp26_;
				_sid_index = -1;
				while (TRUE) {
					gpointer _tmp27_ = NULL;
					guint sid;
					_sid_index = _sid_index + 1;
					if (!(_sid_index < _sid_size)) {
						break;
					}
					_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _sid_list, _sid_index);
					sid = GPOINTER_TO_UINT (_tmp27_);
					gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->new_channels, GUINT_TO_POINTER (sid));
				}
				_g_object_unref0 (_sid_list);
			}
			_g_object_unref0 (del_channels);
			__finally149:
			g_static_rec_mutex_unlock (&self->priv->__lock_new_channels);
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (self->priv->sdt_arrived) {
		_tmp30_ = self->priv->nit_arrived;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		_tmp29_ = self->priv->pat_arrived;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		_tmp28_ = self->priv->pmt_arrived;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		dvb_scanner_remove_wait_for_tables_timeout (self);
		dvb_scanner_queue_start_scan (self);
	}
	result = TRUE;
	return result;
}


void dvb_scanner_add_new_channel (DVBScanner* self, guint sid) {
	DVBChannel* _tmp0_ = NULL;
	DVBChannel* new_channel;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_debug ("Scanner.vala:827: Adding new channel with SID 0x%x", sid);
	_tmp0_ = dvb_scanner_get_new_channel (self);
	new_channel = _tmp0_;
	dvb_channel_set_Sid (new_channel, sid);
	dvb_scanner_add_values_from_structure_to_channel (self, self->current_tuning_params, new_channel);
	dvb_channel_list_add (self->channels, new_channel);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_new_channels);
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->new_channels, GUINT_TO_POINTER (sid));
		__finally150:
		g_static_rec_mutex_unlock (&self->priv->__lock_new_channels);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (new_channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (new_channel);
}


DVBScanner* dvb_scanner_construct (GType object_type) {
	DVBScanner * self = NULL;
	self = (DVBScanner*) g_object_new (object_type, NULL);
	return self;
}


DVBDevice* dvb_scanner_get_Device (DVBScanner* self) {
	DVBDevice* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Device;
	return result;
}


static void dvb_scanner_set_Device (DVBScanner* self, DVBDevice* value) {
	DVBDevice* _tmp0_;
	DVBDevice* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_Device);
	self->priv->_Device = _tmp1_;
	g_object_notify ((GObject *) self, "Device");
}


DVBChannelList* dvb_scanner_get_Channels (DVBScanner* self) {
	DVBChannelList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->channels;
	return result;
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (gpointer data1, guint arg_1, guint arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gboolean arg_6, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 7);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), g_value_get_boolean (param_values + 6), data2);
}


static void g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__DOUBLE_DOUBLE) (gpointer data1, gdouble arg_1, gdouble arg_2, gpointer data2);
	register GMarshalFunc_VOID__DOUBLE_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__DOUBLE_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_double (param_values + 1), g_value_get_double (param_values + 2), data2);
}


static guint _dvb_scanned_item_hash_ghash_func (gconstpointer key) {
	guint result;
	result = dvb_scanned_item_hash (key);
	return result;
}


static gboolean _dvb_scanned_item_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = dvb_scanned_item_equal (a, b);
	return result;
}


static GObject * dvb_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBScanner * self;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* _tmp1_;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_;
	GQueue* _tmp4_ = NULL;
	GQueue* _tmp5_;
	GMainContext* _tmp6_ = NULL;
	GMainContext* _tmp7_;
	parent_class = G_OBJECT_CLASS (dvb_scanner_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_SCANNER (obj);
	_tmp0_ = gee_hash_set_new (DVB_TYPE_SCANNED_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, _dvb_scanned_item_hash_ghash_func, _dvb_scanned_item_equal_gequal_func);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->scanned_frequencies);
	self->scanned_frequencies = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->new_channels);
	self->priv->new_channels = _tmp3_;
	_tmp4_ = g_queue_new ();
	_tmp5_ = _tmp4_;
	_g_queue_free0 (self->frequencies);
	self->frequencies = _tmp5_;
	_tmp6_ = g_main_context_new ();
	_tmp7_ = _tmp6_;
	_g_main_context_unref0 (self->priv->context);
	self->priv->context = _tmp7_;
	self->priv->running = FALSE;
	return obj;
}


static void dvb_scanner_class_init (DVBScannerClass * klass) {
	dvb_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBScannerPrivate));
	DVB_SCANNER_CLASS (klass)->prepare = dvb_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_scanner_real_add_values_from_structure_to_channel;
	DVB_SCANNER_CLASS (klass)->add_scanning_data_from_string = dvb_scanner_real_add_scanning_data_from_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_scanner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_scanner_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_scanner_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_scanner_finalize;
	/**
	         * The DVB device the scanner should use
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNER_DEVICE, g_param_spec_object ("Device", "Device", "Device", DVB_TYPE_DEVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCANNER_CHANNELS, g_param_spec_object ("Channels", "Channels", "Channels", DVB_TYPE_CHANNEL_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Emitted when the Destroy () method is called
	         */
	g_signal_new ("destroyed", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	         * Emitted when a frequency has been scanned.
	         * Whether a new channel has been found on that frequency or not.
	         */
	g_signal_new ("frequency_scanned", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	/**
	         * @frequency: Frequency of the channel
	         * @sid: SID of the channel
	         * @name: Name of the channel
	         * @network: Name of network the channel is part of
	         * @type: What type of channel this is (Radio or TV)
	         * @scrambled: Whether the channel is scrambled
	         *
	         * Emitted when a new channel has been found
	         */
	g_signal_new ("channel_added", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
	g_signal_new ("frontend_stats", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE, G_TYPE_NONE, 2, G_TYPE_DOUBLE, G_TYPE_DOUBLE);
	/**
	         * Emitted when all frequencies have been scanned
	         */
	g_signal_new ("finished", DVB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void dvb_scanner_instance_init (DVBScanner * self) {
	self->priv = DVB_SCANNER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_new_channels);
}


static void dvb_scanner_finalize (GObject* obj) {
	DVBScanner * self;
	self = DVB_SCANNER (obj);
	_g_object_unref0 (self->priv->_Device);
	_g_object_unref0 (self->channels);
	_gst_object_unref0 (self->pipeline);
	_g_queue_free0 (self->frequencies);
	_gst_structure_free0 (self->current_tuning_params);
	_g_object_unref0 (self->scanned_frequencies);
	g_static_rec_mutex_free (&self->priv->__lock_new_channels);
	_g_object_unref0 (self->priv->new_channels);
	_g_source_unref0 (self->priv->check_for_lock_source);
	_g_source_unref0 (self->priv->wait_for_tables_source);
	_g_source_unref0 (self->priv->start_scan_source);
	_g_main_context_unref0 (self->priv->context);
	_g_main_loop_unref0 (self->priv->loop);
	G_OBJECT_CLASS (dvb_scanner_parent_class)->finalize (obj);
}


/**
     * An abstract class responsible for scanning for new channels
     */
GType dvb_scanner_get_type (void) {
	static volatile gsize dvb_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBScanner), 0, (GInstanceInitFunc) dvb_scanner_instance_init, NULL };
		GType dvb_scanner_type_id;
		dvb_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBScanner", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&dvb_scanner_type_id__volatile, dvb_scanner_type_id);
	}
	return dvb_scanner_type_id__volatile;
}


static void _vala_dvb_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBScanner * self;
	self = DVB_SCANNER (object);
	switch (property_id) {
		case DVB_SCANNER_DEVICE:
		g_value_set_object (value, dvb_scanner_get_Device (self));
		break;
		case DVB_SCANNER_CHANNELS:
		g_value_set_object (value, dvb_scanner_get_Channels (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBScanner * self;
	self = DVB_SCANNER (object);
	switch (property_id) {
		case DVB_SCANNER_DEVICE:
		dvb_scanner_set_Device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



