/* Schedule.c generated by valac 0.11.3, the Vala compiler
 * generated from Schedule.vala, do not modify */

/*
 * Copyright (C) 2008-2011 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <dbus/dbus.h>
#include <float.h>
#include <math.h>
#include <time.h>


#define DVB_TYPE_ID_BUS_SCHEDULE (dvb_id_bus_schedule_get_type ())
#define DVB_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusSchedule))
#define DVB_IS_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCHEDULE))
#define DVB_ID_BUS_SCHEDULE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusScheduleIface))

typedef struct _DVBIDBusSchedule DVBIDBusSchedule;
typedef struct _DVBIDBusScheduleIface DVBIDBusScheduleIface;

#define DVB_TYPE_EVENT_INFO (dvb_event_info_get_type ())
typedef struct _DVBEventInfo DVBEventInfo;

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;
typedef struct _DVBSchedulePrivate DVBSchedulePrivate;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_DATABASE_TYPE_EPG_STORE (dvb_database_epg_store_get_type ())
#define DVB_DATABASE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStore))
#define DVB_DATABASE_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_EPG_STORE))
#define DVB_DATABASE_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStoreIface))

typedef struct _DVBdatabaseEPGStore DVBdatabaseEPGStore;
typedef struct _DVBdatabaseEPGStoreIface DVBdatabaseEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;

#define DVB_TYPE_EVENT_STORAGE (dvb_event_storage_get_type ())
#define DVB_EVENT_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT_STORAGE, DVBEventStorage))
#define DVB_EVENT_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT_STORAGE, DVBEventStorageClass))
#define DVB_IS_EVENT_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT_STORAGE))
#define DVB_IS_EVENT_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT_STORAGE))
#define DVB_EVENT_STORAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT_STORAGE, DVBEventStorageClass))

typedef struct _DVBEventStorage DVBEventStorage;
typedef struct _DVBEventStorageClass DVBEventStorageClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))

#define DVB_TYPE_EVENT_ELEMENT (dvb_event_element_get_type ())
#define DVB_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElement))
#define DVB_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))
#define DVB_IS_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT_ELEMENT))
#define DVB_IS_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT_ELEMENT))
#define DVB_EVENT_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))

typedef struct _DVBEventElement DVBEventElement;
typedef struct _DVBEventElementClass DVBEventElementClass;
typedef struct _DVBEventElementPrivate DVBEventElementPrivate;

#define DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE (dvb_database_sqlite_sqlite_database_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabase))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))

typedef struct _DVBdatabasesqliteSqliteDatabase DVBdatabasesqliteSqliteDatabase;
typedef struct _DVBdatabasesqliteSqliteDatabaseClass DVBdatabasesqliteSqliteDatabaseClass;
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DVBEventInfo {
	guint32 id;
	guint32 next;
	gchar* name;
	guint duration;
	gchar* short_description;
};

struct _DVBIDBusScheduleIface {
	GTypeInterface parent_iface;
	guint32* (*GetAllEvents) (DVBIDBusSchedule* self, int* result_length1, GError** error);
	DVBEventInfo* (*GetAllEventInfos) (DVBIDBusSchedule* self, int* result_length1, GError** error);
	gboolean (*GetInformations) (DVBIDBusSchedule* self, guint32 event_id, DVBEventInfo* event_info, GError** error);
	guint32 (*NowPlaying) (DVBIDBusSchedule* self, GError** error);
	guint32 (*Next) (DVBIDBusSchedule* self, guint32 event_id, GError** error);
	gboolean (*GetName) (DVBIDBusSchedule* self, guint32 event_id, gchar** name, GError** error);
	gboolean (*GetShortDescription) (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error);
	gboolean (*GetExtendedDescription) (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error);
	gboolean (*GetDuration) (DVBIDBusSchedule* self, guint32 event_id, guint* duration, GError** error);
	gboolean (*GetLocalStartTime) (DVBIDBusSchedule* self, guint32 event_id, guint** start_time, int* start_time_length1, GError** error);
	gboolean (*GetLocalStartTimestamp) (DVBIDBusSchedule* self, guint32 event_id, gint64* timestamp, GError** error);
	gboolean (*IsRunning) (DVBIDBusSchedule* self, guint32 event_id, gboolean* running, GError** error);
	gboolean (*IsScrambled) (DVBIDBusSchedule* self, guint32 event_id, gboolean* scrambled, GError** error);
};

struct _DVBSchedule {
	GObject parent_instance;
	DVBSchedulePrivate * priv;
};

struct _DVBScheduleClass {
	GObjectClass parent_class;
};

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	DVBEvent* (*get_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_older_than) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	gboolean (*contains_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	GeeList* (*get_events) (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_of_group) (DVBdatabaseEPGStore* self, guint group_id, GError** error);
};

struct _DVBSchedulePrivate {
	DVBChannel* _channel;
	DVBdatabaseEPGStore* epgstore;
	DVBEventStorage* events;
	GStaticRecMutex __lock_events;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _DVBEventElement {
	GObject parent_instance;
	DVBEventElementPrivate * priv;
	guint id;
	time_t starttime;
};

struct _DVBEventElementClass {
	GObjectClass parent_class;
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};


static gpointer dvb_schedule_parent_class = NULL;
static GStaticRecMutex dvb_schedule_mutex;
static GStaticRecMutex dvb_schedule_mutex = {0};
static DVBIDBusScheduleIface* dvb_schedule_dvb_id_bus_schedule_parent_iface = NULL;

DVBIDBusSchedule* dvb_id_bus_schedule_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType dvb_event_info_get_type (void) G_GNUC_CONST;
DVBEventInfo* dvb_event_info_dup (const DVBEventInfo* self);
void dvb_event_info_free (DVBEventInfo* self);
void dvb_event_info_copy (const DVBEventInfo* self, DVBEventInfo* dest);
void dvb_event_info_destroy (DVBEventInfo* self);
GType dvb_id_bus_schedule_get_type (void) G_GNUC_CONST;
GType dvb_schedule_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
GType dvb_database_epg_store_get_type (void) G_GNUC_CONST;
GType dvb_event_storage_get_type (void) G_GNUC_CONST;
#define DVB_SCHEDULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_SCHEDULE, DVBSchedulePrivate))
enum  {
	DVB_SCHEDULE_DUMMY_PROPERTY,
	DVB_SCHEDULE_CHANNEL
};
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void dvb_schedule_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_schedule_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_schedule_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_schedule_introspect (DVBSchedule* self, DBusConnection* connection, DBusMessage* message);
#define DVB_SCHEDULE_MATCH_THRESHOLD 100
#define DVB_SCHEDULE_MIN_EVENT_OVERLAP 0.5
static gboolean dvb_schedule_restore (DVBSchedule* self);
GeeList* dvb_database_epg_store_get_events (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
DVBChannel* dvb_schedule_get_channel (DVBSchedule* self);
guint dvb_channel_get_Sid (DVBChannel* self);
guint dvb_channel_get_GroupId (DVBChannel* self);
gboolean dvb_event_has_expired (DVBEvent* self);
void dvb_event_storage_insert (DVBEventStorage* self, DVBEvent* event);
gboolean dvb_database_epg_store_remove_events_older_than (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
DVBSchedule* dvb_schedule_new (DVBChannel* channel);
DVBSchedule* dvb_schedule_construct (GType object_type, DVBChannel* channel);
void dvb_schedule_remove_expired_events (DVBSchedule* self);
gint dvb_event_storage_get_size (DVBEventStorage* self);
GType dvb_event_element_get_type (void) G_GNUC_CONST;
DVBEventElement* dvb_event_storage_get (DVBEventStorage* self, gint index);
DVBEvent* dvb_schedule_get_event (DVBSchedule* self, guint event_id);
const gchar* dvb_channel_get_Name (DVBChannel* self);
void dvb_event_storage_remove_range (DVBEventStorage* self, gint start, gint end);
DVBEvent* dvb_database_epg_store_get_event (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
void dvb_schedule_add (DVBSchedule* self, DVBEvent* event);
static void dvb_schedule_store_event (DVBSchedule* self, DVBEvent* event, GError** error);
void dvb_schedule_add_all (DVBSchedule* self, GeeCollection* new_events);
GType dvb_database_sqlite_sqlite_database_get_type (void) G_GNUC_CONST;
void dvb_database_sqlite_sqlite_database_begin_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_database_sqlite_sqlite_database_end_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
static GeeList* dvb_schedule_get_overlapping_events (DVBSchedule* self, DVBEvent* event);
static gint dvb_schedule_match_events (DVBSchedule* self, GeeList* events, DVBEvent* ref_event);
void dvb_event_storage_remove_all (DVBEventStorage* self, GeeList* events);
gboolean dvb_database_epg_store_add_or_update_event (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
gboolean dvb_event_storage_contains_event_with_id (DVBEventStorage* self, guint event_id);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
GeeList* dvb_event_storage_get_overlapping_events (DVBEventStorage* self, DVBEvent* event);
gdouble dvb_event_get_overlap_percentage (DVBEvent* self, DVBEvent* other);
time_t dvb_event_get_start_timestamp (DVBEvent* self);
time_t dvb_event_get_end_timestamp (DVBEvent* self);
glong dvb_utils_strdiff (const gchar* a, const gchar* b, glong* unmatched);
gboolean dvb_schedule_contains (DVBSchedule* self, guint event_id);
DVBEvent* dvb_schedule_get_running_event (DVBSchedule* self);
gboolean dvb_event_is_running (DVBEvent* self);
DVBEvent* dvb_schedule_get_event_around (DVBSchedule* self, struct tm* start, guint duration);
static guint32* dvb_schedule_real_GetAllEvents (DVBIDBusSchedule* base, int* result_length1, GError** error);
static DVBEventInfo* dvb_schedule_real_GetAllEventInfos (DVBIDBusSchedule* base, int* result_length1, GError** error);
static void dvb_schedule_event_to_event_info (DVBEvent* event, DVBEventInfo* result);
static void _vala_DVBEventInfo_array_free (DVBEventInfo* array, gint array_length);
static gboolean dvb_schedule_real_GetInformations (DVBIDBusSchedule* base, guint32 event_id, DVBEventInfo* event_info, GError** error);
DVBEventElement* dvb_event_storage_get_by_id (DVBEventStorage* self, guint event_id);
DVBEventElement* dvb_event_storage_next (DVBEventStorage* self, DVBEventElement* element);
static guint32 dvb_schedule_real_NowPlaying (DVBIDBusSchedule* base, GError** error);
static guint32 dvb_schedule_real_Next (DVBIDBusSchedule* base, guint32 event_id, GError** error);
static gboolean dvb_schedule_real_GetName (DVBIDBusSchedule* base, guint32 event_id, gchar** name, GError** error);
static DVBEvent* dvb_schedule_get_extended_event_by_id (DVBSchedule* self, guint event_id);
static gboolean dvb_schedule_real_GetShortDescription (DVBIDBusSchedule* base, guint32 event_id, gchar** description, GError** error);
static gboolean dvb_schedule_real_GetExtendedDescription (DVBIDBusSchedule* base, guint32 event_id, gchar** description, GError** error);
static gboolean dvb_schedule_real_GetDuration (DVBIDBusSchedule* base, guint32 event_id, guint* duration, GError** error);
static gboolean dvb_schedule_real_GetLocalStartTime (DVBIDBusSchedule* base, guint32 event_id, guint** start_time, int* start_time_length1, GError** error);
void dvb_event_get_local_start_time (DVBEvent* self, struct tm* result);
static guint* dvb_schedule_to_time_array (struct tm* local_time, int* result_length1);
static gboolean dvb_schedule_real_GetLocalStartTimestamp (DVBIDBusSchedule* base, guint32 event_id, gint64* timestamp, GError** error);
static gboolean dvb_schedule_real_IsRunning (DVBIDBusSchedule* base, guint32 event_id, gboolean* running, GError** error);
static gboolean dvb_schedule_real_IsScrambled (DVBIDBusSchedule* base, guint32 event_id, gboolean* scrambled, GError** error);
static void dvb_schedule_set_channel (DVBSchedule* self, DVBChannel* value);
static GObject * dvb_schedule_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
DVBEventStorage* dvb_event_storage_new (void);
DVBEventStorage* dvb_event_storage_construct (GType object_type);
DVBdatabaseEPGStore* dvb_factory_get_epg_store (void);
static gboolean _dvb_schedule_restore_gsource_func (gpointer self);
static void dvb_schedule_finalize (GObject* obj);
static void _vala_dvb_schedule_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_schedule_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const DBusObjectPathVTable _dvb_schedule_dbus_path_vtable = {_dvb_schedule_dbus_unregister, dvb_schedule_dbus_message};
static const _DBusObjectVTable _dvb_schedule_dbus_vtable = {dvb_schedule_dbus_register_object};

static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _dvb_schedule_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_schedule_introspect (DVBSchedule* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.Schedule\">\n  <method name=\"GetAllEvents\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetAllEventInfos\">\n    <arg name=\"result\" type=\"a(uusus)\" direction=\"out\"/>\n  </method>\n  <method name=\"GetInformations\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"event_info\" type=\"(uusus)\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"NowPlaying\">\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"Next\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n  <method name=\"GetName\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"name\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetShortDescription\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"description\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetExtendedDescription\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"description\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetDuration\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"duration\" type=\"u\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLocalStartTime\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"start_time\" type=\"au\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetLocalStartTimestamp\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"timestamp\" type=\"x\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"IsRunning\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"running\" type=\"b\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"IsScrambled\">\n    <arg name=\"event_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"scrambled\" type=\"b\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_schedule_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_schedule_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (dvb_id_bus_schedule_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_schedule_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_schedule_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dvb_id_bus_schedule_dbus_register_object (connection, path, object);
}


static gboolean dvb_schedule_restore (DVBSchedule* self) {
	gboolean result = FALSE;
	GeeList* levents;
	guint _tmp0_;
	guint _tmp1_;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	gint newest_expired;
	guint _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	levents = NULL;
	_tmp0_ = dvb_channel_get_Sid (self->priv->_channel);
	_tmp1_ = dvb_channel_get_GroupId (self->priv->_channel);
	_tmp2_ = dvb_database_epg_store_get_events (self->priv->epgstore, _tmp0_, _tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch151_dvb_database_sql_error;
		}
		_g_object_unref0 (levents);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp4_ = _tmp3_;
	_g_object_unref0 (levents);
	levents = _tmp4_;
	goto __finally151;
	__catch151_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Schedule.vala:55: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (levents);
		return result;
	}
	__finally151:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (levents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	newest_expired = -1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gpointer _tmp7_ = NULL;
				DVBEvent* event;
				gboolean _tmp8_;
				if (!_tmp5_) {
					i++;
				}
				_tmp5_ = FALSE;
				_tmp6_ = gee_collection_get_size ((GeeCollection*) levents);
				if (!(i < _tmp6_)) {
					break;
				}
				_tmp7_ = gee_list_get (levents, i);
				event = (DVBEvent*) _tmp7_;
				_tmp8_ = dvb_event_has_expired (event);
				if (_tmp8_) {
					newest_expired = i;
				} else {
					dvb_event_storage_insert (self->priv->events, event);
				}
				_dvb_event_unref0 (event);
			}
		}
	}
	if (newest_expired != (-1)) {
		gpointer _tmp9_ = NULL;
		DVBEvent* event;
		guint _tmp10_;
		guint _tmp11_;
		_tmp9_ = gee_list_get (levents, newest_expired);
		event = (DVBEvent*) _tmp9_;
		_tmp10_ = dvb_channel_get_Sid (self->priv->_channel);
		_tmp11_ = dvb_channel_get_GroupId (self->priv->_channel);
		dvb_database_epg_store_remove_events_older_than (self->priv->epgstore, event, _tmp10_, _tmp11_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch152_dvb_database_sql_error;
			}
			_dvb_event_unref0 (event);
			_g_object_unref0 (levents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		goto __finally152;
		__catch152_dvb_database_sql_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_critical ("Schedule.vala:76: %s", e->message);
			result = FALSE;
			_g_error_free0 (e);
			_dvb_event_unref0 (event);
			_g_object_unref0 (levents);
			return result;
		}
		__finally152:
		if (_inner_error_ != NULL) {
			_dvb_event_unref0 (event);
			_g_object_unref0 (levents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_dvb_event_unref0 (event);
	}
	_tmp12_ = dvb_channel_get_Sid (self->priv->_channel);
	g_debug ("Schedule.vala:81: Finished restoring EPG events for channel %u", _tmp12_);
	result = FALSE;
	_g_object_unref0 (levents);
	return result;
}


DVBSchedule* dvb_schedule_construct (GType object_type, DVBChannel* channel) {
	DVBSchedule * self = NULL;
	g_return_val_if_fail (channel != NULL, NULL);
	self = (DVBSchedule*) g_object_new (object_type, "channel", channel, NULL);
	return self;
}


DVBSchedule* dvb_schedule_new (DVBChannel* channel) {
	return dvb_schedule_construct (DVB_TYPE_SCHEDULE, channel);
}


void dvb_schedule_remove_expired_events (DVBSchedule* self) {
	gint last_expired;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	last_expired = -1;
	{
		const gchar* _tmp6_ = NULL;
		guint _tmp7_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp0_;
				_tmp0_ = TRUE;
				while (TRUE) {
					gint _tmp1_;
					DVBEventElement* _tmp2_ = NULL;
					DVBEventElement* element;
					DVBEvent* _tmp3_ = NULL;
					DVBEvent* e;
					gboolean _tmp4_ = FALSE;
					if (!_tmp0_) {
						i++;
					}
					_tmp0_ = FALSE;
					_tmp1_ = dvb_event_storage_get_size (self->priv->events);
					if (!(i < _tmp1_)) {
						break;
					}
					_tmp2_ = dvb_event_storage_get (self->priv->events, i);
					element = _tmp2_;
					_tmp3_ = dvb_schedule_get_event (self, element->id);
					e = _tmp3_;
					if (e != NULL) {
						gboolean _tmp5_;
						_tmp5_ = dvb_event_has_expired (e);
						_tmp4_ = _tmp5_;
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						last_expired = i;
					} else {
						_dvb_event_unref0 (e);
						_g_object_unref0 (element);
						break;
					}
					_dvb_event_unref0 (e);
					_g_object_unref0 (element);
				}
			}
		}
		_tmp6_ = dvb_channel_get_Name (self->priv->_channel);
		_tmp7_ = dvb_channel_get_Sid (self->priv->_channel);
		g_debug ("Schedule.vala:105: Removing expired events of channel %s (%u)", _tmp6_, _tmp7_);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					DVBEventElement* _tmp9_ = NULL;
					DVBEventElement* element;
					DVBEvent* _tmp10_ = NULL;
					DVBEvent* event;
					guint _tmp11_;
					guint _tmp12_;
					if (!_tmp8_) {
						i++;
					}
					_tmp8_ = FALSE;
					if (!(i <= last_expired)) {
						break;
					}
					_tmp9_ = dvb_event_storage_get (self->priv->events, i);
					element = _tmp9_;
					_tmp10_ = dvb_schedule_get_event (self, element->id);
					event = _tmp10_;
					_tmp11_ = dvb_channel_get_Sid (self->priv->_channel);
					_tmp12_ = dvb_channel_get_GroupId (self->priv->_channel);
					dvb_database_epg_store_remove_events_older_than (self->priv->epgstore, event, _tmp11_, _tmp12_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch154_dvb_database_sql_error;
						}
						_dvb_event_unref0 (event);
						_g_object_unref0 (element);
						g_static_rec_mutex_unlock (&self->priv->__lock_events);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					goto __finally154;
					__catch154_dvb_database_sql_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						g_critical ("Schedule.vala:115: %s", e->message);
						_g_error_free0 (e);
					}
					__finally154:
					if (_inner_error_ != NULL) {
						_dvb_event_unref0 (event);
						_g_object_unref0 (element);
						_dvb_event_unref0 (event);
						_g_object_unref0 (element);
						g_static_rec_mutex_unlock (&self->priv->__lock_events);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
				}
			}
		}
		if (last_expired > (-1)) {
			dvb_event_storage_remove_range (self->priv->events, 0, last_expired);
		}
		__finally153:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


DVBEvent* dvb_schedule_get_event (DVBSchedule* self, guint event_id) {
	DVBEvent* result = NULL;
	guint _tmp0_;
	guint _tmp1_;
	DVBEvent* _tmp2_ = NULL;
	DVBEvent* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_channel_get_Sid (self->priv->_channel);
	_tmp1_ = dvb_channel_get_GroupId (self->priv->_channel);
	_tmp2_ = dvb_database_epg_store_get_event (self->priv->epgstore, event_id, _tmp0_, _tmp1_, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch155_dvb_database_sql_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp3_;
	return result;
	goto __finally155;
	__catch155_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Schedule.vala:130: %s", e->message);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally155:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/**
         * When an event with the same id already exists, it's replaced
         */
void dvb_schedule_add (DVBSchedule* self, DVBEvent* event) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = dvb_event_has_expired (event);
	if (_tmp0_) {
		return;
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		dvb_schedule_store_event (self, event, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch157_dvb_database_sql_error;
			}
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		goto __finally157;
		__catch157_dvb_database_sql_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_critical ("Schedule.vala:145: %s", e->message);
			_g_error_free0 (e);
		}
		__finally157:
		if (_inner_error_ != NULL) {
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		__finally156:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_schedule_add_all (DVBSchedule* self, GeeCollection* new_events) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_events != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		g_static_rec_mutex_lock (&dvb_schedule_mutex);
		dvb_database_sqlite_sqlite_database_begin_transaction (DVB_DATABASE_SQLITE_SQLITE_DATABASE (self->priv->epgstore), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch159_dvb_database_sql_error;
			}
			g_static_rec_mutex_unlock (&dvb_schedule_mutex);
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		{
			GeeIterator* _tmp0_ = NULL;
			GeeIterator* _event_it;
			_tmp0_ = gee_iterable_iterator ((GeeIterable*) new_events);
			_event_it = _tmp0_;
			while (TRUE) {
				gboolean _tmp1_;
				gpointer _tmp2_ = NULL;
				DVBEvent* event;
				gboolean _tmp3_;
				_tmp1_ = gee_iterator_next (_event_it);
				if (!_tmp1_) {
					break;
				}
				_tmp2_ = gee_iterator_get (_event_it);
				event = (DVBEvent*) _tmp2_;
				_tmp3_ = dvb_event_has_expired (event);
				if (!_tmp3_) {
					dvb_schedule_store_event (self, event, &_inner_error_);
					if (_inner_error_ != NULL) {
						_dvb_event_unref0 (event);
						_g_object_unref0 (_event_it);
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch159_dvb_database_sql_error;
						}
						_dvb_event_unref0 (event);
						_g_object_unref0 (_event_it);
						g_static_rec_mutex_unlock (&dvb_schedule_mutex);
						g_static_rec_mutex_unlock (&self->priv->__lock_events);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_dvb_event_unref0 (event);
			}
			_g_object_unref0 (_event_it);
		}
		dvb_database_sqlite_sqlite_database_end_transaction (DVB_DATABASE_SQLITE_SQLITE_DATABASE (self->priv->epgstore), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch159_dvb_database_sql_error;
			}
			g_static_rec_mutex_unlock (&dvb_schedule_mutex);
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		goto __finally159;
		__catch159_dvb_database_sql_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_critical ("Schedule.vala:163: %s", e->message);
			_g_error_free0 (e);
		}
		__finally159:
		g_static_rec_mutex_unlock (&dvb_schedule_mutex);
		if (_inner_error_ != NULL) {
			g_static_rec_mutex_unlock (&self->priv->__lock_events);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		__finally158:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void dvb_schedule_store_event (DVBSchedule* self, DVBEvent* event, GError** error) {
	GeeList* _tmp0_ = NULL;
	GeeList* overlap;
	gint _tmp1_;
	gint s;
	guint _tmp2_;
	guint _tmp3_;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = dvb_schedule_get_overlapping_events (self, event);
	overlap = _tmp0_;
	_tmp1_ = dvb_schedule_match_events (self, overlap, event);
	s = _tmp1_;
	if (s > DVB_SCHEDULE_MATCH_THRESHOLD) {
		dvb_event_storage_remove_all (self->priv->events, overlap);
	}
	_tmp2_ = dvb_channel_get_Sid (self->priv->_channel);
	_tmp3_ = dvb_channel_get_GroupId (self->priv->_channel);
	dvb_database_epg_store_add_or_update_event (self->priv->epgstore, event, _tmp2_, _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (overlap);
			return;
		} else {
			_g_object_unref0 (overlap);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = dvb_event_storage_contains_event_with_id (self->priv->events, event->id);
	if (!_tmp4_) {
		dvb_event_storage_insert (self->priv->events, event);
	}
	_g_object_unref0 (overlap);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeList* dvb_schedule_get_overlapping_events (DVBSchedule* self, DVBEvent* event) {
	GeeList* result = NULL;
	GeeList* _tmp0_ = NULL;
	GeeList* elements;
	GeeArrayList* _tmp1_ = NULL;
	GeeList* overlap;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event != NULL, NULL);
	_tmp0_ = dvb_event_storage_get_overlapping_events (self->priv->events, event);
	elements = _tmp0_;
	_tmp1_ = gee_array_list_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, NULL);
	overlap = (GeeList*) _tmp1_;
	{
		GeeList* _tmp2_;
		GeeList* _data_list;
		gint _tmp3_;
		gint _data_size;
		gint _data_index;
		_tmp2_ = _g_object_ref0 (elements);
		_data_list = _tmp2_;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _data_list);
		_data_size = _tmp3_;
		_data_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			DVBEventElement* data;
			DVBEvent* _tmp5_ = NULL;
			DVBEvent* e;
			gboolean _tmp6_ = FALSE;
			_data_index = _data_index + 1;
			if (!(_data_index < _data_size)) {
				break;
			}
			_tmp4_ = gee_list_get (_data_list, _data_index);
			data = (DVBEventElement*) _tmp4_;
			_tmp5_ = dvb_schedule_get_event (self, data->id);
			e = _tmp5_;
			if (e != NULL) {
				gdouble _tmp7_;
				_tmp7_ = dvb_event_get_overlap_percentage (e, event);
				_tmp6_ = _tmp7_ >= DVB_SCHEDULE_MIN_EVENT_OVERLAP;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				gee_collection_add ((GeeCollection*) overlap, e);
			}
			_dvb_event_unref0 (e);
			_g_object_unref0 (data);
		}
		_g_object_unref0 (_data_list);
	}
	result = overlap;
	_g_object_unref0 (elements);
	return result;
}


static gint dvb_schedule_match_events (DVBSchedule* self, GeeList* events, DVBEvent* ref_event) {
	gint result = 0;
	time_t _tmp0_;
	time_t ref_start;
	time_t _tmp1_;
	time_t ref_end;
	gdouble max_score;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (events != NULL, 0);
	g_return_val_if_fail (ref_event != NULL, 0);
	_tmp0_ = dvb_event_get_start_timestamp (ref_event);
	ref_start = _tmp0_;
	_tmp1_ = dvb_event_get_end_timestamp (ref_event);
	ref_end = _tmp1_;
	max_score = (gdouble) 0;
	{
		GeeList* _tmp2_;
		GeeList* _event_list;
		gint _tmp3_;
		gint _event_size;
		gint _event_index;
		_tmp2_ = _g_object_ref0 (events);
		_event_list = _tmp2_;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _event_list);
		_event_size = _tmp3_;
		_event_index = -1;
		while (TRUE) {
			gpointer _tmp4_ = NULL;
			DVBEvent* event;
			gdouble score;
			time_t _tmp5_;
			time_t e_start;
			time_t _tmp6_;
			time_t e_end;
			gdouble _tmp7_;
			gdouble _tmp8_;
			gdouble _tmp9_;
			gboolean _tmp10_ = FALSE;
			_event_index = _event_index + 1;
			if (!(_event_index < _event_size)) {
				break;
			}
			_tmp4_ = gee_list_get (_event_list, _event_index);
			event = (DVBEvent*) _tmp4_;
			score = (gdouble) 0;
			_tmp5_ = dvb_event_get_start_timestamp (event);
			e_start = _tmp5_;
			_tmp6_ = dvb_event_get_end_timestamp (event);
			e_end = _tmp6_;
			_tmp7_ = fabs ((gdouble) (ref_start - e_start));
			score = score + _tmp7_;
			_tmp8_ = fabs ((gdouble) (ref_end - e_end));
			score = score + _tmp8_;
			_tmp9_ = fabs ((gdouble) (ref_event->duration - event->duration));
			score = score + (_tmp9_ / 60.0);
			if (ref_event->name != NULL) {
				_tmp10_ = event->name != NULL;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				glong unmatched = 0L;
				glong _tmp11_;
				glong _tmp12_;
				glong diff;
				_tmp12_ = dvb_utils_strdiff (ref_event->name, event->name, &_tmp11_);
				unmatched = _tmp11_;
				diff = _tmp12_;
				score = score + ((gdouble) (10 * (diff + (5 * unmatched))));
			}
			if (score > max_score) {
				max_score = score;
			}
			_dvb_event_unref0 (event);
		}
		_g_object_unref0 (_event_list);
	}
	result = (gint) max_score;
	return result;
}


gboolean dvb_schedule_contains (DVBSchedule* self, guint event_id) {
	gboolean result = FALSE;
	gboolean val = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, event_id);
		val = _tmp0_;
		__finally160:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = val;
	return result;
}


static gpointer _dvb_event_ref0 (gpointer self) {
	return self ? dvb_event_ref (self) : NULL;
}


DVBEvent* dvb_schedule_get_running_event (DVBSchedule* self) {
	DVBEvent* result = NULL;
	DVBEvent* running_event;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	running_event = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp0_;
			DVBEventStorage* _element_list;
			gint _tmp1_;
			gint _element_size;
			gint _element_index;
			_tmp0_ = _g_object_ref0 (self->priv->events);
			_element_list = _tmp0_;
			_tmp1_ = dvb_event_storage_get_size (_element_list);
			_element_size = _tmp1_;
			_element_index = -1;
			while (TRUE) {
				DVBEventElement* _tmp2_ = NULL;
				DVBEventElement* element;
				DVBEvent* _tmp3_ = NULL;
				DVBEvent* event;
				gboolean _tmp4_ = FALSE;
				_element_index = _element_index + 1;
				if (!(_element_index < _element_size)) {
					break;
				}
				_tmp2_ = dvb_event_storage_get (_element_list, _element_index);
				element = _tmp2_;
				_tmp3_ = dvb_schedule_get_event (self, element->id);
				event = _tmp3_;
				if (event != NULL) {
					gboolean _tmp5_;
					_tmp5_ = dvb_event_is_running (event);
					_tmp4_ = _tmp5_;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					DVBEvent* _tmp6_;
					DVBEvent* _tmp7_;
					_tmp6_ = _dvb_event_ref0 (event);
					_tmp7_ = _tmp6_;
					_dvb_event_unref0 (running_event);
					running_event = _tmp7_;
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
					break;
				}
				_dvb_event_unref0 (event);
				_g_object_unref0 (element);
			}
			_g_object_unref0 (_element_list);
		}
		__finally161:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			_dvb_event_unref0 (running_event);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = running_event;
	return result;
}


/**
         * @start: local time of event
         * @duration: how long the event is
         * @returns: the event that starts after @start
         * and spans the given time period
         */
static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


DVBEvent* dvb_schedule_get_event_around (DVBSchedule* self, struct tm* start, guint duration) {
	DVBEvent* result = NULL;
	DVBEvent* _result_;
	time_t _tmp0_;
	time_t timer_start;
	time_t timer_end;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = mktime (start);
	timer_start = _tmp0_;
	timer_end = timer_start + (duration * 60);
	{
		time_t last_diff;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		last_diff = (time_t) 0;
		{
			DVBEventStorage* _tmp1_;
			DVBEventStorage* _element_list;
			gint _tmp2_;
			gint _element_size;
			gint _element_index;
			_tmp1_ = _g_object_ref0 (self->priv->events);
			_element_list = _tmp1_;
			_tmp2_ = dvb_event_storage_get_size (_element_list);
			_element_size = _tmp2_;
			_element_index = -1;
			while (TRUE) {
				DVBEventElement* _tmp3_ = NULL;
				DVBEventElement* element;
				struct tm _tmp4_ = {0};
				struct tm _tmp5_ = {0};
				time_t _tmp6_;
				time_t event_start;
				DVBEvent* _tmp7_ = NULL;
				DVBEvent* event;
				time_t event_end;
				time_t _tmp8_;
				time_t min_end;
				time_t _tmp9_;
				time_t max_start;
				time_t overlap;
				_element_index = _element_index + 1;
				if (!(_element_index < _element_size)) {
					break;
				}
				_tmp3_ = dvb_event_storage_get (_element_list, _element_index);
				element = _tmp3_;
				_tmp5_ = (g_time_local (element->starttime, &_tmp4_), _tmp4_);
				_tmp6_ = timegm (&_tmp5_);
				event_start = _tmp6_;
				_tmp7_ = dvb_schedule_get_event (self, element->id);
				event = _tmp7_;
				if (event == NULL) {
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
					continue;
				}
				event_end = event_start + event->duration;
				if (timer_end < event_end) {
					_tmp8_ = timer_end;
				} else {
					_tmp8_ = event_end;
				}
				min_end = _tmp8_;
				if (timer_start > event_start) {
					_tmp9_ = timer_start;
				} else {
					_tmp9_ = event_start;
				}
				max_start = _tmp9_;
				overlap = min_end - max_start;
				if (last_diff < overlap) {
					DVBEvent* _tmp10_;
					DVBEvent* _tmp11_;
					last_diff = overlap;
					_tmp10_ = _dvb_event_ref0 (event);
					_tmp11_ = _tmp10_;
					_dvb_event_unref0 (_result_);
					_result_ = _tmp11_;
				}
				if (event_start > timer_end) {
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
					break;
				}
				_dvb_event_unref0 (event);
				_g_object_unref0 (element);
			}
			_g_object_unref0 (_element_list);
		}
		__finally162:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			_dvb_event_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _result_;
	return result;
}


static guint32* dvb_schedule_real_GetAllEvents (DVBIDBusSchedule* base, int* result_length1, GError** error) {
	DVBSchedule * self;
	guint32* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* events;
	gint _tmp7_;
	guint32* _tmp8_ = NULL;
	gint event_ids_length1;
	gint _event_ids_size_;
	guint32* _tmp9_;
	guint32* event_ids;
	guint32* _tmp12_;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL);
	events = _tmp0_;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp1_;
			DVBEventStorage* _element_list;
			gint _tmp2_;
			gint _element_size;
			gint _element_index;
			_tmp1_ = _g_object_ref0 (self->priv->events);
			_element_list = _tmp1_;
			_tmp2_ = dvb_event_storage_get_size (_element_list);
			_element_size = _tmp2_;
			_element_index = -1;
			while (TRUE) {
				DVBEventElement* _tmp3_ = NULL;
				DVBEventElement* element;
				DVBEvent* _tmp4_ = NULL;
				DVBEvent* event;
				gboolean _tmp5_ = FALSE;
				_element_index = _element_index + 1;
				if (!(_element_index < _element_size)) {
					break;
				}
				_tmp3_ = dvb_event_storage_get (_element_list, _element_index);
				element = _tmp3_;
				_tmp4_ = dvb_schedule_get_event (self, element->id);
				event = _tmp4_;
				if (event == NULL) {
					_tmp5_ = TRUE;
				} else {
					gboolean _tmp6_;
					_tmp6_ = dvb_event_has_expired (event);
					_tmp5_ = _tmp6_;
				}
				if (_tmp5_) {
					_dvb_event_unref0 (event);
					_g_object_unref0 (element);
					continue;
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) events, GUINT_TO_POINTER ((guint32) element->id));
				_dvb_event_unref0 (event);
				_g_object_unref0 (element);
			}
			_g_object_unref0 (_element_list);
		}
		__finally163:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (events);
				return NULL;
			} else {
				_g_object_unref0 (events);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp7_ = gee_collection_get_size ((GeeCollection*) events);
	_tmp8_ = g_new0 (guint32, _tmp7_);
	_tmp9_ = _tmp8_;
	event_ids_length1 = _tmp7_;
	_event_ids_size_ = event_ids_length1;
	event_ids = _tmp9_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				gpointer _tmp11_ = NULL;
				if (!_tmp10_) {
					i++;
				}
				_tmp10_ = FALSE;
				if (!(i < event_ids_length1)) {
					break;
				}
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) events, i);
				event_ids[i] = GPOINTER_TO_UINT (_tmp11_);
			}
		}
	}
	_tmp12_ = event_ids;
	*result_length1 = event_ids_length1;
	result = _tmp12_;
	_g_object_unref0 (events);
	return result;
}


static void _vala_DVBEventInfo_array_free (DVBEventInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_event_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DVBEventInfo* dvb_schedule_real_GetAllEventInfos (DVBIDBusSchedule* base, int* result_length1, GError** error) {
	DVBSchedule * self;
	DVBEventInfo* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* all_events;
	gint _tmp7_;
	gint n_events;
	DVBEventInfo* _tmp8_ = NULL;
	gint event_infos_length1;
	gint _event_infos_size_;
	DVBEventInfo* _tmp9_;
	DVBEventInfo* event_infos;
	gint i;
	DVBEvent* event;
	DVBEventInfo* _tmp18_;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	_tmp0_ = gee_array_list_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, NULL);
	all_events = _tmp0_;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		{
			DVBEventStorage* _tmp1_;
			DVBEventStorage* _element_list;
			gint _tmp2_;
			gint _element_size;
			gint _element_index;
			_tmp1_ = _g_object_ref0 (self->priv->events);
			_element_list = _tmp1_;
			_tmp2_ = dvb_event_storage_get_size (_element_list);
			_element_size = _tmp2_;
			_element_index = -1;
			while (TRUE) {
				DVBEventElement* _tmp3_ = NULL;
				DVBEventElement* element;
				DVBEvent* _tmp4_ = NULL;
				DVBEvent* event;
				gboolean _tmp5_ = FALSE;
				_element_index = _element_index + 1;
				if (!(_element_index < _element_size)) {
					break;
				}
				_tmp3_ = dvb_event_storage_get (_element_list, _element_index);
				element = _tmp3_;
				_tmp4_ = dvb_schedule_get_event (self, element->id);
				event = _tmp4_;
				if (event != NULL) {
					gboolean _tmp6_;
					_tmp6_ = dvb_event_has_expired (event);
					_tmp5_ = !_tmp6_;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					gee_abstract_collection_add ((GeeAbstractCollection*) all_events, event);
				}
				_dvb_event_unref0 (event);
				_g_object_unref0 (element);
			}
			_g_object_unref0 (_element_list);
		}
		__finally164:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (all_events);
				return NULL;
			} else {
				_g_object_unref0 (all_events);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp7_ = gee_collection_get_size ((GeeCollection*) all_events);
	n_events = _tmp7_;
	_tmp8_ = g_new0 (DVBEventInfo, n_events);
	_tmp9_ = _tmp8_;
	event_infos_length1 = n_events;
	_event_infos_size_ = event_infos_length1;
	event_infos = _tmp9_;
	i = 0;
	event = NULL;
	if (n_events > i) {
		gpointer _tmp10_ = NULL;
		DVBEvent* _tmp11_;
		_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) all_events, i);
		_tmp11_ = (DVBEvent*) _tmp10_;
		_dvb_event_unref0 (event);
		event = _tmp11_;
	}
	while (TRUE) {
		DVBEventInfo _tmp12_ = {0};
		DVBEventInfo _tmp13_ = {0};
		DVBEventInfo _tmp14_;
		if (!(event != NULL)) {
			break;
		}
		_tmp13_ = (dvb_schedule_event_to_event_info (event, &_tmp12_), _tmp12_);
		_tmp14_ = _tmp13_;
		dvb_event_info_destroy (&event_infos[i]);
		event_infos[i] = _tmp14_;
		if ((i + 1) == n_events) {
			DVBEvent* _tmp15_;
			event_infos[i].next = (guint32) 0;
			_tmp15_ = NULL;
			_dvb_event_unref0 (event);
			event = _tmp15_;
		} else {
			gpointer _tmp16_ = NULL;
			DVBEvent* _tmp17_;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) all_events, i + 1);
			_tmp17_ = (DVBEvent*) _tmp16_;
			_dvb_event_unref0 (event);
			event = _tmp17_;
			event_infos[i].next = (guint32) event->id;
		}
		i++;
	}
	_tmp18_ = event_infos;
	*result_length1 = event_infos_length1;
	result = _tmp18_;
	_dvb_event_unref0 (event);
	_g_object_unref0 (all_events);
	return result;
}


static gboolean dvb_schedule_real_GetInformations (DVBIDBusSchedule* base, guint32 event_id, DVBEventInfo* event_info, GError** error) {
	DVBSchedule * self;
	DVBEventInfo _event_info = {0};
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEventElement* _tmp1_ = NULL;
			DVBEventElement* element;
			DVBEvent* _tmp2_ = NULL;
			DVBEvent* event;
			DVBEventInfo _tmp3_ = {0};
			DVBEventInfo _tmp4_ = {0};
			DVBEventInfo _tmp5_;
			DVBEventElement* _tmp6_ = NULL;
			DVBEventElement* next_element;
			_tmp1_ = dvb_event_storage_get_by_id (self->priv->events, (guint) event_id);
			element = _tmp1_;
			_tmp2_ = dvb_schedule_get_event (self, element->id);
			event = _tmp2_;
			_tmp4_ = (dvb_schedule_event_to_event_info (event, &_tmp3_), _tmp3_);
			_tmp5_ = _tmp4_;
			dvb_event_info_destroy (&_event_info);
			_event_info = _tmp5_;
			_tmp6_ = dvb_event_storage_next (self->priv->events, element);
			next_element = _tmp6_;
			if (next_element == NULL) {
				_event_info.next = (guint32) 0;
			} else {
				DVBEventElement* _tmp7_;
				DVBEventElement* _tmp8_;
				_tmp7_ = _g_object_ref0 (next_element);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (element);
				element = _tmp8_;
				_event_info.next = (guint32) element->id;
			}
			ret = TRUE;
			_g_object_unref0 (next_element);
			_dvb_event_unref0 (event);
			_g_object_unref0 (element);
		} else {
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_event_info.id = (guint32) 0;
			_tmp9_ = g_strdup ("");
			_tmp10_ = _tmp9_;
			_g_free0 (_event_info.name);
			_event_info.name = _tmp10_;
			_event_info.duration = (guint) 0;
			_tmp11_ = g_strdup ("");
			_tmp12_ = _tmp11_;
			_g_free0 (_event_info.short_description);
			_event_info.short_description = _tmp12_;
			_event_info.next = (guint32) 0;
			ret = FALSE;
		}
		__finally165:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (event_info) {
		*event_info = _event_info;
	} else {
		dvb_event_info_destroy (&_event_info);
	}
	return result;
}


static guint32 dvb_schedule_real_NowPlaying (DVBIDBusSchedule* base, GError** error) {
	DVBSchedule * self;
	guint32 result = 0U;
	DVBEvent* _tmp0_ = NULL;
	DVBEvent* event;
	guint _tmp1_ = 0U;
	self = (DVBSchedule*) base;
	_tmp0_ = dvb_schedule_get_running_event (self);
	event = _tmp0_;
	if (event == NULL) {
		_tmp1_ = (guint) 0;
	} else {
		_tmp1_ = event->id;
	}
	result = (guint32) _tmp1_;
	_dvb_event_unref0 (event);
	return result;
}


static guint32 dvb_schedule_real_Next (DVBIDBusSchedule* base, guint32 event_id, GError** error) {
	DVBSchedule * self;
	guint32 result = 0U;
	guint32 next_event;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	next_event = (guint32) 0;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEventElement* _tmp1_ = NULL;
			DVBEventElement* element;
			DVBEventElement* _tmp2_ = NULL;
			DVBEventElement* next;
			_tmp1_ = dvb_event_storage_get_by_id (self->priv->events, (guint) event_id);
			element = _tmp1_;
			_tmp2_ = dvb_event_storage_next (self->priv->events, element);
			next = _tmp2_;
			if (next != NULL) {
				next_event = (guint32) next->id;
			}
			_g_object_unref0 (next);
			_g_object_unref0 (element);
		} else {
			g_debug ("Schedule.vala:389: No event with id %u", (guint) event_id);
		}
		__finally166:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return 0U;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0U;
			}
		}
	}
	result = next_event;
	return result;
}


static gboolean dvb_schedule_real_GetName (DVBIDBusSchedule* base, guint32 event_id, gchar** name, GError** error) {
	DVBSchedule * self;
	gchar* _name = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			gboolean _tmp2_ = FALSE;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				_tmp2_ = event->name != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = g_strdup (event->name);
				_tmp4_ = _tmp3_;
				_g_free0 (_name);
				_name = _tmp4_;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		} else {
			g_debug ("Schedule.vala:407: No event with id %u", (guint) event_id);
		}
		__finally167:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup ("");
		_tmp6_ = _tmp5_;
		_g_free0 (_name);
		_name = _tmp6_;
	}
	result = ret;
	if (name) {
		*name = _name;
	} else {
		_g_free0 (_name);
	}
	return result;
}


static gboolean dvb_schedule_real_GetShortDescription (DVBIDBusSchedule* base, guint32 event_id, gchar** description, GError** error) {
	DVBSchedule * self;
	gchar* _description = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			gboolean _tmp2_ = FALSE;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				_tmp2_ = event->description != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = g_strdup (event->description);
				_tmp4_ = _tmp3_;
				_g_free0 (_description);
				_description = _tmp4_;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		} else {
			g_debug ("Schedule.vala:427: No event with id %u", (guint) event_id);
		}
		__finally168:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup ("");
		_tmp6_ = _tmp5_;
		_g_free0 (_description);
		_description = _tmp6_;
	}
	result = ret;
	if (description) {
		*description = _description;
	} else {
		_g_free0 (_description);
	}
	return result;
}


static gboolean dvb_schedule_real_GetExtendedDescription (DVBIDBusSchedule* base, guint32 event_id, gchar** description, GError** error) {
	DVBSchedule * self;
	gchar* _description = NULL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			gboolean _tmp2_ = FALSE;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				_tmp2_ = event->extended_description != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = g_strdup (event->extended_description);
				_tmp4_ = _tmp3_;
				_g_free0 (_description);
				_description = _tmp4_;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		} else {
			g_debug ("Schedule.vala:447: No event with id %u", (guint) event_id);
		}
		__finally169:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_strdup ("");
		_tmp6_ = _tmp5_;
		_g_free0 (_description);
		_description = _tmp6_;
	}
	result = ret;
	if (description) {
		*description = _description;
	} else {
		_g_free0 (_description);
	}
	return result;
}


static gboolean dvb_schedule_real_GetDuration (DVBIDBusSchedule* base, guint32 event_id, guint* duration, GError** error) {
	DVBSchedule * self;
	guint _duration = 0U;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				_duration = event->duration;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		} else {
			g_debug ("Schedule.vala:467: No event with id %u", (guint) event_id);
		}
		__finally170:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (duration) {
		*duration = _duration;
	}
	return result;
}


static gboolean dvb_schedule_real_GetLocalStartTime (DVBIDBusSchedule* base, guint32 event_id, guint** start_time, int* start_time_length1, GError** error) {
	DVBSchedule * self;
	guint* _start_time = NULL;
	int _start_time_length1 = 0;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				struct tm _tmp2_ = {0};
				struct tm _tmp3_ = {0};
				struct tm local_time;
				gint _tmp4_;
				guint* _tmp5_ = NULL;
				guint* _tmp6_;
				_tmp3_ = (dvb_event_get_local_start_time (event, &_tmp2_), _tmp2_);
				local_time = _tmp3_;
				_tmp5_ = dvb_schedule_to_time_array (&local_time, &_tmp4_);
				_tmp6_ = _tmp5_;
				_start_time = (g_free (_start_time), NULL);
				_start_time_length1 = _tmp4_;
				_start_time = _tmp6_;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		} else {
			guint* _tmp7_ = NULL;
			guint* _tmp8_;
			g_debug ("Schedule.vala:488: No event with id %u", (guint) event_id);
			_tmp7_ = g_new0 (guint, 0);
			_tmp8_ = _tmp7_;
			_start_time = (g_free (_start_time), NULL);
			_start_time_length1 = 0;
			_start_time = _tmp8_;
		}
		__finally171:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (!ret) {
		guint* _tmp9_ = NULL;
		guint* _tmp10_;
		_tmp9_ = g_new0 (guint, 0);
		_tmp10_ = _tmp9_;
		_start_time = (g_free (_start_time), NULL);
		_start_time_length1 = 0;
		_start_time = _tmp10_;
	}
	result = ret;
	if (start_time) {
		*start_time = _start_time;
	} else {
		_start_time = (g_free (_start_time), NULL);
	}
	if (start_time_length1) {
		*start_time_length1 = _start_time_length1;
	}
	return result;
}


static gboolean dvb_schedule_real_GetLocalStartTimestamp (DVBIDBusSchedule* base, guint32 event_id, gint64* timestamp, GError** error) {
	DVBSchedule * self;
	gint64 _timestamp = 0LL;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				struct tm _tmp2_ = {0};
				struct tm _tmp3_ = {0};
				struct tm local_time;
				time_t _tmp4_;
				_tmp3_ = (dvb_event_get_local_start_time (event, &_tmp2_), _tmp2_);
				local_time = _tmp3_;
				_tmp4_ = mktime (&local_time);
				_timestamp = (gint64) _tmp4_;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		}
		__finally172:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (timestamp) {
		*timestamp = _timestamp;
	}
	return result;
}


static gboolean dvb_schedule_real_IsRunning (DVBIDBusSchedule* base, guint32 event_id, gboolean* running, GError** error) {
	DVBSchedule * self;
	gboolean _running = FALSE;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				gboolean _tmp2_;
				_tmp2_ = dvb_event_is_running (event);
				_running = _tmp2_;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		} else {
			g_debug ("Schedule.vala:528: No event with id %u", (guint) event_id);
		}
		__finally173:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (running) {
		*running = _running;
	}
	return result;
}


static gboolean dvb_schedule_real_IsScrambled (DVBIDBusSchedule* base, guint32 event_id, gboolean* scrambled, GError** error) {
	DVBSchedule * self;
	gboolean _scrambled = FALSE;
	gboolean result = FALSE;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBSchedule*) base;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_events);
		_tmp0_ = dvb_event_storage_contains_event_with_id (self->priv->events, (guint) event_id);
		if (_tmp0_) {
			DVBEvent* _tmp1_ = NULL;
			DVBEvent* event;
			_tmp1_ = dvb_schedule_get_extended_event_by_id (self, (guint) event_id);
			event = _tmp1_;
			if (event != NULL) {
				_scrambled = !event->free_ca_mode;
				ret = TRUE;
			}
			_dvb_event_unref0 (event);
		} else {
			g_debug ("Schedule.vala:548: No event with id %u", (guint) event_id);
		}
		__finally174:
		g_static_rec_mutex_unlock (&self->priv->__lock_events);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (scrambled) {
		*scrambled = _scrambled;
	}
	return result;
}


static DVBEvent* dvb_schedule_get_extended_event_by_id (DVBSchedule* self, guint event_id) {
	DVBEvent* result = NULL;
	DVBEventElement* _tmp0_ = NULL;
	DVBEventElement* element;
	DVBEvent* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_event_storage_get_by_id (self->priv->events, event_id);
	element = _tmp0_;
	_tmp1_ = dvb_schedule_get_event (self, element->id);
	result = _tmp1_;
	_g_object_unref0 (element);
	return result;
}


static guint* dvb_schedule_to_time_array (struct tm* local_time, int* result_length1) {
	guint* result = NULL;
	guint* _tmp0_ = NULL;
	gint start_length1;
	gint _start_size_;
	guint* _tmp1_;
	guint* start;
	guint* _tmp2_;
	_tmp0_ = g_new0 (guint, 6);
	_tmp1_ = _tmp0_;
	start_length1 = 6;
	_start_size_ = start_length1;
	start = _tmp1_;
	start[0] = (guint) ((*local_time).tm_year + 1900);
	start[1] = (guint) ((*local_time).tm_mon + 1);
	start[2] = (guint) (*local_time).tm_mday;
	start[3] = (guint) (*local_time).tm_hour;
	start[4] = (guint) (*local_time).tm_min;
	start[5] = (guint) (*local_time).tm_sec;
	_tmp2_ = start;
	*result_length1 = start_length1;
	result = _tmp2_;
	return result;
}


static void dvb_schedule_event_to_event_info (DVBEvent* event, DVBEventInfo* result) {
	DVBEventInfo event_info = {0};
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (event != NULL);
	memset (&event_info, 0, sizeof (DVBEventInfo));
	event_info.id = (guint32) event->id;
	_tmp0_ = g_strdup (event->name);
	_tmp1_ = _tmp0_;
	_g_free0 (event_info.name);
	event_info.name = _tmp1_;
	event_info.duration = event->duration;
	_tmp2_ = g_strdup (event->description);
	_tmp3_ = _tmp2_;
	_g_free0 (event_info.short_description);
	event_info.short_description = _tmp3_;
	*result = event_info;
	return;
}


DVBChannel* dvb_schedule_get_channel (DVBSchedule* self) {
	DVBChannel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_channel;
	return result;
}


static void dvb_schedule_set_channel (DVBSchedule* self, DVBChannel* value) {
	g_return_if_fail (self != NULL);
	self->priv->_channel = value;
	g_object_notify ((GObject *) self, "channel");
}


static gboolean _dvb_schedule_restore_gsource_func (gpointer self) {
	gboolean result;
	result = dvb_schedule_restore (self);
	return result;
}


static GObject * dvb_schedule_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBSchedule * self;
	DVBEventStorage* _tmp0_ = NULL;
	DVBEventStorage* _tmp1_;
	DVBdatabaseEPGStore* _tmp2_ = NULL;
	DVBdatabaseEPGStore* _tmp3_;
	parent_class = G_OBJECT_CLASS (dvb_schedule_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_SCHEDULE (obj);
	_tmp0_ = dvb_event_storage_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->events);
	self->priv->events = _tmp1_;
	_tmp2_ = dvb_factory_get_epg_store ();
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->epgstore);
	self->priv->epgstore = _tmp3_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _dvb_schedule_restore_gsource_func, g_object_ref (self), g_object_unref);
	return obj;
}


static void dvb_schedule_class_init (DVBScheduleClass * klass) {
	GStaticRecMutex _tmp0_ = {0};
	GStaticRecMutex _tmp1_ = {0};
	dvb_schedule_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBSchedulePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_schedule_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_schedule_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_schedule_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_schedule_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_SCHEDULE_CHANNEL, g_param_spec_object ("channel", "channel", "channel", DVB_TYPE_CHANNEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_type_set_qdata (DVB_TYPE_SCHEDULE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_schedule_dbus_vtable));
	g_static_rec_mutex_init (&_tmp0_);
	_tmp1_ = _tmp0_;
	dvb_schedule_mutex = _tmp1_;
}


static void dvb_schedule_dvb_id_bus_schedule_interface_init (DVBIDBusScheduleIface * iface) {
	dvb_schedule_dvb_id_bus_schedule_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetAllEvents = (guint32* (*)(DVBIDBusSchedule* ,int* ,GError**)) dvb_schedule_real_GetAllEvents;
	iface->GetAllEventInfos = (DVBEventInfo* (*)(DVBIDBusSchedule* ,int* ,GError**)) dvb_schedule_real_GetAllEventInfos;
	iface->GetInformations = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,DVBEventInfo* ,GError**)) dvb_schedule_real_GetInformations;
	iface->NowPlaying = (guint32 (*)(DVBIDBusSchedule* ,GError**)) dvb_schedule_real_NowPlaying;
	iface->Next = (guint32 (*)(DVBIDBusSchedule* ,guint32 ,GError**)) dvb_schedule_real_Next;
	iface->GetName = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,gchar** ,GError**)) dvb_schedule_real_GetName;
	iface->GetShortDescription = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,gchar** ,GError**)) dvb_schedule_real_GetShortDescription;
	iface->GetExtendedDescription = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,gchar** ,GError**)) dvb_schedule_real_GetExtendedDescription;
	iface->GetDuration = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,guint* ,GError**)) dvb_schedule_real_GetDuration;
	iface->GetLocalStartTime = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,guint** ,int* ,GError**)) dvb_schedule_real_GetLocalStartTime;
	iface->GetLocalStartTimestamp = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,gint64* ,GError**)) dvb_schedule_real_GetLocalStartTimestamp;
	iface->IsRunning = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,gboolean* ,GError**)) dvb_schedule_real_IsRunning;
	iface->IsScrambled = (gboolean (*)(DVBIDBusSchedule* ,guint32 ,gboolean* ,GError**)) dvb_schedule_real_IsScrambled;
}


static void dvb_schedule_instance_init (DVBSchedule * self) {
	self->priv = DVB_SCHEDULE_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_events);
}


static void dvb_schedule_finalize (GObject* obj) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (obj);
	_g_object_unref0 (self->priv->epgstore);
	g_static_rec_mutex_free (&self->priv->__lock_events);
	_g_object_unref0 (self->priv->events);
	G_OBJECT_CLASS (dvb_schedule_parent_class)->finalize (obj);
}


/**
     * Represents a series of events of a channel
     */
GType dvb_schedule_get_type (void) {
	static volatile gsize dvb_schedule_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_schedule_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBScheduleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_schedule_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSchedule), 0, (GInstanceInitFunc) dvb_schedule_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_schedule_info = { (GInterfaceInitFunc) dvb_schedule_dvb_id_bus_schedule_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_schedule_type_id;
		dvb_schedule_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBSchedule", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_schedule_type_id, DVB_TYPE_ID_BUS_SCHEDULE, &dvb_id_bus_schedule_info);
		g_once_init_leave (&dvb_schedule_type_id__volatile, dvb_schedule_type_id);
	}
	return dvb_schedule_type_id__volatile;
}


static void _vala_dvb_schedule_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (object);
	switch (property_id) {
		case DVB_SCHEDULE_CHANNEL:
		g_value_set_object (value, dvb_schedule_get_channel (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_schedule_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBSchedule * self;
	self = DVB_SCHEDULE (object);
	switch (property_id) {
		case DVB_SCHEDULE_CHANNEL:
		dvb_schedule_set_channel (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



