/* Services.c generated by valac 0.11.3, the Vala compiler
 * generated from Services.vala, do not modify */

/*
 * Copyright (C) 2009-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib.h>
#include <gee.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib-lowlevel.h>


#define TYPE_MEDIA_CONTAINER1 (media_container1_get_type ())
#define MEDIA_CONTAINER1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER1, MediaContainer1))
#define IS_MEDIA_CONTAINER1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER1))
#define MEDIA_CONTAINER1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_CONTAINER1, MediaContainer1Iface))

typedef struct _MediaContainer1 MediaContainer1;
typedef struct _MediaContainer1Iface MediaContainer1Iface;

#define TYPE_MEDIA_OBJECT1 (media_object1_get_type ())
#define MEDIA_OBJECT1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT1, MediaObject1))
#define IS_MEDIA_OBJECT1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT1))
#define MEDIA_OBJECT1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_OBJECT1, MediaObject1Iface))

typedef struct _MediaObject1 MediaObject1;
typedef struct _MediaObject1Iface MediaObject1Iface;

#define DVB_MEDIA_SERVER_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER (dvb_media_server_device_groups_media_container_get_type ())
#define DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_MEDIA_SERVER_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER, DVBMediaServerDeviceGroupsMediaContainer))
#define DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_MEDIA_SERVER_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER, DVBMediaServerDeviceGroupsMediaContainerClass))
#define DVB_MEDIA_SERVER_IS_DEVICE_GROUPS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_MEDIA_SERVER_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER))
#define DVB_MEDIA_SERVER_IS_DEVICE_GROUPS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_MEDIA_SERVER_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER))
#define DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_MEDIA_SERVER_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER, DVBMediaServerDeviceGroupsMediaContainerClass))

typedef struct _DVBMediaServerDeviceGroupsMediaContainer DVBMediaServerDeviceGroupsMediaContainer;
typedef struct _DVBMediaServerDeviceGroupsMediaContainerClass DVBMediaServerDeviceGroupsMediaContainerClass;
typedef struct _DVBMediaServerDeviceGroupsMediaContainerPrivate DVBMediaServerDeviceGroupsMediaContainerPrivate;

#define DVB_MEDIA_SERVER_TYPE_CHANNELS_MEDIA_CONTAINER (dvb_media_server_channels_media_container_get_type ())
#define DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_MEDIA_SERVER_TYPE_CHANNELS_MEDIA_CONTAINER, DVBMediaServerChannelsMediaContainer))
#define DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_MEDIA_SERVER_TYPE_CHANNELS_MEDIA_CONTAINER, DVBMediaServerChannelsMediaContainerClass))
#define DVB_MEDIA_SERVER_IS_CHANNELS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_MEDIA_SERVER_TYPE_CHANNELS_MEDIA_CONTAINER))
#define DVB_MEDIA_SERVER_IS_CHANNELS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_MEDIA_SERVER_TYPE_CHANNELS_MEDIA_CONTAINER))
#define DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_MEDIA_SERVER_TYPE_CHANNELS_MEDIA_CONTAINER, DVBMediaServerChannelsMediaContainerClass))

typedef struct _DVBMediaServerChannelsMediaContainer DVBMediaServerChannelsMediaContainer;
typedef struct _DVBMediaServerChannelsMediaContainerClass DVBMediaServerChannelsMediaContainerClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

#define DVB_TYPE_ID_BUS_MANAGER (dvb_id_bus_manager_get_type ())
#define DVB_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManager))
#define DVB_IS_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_MANAGER))
#define DVB_ID_BUS_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManagerIface))

typedef struct _DVBIDBusManager DVBIDBusManager;
typedef struct _DVBIDBusManagerIface DVBIDBusManagerIface;

#define DVB_TYPE_CHANNEL_GROUP_INFO (dvb_channel_group_info_get_type ())
typedef struct _DVBChannelGroupInfo DVBChannelGroupInfo;
typedef struct _DVBMediaServerChannelsMediaContainerPrivate DVBMediaServerChannelsMediaContainerPrivate;

#define DVB_MEDIA_SERVER_TYPE_CHANNEL_MEDIA_ITEM (dvb_media_server_channel_media_item_get_type ())
#define DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_MEDIA_SERVER_TYPE_CHANNEL_MEDIA_ITEM, DVBMediaServerChannelMediaItem))
#define DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_MEDIA_SERVER_TYPE_CHANNEL_MEDIA_ITEM, DVBMediaServerChannelMediaItemClass))
#define DVB_MEDIA_SERVER_IS_CHANNEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_MEDIA_SERVER_TYPE_CHANNEL_MEDIA_ITEM))
#define DVB_MEDIA_SERVER_IS_CHANNEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_MEDIA_SERVER_TYPE_CHANNEL_MEDIA_ITEM))
#define DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_MEDIA_SERVER_TYPE_CHANNEL_MEDIA_ITEM, DVBMediaServerChannelMediaItemClass))

typedef struct _DVBMediaServerChannelMediaItem DVBMediaServerChannelMediaItem;
typedef struct _DVBMediaServerChannelMediaItemClass DVBMediaServerChannelMediaItemClass;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define TYPE_MEDIA_ITEM1 (media_item1_get_type ())
#define MEDIA_ITEM1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_ITEM1, MediaItem1))
#define IS_MEDIA_ITEM1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_ITEM1))
#define MEDIA_ITEM1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_ITEM1, MediaItem1Iface))

typedef struct _MediaItem1 MediaItem1;
typedef struct _MediaItem1Iface MediaItem1Iface;
typedef struct _DVBMediaServerChannelMediaItemPrivate DVBMediaServerChannelMediaItemPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _MediaContainer1Iface {
	GTypeInterface parent_iface;
	char** (*get_Items) (MediaContainer1* self, int* result_length1);
	guint (*get_ItemCount) (MediaContainer1* self);
	char** (*get_Containers) (MediaContainer1* self, int* result_length1);
	guint (*get_ContainerCount) (MediaContainer1* self);
};

struct _MediaObject1Iface {
	GTypeInterface parent_iface;
	char* (*get_Parent) (MediaObject1* self);
	gchar* (*get_DisplayName) (MediaObject1* self);
};

struct _DVBMediaServerDeviceGroupsMediaContainer {
	GObject parent_instance;
	DVBMediaServerDeviceGroupsMediaContainerPrivate * priv;
};

struct _DVBMediaServerDeviceGroupsMediaContainerClass {
	GObjectClass parent_class;
};

struct _DVBMediaServerDeviceGroupsMediaContainerPrivate {
	GeeHashMap* containers;
	char* path;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _DVBChannelGroupInfo {
	gint id;
	gchar* name;
};

struct _DVBIDBusManagerIface {
	GTypeInterface parent_iface;
	gboolean (*GetScannerForDevice) (DVBIDBusManager* self, guint adapter, guint frontend, char** opath, gchar** dbusiface, GError** error);
	char** (*GetRegisteredDeviceGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*GetDeviceGroup) (DVBIDBusManager* self, guint group_id, char** opath, GError** error);
	gboolean (*AddDeviceToNewGroup) (DVBIDBusManager* self, guint adapter, guint frontend, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error);
	gboolean (*GetNameOfRegisteredDevice) (DVBIDBusManager* self, guint adapter, guint frontend, gchar** name, GError** error);
	gint (*GetDeviceGroupSize) (DVBIDBusManager* self, GError** error);
	DVBChannelGroupInfo* (*GetChannelGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*AddChannelGroup) (DVBIDBusManager* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*RemoveChannelGroup) (DVBIDBusManager* self, gint channel_group_id, GError** error);
	GHashTable** (*GetDevices) (DVBIDBusManager* self, int* result_length1, GError** error);
};

struct _DVBMediaServerChannelsMediaContainer {
	GObject parent_instance;
	DVBMediaServerChannelsMediaContainerPrivate * priv;
	char* parent;
};

struct _DVBMediaServerChannelsMediaContainerClass {
	GObjectClass parent_class;
};

struct _DVBMediaServerChannelsMediaContainerPrivate {
	DVBDeviceGroup* device_group;
	GeeHashMap* items;
};

struct _MediaItem1Iface {
	GTypeInterface parent_iface;
	gchar** (*get_URLs) (MediaItem1* self, int* result_length1);
	gchar* (*get_MIMEType) (MediaItem1* self);
	gchar* (*get_Type) (MediaItem1* self);
};

struct _DVBMediaServerChannelMediaItem {
	GObject parent_instance;
	DVBMediaServerChannelMediaItemPrivate * priv;
};

struct _DVBMediaServerChannelMediaItemClass {
	GObjectClass parent_class;
};

struct _DVBMediaServerChannelMediaItemPrivate {
	DVBChannel* channel;
	char* parent;
};


static gpointer dvb_media_server_device_groups_media_container_parent_class = NULL;
static MediaContainer1Iface* dvb_media_server_device_groups_media_container_media_container1_parent_iface = NULL;
static MediaObject1Iface* dvb_media_server_device_groups_media_container_media_object1_parent_iface = NULL;
static gpointer dvb_media_server_channels_media_container_parent_class = NULL;
static MediaContainer1Iface* dvb_media_server_channels_media_container_media_container1_parent_iface = NULL;
static MediaObject1Iface* dvb_media_server_channels_media_container_media_object1_parent_iface = NULL;
static gpointer dvb_media_server_channel_media_item_parent_class = NULL;
static MediaItem1Iface* dvb_media_server_channel_media_item_media_item1_parent_iface = NULL;
static MediaObject1Iface* dvb_media_server_channel_media_item_media_object1_parent_iface = NULL;
extern DVBMediaServerDeviceGroupsMediaContainer* dvb_media_server_root_container;
DVBMediaServerDeviceGroupsMediaContainer* dvb_media_server_root_container = NULL;

#define DVB_MEDIA_SERVER_SERVICE_NAME "org.gnome.UPnP.MediaServer1.DVBDaemon"
#define DVB_MEDIA_SERVER_ROOT_PATH "/org/gnome/UPnP/MediaServer1/DVBDaemon"
#define DVB_MEDIA_SERVER_GROUP_PATH "/org/gnome/UPnP/MediaServer1/DVBDaemon/Group%u"
#define DVB_MEDIA_SERVER_CHANNEL_PATH DVB_MEDIA_SERVER_GROUP_PATH "/Channel%u"
GType media_container1_get_type (void) G_GNUC_CONST;
MediaContainer1* media_container1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType media_object1_get_type (void) G_GNUC_CONST;
MediaObject1* media_object1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType dvb_media_server_device_groups_media_container_get_type (void) G_GNUC_CONST;
GType dvb_media_server_channels_media_container_get_type (void) G_GNUC_CONST;
#define DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_MEDIA_SERVER_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER, DVBMediaServerDeviceGroupsMediaContainerPrivate))
enum  {
	DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_DUMMY_PROPERTY,
	DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_PARENT,
	DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_DISPLAY_NAME,
	DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_ITEM_COUNT,
	DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_CONTAINER_COUNT
};
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void dvb_media_server_device_groups_media_container_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_media_server_device_groups_media_container_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_media_server_device_groups_media_container_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_media_server_device_groups_media_container_introspect (DVBMediaServerDeviceGroupsMediaContainer* self, DBusConnection* connection, DBusMessage* message);
void dvb_media_server_device_groups_media_container_create_container_services (DVBMediaServerDeviceGroupsMediaContainer* self);
GType dvb_manager_get_type (void) G_GNUC_CONST;
DVBManager* dvb_manager_get_instance (void);
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GeeCollection* dvb_manager_get_device_groups (DVBManager* self);
static void dvb_media_server_device_groups_media_container_create_service (DVBMediaServerDeviceGroupsMediaContainer* self, DVBDeviceGroup* devgroup);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
DBusGConnection* dvb_utils_get_dbus_connection (void);
DVBMediaServerChannelsMediaContainer* dvb_media_server_channels_media_container_new (DVBDeviceGroup* devgroup, const char* parent);
DVBMediaServerChannelsMediaContainer* dvb_media_server_channels_media_container_construct (GType object_type, DVBDeviceGroup* devgroup, const char* parent);
gchar* dvb_media_server_channels_media_container_get_Path (DVBMediaServerChannelsMediaContainer* self);
void dvb_media_server_channels_media_container_create_item_services (DVBMediaServerChannelsMediaContainer* self);
static void dvb_media_server_device_groups_media_container_on_device_added (DVBMediaServerDeviceGroupsMediaContainer* self, guint group_id);
DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id);
static void dvb_media_server_device_groups_media_container_on_device_removed (DVBMediaServerDeviceGroupsMediaContainer* self, guint group_id);
DVBMediaServerDeviceGroupsMediaContainer* dvb_media_server_device_groups_media_container_new (void);
DVBMediaServerDeviceGroupsMediaContainer* dvb_media_server_device_groups_media_container_construct (GType object_type);
static GObject * dvb_media_server_device_groups_media_container_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
DVBIDBusManager* dvb_id_bus_manager_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType dvb_channel_group_info_get_type (void) G_GNUC_CONST;
DVBChannelGroupInfo* dvb_channel_group_info_dup (const DVBChannelGroupInfo* self);
void dvb_channel_group_info_free (DVBChannelGroupInfo* self);
void dvb_channel_group_info_copy (const DVBChannelGroupInfo* self, DVBChannelGroupInfo* dest);
void dvb_channel_group_info_destroy (DVBChannelGroupInfo* self);
GType dvb_id_bus_manager_get_type (void) G_GNUC_CONST;
static void _dvb_media_server_device_groups_media_container_on_device_added_dvb_id_bus_manager_group_added (DVBIDBusManager* _sender, guint group_id, gpointer self);
static void _dvb_media_server_device_groups_media_container_on_device_removed_dvb_id_bus_manager_group_removed (DVBIDBusManager* _sender, guint group_id, gpointer self);
static void dvb_media_server_device_groups_media_container_finalize (GObject* obj);
char* media_object1_get_Parent (MediaObject1* self);
gchar* media_object1_get_DisplayName (MediaObject1* self);
guint media_container1_get_ItemCount (MediaContainer1* self);
guint media_container1_get_ContainerCount (MediaContainer1* self);
static void _vala_dvb_media_server_device_groups_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType dvb_media_server_channel_media_item_get_type (void) G_GNUC_CONST;
#define DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_MEDIA_SERVER_TYPE_CHANNELS_MEDIA_CONTAINER, DVBMediaServerChannelsMediaContainerPrivate))
enum  {
	DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_DUMMY_PROPERTY,
	DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_PATH,
	DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_PARENT,
	DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_DISPLAY_NAME,
	DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_ITEM_COUNT,
	DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_CONTAINER_COUNT
};
void dvb_media_server_channels_media_container_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_media_server_channels_media_container_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_media_server_channels_media_container_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_media_server_channels_media_container_introspect (DVBMediaServerChannelsMediaContainer* self, DBusConnection* connection, DBusMessage* message);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
GType dvb_channel_get_type (void) G_GNUC_CONST;
void dvb_media_server_channels_media_container_create_service (DVBMediaServerChannelsMediaContainer* self, DVBChannel* channel);
guint dvb_channel_get_Sid (DVBChannel* self);
DVBMediaServerChannelMediaItem* dvb_media_server_channel_media_item_new (DVBChannel* channel, const char* parent);
DVBMediaServerChannelMediaItem* dvb_media_server_channel_media_item_construct (GType object_type, DVBChannel* channel, const char* parent);
gchar* dvb_media_server_channel_media_item_get_Path (DVBMediaServerChannelMediaItem* self);
const gchar* dvb_device_group_get_Name (DVBDeviceGroup* self);
static GObject * dvb_media_server_channels_media_container_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_media_server_channels_media_container_finalize (GObject* obj);
static void _vala_dvb_media_server_channels_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType media_item1_get_type (void) G_GNUC_CONST;
MediaItem1* media_item1_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
#define DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_MEDIA_SERVER_TYPE_CHANNEL_MEDIA_ITEM, DVBMediaServerChannelMediaItemPrivate))
enum  {
	DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_DUMMY_PROPERTY,
	DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_PATH,
	DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_PARENT,
	DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_DISPLAY_NAME,
	DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_UR_LS,
	DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_MIME_TYPE,
	DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_TYPE
};
void dvb_media_server_channel_media_item_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_media_server_channel_media_item_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_media_server_channel_media_item_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_media_server_channel_media_item_introspect (DVBMediaServerChannelMediaItem* self, DBusConnection* connection, DBusMessage* message);
guint dvb_channel_get_GroupId (DVBChannel* self);
const gchar* dvb_channel_get_Name (DVBChannel* self);
gchar* dvb_channel_get_URL (DVBChannel* self);
static void dvb_media_server_channel_media_item_finalize (GObject* obj);
gchar** media_item1_get_URLs (MediaItem1* self, int* result_length1);
gchar* media_item1_get_MIMEType (MediaItem1* self);
gchar* media_item1_get_Type (MediaItem1* self);
static void _vala_dvb_media_server_channel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
gboolean dvb_media_server_start_rygel_services (void);
static guint _dynamic_RequestName1 (DBusGProxy* self, const gchar* param1, guint param2, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _dvb_media_server_device_groups_media_container_dbus_path_vtable = {_dvb_media_server_device_groups_media_container_dbus_unregister, dvb_media_server_device_groups_media_container_dbus_message};
static const _DBusObjectVTable _dvb_media_server_device_groups_media_container_dbus_vtable = {dvb_media_server_device_groups_media_container_dbus_register_object};
static const DBusObjectPathVTable _dvb_media_server_channels_media_container_dbus_path_vtable = {_dvb_media_server_channels_media_container_dbus_unregister, dvb_media_server_channels_media_container_dbus_message};
static const _DBusObjectVTable _dvb_media_server_channels_media_container_dbus_vtable = {dvb_media_server_channels_media_container_dbus_register_object};
static const DBusObjectPathVTable _dvb_media_server_channel_media_item_dbus_path_vtable = {_dvb_media_server_channel_media_item_dbus_unregister, dvb_media_server_channel_media_item_dbus_message};
static const _DBusObjectVTable _dvb_media_server_channel_media_item_dbus_vtable = {dvb_media_server_channel_media_item_dbus_register_object};

static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _dvb_media_server_device_groups_media_container_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_media_server_device_groups_media_container_introspect (DVBMediaServerDeviceGroupsMediaContainer* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaContainer1\">\n  <property name=\"Items\" type=\"ao\" access=\"read\"/>\n  <property name=\"ItemCount\" type=\"u\" access=\"read\"/>\n  <property name=\"Containers\" type=\"ao\" access=\"read\"/>\n  <property name=\"ContainerCount\" type=\"u\" access=\"read\"/>\n  <signal name=\"Updated\">\n  </signal>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaObject1\">\n  <property name=\"Parent\" type=\"o\" access=\"read\"/>\n  <property name=\"DisplayName\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_media_server_device_groups_media_container_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_media_server_device_groups_media_container_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (media_container1_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (media_object1_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_media_server_device_groups_media_container_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_media_server_device_groups_media_container_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	media_container1_dbus_register_object (connection, path, object);
	media_object1_dbus_register_object (connection, path, object);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_media_server_device_groups_media_container_create_container_services (DVBMediaServerDeviceGroupsMediaContainer* self) {
	DVBManager* _tmp0_ = NULL;
	DVBManager* _tmp1_;
	DVBManager* manager;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_manager_get_instance ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	manager = _tmp1_;
	{
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _devgroup_it;
		_tmp2_ = dvb_manager_get_device_groups (manager);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_devgroup_it = (_tmp5_ = _tmp4_, _g_object_unref0 (_tmp3_), _tmp5_);
		while (TRUE) {
			gboolean _tmp6_;
			gpointer _tmp7_ = NULL;
			DVBDeviceGroup* devgroup;
			_tmp6_ = gee_iterator_next (_devgroup_it);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = gee_iterator_get (_devgroup_it);
			devgroup = (DVBDeviceGroup*) _tmp7_;
			dvb_media_server_device_groups_media_container_create_service (self, devgroup);
			_g_object_unref0 (devgroup);
		}
		_g_object_unref0 (_devgroup_it);
	}
	_g_object_unref0 (manager);
}


static void dvb_media_server_device_groups_media_container_create_service (DVBMediaServerDeviceGroupsMediaContainer* self, DVBDeviceGroup* devgroup) {
	guint _tmp0_;
	DBusGConnection* _tmp1_ = NULL;
	DBusGConnection* conn;
	DVBMediaServerChannelsMediaContainer* _tmp2_ = NULL;
	DVBMediaServerChannelsMediaContainer* devgroup_container;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devgroup != NULL);
	_tmp0_ = dvb_device_group_get_Id (devgroup);
	g_debug ("Services.vala:59: Creating container for device group %u", _tmp0_);
	_tmp1_ = dvb_utils_get_dbus_connection ();
	conn = _tmp1_;
	if (conn == NULL) {
		g_critical ("Services.vala:63: Could not get DBus connection");
		_dbus_g_connection_unref0 (conn);
		return;
	}
	_tmp2_ = dvb_media_server_channels_media_container_new (devgroup, self->priv->path);
	devgroup_container = _tmp2_;
	_tmp3_ = dvb_media_server_channels_media_container_get_Path (devgroup_container);
	_tmp4_ = _tmp3_;
	_vala_dbus_register_object (dbus_g_connection_get_connection (conn), _tmp4_, (GObject*) devgroup_container);
	_g_free0 (_tmp4_);
	dvb_media_server_channels_media_container_create_item_services (devgroup_container);
	_tmp5_ = dvb_device_group_get_Id (devgroup);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->containers, GUINT_TO_POINTER (_tmp5_), devgroup_container);
	_g_object_unref0 (devgroup_container);
	_dbus_g_connection_unref0 (conn);
}


static void dvb_media_server_device_groups_media_container_on_device_added (DVBMediaServerDeviceGroupsMediaContainer* self, guint group_id) {
	DVBManager* _tmp0_ = NULL;
	DVBManager* _tmp1_;
	DVBManager* manager;
	DVBDeviceGroup* _tmp2_ = NULL;
	DVBDeviceGroup* devgroup;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_manager_get_instance ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = dvb_manager_get_device_group_if_exists (manager, group_id);
	devgroup = _tmp2_;
	dvb_media_server_device_groups_media_container_create_service (self, devgroup);
	g_signal_emit_by_name ((MediaContainer1*) self, "updated");
	_g_object_unref0 (devgroup);
	_g_object_unref0 (manager);
}


static void dvb_media_server_device_groups_media_container_on_device_removed (DVBMediaServerDeviceGroupsMediaContainer* self, guint group_id) {
	g_return_if_fail (self != NULL);
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->containers, GUINT_TO_POINTER (group_id), NULL);
	g_signal_emit_by_name ((MediaContainer1*) self, "updated");
}


DVBMediaServerDeviceGroupsMediaContainer* dvb_media_server_device_groups_media_container_construct (GType object_type) {
	DVBMediaServerDeviceGroupsMediaContainer * self = NULL;
	self = (DVBMediaServerDeviceGroupsMediaContainer*) g_object_new (object_type, NULL);
	return self;
}


DVBMediaServerDeviceGroupsMediaContainer* dvb_media_server_device_groups_media_container_new (void) {
	return dvb_media_server_device_groups_media_container_construct (DVB_MEDIA_SERVER_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER);
}


static char* dvb_media_server_device_groups_media_container_real_get_Parent (MediaObject1* base) {
	char* result;
	DVBMediaServerDeviceGroupsMediaContainer* self;
	char* _tmp0_;
	self = (DVBMediaServerDeviceGroupsMediaContainer*) base;
	_tmp0_ = g_strdup (self->priv->path);
	result = _tmp0_;
	return result;
}


static gchar* dvb_media_server_device_groups_media_container_real_get_DisplayName (MediaObject1* base) {
	gchar* result;
	DVBMediaServerDeviceGroupsMediaContainer* self;
	gchar* _tmp0_;
	self = (DVBMediaServerDeviceGroupsMediaContainer*) base;
	_tmp0_ = g_strdup ("@REALNAME@'s TV on @HOSTNAME@");
	result = _tmp0_;
	return result;
}


static char** dvb_media_server_device_groups_media_container_real_get_Items (MediaContainer1* base, int* result_length1) {
	char** result;
	DVBMediaServerDeviceGroupsMediaContainer* self;
	char** _tmp0_ = NULL;
	char** _tmp1_;
	self = (DVBMediaServerDeviceGroupsMediaContainer*) base;
	_tmp0_ = g_new0 (char*, 0 + 1);
	_tmp1_ = _tmp0_;
	*result_length1 = 0;
	result = _tmp1_;
	return result;
}


static guint dvb_media_server_device_groups_media_container_real_get_ItemCount (MediaContainer1* base) {
	guint result;
	DVBMediaServerDeviceGroupsMediaContainer* self;
	self = (DVBMediaServerDeviceGroupsMediaContainer*) base;
	result = (guint) 0;
	return result;
}


static char** dvb_media_server_device_groups_media_container_real_get_Containers (MediaContainer1* base, int* result_length1) {
	char** result;
	DVBMediaServerDeviceGroupsMediaContainer* self;
	gint _tmp0_;
	char** _tmp1_ = NULL;
	gint paths_length1;
	gint _paths_size_;
	char** _tmp2_;
	char** paths;
	gint i;
	char** _tmp13_;
	self = (DVBMediaServerDeviceGroupsMediaContainer*) base;
	_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->containers);
	_tmp1_ = g_new0 (char*, _tmp0_ + 1);
	_tmp2_ = _tmp1_;
	paths_length1 = _tmp0_;
	_paths_size_ = paths_length1;
	paths = _tmp2_;
	i = 0;
	{
		GeeCollection* _tmp3_ = NULL;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _container_it;
		_tmp3_ = gee_map_get_values ((GeeMap*) self->priv->containers);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_container_it = (_tmp6_ = _tmp5_, _g_object_unref0 (_tmp4_), _tmp6_);
		while (TRUE) {
			gboolean _tmp7_;
			gpointer _tmp8_ = NULL;
			DVBMediaServerChannelsMediaContainer* container;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			char* _tmp11_ = NULL;
			char* _tmp12_;
			_tmp7_ = gee_iterator_next (_container_it);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = gee_iterator_get (_container_it);
			container = (DVBMediaServerChannelsMediaContainer*) _tmp8_;
			_tmp9_ = dvb_media_server_channels_media_container_get_Path (container);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup (_tmp10_);
			_tmp12_ = _tmp11_;
			_g_free0 (paths[i]);
			paths[i] = _tmp12_;
			_g_free0 (_tmp10_);
			i++;
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_it);
	}
	_tmp13_ = paths;
	*result_length1 = paths_length1;
	result = _tmp13_;
	return result;
}


static guint dvb_media_server_device_groups_media_container_real_get_ContainerCount (MediaContainer1* base) {
	guint result;
	DVBMediaServerDeviceGroupsMediaContainer* self;
	gint _tmp0_;
	self = (DVBMediaServerDeviceGroupsMediaContainer*) base;
	_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->containers);
	result = (guint) _tmp0_;
	return result;
}


static void _dvb_media_server_device_groups_media_container_on_device_added_dvb_id_bus_manager_group_added (DVBIDBusManager* _sender, guint group_id, gpointer self) {
	dvb_media_server_device_groups_media_container_on_device_added (self, group_id);
}


static void _dvb_media_server_device_groups_media_container_on_device_removed_dvb_id_bus_manager_group_removed (DVBIDBusManager* _sender, guint group_id, gpointer self) {
	dvb_media_server_device_groups_media_container_on_device_removed (self, group_id);
}


static GObject * dvb_media_server_device_groups_media_container_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBMediaServerDeviceGroupsMediaContainer * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_;
	DVBManager* _tmp2_ = NULL;
	DVBManager* _tmp3_;
	DVBManager* manager;
	char* _tmp4_ = NULL;
	char* _tmp5_;
	parent_class = G_OBJECT_CLASS (dvb_media_server_device_groups_media_container_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_MEDIA_SERVER_TYPE_CHANNELS_MEDIA_CONTAINER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->containers);
	self->priv->containers = _tmp1_;
	_tmp2_ = dvb_manager_get_instance ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	manager = _tmp3_;
	g_signal_connect_object ((DVBIDBusManager*) manager, "group-added", (GCallback) _dvb_media_server_device_groups_media_container_on_device_added_dvb_id_bus_manager_group_added, self, 0);
	g_signal_connect_object ((DVBIDBusManager*) manager, "group-removed", (GCallback) _dvb_media_server_device_groups_media_container_on_device_removed_dvb_id_bus_manager_group_removed, self, 0);
	_tmp4_ = g_strdup (DVB_MEDIA_SERVER_ROOT_PATH);
	_tmp5_ = _tmp4_;
	_g_free0 (self->priv->path);
	self->priv->path = _tmp5_;
	_g_object_unref0 (manager);
	return obj;
}


static void dvb_media_server_device_groups_media_container_class_init (DVBMediaServerDeviceGroupsMediaContainerClass * klass) {
	dvb_media_server_device_groups_media_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBMediaServerDeviceGroupsMediaContainerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_media_server_device_groups_media_container_get_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_media_server_device_groups_media_container_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_media_server_device_groups_media_container_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_PARENT, "Parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_DISPLAY_NAME, "DisplayName");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_ITEM_COUNT, "ItemCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_CONTAINER_COUNT, "ContainerCount");
	g_type_set_qdata (DVB_MEDIA_SERVER_TYPE_DEVICE_GROUPS_MEDIA_CONTAINER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_media_server_device_groups_media_container_dbus_vtable));
}


static void dvb_media_server_device_groups_media_container_media_container1_interface_init (MediaContainer1Iface * iface) {
	dvb_media_server_device_groups_media_container_media_container1_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Items = dvb_media_server_device_groups_media_container_real_get_Items;
	iface->get_ItemCount = dvb_media_server_device_groups_media_container_real_get_ItemCount;
	iface->get_Containers = dvb_media_server_device_groups_media_container_real_get_Containers;
	iface->get_ContainerCount = dvb_media_server_device_groups_media_container_real_get_ContainerCount;
}


static void dvb_media_server_device_groups_media_container_media_object1_interface_init (MediaObject1Iface * iface) {
	dvb_media_server_device_groups_media_container_media_object1_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Parent = dvb_media_server_device_groups_media_container_real_get_Parent;
	iface->get_DisplayName = dvb_media_server_device_groups_media_container_real_get_DisplayName;
}


static void dvb_media_server_device_groups_media_container_instance_init (DVBMediaServerDeviceGroupsMediaContainer * self) {
	self->priv = DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_GET_PRIVATE (self);
}


static void dvb_media_server_device_groups_media_container_finalize (GObject* obj) {
	DVBMediaServerDeviceGroupsMediaContainer * self;
	self = DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER (obj);
	_g_object_unref0 (self->priv->containers);
	_g_free0 (self->priv->path);
	G_OBJECT_CLASS (dvb_media_server_device_groups_media_container_parent_class)->finalize (obj);
}


/**
     * Holds all device groups
     *
     * It only contains containers only and no items
     */
GType dvb_media_server_device_groups_media_container_get_type (void) {
	static volatile gsize dvb_media_server_device_groups_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_media_server_device_groups_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaServerDeviceGroupsMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_server_device_groups_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaServerDeviceGroupsMediaContainer), 0, (GInstanceInitFunc) dvb_media_server_device_groups_media_container_instance_init, NULL };
		static const GInterfaceInfo media_container1_info = { (GInterfaceInitFunc) dvb_media_server_device_groups_media_container_media_container1_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo media_object1_info = { (GInterfaceInitFunc) dvb_media_server_device_groups_media_container_media_object1_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_media_server_device_groups_media_container_type_id;
		dvb_media_server_device_groups_media_container_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBMediaServerDeviceGroupsMediaContainer", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_media_server_device_groups_media_container_type_id, TYPE_MEDIA_CONTAINER1, &media_container1_info);
		g_type_add_interface_static (dvb_media_server_device_groups_media_container_type_id, TYPE_MEDIA_OBJECT1, &media_object1_info);
		g_once_init_leave (&dvb_media_server_device_groups_media_container_type_id__volatile, dvb_media_server_device_groups_media_container_type_id);
	}
	return dvb_media_server_device_groups_media_container_type_id__volatile;
}


static void _vala_dvb_media_server_device_groups_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBMediaServerDeviceGroupsMediaContainer * self;
	self = DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER (object);
	switch (property_id) {
		case DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_PARENT:
		g_value_take_string (value, media_object1_get_Parent ((MediaObject1*) self));
		break;
		case DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_DISPLAY_NAME:
		g_value_take_string (value, media_object1_get_DisplayName ((MediaObject1*) self));
		break;
		case DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_ITEM_COUNT:
		g_value_set_uint (value, media_container1_get_ItemCount ((MediaContainer1*) self));
		break;
		case DVB_MEDIA_SERVER_DEVICE_GROUPS_MEDIA_CONTAINER_CONTAINER_COUNT:
		g_value_set_uint (value, media_container1_get_ContainerCount ((MediaContainer1*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void _dvb_media_server_channels_media_container_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_media_server_channels_media_container_introspect (DVBMediaServerChannelsMediaContainer* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaContainer1\">\n  <property name=\"Items\" type=\"ao\" access=\"read\"/>\n  <property name=\"ItemCount\" type=\"u\" access=\"read\"/>\n  <property name=\"Containers\" type=\"ao\" access=\"read\"/>\n  <property name=\"ContainerCount\" type=\"u\" access=\"read\"/>\n  <signal name=\"Updated\">\n  </signal>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaObject1\">\n  <property name=\"Parent\" type=\"o\" access=\"read\"/>\n  <property name=\"DisplayName\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_media_server_channels_media_container_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_media_server_channels_media_container_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (media_container1_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (media_object1_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_media_server_channels_media_container_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_media_server_channels_media_container_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	media_container1_dbus_register_object (connection, path, object);
	media_object1_dbus_register_object (connection, path, object);
}


DVBMediaServerChannelsMediaContainer* dvb_media_server_channels_media_container_construct (GType object_type, DVBDeviceGroup* devgroup, const char* parent) {
	DVBMediaServerChannelsMediaContainer * self = NULL;
	DVBDeviceGroup* _tmp0_;
	DVBDeviceGroup* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	g_return_val_if_fail (devgroup != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (DVBMediaServerChannelsMediaContainer*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (devgroup);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->device_group);
	self->priv->device_group = _tmp1_;
	_tmp2_ = g_strdup (parent);
	_tmp3_ = _tmp2_;
	_g_free0 (self->parent);
	self->parent = _tmp3_;
	return self;
}


DVBMediaServerChannelsMediaContainer* dvb_media_server_channels_media_container_new (DVBDeviceGroup* devgroup, const char* parent) {
	return dvb_media_server_channels_media_container_construct (DVB_MEDIA_SERVER_TYPE_CHANNELS_MEDIA_CONTAINER, devgroup, parent);
}


void dvb_media_server_channels_media_container_create_item_services (DVBMediaServerChannelsMediaContainer* self) {
	g_return_if_fail (self != NULL);
	{
		DVBChannelList* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _channel_it;
		_tmp0_ = dvb_device_group_get_Channels (self->priv->device_group);
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_channel_it = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			gpointer _tmp3_ = NULL;
			DVBChannel* channel;
			_tmp2_ = gee_iterator_next (_channel_it);
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = gee_iterator_get (_channel_it);
			channel = (DVBChannel*) _tmp3_;
			dvb_media_server_channels_media_container_create_service (self, channel);
			_g_object_unref0 (channel);
		}
		_g_object_unref0 (_channel_it);
	}
}


void dvb_media_server_channels_media_container_create_service (DVBMediaServerChannelsMediaContainer* self, DVBChannel* channel) {
	guint _tmp0_;
	DBusGConnection* _tmp1_ = NULL;
	DBusGConnection* conn;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	char* _tmp4_ = NULL;
	char* _tmp5_;
	DVBMediaServerChannelMediaItem* _tmp6_ = NULL;
	DVBMediaServerChannelMediaItem* _tmp7_;
	DVBMediaServerChannelMediaItem* channel_item;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	guint _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = dvb_channel_get_Sid (channel);
	g_debug ("Services.vala:166: Creating container for channel %u", _tmp0_);
	_tmp1_ = dvb_utils_get_dbus_connection ();
	conn = _tmp1_;
	if (conn == NULL) {
		g_critical ("Services.vala:170: Could not get DBus connection");
		_dbus_g_connection_unref0 (conn);
		return;
	}
	_tmp2_ = dvb_media_server_channels_media_container_get_Path (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = dvb_media_server_channel_media_item_new (channel, _tmp5_);
	channel_item = (_tmp7_ = _tmp6_, _g_free0 (_tmp5_), _g_free0 (_tmp3_), _tmp7_);
	_tmp8_ = dvb_media_server_channel_media_item_get_Path (channel_item);
	_tmp9_ = _tmp8_;
	_vala_dbus_register_object (dbus_g_connection_get_connection (conn), _tmp9_, (GObject*) channel_item);
	_g_free0 (_tmp9_);
	_tmp10_ = dvb_channel_get_Sid (channel);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->items, GUINT_TO_POINTER (_tmp10_), channel_item);
	_g_object_unref0 (channel_item);
	_dbus_g_connection_unref0 (conn);
}


gchar* dvb_media_server_channels_media_container_get_Path (DVBMediaServerChannelsMediaContainer* self) {
	gchar* result;
	guint _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_device_group_get_Id (self->priv->device_group);
	_tmp1_ = g_strdup_printf (DVB_MEDIA_SERVER_GROUP_PATH, _tmp0_);
	result = _tmp1_;
	return result;
}


static char* dvb_media_server_channels_media_container_real_get_Parent (MediaObject1* base) {
	char* result;
	DVBMediaServerChannelsMediaContainer* self;
	char* _tmp0_;
	self = (DVBMediaServerChannelsMediaContainer*) base;
	_tmp0_ = g_strdup (self->parent);
	result = _tmp0_;
	return result;
}


static gchar* dvb_media_server_channels_media_container_real_get_DisplayName (MediaObject1* base) {
	gchar* result;
	DVBMediaServerChannelsMediaContainer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	self = (DVBMediaServerChannelsMediaContainer*) base;
	_tmp0_ = dvb_device_group_get_Name (self->priv->device_group);
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static char** dvb_media_server_channels_media_container_real_get_Items (MediaContainer1* base, int* result_length1) {
	char** result;
	DVBMediaServerChannelsMediaContainer* self;
	gint _tmp0_;
	char** _tmp1_ = NULL;
	gint paths_length1;
	gint _paths_size_;
	char** _tmp2_;
	char** paths;
	gint i;
	char** _tmp13_;
	self = (DVBMediaServerChannelsMediaContainer*) base;
	_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->items);
	_tmp1_ = g_new0 (char*, _tmp0_ + 1);
	_tmp2_ = _tmp1_;
	paths_length1 = _tmp0_;
	_paths_size_ = paths_length1;
	paths = _tmp2_;
	i = 0;
	{
		GeeCollection* _tmp3_ = NULL;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _item_it;
		_tmp3_ = gee_map_get_values ((GeeMap*) self->priv->items);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_item_it = (_tmp6_ = _tmp5_, _g_object_unref0 (_tmp4_), _tmp6_);
		while (TRUE) {
			gboolean _tmp7_;
			gpointer _tmp8_ = NULL;
			DVBMediaServerChannelMediaItem* item;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			char* _tmp11_ = NULL;
			char* _tmp12_;
			_tmp7_ = gee_iterator_next (_item_it);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = gee_iterator_get (_item_it);
			item = (DVBMediaServerChannelMediaItem*) _tmp8_;
			_tmp9_ = dvb_media_server_channel_media_item_get_Path (item);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup (_tmp10_);
			_tmp12_ = _tmp11_;
			_g_free0 (paths[i]);
			paths[i] = _tmp12_;
			_g_free0 (_tmp10_);
			i++;
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	_tmp13_ = paths;
	*result_length1 = paths_length1;
	result = _tmp13_;
	return result;
}


static guint dvb_media_server_channels_media_container_real_get_ItemCount (MediaContainer1* base) {
	guint result;
	DVBMediaServerChannelsMediaContainer* self;
	gint _tmp0_;
	self = (DVBMediaServerChannelsMediaContainer*) base;
	_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->items);
	result = (guint) _tmp0_;
	return result;
}


static char** dvb_media_server_channels_media_container_real_get_Containers (MediaContainer1* base, int* result_length1) {
	char** result;
	DVBMediaServerChannelsMediaContainer* self;
	char** _tmp0_ = NULL;
	char** _tmp1_;
	self = (DVBMediaServerChannelsMediaContainer*) base;
	_tmp0_ = g_new0 (char*, 0 + 1);
	_tmp1_ = _tmp0_;
	*result_length1 = 0;
	result = _tmp1_;
	return result;
}


static guint dvb_media_server_channels_media_container_real_get_ContainerCount (MediaContainer1* base) {
	guint result;
	DVBMediaServerChannelsMediaContainer* self;
	self = (DVBMediaServerChannelsMediaContainer*) base;
	result = (guint) 0;
	return result;
}


static GObject * dvb_media_server_channels_media_container_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBMediaServerChannelsMediaContainer * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_;
	parent_class = G_OBJECT_CLASS (dvb_media_server_channels_media_container_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_MEDIA_SERVER_TYPE_CHANNEL_MEDIA_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->items);
	self->priv->items = _tmp1_;
	return obj;
}


static void dvb_media_server_channels_media_container_class_init (DVBMediaServerChannelsMediaContainerClass * klass) {
	dvb_media_server_channels_media_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBMediaServerChannelsMediaContainerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_media_server_channels_media_container_get_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_media_server_channels_media_container_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_media_server_channels_media_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_PATH, g_param_spec_string ("Path", "Path", "Path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_PARENT, "Parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_DISPLAY_NAME, "DisplayName");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_ITEM_COUNT, "ItemCount");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_CONTAINER_COUNT, "ContainerCount");
	g_type_set_qdata (DVB_MEDIA_SERVER_TYPE_CHANNELS_MEDIA_CONTAINER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_media_server_channels_media_container_dbus_vtable));
}


static void dvb_media_server_channels_media_container_media_container1_interface_init (MediaContainer1Iface * iface) {
	dvb_media_server_channels_media_container_media_container1_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Items = dvb_media_server_channels_media_container_real_get_Items;
	iface->get_ItemCount = dvb_media_server_channels_media_container_real_get_ItemCount;
	iface->get_Containers = dvb_media_server_channels_media_container_real_get_Containers;
	iface->get_ContainerCount = dvb_media_server_channels_media_container_real_get_ContainerCount;
}


static void dvb_media_server_channels_media_container_media_object1_interface_init (MediaObject1Iface * iface) {
	dvb_media_server_channels_media_container_media_object1_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Parent = dvb_media_server_channels_media_container_real_get_Parent;
	iface->get_DisplayName = dvb_media_server_channels_media_container_real_get_DisplayName;
}


static void dvb_media_server_channels_media_container_instance_init (DVBMediaServerChannelsMediaContainer * self) {
	self->priv = DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_GET_PRIVATE (self);
}


static void dvb_media_server_channels_media_container_finalize (GObject* obj) {
	DVBMediaServerChannelsMediaContainer * self;
	self = DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER (obj);
	_g_free0 (self->parent);
	_g_object_unref0 (self->priv->device_group);
	_g_object_unref0 (self->priv->items);
	G_OBJECT_CLASS (dvb_media_server_channels_media_container_parent_class)->finalize (obj);
}


/**
     * Holds a list of channels for a single device group
     *
     * It only contains items only and no containers
     */
GType dvb_media_server_channels_media_container_get_type (void) {
	static volatile gsize dvb_media_server_channels_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_media_server_channels_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaServerChannelsMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_server_channels_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaServerChannelsMediaContainer), 0, (GInstanceInitFunc) dvb_media_server_channels_media_container_instance_init, NULL };
		static const GInterfaceInfo media_container1_info = { (GInterfaceInitFunc) dvb_media_server_channels_media_container_media_container1_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo media_object1_info = { (GInterfaceInitFunc) dvb_media_server_channels_media_container_media_object1_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_media_server_channels_media_container_type_id;
		dvb_media_server_channels_media_container_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBMediaServerChannelsMediaContainer", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_media_server_channels_media_container_type_id, TYPE_MEDIA_CONTAINER1, &media_container1_info);
		g_type_add_interface_static (dvb_media_server_channels_media_container_type_id, TYPE_MEDIA_OBJECT1, &media_object1_info);
		g_once_init_leave (&dvb_media_server_channels_media_container_type_id__volatile, dvb_media_server_channels_media_container_type_id);
	}
	return dvb_media_server_channels_media_container_type_id__volatile;
}


static void _vala_dvb_media_server_channels_media_container_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBMediaServerChannelsMediaContainer * self;
	self = DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER (object);
	switch (property_id) {
		case DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_PATH:
		g_value_take_string (value, dvb_media_server_channels_media_container_get_Path (self));
		break;
		case DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_PARENT:
		g_value_take_string (value, media_object1_get_Parent ((MediaObject1*) self));
		break;
		case DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_DISPLAY_NAME:
		g_value_take_string (value, media_object1_get_DisplayName ((MediaObject1*) self));
		break;
		case DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_ITEM_COUNT:
		g_value_set_uint (value, media_container1_get_ItemCount ((MediaContainer1*) self));
		break;
		case DVB_MEDIA_SERVER_CHANNELS_MEDIA_CONTAINER_CONTAINER_COUNT:
		g_value_set_uint (value, media_container1_get_ContainerCount ((MediaContainer1*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void _dvb_media_server_channel_media_item_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_media_server_channel_media_item_introspect (DVBMediaServerChannelMediaItem* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaItem1\">\n  <property name=\"URLs\" type=\"as\" access=\"read\"/>\n  <property name=\"MIMEType\" type=\"s\" access=\"read\"/>\n  <property name=\"Type\" type=\"s\" access=\"read\"/>\n</interface>\n<interface name=\"org.gnome.UPnP.MediaObject1\">\n  <property name=\"Parent\" type=\"o\" access=\"read\"/>\n  <property name=\"DisplayName\" type=\"s\" access=\"read\"/>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_media_server_channel_media_item_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_media_server_channel_media_item_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (media_item1_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (media_object1_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_media_server_channel_media_item_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_media_server_channel_media_item_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	media_item1_dbus_register_object (connection, path, object);
	media_object1_dbus_register_object (connection, path, object);
}


DVBMediaServerChannelMediaItem* dvb_media_server_channel_media_item_construct (GType object_type, DVBChannel* channel, const char* parent) {
	DVBMediaServerChannelMediaItem * self = NULL;
	DVBChannel* _tmp0_;
	DVBChannel* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	g_return_val_if_fail (channel != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (DVBMediaServerChannelMediaItem*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (channel);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->channel);
	self->priv->channel = _tmp1_;
	_tmp2_ = g_strdup (parent);
	_tmp3_ = _tmp2_;
	_g_free0 (self->priv->parent);
	self->priv->parent = _tmp3_;
	return self;
}


DVBMediaServerChannelMediaItem* dvb_media_server_channel_media_item_new (DVBChannel* channel, const char* parent) {
	return dvb_media_server_channel_media_item_construct (DVB_MEDIA_SERVER_TYPE_CHANNEL_MEDIA_ITEM, channel, parent);
}


gchar* dvb_media_server_channel_media_item_get_Path (DVBMediaServerChannelMediaItem* self) {
	gchar* result;
	guint _tmp0_;
	guint _tmp1_;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_channel_get_GroupId (self->priv->channel);
	_tmp1_ = dvb_channel_get_Sid (self->priv->channel);
	_tmp2_ = g_strdup_printf (DVB_MEDIA_SERVER_CHANNEL_PATH, _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static char* dvb_media_server_channel_media_item_real_get_Parent (MediaObject1* base) {
	char* result;
	DVBMediaServerChannelMediaItem* self;
	char* _tmp0_;
	self = (DVBMediaServerChannelMediaItem*) base;
	_tmp0_ = g_strdup (self->priv->parent);
	result = _tmp0_;
	return result;
}


static gchar* dvb_media_server_channel_media_item_real_get_DisplayName (MediaObject1* base) {
	gchar* result;
	DVBMediaServerChannelMediaItem* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	self = (DVBMediaServerChannelMediaItem*) base;
	_tmp0_ = dvb_channel_get_Name (self->priv->channel);
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gchar** dvb_media_server_channel_media_item_real_get_URLs (MediaItem1* base, int* result_length1) {
	gchar** result;
	DVBMediaServerChannelMediaItem* self;
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	self = (DVBMediaServerChannelMediaItem*) base;
	_tmp0_ = dvb_channel_get_URL (self->priv->channel);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	*result_length1 = 1;
	result = _tmp2_;
	return result;
}


static gchar* dvb_media_server_channel_media_item_real_get_MIMEType (MediaItem1* base) {
	gchar* result;
	DVBMediaServerChannelMediaItem* self;
	gchar* _tmp0_;
	self = (DVBMediaServerChannelMediaItem*) base;
	_tmp0_ = g_strdup ("video/mpeg");
	result = _tmp0_;
	return result;
}


static gchar* dvb_media_server_channel_media_item_real_get_Type (MediaItem1* base) {
	gchar* result;
	DVBMediaServerChannelMediaItem* self;
	gchar* _tmp0_;
	self = (DVBMediaServerChannelMediaItem*) base;
	_tmp0_ = g_strdup ("video");
	result = _tmp0_;
	return result;
}


static void dvb_media_server_channel_media_item_class_init (DVBMediaServerChannelMediaItemClass * klass) {
	dvb_media_server_channel_media_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBMediaServerChannelMediaItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_media_server_channel_media_item_get_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_media_server_channel_media_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_PATH, g_param_spec_string ("Path", "Path", "Path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_PARENT, "Parent");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_DISPLAY_NAME, "DisplayName");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_UR_LS, "URLs");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_MIME_TYPE, "MIMEType");
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_TYPE, "Type");
	g_type_set_qdata (DVB_MEDIA_SERVER_TYPE_CHANNEL_MEDIA_ITEM, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_media_server_channel_media_item_dbus_vtable));
}


static void dvb_media_server_channel_media_item_media_item1_interface_init (MediaItem1Iface * iface) {
	dvb_media_server_channel_media_item_media_item1_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_URLs = dvb_media_server_channel_media_item_real_get_URLs;
	iface->get_MIMEType = dvb_media_server_channel_media_item_real_get_MIMEType;
	iface->get_Type = dvb_media_server_channel_media_item_real_get_Type;
}


static void dvb_media_server_channel_media_item_media_object1_interface_init (MediaObject1Iface * iface) {
	dvb_media_server_channel_media_item_media_object1_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_Parent = dvb_media_server_channel_media_item_real_get_Parent;
	iface->get_DisplayName = dvb_media_server_channel_media_item_real_get_DisplayName;
}


static void dvb_media_server_channel_media_item_instance_init (DVBMediaServerChannelMediaItem * self) {
	self->priv = DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_GET_PRIVATE (self);
}


static void dvb_media_server_channel_media_item_finalize (GObject* obj) {
	DVBMediaServerChannelMediaItem * self;
	self = DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM (obj);
	_g_object_unref0 (self->priv->channel);
	_g_free0 (self->priv->parent);
	G_OBJECT_CLASS (dvb_media_server_channel_media_item_parent_class)->finalize (obj);
}


/**
     * Holds a single channel
     */
GType dvb_media_server_channel_media_item_get_type (void) {
	static volatile gsize dvb_media_server_channel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_media_server_channel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBMediaServerChannelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_media_server_channel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBMediaServerChannelMediaItem), 0, (GInstanceInitFunc) dvb_media_server_channel_media_item_instance_init, NULL };
		static const GInterfaceInfo media_item1_info = { (GInterfaceInitFunc) dvb_media_server_channel_media_item_media_item1_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo media_object1_info = { (GInterfaceInitFunc) dvb_media_server_channel_media_item_media_object1_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_media_server_channel_media_item_type_id;
		dvb_media_server_channel_media_item_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBMediaServerChannelMediaItem", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_media_server_channel_media_item_type_id, TYPE_MEDIA_ITEM1, &media_item1_info);
		g_type_add_interface_static (dvb_media_server_channel_media_item_type_id, TYPE_MEDIA_OBJECT1, &media_object1_info);
		g_once_init_leave (&dvb_media_server_channel_media_item_type_id__volatile, dvb_media_server_channel_media_item_type_id);
	}
	return dvb_media_server_channel_media_item_type_id__volatile;
}


static void _vala_dvb_media_server_channel_media_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBMediaServerChannelMediaItem * self;
	int length;
	self = DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM (object);
	switch (property_id) {
		case DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_PATH:
		g_value_take_string (value, dvb_media_server_channel_media_item_get_Path (self));
		break;
		case DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_PARENT:
		g_value_take_string (value, media_object1_get_Parent ((MediaObject1*) self));
		break;
		case DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_DISPLAY_NAME:
		g_value_take_string (value, media_object1_get_DisplayName ((MediaObject1*) self));
		break;
		case DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_UR_LS:
		g_value_take_boxed (value, media_item1_get_URLs ((MediaItem1*) self, &length));
		break;
		case DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_MIME_TYPE:
		g_value_take_string (value, media_item1_get_MIMEType ((MediaItem1*) self));
		break;
		case DVB_MEDIA_SERVER_CHANNEL_MEDIA_ITEM_TYPE:
		g_value_take_string (value, media_item1_get_Type ((MediaItem1*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static guint _dynamic_RequestName1 (DBusGProxy* self, const gchar* param1, guint param2, GError** error) {
	guint result;
	dbus_g_proxy_call (self, "RequestName", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_INVALID, G_TYPE_UINT, &result, G_TYPE_INVALID);
	if (*error) {
		return 0U;
	}
	return result;
}


gboolean dvb_media_server_start_rygel_services (void) {
	gboolean result = FALSE;
	DBusGConnection* _tmp0_ = NULL;
	DBusGConnection* conn;
	DBusGProxy* _tmp1_ = NULL;
	DBusGProxy* bus;
	guint _tmp2_;
	guint request_name_result;
	GError * _inner_error_ = NULL;
	_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	conn = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch190_g_error;
	}
	_tmp1_ = dbus_g_proxy_new_for_name (conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
	bus = _tmp1_;
	_tmp2_ = _dynamic_RequestName1 (bus, DVB_MEDIA_SERVER_SERVICE_NAME, (guint) 0, &_inner_error_);
	request_name_result = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (bus);
		_dbus_g_connection_unref0 (conn);
		goto __catch190_g_error;
	}
	if (request_name_result == DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER) {
		DVBMediaServerDeviceGroupsMediaContainer* _tmp3_ = NULL;
		DVBMediaServerDeviceGroupsMediaContainer* _tmp4_;
		char* _tmp5_ = NULL;
		char* _tmp6_;
		g_message ("Services.vala:291: Creating new Rygel MediaServer D-Bus service");
		_tmp3_ = dvb_media_server_device_groups_media_container_new ();
		_tmp4_ = _tmp3_;
		_g_object_unref0 (dvb_media_server_root_container);
		dvb_media_server_root_container = _tmp4_;
		dvb_media_server_device_groups_media_container_create_container_services (dvb_media_server_root_container);
		_tmp5_ = media_object1_get_Parent ((MediaObject1*) dvb_media_server_root_container);
		_tmp6_ = _tmp5_;
		_vala_dbus_register_object (dbus_g_connection_get_connection (conn), (const gchar*) _tmp6_, (GObject*) dvb_media_server_root_container);
		_g_free0 (_tmp6_);
	} else {
		g_warning ("Services.vala:300: Rygel MediaServer D-Bus service is already running");
		result = FALSE;
		_g_object_unref0 (bus);
		_dbus_g_connection_unref0 (conn);
		return result;
	}
	_g_object_unref0 (bus);
	_dbus_g_connection_unref0 (conn);
	goto __finally190;
	__catch190_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("Services.vala:305: Oops %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally190:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



