/* error.c -- error handler for noninteractive utilities
   Copyright (C) 1990, 91, 92, 93, 94 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by David MacKenzie <djm@gnu.ai.mit.edu>.  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>

#include <stdio.h>

#if HAVE_VPRINTF || HAVE_DOPRNT
# if __STDC__
#  include <stdarg.h>
#  define VA_START(args, lastarg) va_start(args, lastarg)
# else
#  include <varargs.h>
#  define VA_START(args, lastarg) va_start(args)
# endif
#else
# define va_alist a1, a2, a3, a4, a5, a6, a7, a8
# define va_dcl char *a1, *a2, *a3, *a4, *a5, *a6, *a7, *a8;
#endif

#if STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#else
void exit ();
#endif

#include "win.h"
#include "results.h"
#include "misc.h"

/* Print the program name and error message MESSAGE, which is a printf-style
   format string with optional args.
   If ERRNUM is nonzero, print its corresponding system error message.
   Exit with status STATUS if it is nonzero.  */
/* VARARGS */

extern void error(win_t *w, int status, int errnum, const char *message, ...);
void
error(win_t *w, int status, int errnum, const char *message, ...)
{
	va_list args;
	char *buf, *tmp;

	va_start(args, message);
	tmp = g_strdup_vprintf(message, args);
	va_end(args);

	if (status == 0) {
		if (errnum) {
			buf = g_strconcat(tmp, " : ", g_strerror(errnum), NULL);
			results_errors_add(w, buf);
			g_free(buf);
		} else {
			results_errors_add(w, tmp);
		}
	} else {
		cmd_err(tmp, errnum);
		if (status == -1)
			w->exit_status = -1;
	}

	g_free(tmp);
}
