/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2005 Imendio AB
 *
 * The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * Recent File Storage,
 * see http://freedesktop.org/Standards/recent-file-spec/
 *
 * This code is taken from libegg and has been adapted to the GIMP needs.
 * The original author is James Willcox <jwillcox@cs.indiana.edu>,
 * responsible for bugs in this version is Sven Neumann <sven@gimp.org>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *  lb-recent-item.h
 */

#ifndef __LB_RECENT_ITEM_H__
#define __LB_RECENT_ITEM_H__


#include <time.h>


typedef struct _LbRecentItem LbRecentItem;


LbRecentItem * lb_recent_item_new            (void);

LbRecentItem * lb_recent_item_ref            (LbRecentItem       *item);
LbRecentItem * lb_recent_item_unref          (LbRecentItem       *item);

LbRecentItem * lb_recent_item_new_from_uri   (const gchar        *uri);

gboolean       lb_recent_item_set_uri        (LbRecentItem       *item,
                                              const gchar        *uri);
const gchar  * lb_recent_item_get_uri        (const LbRecentItem *item);

gchar        * lb_recent_item_get_uri_utf8   (const LbRecentItem *item);

void           lb_recent_item_set_mime_type  (LbRecentItem       *item,
                                              const gchar        *mime);
const gchar  * lb_recent_item_get_mime_type  (const LbRecentItem *item);

void           lb_recent_item_set_timestamp  (LbRecentItem       *item,
                                              time_t              timestamp);
time_t         lb_recent_item_get_timestamp  (const LbRecentItem *item);



/* groups */
const GList  * lb_recent_item_get_groups     (const LbRecentItem *item);

gboolean       lb_recent_item_in_group       (const LbRecentItem *item,
                                              const gchar        *group_name);
void           lb_recent_item_add_group      (LbRecentItem       *item,
                                              const gchar        *group_name);
void           lb_recent_item_remove_group   (LbRecentItem       *item,
                                              const gchar        *group_name);

void           lb_recent_item_set_private    (LbRecentItem       *item,
                                              gboolean            priv);
gboolean       lb_recent_item_get_private    (const LbRecentItem *item);


#endif /* __LB_RECENT_ITEM_H__ */
