/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2005 Imendio AB
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-mime-handlers.h>
#include <libgnomeui/gnome-icon-lookup.h>
#include <gtk/gtkicontheme.h>

GList *
get_actions_for_file (const gchar      *file_uri,
		      GnomeVFSFileInfo *info)
{
	GList *applications, *list;
	
	applications = gnome_vfs_mime_get_all_applications (info->mime_type);

	for (list = applications; list != NULL; list = list->next) {
		GnomeVFSMimeApplication *application = list->data;
		const gchar *name = gnome_vfs_mime_application_get_name (application);
		const gchar *icon = gnome_vfs_mime_application_get_icon (application);
		
		g_print ("found: %s %s\n", name, icon);
	}
}

gint
main (gint argc, gchar **argv)
{
	GList *files;
	gchar *path;
	GnomeVFSFileInfo *info;
	GnomeVFSResult status;

	gtk_init (&argc, &argv);
	gnome_vfs_init ();

	if (argc < 2) {
		printf ("%s filename\n", argv[0]);
		return -1;
	}

	info = gnome_vfs_file_info_new ();
	path = g_filename_to_uri (argv[1], NULL, NULL);
	if ((status = gnome_vfs_get_file_info (path, info, 
					       GNOME_VFS_FILE_INFO_GET_MIME_TYPE)) != GNOME_VFS_OK) {
		g_printerr ("Could not open file: %s\n",
			    gnome_vfs_result_to_string (status));

		return -1;
	}

	get_actions_for_file (path, info);
	g_free (path);
}
