/* boni.c generated by valac 0.42.3, the Vala compiler
 * generated from boni.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* This is a fairly literal translation of the GPLv2+ original by*/
/* Sean MacIsaac, Ian Peters, Guillaume Béland.*/


#include <glib.h>
#include <glib-object.h>
#include <gee.h>


#define TYPE_BONUS_TYPE (bonus_type_get_type ())

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;
typedef struct _BonusPrivate BonusPrivate;
enum  {
	BONUS_0_PROPERTY,
	BONUS_NUM_PROPERTIES
};
static GParamSpec* bonus_properties[BONUS_NUM_PROPERTIES];

#define TYPE_BONI (boni_get_type ())
#define BONI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONI, Boni))
#define BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONI, BoniClass))
#define IS_BONI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONI))
#define IS_BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONI))
#define BONI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONI, BoniClass))

typedef struct _Boni Boni;
typedef struct _BoniClass BoniClass;
typedef struct _BoniPrivate BoniPrivate;
enum  {
	BONI_0_PROPERTY,
	BONI_NUM_PROPERTIES
};
static GParamSpec* boni_properties[BONI_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	BONI_BONUS_ADDED_SIGNAL,
	BONI_BONUS_REMOVED_SIGNAL,
	BONI_NUM_SIGNALS
};
static guint boni_signals[BONI_NUM_SIGNALS] = {0};

typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;

struct _Bonus {
	GObject parent_instance;
	BonusPrivate * priv;
	gint x;
	gint y;
	BonusType type;
	gboolean fake;
	gint countdown;
};

struct _BonusClass {
	GObjectClass parent_class;
};

struct _Boni {
	GObject parent_instance;
	BoniPrivate * priv;
	GeeLinkedList* bonuses;
	gint missed;
	gint numleft;
	gint numboni;
	gint numbonuses;
};

struct _BoniClass {
	GObjectClass parent_class;
};


static gpointer bonus_parent_class = NULL;
static gpointer boni_parent_class = NULL;

GType bonus_type_get_type (void) G_GNUC_CONST;
GType bonus_get_type (void) G_GNUC_CONST;
Bonus* bonus_new (gint x,
                  gint y,
                  BonusType type,
                  gboolean fake,
                  gint countdown);
Bonus* bonus_construct (GType object_type,
                        gint x,
                        gint y,
                        BonusType type,
                        gboolean fake,
                        gint countdown);
static void bonus_finalize (GObject * obj);
GType boni_get_type (void) G_GNUC_CONST;
#define BONI_MAX_BONUSES 100
#define BONI_MAX_MISSED 2
Boni* boni_new (gint numworms);
Boni* boni_construct (GType object_type,
                      gint numworms);
void boni_add_bonus (Boni* self,
                     gint* board,
                     int board_length1,
                     int board_length2,
                     gint x,
                     gint y,
                     BonusType type,
                     gboolean fake,
                     gint countdown);
void boni_remove_bonus (Boni* self,
                        gint* board,
                        int board_length1,
                        int board_length2,
                        Bonus* bonus);
#define NIBBLES_GAME_EMPTYCHAR 'a'
void boni_reset (Boni* self,
                 gint numworms);
Bonus* boni_get_bonus (Boni* self,
                       gint* board,
                       int board_length1,
                       int board_length2,
                       gint x,
                       gint y);
static void boni_finalize (GObject * obj);


GType
bonus_type_get_type (void)
{
	static volatile gsize bonus_type_type_id__volatile = 0;
	if (g_once_init_enter (&bonus_type_type_id__volatile)) {
		static const GEnumValue values[] = {{BONUS_TYPE_REGULAR, "BONUS_TYPE_REGULAR", "regular"}, {BONUS_TYPE_HALF, "BONUS_TYPE_HALF", "half"}, {BONUS_TYPE_DOUBLE, "BONUS_TYPE_DOUBLE", "double"}, {BONUS_TYPE_LIFE, "BONUS_TYPE_LIFE", "life"}, {BONUS_TYPE_REVERSE, "BONUS_TYPE_REVERSE", "reverse"}, {BONUS_TYPE_WARP, "BONUS_TYPE_WARP", "warp"}, {0, NULL, NULL}};
		GType bonus_type_type_id;
		bonus_type_type_id = g_enum_register_static ("BonusType", values);
		g_once_init_leave (&bonus_type_type_id__volatile, bonus_type_type_id);
	}
	return bonus_type_type_id__volatile;
}


Bonus*
bonus_construct (GType object_type,
                 gint x,
                 gint y,
                 BonusType type,
                 gboolean fake,
                 gint countdown)
{
	Bonus * self = NULL;
#line 40 "boni.vala"
	self = (Bonus*) g_object_new (object_type, NULL);
#line 42 "boni.vala"
	self->x = x;
#line 43 "boni.vala"
	self->y = y;
#line 44 "boni.vala"
	self->type = type;
#line 45 "boni.vala"
	self->fake = fake;
#line 46 "boni.vala"
	self->countdown = countdown;
#line 40 "boni.vala"
	return self;
#line 196 "boni.c"
}


Bonus*
bonus_new (gint x,
           gint y,
           BonusType type,
           gboolean fake,
           gint countdown)
{
#line 40 "boni.vala"
	return bonus_construct (TYPE_BONUS, x, y, type, fake, countdown);
#line 209 "boni.c"
}


static void
bonus_class_init (BonusClass * klass)
{
#line 32 "boni.vala"
	bonus_parent_class = g_type_class_peek_parent (klass);
#line 32 "boni.vala"
	G_OBJECT_CLASS (klass)->finalize = bonus_finalize;
#line 220 "boni.c"
}


static void
bonus_instance_init (Bonus * self)
{
}


static void
bonus_finalize (GObject * obj)
{
	Bonus * self;
#line 32 "boni.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BONUS, Bonus);
#line 32 "boni.vala"
	G_OBJECT_CLASS (bonus_parent_class)->finalize (obj);
#line 238 "boni.c"
}


GType
bonus_get_type (void)
{
	static volatile gsize bonus_type_id__volatile = 0;
	if (g_once_init_enter (&bonus_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BonusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bonus_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Bonus), 0, (GInstanceInitFunc) bonus_instance_init, NULL };
		GType bonus_type_id;
		bonus_type_id = g_type_register_static (G_TYPE_OBJECT, "Bonus", &g_define_type_info, 0);
		g_once_init_leave (&bonus_type_id__volatile, bonus_type_id);
	}
	return bonus_type_id__volatile;
}


Boni*
boni_construct (GType object_type,
                gint numworms)
{
	Boni * self = NULL;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
#line 65 "boni.vala"
	self = (Boni*) g_object_new (object_type, NULL);
#line 67 "boni.vala"
	_tmp0_ = gee_linked_list_new (TYPE_BONUS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 67 "boni.vala"
	_g_object_unref0 (self->bonuses);
#line 67 "boni.vala"
	self->bonuses = _tmp0_;
#line 68 "boni.vala"
	self->missed = 0;
#line 69 "boni.vala"
	self->numboni = 8 + numworms;
#line 70 "boni.vala"
	self->numbonuses = 0;
#line 71 "boni.vala"
	_tmp1_ = self->numboni;
#line 71 "boni.vala"
	self->numleft = _tmp1_;
#line 65 "boni.vala"
	return self;
#line 283 "boni.c"
}


Boni*
boni_new (gint numworms)
{
#line 65 "boni.vala"
	return boni_construct (TYPE_BONI, numworms);
#line 292 "boni.c"
}


void
boni_add_bonus (Boni* self,
                gint* board,
                int board_length1,
                int board_length2,
                gint x,
                gint y,
                BonusType type,
                gboolean fake,
                gint countdown)
{
	gint _tmp0_;
	Bonus* bonus = NULL;
	Bonus* _tmp1_;
	GeeLinkedList* _tmp2_;
	Bonus* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
#line 74 "boni.vala"
	g_return_if_fail (self != NULL);
#line 76 "boni.vala"
	_tmp0_ = self->numbonuses;
#line 76 "boni.vala"
	if (_tmp0_ == BONI_MAX_BONUSES) {
#line 77 "boni.vala"
		return;
#line 325 "boni.c"
	}
#line 79 "boni.vala"
	_tmp1_ = bonus_new (x, y, type, fake, countdown);
#line 79 "boni.vala"
	bonus = _tmp1_;
#line 80 "boni.vala"
	_tmp2_ = self->bonuses;
#line 80 "boni.vala"
	_tmp3_ = bonus;
#line 80 "boni.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _tmp3_);
#line 81 "boni.vala"
	board[(x * board_length2) + y] = (gint) (type + 'A');
#line 81 "boni.vala"
	_tmp4_ = board[(x * board_length2) + y];
#line 82 "boni.vala"
	board[((x + 1) * board_length2) + y] = (gint) (type + 'A');
#line 82 "boni.vala"
	_tmp5_ = board[((x + 1) * board_length2) + y];
#line 83 "boni.vala"
	board[(x * board_length2) + (y + 1)] = (gint) (type + 'A');
#line 83 "boni.vala"
	_tmp6_ = board[(x * board_length2) + (y + 1)];
#line 84 "boni.vala"
	board[((x + 1) * board_length2) + (y + 1)] = (gint) (type + 'A');
#line 84 "boni.vala"
	_tmp7_ = board[((x + 1) * board_length2) + (y + 1)];
#line 85 "boni.vala"
	g_signal_emit (self, boni_signals[BONI_BONUS_ADDED_SIGNAL], 0);
#line 86 "boni.vala"
	_tmp8_ = self->numbonuses;
#line 86 "boni.vala"
	self->numbonuses = _tmp8_ + 1;
#line 74 "boni.vala"
	_g_object_unref0 (bonus);
#line 361 "boni.c"
}


void
boni_remove_bonus (Boni* self,
                   gint* board,
                   int board_length1,
                   int board_length2,
                   Bonus* bonus)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
#line 89 "boni.vala"
	g_return_if_fail (self != NULL);
#line 89 "boni.vala"
	g_return_if_fail (bonus != NULL);
#line 91 "boni.vala"
	_tmp0_ = bonus->x;
#line 91 "boni.vala"
	_tmp1_ = bonus->y;
#line 91 "boni.vala"
	board[(_tmp0_ * board_length2) + _tmp1_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 91 "boni.vala"
	_tmp2_ = board[(_tmp0_ * board_length2) + _tmp1_];
#line 92 "boni.vala"
	_tmp3_ = bonus->x;
#line 92 "boni.vala"
	_tmp4_ = bonus->y;
#line 92 "boni.vala"
	board[((_tmp3_ + 1) * board_length2) + _tmp4_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 92 "boni.vala"
	_tmp5_ = board[((_tmp3_ + 1) * board_length2) + _tmp4_];
#line 93 "boni.vala"
	_tmp6_ = bonus->x;
#line 93 "boni.vala"
	_tmp7_ = bonus->y;
#line 93 "boni.vala"
	board[(_tmp6_ * board_length2) + (_tmp7_ + 1)] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 93 "boni.vala"
	_tmp8_ = board[(_tmp6_ * board_length2) + (_tmp7_ + 1)];
#line 94 "boni.vala"
	_tmp9_ = bonus->x;
#line 94 "boni.vala"
	_tmp10_ = bonus->y;
#line 94 "boni.vala"
	board[((_tmp9_ + 1) * board_length2) + (_tmp10_ + 1)] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 94 "boni.vala"
	_tmp11_ = board[((_tmp9_ + 1) * board_length2) + (_tmp10_ + 1)];
#line 96 "boni.vala"
	g_signal_emit (self, boni_signals[BONI_BONUS_REMOVED_SIGNAL], 0, bonus);
#line 422 "boni.c"
}


void
boni_reset (Boni* self,
            gint numworms)
{
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
#line 99 "boni.vala"
	g_return_if_fail (self != NULL);
#line 101 "boni.vala"
	_tmp0_ = self->bonuses;
#line 101 "boni.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 102 "boni.vala"
	self->missed = 0;
#line 103 "boni.vala"
	self->numboni = 8 + numworms;
#line 104 "boni.vala"
	self->numbonuses = 0;
#line 105 "boni.vala"
	_tmp1_ = self->numboni;
#line 105 "boni.vala"
	self->numleft = _tmp1_;
#line 448 "boni.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 110 "boni.vala"
	return self ? g_object_ref (self) : NULL;
#line 457 "boni.c"
}


Bonus*
boni_get_bonus (Boni* self,
                gint* board,
                int board_length1,
                int board_length2,
                gint x,
                gint y)
{
	Bonus* result = NULL;
#line 108 "boni.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 472 "boni.c"
	{
		GeeLinkedList* _bonus_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _bonus_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _bonus_index = 0;
#line 110 "boni.vala"
		_tmp0_ = self->bonuses;
#line 110 "boni.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 110 "boni.vala"
		_bonus_list = _tmp1_;
#line 110 "boni.vala"
		_tmp2_ = _bonus_list;
#line 110 "boni.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 110 "boni.vala"
		_tmp4_ = _tmp3_;
#line 110 "boni.vala"
		_bonus_size = _tmp4_;
#line 110 "boni.vala"
		_bonus_index = -1;
#line 110 "boni.vala"
		while (TRUE) {
#line 500 "boni.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Bonus* bonus = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			Bonus* _tmp15_;
			gint _tmp16_;
#line 110 "boni.vala"
			_tmp5_ = _bonus_index;
#line 110 "boni.vala"
			_bonus_index = _tmp5_ + 1;
#line 110 "boni.vala"
			_tmp6_ = _bonus_index;
#line 110 "boni.vala"
			_tmp7_ = _bonus_size;
#line 110 "boni.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 110 "boni.vala"
				break;
#line 526 "boni.c"
			}
#line 110 "boni.vala"
			_tmp8_ = _bonus_list;
#line 110 "boni.vala"
			_tmp9_ = _bonus_index;
#line 110 "boni.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 110 "boni.vala"
			bonus = (Bonus*) _tmp10_;
#line 112 "boni.vala"
			_tmp15_ = bonus;
#line 112 "boni.vala"
			_tmp16_ = _tmp15_->x;
#line 112 "boni.vala"
			if (x == _tmp16_) {
#line 542 "boni.c"
				Bonus* _tmp17_;
				gint _tmp18_;
#line 112 "boni.vala"
				_tmp17_ = bonus;
#line 112 "boni.vala"
				_tmp18_ = _tmp17_->y;
#line 112 "boni.vala"
				_tmp14_ = y == _tmp18_;
#line 551 "boni.c"
			} else {
#line 112 "boni.vala"
				_tmp14_ = FALSE;
#line 555 "boni.c"
			}
#line 112 "boni.vala"
			if (_tmp14_) {
#line 112 "boni.vala"
				_tmp13_ = TRUE;
#line 561 "boni.c"
			} else {
				gboolean _tmp19_ = FALSE;
				Bonus* _tmp20_;
				gint _tmp21_;
#line 113 "boni.vala"
				_tmp20_ = bonus;
#line 113 "boni.vala"
				_tmp21_ = _tmp20_->x;
#line 113 "boni.vala"
				if (x == (_tmp21_ + 1)) {
#line 572 "boni.c"
					Bonus* _tmp22_;
					gint _tmp23_;
#line 113 "boni.vala"
					_tmp22_ = bonus;
#line 113 "boni.vala"
					_tmp23_ = _tmp22_->y;
#line 113 "boni.vala"
					_tmp19_ = y == _tmp23_;
#line 581 "boni.c"
				} else {
#line 113 "boni.vala"
					_tmp19_ = FALSE;
#line 585 "boni.c"
				}
#line 113 "boni.vala"
				_tmp13_ = _tmp19_;
#line 589 "boni.c"
			}
#line 112 "boni.vala"
			if (_tmp13_) {
#line 112 "boni.vala"
				_tmp12_ = TRUE;
#line 595 "boni.c"
			} else {
				gboolean _tmp24_ = FALSE;
				Bonus* _tmp25_;
				gint _tmp26_;
#line 114 "boni.vala"
				_tmp25_ = bonus;
#line 114 "boni.vala"
				_tmp26_ = _tmp25_->x;
#line 114 "boni.vala"
				if (x == _tmp26_) {
#line 606 "boni.c"
					Bonus* _tmp27_;
					gint _tmp28_;
#line 114 "boni.vala"
					_tmp27_ = bonus;
#line 114 "boni.vala"
					_tmp28_ = _tmp27_->y;
#line 114 "boni.vala"
					_tmp24_ = y == (_tmp28_ + 1);
#line 615 "boni.c"
				} else {
#line 114 "boni.vala"
					_tmp24_ = FALSE;
#line 619 "boni.c"
				}
#line 114 "boni.vala"
				_tmp12_ = _tmp24_;
#line 623 "boni.c"
			}
#line 112 "boni.vala"
			if (_tmp12_) {
#line 112 "boni.vala"
				_tmp11_ = TRUE;
#line 629 "boni.c"
			} else {
				gboolean _tmp29_ = FALSE;
				Bonus* _tmp30_;
				gint _tmp31_;
#line 115 "boni.vala"
				_tmp30_ = bonus;
#line 115 "boni.vala"
				_tmp31_ = _tmp30_->x;
#line 115 "boni.vala"
				if (x == (_tmp31_ + 1)) {
#line 640 "boni.c"
					Bonus* _tmp32_;
					gint _tmp33_;
#line 115 "boni.vala"
					_tmp32_ = bonus;
#line 115 "boni.vala"
					_tmp33_ = _tmp32_->y;
#line 115 "boni.vala"
					_tmp29_ = y == (_tmp33_ + 1);
#line 649 "boni.c"
				} else {
#line 115 "boni.vala"
					_tmp29_ = FALSE;
#line 653 "boni.c"
				}
#line 115 "boni.vala"
				_tmp11_ = _tmp29_;
#line 657 "boni.c"
			}
#line 112 "boni.vala"
			if (_tmp11_) {
#line 117 "boni.vala"
				result = bonus;
#line 117 "boni.vala"
				_g_object_unref0 (_bonus_list);
#line 117 "boni.vala"
				return result;
#line 667 "boni.c"
			}
#line 110 "boni.vala"
			_g_object_unref0 (bonus);
#line 671 "boni.c"
		}
#line 110 "boni.vala"
		_g_object_unref0 (_bonus_list);
#line 675 "boni.c"
	}
#line 121 "boni.vala"
	result = NULL;
#line 121 "boni.vala"
	return result;
#line 681 "boni.c"
}


static void
boni_class_init (BoniClass * klass)
{
#line 50 "boni.vala"
	boni_parent_class = g_type_class_peek_parent (klass);
#line 50 "boni.vala"
	G_OBJECT_CLASS (klass)->finalize = boni_finalize;
#line 50 "boni.vala"
	boni_signals[BONI_BONUS_ADDED_SIGNAL] = g_signal_new ("bonus-added", TYPE_BONI, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 50 "boni.vala"
	boni_signals[BONI_BONUS_REMOVED_SIGNAL] = g_signal_new ("bonus-removed", TYPE_BONI, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_BONUS);
#line 696 "boni.c"
}


static void
boni_instance_init (Boni * self)
{
}


static void
boni_finalize (GObject * obj)
{
	Boni * self;
#line 50 "boni.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BONI, Boni);
#line 52 "boni.vala"
	_g_object_unref0 (self->bonuses);
#line 50 "boni.vala"
	G_OBJECT_CLASS (boni_parent_class)->finalize (obj);
#line 716 "boni.c"
}


GType
boni_get_type (void)
{
	static volatile gsize boni_type_id__volatile = 0;
	if (g_once_init_enter (&boni_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoniClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boni_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Boni), 0, (GInstanceInitFunc) boni_instance_init, NULL };
		GType boni_type_id;
		boni_type_id = g_type_register_static (G_TYPE_OBJECT, "Boni", &g_define_type_info, 0);
		g_once_init_leave (&boni_type_id__volatile, boni_type_id);
	}
	return boni_type_id__volatile;
}



