/* preferences-dialog.c generated by valac 0.42.3, the Vala compiler
 * generated from preferences-dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Gabriel Ivascu <ivascu.gabriel59@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>


#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;
enum  {
	PREFERENCES_DIALOG_0_PROPERTY,
	PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* preferences_dialog_properties[PREFERENCES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

struct _PreferencesDialog {
	GtkDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _PreferencesDialogPrivate {
	GtkApplicationWindow* window;
	GSettings* settings;
	GeeArrayList* worm_settings;
	GtkNotebook* notebook;
	GtkRadioButton* beginner_radio_button;
	GtkRadioButton* slow_radio_button;
	GtkRadioButton* medium_radio_button;
	GtkRadioButton* fast_radio_button;
	GtkCheckButton* sound_check_button;
	GtkCheckButton* fakes_check_button;
	GtkListStore* list_store_1;
	GtkListStore* list_store_2;
	GtkListStore* list_store_3;
	GtkListStore* list_store_4;
	GtkTreeView* tree_view_1;
	GtkTreeView* tree_view_2;
	GtkTreeView* tree_view_3;
	GtkTreeView* tree_view_4;
	GtkComboBoxText* combo_box_1;
	GtkComboBoxText* combo_box_2;
	GtkComboBoxText* combo_box_3;
	GtkComboBoxText* combo_box_4;
	GeeArrayList* radio_buttons;
	GeeArrayList* list_stores;
	GeeArrayList* tree_views;
	GeeArrayList* combo_boxes;
};


static gint PreferencesDialog_private_offset;
static gpointer preferences_dialog_parent_class = NULL;

GType preferences_dialog_get_type (void) G_GNUC_CONST;
PreferencesDialog* preferences_dialog_new (GtkApplicationWindow* window,
                                           GSettings* settings,
                                           GeeArrayList* worm_settings);
PreferencesDialog* preferences_dialog_construct (GType object_type,
                                                 GtkApplicationWindow* window,
                                                 GSettings* settings,
                                                 GeeArrayList* worm_settings);
static void __lambda4_ (PreferencesDialog* self);
static void ___lambda4__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
#define NIBBLES_GAME_MAX_SPEED 4
static void preferences_dialog_radio_button_toggled_cb (PreferencesDialog* self,
                                                 GtkToggleButton* button);
static void _preferences_dialog_radio_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                            gpointer self);
static void preferences_dialog_sound_toggled_cb (PreferencesDialog* self);
static void _preferences_dialog_sound_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self);
static void preferences_dialog_fakes_toggles_cb (PreferencesDialog* self);
static void _preferences_dialog_fakes_toggles_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self);
static void preferences_dialog_accel_edited_cb (PreferencesDialog* self,
                                         GtkCellRendererAccel* cell,
                                         const gchar* path_string,
                                         guint keyval,
                                         GdkModifierType mask,
                                         guint hardware_keycode);
static void _preferences_dialog_accel_edited_cb_gtk_cell_renderer_accel_accel_edited (GtkCellRendererAccel* _sender,
                                                                               const gchar* path_string,
                                                                               guint accel_key,
                                                                               GdkModifierType accel_mods,
                                                                               guint hardware_keycode,
                                                                               gpointer self);
static void preferences_dialog_accel_cleared_cb (PreferencesDialog* self,
                                          GtkCellRendererAccel* cell,
                                          const gchar* path_string);
static void _preferences_dialog_accel_cleared_cb_gtk_cell_renderer_accel_accel_cleared (GtkCellRendererAccel* _sender,
                                                                                 const gchar* path_string,
                                                                                 gpointer self);
#define NIBBLES_VIEW_NUM_COLORS 6
gchar* nibbles_view_colorval_name (gint colorval);
static void preferences_dialog_combo_box_changed_cb (PreferencesDialog* self,
                                              GtkComboBox* combo_box);
static void _preferences_dialog_combo_box_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                     gpointer self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
#define NIBBLES_GAME_MAX_HUMANS 4
#define NIBBLES_GAME_MAX_WORMS 6
static void preferences_dialog_finalize (GObject * obj);


static inline gpointer
preferences_dialog_get_instance_private (PreferencesDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PreferencesDialog_private_offset);
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 75 "preferences-dialog.vala"
	return self ? g_object_ref (self) : NULL;
#line 161 "preferences-dialog.c"
}


static void
__lambda4_ (PreferencesDialog* self)
{
#line 80 "preferences-dialog.vala"
	gtk_widget_destroy ((GtkWidget*) self);
#line 170 "preferences-dialog.c"
}


static void
___lambda4__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
#line 79 "preferences-dialog.vala"
	__lambda4_ ((PreferencesDialog*) self);
#line 181 "preferences-dialog.c"
}


static void
_preferences_dialog_radio_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self)
{
#line 96 "preferences-dialog.vala"
	preferences_dialog_radio_button_toggled_cb ((PreferencesDialog*) self, _sender);
#line 191 "preferences-dialog.c"
}


static void
_preferences_dialog_sound_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self)
{
#line 101 "preferences-dialog.vala"
	preferences_dialog_sound_toggled_cb ((PreferencesDialog*) self);
#line 201 "preferences-dialog.c"
}


static void
_preferences_dialog_fakes_toggles_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self)
{
#line 105 "preferences-dialog.vala"
	preferences_dialog_fakes_toggles_cb ((PreferencesDialog*) self);
#line 211 "preferences-dialog.c"
}


static void
_preferences_dialog_accel_edited_cb_gtk_cell_renderer_accel_accel_edited (GtkCellRendererAccel* _sender,
                                                                          const gchar* path_string,
                                                                          guint accel_key,
                                                                          GdkModifierType accel_mods,
                                                                          guint hardware_keycode,
                                                                          gpointer self)
{
#line 145 "preferences-dialog.vala"
	preferences_dialog_accel_edited_cb ((PreferencesDialog*) self, _sender, path_string, accel_key, accel_mods, hardware_keycode);
#line 225 "preferences-dialog.c"
}


static void
_preferences_dialog_accel_cleared_cb_gtk_cell_renderer_accel_accel_cleared (GtkCellRendererAccel* _sender,
                                                                            const gchar* path_string,
                                                                            gpointer self)
{
#line 146 "preferences-dialog.vala"
	preferences_dialog_accel_cleared_cb ((PreferencesDialog*) self, _sender, path_string);
#line 236 "preferences-dialog.c"
}


static void
_preferences_dialog_combo_box_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                gpointer self)
{
#line 167 "preferences-dialog.vala"
	preferences_dialog_combo_box_changed_cb ((PreferencesDialog*) self, _sender);
#line 246 "preferences-dialog.c"
}


PreferencesDialog*
preferences_dialog_construct (GType object_type,
                              GtkApplicationWindow* window,
                              GSettings* settings,
                              GeeArrayList* worm_settings)
{
	PreferencesDialog * self = NULL;
	GSettings* _tmp0_;
	GeeArrayList* _tmp1_;
	GtkApplicationWindow* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GtkRadioButton* _tmp5_;
	GeeArrayList* _tmp6_;
	GtkRadioButton* _tmp7_;
	GeeArrayList* _tmp8_;
	GtkRadioButton* _tmp9_;
	GeeArrayList* _tmp10_;
	GtkRadioButton* _tmp11_;
	GtkCheckButton* _tmp28_;
	GtkCheckButton* _tmp29_;
	GtkCheckButton* _tmp30_;
	GtkCheckButton* _tmp31_;
	GeeArrayList* _tmp32_;
	GeeArrayList* _tmp33_;
	GtkTreeView* _tmp34_;
	GeeArrayList* _tmp35_;
	GtkTreeView* _tmp36_;
	GeeArrayList* _tmp37_;
	GtkTreeView* _tmp38_;
	GeeArrayList* _tmp39_;
	GtkTreeView* _tmp40_;
	GeeArrayList* _tmp41_;
	GeeArrayList* _tmp42_;
	GtkListStore* _tmp43_;
	GeeArrayList* _tmp44_;
	GtkListStore* _tmp45_;
	GeeArrayList* _tmp46_;
	GtkListStore* _tmp47_;
	GeeArrayList* _tmp48_;
	GtkListStore* _tmp49_;
	GeeArrayList* _tmp109_;
	GeeArrayList* _tmp110_;
	GtkComboBoxText* _tmp111_;
	GeeArrayList* _tmp112_;
	GtkComboBoxText* _tmp113_;
	GeeArrayList* _tmp114_;
	GtkComboBoxText* _tmp115_;
	GeeArrayList* _tmp116_;
	GtkComboBoxText* _tmp117_;
#line 71 "preferences-dialog.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 71 "preferences-dialog.vala"
	g_return_val_if_fail (settings != NULL, NULL);
#line 71 "preferences-dialog.vala"
	g_return_val_if_fail (worm_settings != NULL, NULL);
#line 73 "preferences-dialog.vala"
	self = (PreferencesDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
#line 75 "preferences-dialog.vala"
	_tmp0_ = _g_object_ref0 (settings);
#line 75 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->settings);
#line 75 "preferences-dialog.vala"
	self->priv->settings = _tmp0_;
#line 76 "preferences-dialog.vala"
	_tmp1_ = _g_object_ref0 (worm_settings);
#line 76 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->worm_settings);
#line 76 "preferences-dialog.vala"
	self->priv->worm_settings = _tmp1_;
#line 77 "preferences-dialog.vala"
	_tmp2_ = _g_object_ref0 (window);
#line 77 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->window);
#line 77 "preferences-dialog.vala"
	self->priv->window = _tmp2_;
#line 79 "preferences-dialog.vala"
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) ___lambda4__gtk_dialog_response, self, 0);
#line 83 "preferences-dialog.vala"
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) window);
#line 86 "preferences-dialog.vala"
	_tmp3_ = gee_array_list_new (gtk_radio_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 86 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->radio_buttons);
#line 86 "preferences-dialog.vala"
	self->priv->radio_buttons = _tmp3_;
#line 87 "preferences-dialog.vala"
	_tmp4_ = self->priv->radio_buttons;
#line 87 "preferences-dialog.vala"
	_tmp5_ = self->priv->beginner_radio_button;
#line 87 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
#line 88 "preferences-dialog.vala"
	_tmp6_ = self->priv->radio_buttons;
#line 88 "preferences-dialog.vala"
	_tmp7_ = self->priv->slow_radio_button;
#line 88 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
#line 89 "preferences-dialog.vala"
	_tmp8_ = self->priv->radio_buttons;
#line 89 "preferences-dialog.vala"
	_tmp9_ = self->priv->medium_radio_button;
#line 89 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
#line 90 "preferences-dialog.vala"
	_tmp10_ = self->priv->radio_buttons;
#line 90 "preferences-dialog.vala"
	_tmp11_ = self->priv->fast_radio_button;
#line 90 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
#line 360 "preferences-dialog.c"
	{
		GeeArrayList* _radio_button_list = NULL;
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		gint _radio_button_size = 0;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _radio_button_index = 0;
#line 92 "preferences-dialog.vala"
		_tmp12_ = self->priv->radio_buttons;
#line 92 "preferences-dialog.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 92 "preferences-dialog.vala"
		_radio_button_list = _tmp13_;
#line 92 "preferences-dialog.vala"
		_tmp14_ = _radio_button_list;
#line 92 "preferences-dialog.vala"
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
#line 92 "preferences-dialog.vala"
		_tmp16_ = _tmp15_;
#line 92 "preferences-dialog.vala"
		_radio_button_size = _tmp16_;
#line 92 "preferences-dialog.vala"
		_radio_button_index = -1;
#line 92 "preferences-dialog.vala"
		while (TRUE) {
#line 388 "preferences-dialog.c"
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			GtkRadioButton* radio_button = NULL;
			GeeArrayList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			gint speed = 0;
			GeeArrayList* _tmp23_;
			GtkRadioButton* _tmp24_;
			GtkRadioButton* _tmp25_;
			gint _tmp26_;
			GtkRadioButton* _tmp27_;
#line 92 "preferences-dialog.vala"
			_tmp17_ = _radio_button_index;
#line 92 "preferences-dialog.vala"
			_radio_button_index = _tmp17_ + 1;
#line 92 "preferences-dialog.vala"
			_tmp18_ = _radio_button_index;
#line 92 "preferences-dialog.vala"
			_tmp19_ = _radio_button_size;
#line 92 "preferences-dialog.vala"
			if (!(_tmp18_ < _tmp19_)) {
#line 92 "preferences-dialog.vala"
				break;
#line 414 "preferences-dialog.c"
			}
#line 92 "preferences-dialog.vala"
			_tmp20_ = _radio_button_list;
#line 92 "preferences-dialog.vala"
			_tmp21_ = _radio_button_index;
#line 92 "preferences-dialog.vala"
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp21_);
#line 92 "preferences-dialog.vala"
			radio_button = (GtkRadioButton*) _tmp22_;
#line 94 "preferences-dialog.vala"
			_tmp23_ = self->priv->radio_buttons;
#line 94 "preferences-dialog.vala"
			_tmp24_ = radio_button;
#line 94 "preferences-dialog.vala"
			speed = NIBBLES_GAME_MAX_SPEED - gee_abstract_list_index_of ((GeeAbstractList*) _tmp23_, _tmp24_);
#line 95 "preferences-dialog.vala"
			_tmp25_ = radio_button;
#line 95 "preferences-dialog.vala"
			_tmp26_ = speed;
#line 95 "preferences-dialog.vala"
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp25_, _tmp26_ == g_settings_get_int (settings, "speed"));
#line 96 "preferences-dialog.vala"
			_tmp27_ = radio_button;
#line 96 "preferences-dialog.vala"
			g_signal_connect_object ((GtkToggleButton*) _tmp27_, "toggled", (GCallback) _preferences_dialog_radio_button_toggled_cb_gtk_toggle_button_toggled, self, 0);
#line 92 "preferences-dialog.vala"
			_g_object_unref0 (radio_button);
#line 442 "preferences-dialog.c"
		}
#line 92 "preferences-dialog.vala"
		_g_object_unref0 (_radio_button_list);
#line 446 "preferences-dialog.c"
	}
#line 100 "preferences-dialog.vala"
	_tmp28_ = self->priv->sound_check_button;
#line 100 "preferences-dialog.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp28_, g_settings_get_boolean (settings, "sound"));
#line 101 "preferences-dialog.vala"
	_tmp29_ = self->priv->sound_check_button;
#line 101 "preferences-dialog.vala"
	g_signal_connect_object ((GtkToggleButton*) _tmp29_, "toggled", (GCallback) _preferences_dialog_sound_toggled_cb_gtk_toggle_button_toggled, self, 0);
#line 104 "preferences-dialog.vala"
	_tmp30_ = self->priv->fakes_check_button;
#line 104 "preferences-dialog.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp30_, g_settings_get_boolean (settings, "fakes"));
#line 105 "preferences-dialog.vala"
	_tmp31_ = self->priv->fakes_check_button;
#line 105 "preferences-dialog.vala"
	g_signal_connect_object ((GtkToggleButton*) _tmp31_, "toggled", (GCallback) _preferences_dialog_fakes_toggles_cb_gtk_toggle_button_toggled, self, 0);
#line 108 "preferences-dialog.vala"
	_tmp32_ = gee_array_list_new (gtk_tree_view_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 108 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->tree_views);
#line 108 "preferences-dialog.vala"
	self->priv->tree_views = _tmp32_;
#line 109 "preferences-dialog.vala"
	_tmp33_ = self->priv->tree_views;
#line 109 "preferences-dialog.vala"
	_tmp34_ = self->priv->tree_view_1;
#line 109 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp34_);
#line 110 "preferences-dialog.vala"
	_tmp35_ = self->priv->tree_views;
#line 110 "preferences-dialog.vala"
	_tmp36_ = self->priv->tree_view_2;
#line 110 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp36_);
#line 111 "preferences-dialog.vala"
	_tmp37_ = self->priv->tree_views;
#line 111 "preferences-dialog.vala"
	_tmp38_ = self->priv->tree_view_3;
#line 111 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, _tmp38_);
#line 112 "preferences-dialog.vala"
	_tmp39_ = self->priv->tree_views;
#line 112 "preferences-dialog.vala"
	_tmp40_ = self->priv->tree_view_4;
#line 112 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
#line 114 "preferences-dialog.vala"
	_tmp41_ = gee_array_list_new (gtk_list_store_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 114 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->list_stores);
#line 114 "preferences-dialog.vala"
	self->priv->list_stores = _tmp41_;
#line 115 "preferences-dialog.vala"
	_tmp42_ = self->priv->list_stores;
#line 115 "preferences-dialog.vala"
	_tmp43_ = self->priv->list_store_1;
#line 115 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, _tmp43_);
#line 116 "preferences-dialog.vala"
	_tmp44_ = self->priv->list_stores;
#line 116 "preferences-dialog.vala"
	_tmp45_ = self->priv->list_store_2;
#line 116 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, _tmp45_);
#line 117 "preferences-dialog.vala"
	_tmp46_ = self->priv->list_stores;
#line 117 "preferences-dialog.vala"
	_tmp47_ = self->priv->list_store_3;
#line 117 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp47_);
#line 118 "preferences-dialog.vala"
	_tmp48_ = self->priv->list_stores;
#line 118 "preferences-dialog.vala"
	_tmp49_ = self->priv->list_store_4;
#line 118 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, _tmp49_);
#line 524 "preferences-dialog.c"
	{
		GeeArrayList* _list_store_list = NULL;
		GeeArrayList* _tmp50_;
		GeeArrayList* _tmp51_;
		gint _list_store_size = 0;
		GeeArrayList* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _list_store_index = 0;
#line 120 "preferences-dialog.vala"
		_tmp50_ = self->priv->list_stores;
#line 120 "preferences-dialog.vala"
		_tmp51_ = _g_object_ref0 (_tmp50_);
#line 120 "preferences-dialog.vala"
		_list_store_list = _tmp51_;
#line 120 "preferences-dialog.vala"
		_tmp52_ = _list_store_list;
#line 120 "preferences-dialog.vala"
		_tmp53_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp52_);
#line 120 "preferences-dialog.vala"
		_tmp54_ = _tmp53_;
#line 120 "preferences-dialog.vala"
		_list_store_size = _tmp54_;
#line 120 "preferences-dialog.vala"
		_list_store_index = -1;
#line 120 "preferences-dialog.vala"
		while (TRUE) {
#line 552 "preferences-dialog.c"
			gint _tmp55_;
			gint _tmp56_;
			gint _tmp57_;
			GtkListStore* list_store = NULL;
			GeeArrayList* _tmp58_;
			gint _tmp59_;
			gpointer _tmp60_;
			gint id = 0;
			GeeArrayList* _tmp61_;
			GtkListStore* _tmp62_;
			GtkTreeView* tree_view = NULL;
			GeeArrayList* _tmp63_;
			gint _tmp64_;
			gpointer _tmp65_;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp66_;
			GtkTreeIter _tmp67_ = {0};
			gint keyval = 0;
			gint _tmp68_;
			gpointer _tmp69_;
			GSettings* _tmp70_;
			gint _tmp71_;
			GtkListStore* _tmp72_;
			GtkTreeIter _tmp73_;
			gint _tmp74_;
			GtkListStore* _tmp75_;
			GtkTreeIter _tmp76_ = {0};
			gint _tmp77_;
			gpointer _tmp78_;
			GSettings* _tmp79_;
			GtkListStore* _tmp80_;
			GtkTreeIter _tmp81_;
			gint _tmp82_;
			GtkListStore* _tmp83_;
			GtkTreeIter _tmp84_ = {0};
			gint _tmp85_;
			gpointer _tmp86_;
			GSettings* _tmp87_;
			GtkListStore* _tmp88_;
			GtkTreeIter _tmp89_;
			gint _tmp90_;
			GtkListStore* _tmp91_;
			GtkTreeIter _tmp92_ = {0};
			gint _tmp93_;
			gpointer _tmp94_;
			GSettings* _tmp95_;
			GtkListStore* _tmp96_;
			GtkTreeIter _tmp97_;
			gint _tmp98_;
			GtkCellRendererText* label_renderer = NULL;
			GtkCellRendererText* _tmp99_;
			GtkTreeView* _tmp100_;
			GtkCellRendererText* _tmp101_;
			GtkCellRendererAccel* key_renderer = NULL;
			GtkCellRendererAccel* _tmp102_;
			GtkCellRendererAccel* _tmp103_;
			GtkCellRendererAccel* _tmp104_;
			GtkCellRendererAccel* _tmp105_;
			GtkCellRendererAccel* _tmp106_;
			GtkTreeView* _tmp107_;
			GtkCellRendererAccel* _tmp108_;
#line 120 "preferences-dialog.vala"
			_tmp55_ = _list_store_index;
#line 120 "preferences-dialog.vala"
			_list_store_index = _tmp55_ + 1;
#line 120 "preferences-dialog.vala"
			_tmp56_ = _list_store_index;
#line 120 "preferences-dialog.vala"
			_tmp57_ = _list_store_size;
#line 120 "preferences-dialog.vala"
			if (!(_tmp56_ < _tmp57_)) {
#line 120 "preferences-dialog.vala"
				break;
#line 626 "preferences-dialog.c"
			}
#line 120 "preferences-dialog.vala"
			_tmp58_ = _list_store_list;
#line 120 "preferences-dialog.vala"
			_tmp59_ = _list_store_index;
#line 120 "preferences-dialog.vala"
			_tmp60_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, _tmp59_);
#line 120 "preferences-dialog.vala"
			list_store = (GtkListStore*) _tmp60_;
#line 122 "preferences-dialog.vala"
			_tmp61_ = self->priv->list_stores;
#line 122 "preferences-dialog.vala"
			_tmp62_ = list_store;
#line 122 "preferences-dialog.vala"
			id = gee_abstract_list_index_of ((GeeAbstractList*) _tmp61_, _tmp62_);
#line 123 "preferences-dialog.vala"
			_tmp63_ = self->priv->tree_views;
#line 123 "preferences-dialog.vala"
			_tmp64_ = id;
#line 123 "preferences-dialog.vala"
			_tmp65_ = gee_abstract_list_get ((GeeAbstractList*) _tmp63_, _tmp64_);
#line 123 "preferences-dialog.vala"
			tree_view = (GtkTreeView*) _tmp65_;
#line 126 "preferences-dialog.vala"
			_tmp66_ = list_store;
#line 126 "preferences-dialog.vala"
			gtk_list_store_append (_tmp66_, &_tmp67_);
#line 126 "preferences-dialog.vala"
			iter = _tmp67_;
#line 127 "preferences-dialog.vala"
			_tmp68_ = id;
#line 127 "preferences-dialog.vala"
			_tmp69_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp68_);
#line 127 "preferences-dialog.vala"
			_tmp70_ = (GSettings*) _tmp69_;
#line 127 "preferences-dialog.vala"
			_tmp71_ = g_settings_get_int (_tmp70_, "key-up");
#line 127 "preferences-dialog.vala"
			_g_object_unref0 (_tmp70_);
#line 127 "preferences-dialog.vala"
			keyval = _tmp71_;
#line 128 "preferences-dialog.vala"
			_tmp72_ = list_store;
#line 128 "preferences-dialog.vala"
			_tmp73_ = iter;
#line 128 "preferences-dialog.vala"
			_tmp74_ = keyval;
#line 128 "preferences-dialog.vala"
			gtk_list_store_set (_tmp72_, &_tmp73_, 0, "key-up", 1, _ ("Move up"), 2, _tmp74_, -1);
#line 129 "preferences-dialog.vala"
			_tmp75_ = list_store;
#line 129 "preferences-dialog.vala"
			gtk_list_store_append (_tmp75_, &_tmp76_);
#line 129 "preferences-dialog.vala"
			iter = _tmp76_;
#line 130 "preferences-dialog.vala"
			_tmp77_ = id;
#line 130 "preferences-dialog.vala"
			_tmp78_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp77_);
#line 130 "preferences-dialog.vala"
			_tmp79_ = (GSettings*) _tmp78_;
#line 130 "preferences-dialog.vala"
			keyval = g_settings_get_int (_tmp79_, "key-down");
#line 130 "preferences-dialog.vala"
			_g_object_unref0 (_tmp79_);
#line 131 "preferences-dialog.vala"
			_tmp80_ = list_store;
#line 131 "preferences-dialog.vala"
			_tmp81_ = iter;
#line 131 "preferences-dialog.vala"
			_tmp82_ = keyval;
#line 131 "preferences-dialog.vala"
			gtk_list_store_set (_tmp80_, &_tmp81_, 0, "key-down", 1, _ ("Move down"), 2, _tmp82_, -1);
#line 132 "preferences-dialog.vala"
			_tmp83_ = list_store;
#line 132 "preferences-dialog.vala"
			gtk_list_store_append (_tmp83_, &_tmp84_);
#line 132 "preferences-dialog.vala"
			iter = _tmp84_;
#line 133 "preferences-dialog.vala"
			_tmp85_ = id;
#line 133 "preferences-dialog.vala"
			_tmp86_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp85_);
#line 133 "preferences-dialog.vala"
			_tmp87_ = (GSettings*) _tmp86_;
#line 133 "preferences-dialog.vala"
			keyval = g_settings_get_int (_tmp87_, "key-left");
#line 133 "preferences-dialog.vala"
			_g_object_unref0 (_tmp87_);
#line 134 "preferences-dialog.vala"
			_tmp88_ = list_store;
#line 134 "preferences-dialog.vala"
			_tmp89_ = iter;
#line 134 "preferences-dialog.vala"
			_tmp90_ = keyval;
#line 134 "preferences-dialog.vala"
			gtk_list_store_set (_tmp88_, &_tmp89_, 0, "key-left", 1, _ ("Move left"), 2, _tmp90_, -1);
#line 135 "preferences-dialog.vala"
			_tmp91_ = list_store;
#line 135 "preferences-dialog.vala"
			gtk_list_store_append (_tmp91_, &_tmp92_);
#line 135 "preferences-dialog.vala"
			iter = _tmp92_;
#line 136 "preferences-dialog.vala"
			_tmp93_ = id;
#line 136 "preferences-dialog.vala"
			_tmp94_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp93_);
#line 136 "preferences-dialog.vala"
			_tmp95_ = (GSettings*) _tmp94_;
#line 136 "preferences-dialog.vala"
			keyval = g_settings_get_int (_tmp95_, "key-right");
#line 136 "preferences-dialog.vala"
			_g_object_unref0 (_tmp95_);
#line 137 "preferences-dialog.vala"
			_tmp96_ = list_store;
#line 137 "preferences-dialog.vala"
			_tmp97_ = iter;
#line 137 "preferences-dialog.vala"
			_tmp98_ = keyval;
#line 137 "preferences-dialog.vala"
			gtk_list_store_set (_tmp96_, &_tmp97_, 0, "key-right", 1, _ ("Move right"), 2, _tmp98_, -1);
#line 139 "preferences-dialog.vala"
			_tmp99_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 139 "preferences-dialog.vala"
			g_object_ref_sink (_tmp99_);
#line 139 "preferences-dialog.vala"
			label_renderer = _tmp99_;
#line 140 "preferences-dialog.vala"
			_tmp100_ = tree_view;
#line 140 "preferences-dialog.vala"
			_tmp101_ = label_renderer;
#line 140 "preferences-dialog.vala"
			gtk_tree_view_insert_column_with_attributes (_tmp100_, -1, _ ("Action"), (GtkCellRenderer*) _tmp101_, "text", 1, NULL);
#line 142 "preferences-dialog.vala"
			_tmp102_ = (GtkCellRendererAccel*) gtk_cell_renderer_accel_new ();
#line 142 "preferences-dialog.vala"
			g_object_ref_sink (_tmp102_);
#line 142 "preferences-dialog.vala"
			key_renderer = _tmp102_;
#line 143 "preferences-dialog.vala"
			_tmp103_ = key_renderer;
#line 143 "preferences-dialog.vala"
			g_object_set ((GtkCellRendererText*) _tmp103_, "editable", TRUE, NULL);
#line 144 "preferences-dialog.vala"
			_tmp104_ = key_renderer;
#line 144 "preferences-dialog.vala"
			g_object_set (_tmp104_, "accel-mode", GTK_CELL_RENDERER_ACCEL_MODE_OTHER, NULL);
#line 145 "preferences-dialog.vala"
			_tmp105_ = key_renderer;
#line 145 "preferences-dialog.vala"
			g_signal_connect_object (_tmp105_, "accel-edited", (GCallback) _preferences_dialog_accel_edited_cb_gtk_cell_renderer_accel_accel_edited, self, 0);
#line 146 "preferences-dialog.vala"
			_tmp106_ = key_renderer;
#line 146 "preferences-dialog.vala"
			g_signal_connect_object (_tmp106_, "accel-cleared", (GCallback) _preferences_dialog_accel_cleared_cb_gtk_cell_renderer_accel_accel_cleared, self, 0);
#line 147 "preferences-dialog.vala"
			_tmp107_ = tree_view;
#line 147 "preferences-dialog.vala"
			_tmp108_ = key_renderer;
#line 147 "preferences-dialog.vala"
			gtk_tree_view_insert_column_with_attributes (_tmp107_, -1, _ ("Key"), (GtkCellRenderer*) _tmp108_, "accel-key", 2, NULL);
#line 120 "preferences-dialog.vala"
			_g_object_unref0 (key_renderer);
#line 120 "preferences-dialog.vala"
			_g_object_unref0 (label_renderer);
#line 120 "preferences-dialog.vala"
			_g_object_unref0 (tree_view);
#line 120 "preferences-dialog.vala"
			_g_object_unref0 (list_store);
#line 796 "preferences-dialog.c"
		}
#line 120 "preferences-dialog.vala"
		_g_object_unref0 (_list_store_list);
#line 800 "preferences-dialog.c"
	}
#line 152 "preferences-dialog.vala"
	_tmp109_ = gee_array_list_new (gtk_combo_box_text_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 152 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->combo_boxes);
#line 152 "preferences-dialog.vala"
	self->priv->combo_boxes = _tmp109_;
#line 153 "preferences-dialog.vala"
	_tmp110_ = self->priv->combo_boxes;
#line 153 "preferences-dialog.vala"
	_tmp111_ = self->priv->combo_box_1;
#line 153 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp110_, _tmp111_);
#line 154 "preferences-dialog.vala"
	_tmp112_ = self->priv->combo_boxes;
#line 154 "preferences-dialog.vala"
	_tmp113_ = self->priv->combo_box_2;
#line 154 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp112_, _tmp113_);
#line 155 "preferences-dialog.vala"
	_tmp114_ = self->priv->combo_boxes;
#line 155 "preferences-dialog.vala"
	_tmp115_ = self->priv->combo_box_3;
#line 155 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp114_, _tmp115_);
#line 156 "preferences-dialog.vala"
	_tmp116_ = self->priv->combo_boxes;
#line 156 "preferences-dialog.vala"
	_tmp117_ = self->priv->combo_box_4;
#line 156 "preferences-dialog.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp116_, _tmp117_);
#line 832 "preferences-dialog.c"
	{
		GeeArrayList* _combo_box_list = NULL;
		GeeArrayList* _tmp118_;
		GeeArrayList* _tmp119_;
		gint _combo_box_size = 0;
		GeeArrayList* _tmp120_;
		gint _tmp121_;
		gint _tmp122_;
		gint _combo_box_index = 0;
#line 158 "preferences-dialog.vala"
		_tmp118_ = self->priv->combo_boxes;
#line 158 "preferences-dialog.vala"
		_tmp119_ = _g_object_ref0 (_tmp118_);
#line 158 "preferences-dialog.vala"
		_combo_box_list = _tmp119_;
#line 158 "preferences-dialog.vala"
		_tmp120_ = _combo_box_list;
#line 158 "preferences-dialog.vala"
		_tmp121_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp120_);
#line 158 "preferences-dialog.vala"
		_tmp122_ = _tmp121_;
#line 158 "preferences-dialog.vala"
		_combo_box_size = _tmp122_;
#line 158 "preferences-dialog.vala"
		_combo_box_index = -1;
#line 158 "preferences-dialog.vala"
		while (TRUE) {
#line 860 "preferences-dialog.c"
			gint _tmp123_;
			gint _tmp124_;
			gint _tmp125_;
			GtkComboBoxText* combo_box = NULL;
			GeeArrayList* _tmp126_;
			gint _tmp127_;
			gpointer _tmp128_;
			gint id = 0;
			GeeArrayList* _tmp136_;
			GtkComboBoxText* _tmp137_;
			gint color = 0;
			gint _tmp138_;
			gpointer _tmp139_;
			GSettings* _tmp140_;
			gint _tmp141_;
			GtkComboBoxText* _tmp142_;
			gint _tmp143_;
			GtkComboBoxText* _tmp144_;
#line 158 "preferences-dialog.vala"
			_tmp123_ = _combo_box_index;
#line 158 "preferences-dialog.vala"
			_combo_box_index = _tmp123_ + 1;
#line 158 "preferences-dialog.vala"
			_tmp124_ = _combo_box_index;
#line 158 "preferences-dialog.vala"
			_tmp125_ = _combo_box_size;
#line 158 "preferences-dialog.vala"
			if (!(_tmp124_ < _tmp125_)) {
#line 158 "preferences-dialog.vala"
				break;
#line 891 "preferences-dialog.c"
			}
#line 158 "preferences-dialog.vala"
			_tmp126_ = _combo_box_list;
#line 158 "preferences-dialog.vala"
			_tmp127_ = _combo_box_index;
#line 158 "preferences-dialog.vala"
			_tmp128_ = gee_abstract_list_get ((GeeAbstractList*) _tmp126_, _tmp127_);
#line 158 "preferences-dialog.vala"
			combo_box = (GtkComboBoxText*) _tmp128_;
#line 901 "preferences-dialog.c"
			{
				gint i = 0;
#line 160 "preferences-dialog.vala"
				i = 0;
#line 906 "preferences-dialog.c"
				{
					gboolean _tmp129_ = FALSE;
#line 160 "preferences-dialog.vala"
					_tmp129_ = TRUE;
#line 160 "preferences-dialog.vala"
					while (TRUE) {
#line 913 "preferences-dialog.c"
						gint _tmp131_;
						GtkComboBoxText* _tmp132_;
						gint _tmp133_;
						gchar* _tmp134_;
						gchar* _tmp135_;
#line 160 "preferences-dialog.vala"
						if (!_tmp129_) {
#line 921 "preferences-dialog.c"
							gint _tmp130_;
#line 160 "preferences-dialog.vala"
							_tmp130_ = i;
#line 160 "preferences-dialog.vala"
							i = _tmp130_ + 1;
#line 927 "preferences-dialog.c"
						}
#line 160 "preferences-dialog.vala"
						_tmp129_ = FALSE;
#line 160 "preferences-dialog.vala"
						_tmp131_ = i;
#line 160 "preferences-dialog.vala"
						if (!(_tmp131_ < NIBBLES_VIEW_NUM_COLORS)) {
#line 160 "preferences-dialog.vala"
							break;
#line 937 "preferences-dialog.c"
						}
#line 161 "preferences-dialog.vala"
						_tmp132_ = combo_box;
#line 161 "preferences-dialog.vala"
						_tmp133_ = i;
#line 161 "preferences-dialog.vala"
						_tmp134_ = nibbles_view_colorval_name (_tmp133_);
#line 161 "preferences-dialog.vala"
						_tmp135_ = _tmp134_;
#line 161 "preferences-dialog.vala"
						gtk_combo_box_text_append_text (_tmp132_, _tmp135_);
#line 161 "preferences-dialog.vala"
						_g_free0 (_tmp135_);
#line 951 "preferences-dialog.c"
					}
				}
			}
#line 163 "preferences-dialog.vala"
			_tmp136_ = self->priv->combo_boxes;
#line 163 "preferences-dialog.vala"
			_tmp137_ = combo_box;
#line 163 "preferences-dialog.vala"
			id = gee_abstract_list_index_of ((GeeAbstractList*) _tmp136_, _tmp137_);
#line 165 "preferences-dialog.vala"
			_tmp138_ = id;
#line 165 "preferences-dialog.vala"
			_tmp139_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp138_);
#line 165 "preferences-dialog.vala"
			_tmp140_ = (GSettings*) _tmp139_;
#line 165 "preferences-dialog.vala"
			_tmp141_ = g_settings_get_enum (_tmp140_, "color");
#line 165 "preferences-dialog.vala"
			_g_object_unref0 (_tmp140_);
#line 165 "preferences-dialog.vala"
			color = _tmp141_;
#line 166 "preferences-dialog.vala"
			_tmp142_ = combo_box;
#line 166 "preferences-dialog.vala"
			_tmp143_ = color;
#line 166 "preferences-dialog.vala"
			gtk_combo_box_set_active ((GtkComboBox*) _tmp142_, _tmp143_);
#line 167 "preferences-dialog.vala"
			_tmp144_ = combo_box;
#line 167 "preferences-dialog.vala"
			g_signal_connect_object ((GtkComboBox*) _tmp144_, "changed", (GCallback) _preferences_dialog_combo_box_changed_cb_gtk_combo_box_changed, self, 0);
#line 158 "preferences-dialog.vala"
			_g_object_unref0 (combo_box);
#line 985 "preferences-dialog.c"
		}
#line 158 "preferences-dialog.vala"
		_g_object_unref0 (_combo_box_list);
#line 989 "preferences-dialog.c"
	}
#line 71 "preferences-dialog.vala"
	return self;
#line 993 "preferences-dialog.c"
}


PreferencesDialog*
preferences_dialog_new (GtkApplicationWindow* window,
                        GSettings* settings,
                        GeeArrayList* worm_settings)
{
#line 71 "preferences-dialog.vala"
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG, window, settings, worm_settings);
#line 1004 "preferences-dialog.c"
}


static void
preferences_dialog_radio_button_toggled_cb (PreferencesDialog* self,
                                            GtkToggleButton* button)
{
#line 171 "preferences-dialog.vala"
	g_return_if_fail (self != NULL);
#line 171 "preferences-dialog.vala"
	g_return_if_fail (button != NULL);
#line 173 "preferences-dialog.vala"
	if (gtk_toggle_button_get_active (button)) {
#line 1018 "preferences-dialog.c"
		gint speed = 0;
		GeeArrayList* _tmp0_;
		GSettings* _tmp1_;
		gint _tmp2_;
#line 175 "preferences-dialog.vala"
		_tmp0_ = self->priv->radio_buttons;
#line 175 "preferences-dialog.vala"
		speed = NIBBLES_GAME_MAX_SPEED - gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (button, gtk_radio_button_get_type (), GtkRadioButton));
#line 176 "preferences-dialog.vala"
		_tmp1_ = self->priv->settings;
#line 176 "preferences-dialog.vala"
		_tmp2_ = speed;
#line 176 "preferences-dialog.vala"
		g_settings_set_int (_tmp1_, "speed", _tmp2_);
#line 1033 "preferences-dialog.c"
	}
}


static void
preferences_dialog_sound_toggled_cb (PreferencesDialog* self)
{
	gboolean play_sound = FALSE;
	GtkCheckButton* _tmp0_;
	GSettings* _tmp1_;
#line 180 "preferences-dialog.vala"
	g_return_if_fail (self != NULL);
#line 182 "preferences-dialog.vala"
	_tmp0_ = self->priv->sound_check_button;
#line 182 "preferences-dialog.vala"
	play_sound = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
#line 183 "preferences-dialog.vala"
	_tmp1_ = self->priv->settings;
#line 183 "preferences-dialog.vala"
	g_settings_set_boolean (_tmp1_, "sound", play_sound);
#line 1054 "preferences-dialog.c"
}


static void
preferences_dialog_fakes_toggles_cb (PreferencesDialog* self)
{
	gboolean has_fakes = FALSE;
	GtkCheckButton* _tmp0_;
	GSettings* _tmp1_;
#line 186 "preferences-dialog.vala"
	g_return_if_fail (self != NULL);
#line 188 "preferences-dialog.vala"
	_tmp0_ = self->priv->fakes_check_button;
#line 188 "preferences-dialog.vala"
	has_fakes = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
#line 189 "preferences-dialog.vala"
	_tmp1_ = self->priv->settings;
#line 189 "preferences-dialog.vala"
	g_settings_set_boolean (_tmp1_, "fakes", has_fakes);
#line 1074 "preferences-dialog.c"
}


static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 197 "preferences-dialog.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 1083 "preferences-dialog.c"
}


static void
preferences_dialog_accel_edited_cb (PreferencesDialog* self,
                                    GtkCellRendererAccel* cell,
                                    const gchar* path_string,
                                    guint keyval,
                                    GdkModifierType mask,
                                    guint hardware_keycode)
{
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	gint id = 0;
	GtkNotebook* _tmp2_;
	GtkListStore* list_store = NULL;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gpointer _tmp5_;
	GtkTreeIter it = {0};
	GtkListStore* _tmp6_;
	GtkTreePath* _tmp7_;
	GtkTreeIter _tmp8_ = {0};
	gboolean _tmp9_;
	gchar* key = NULL;
	GtkListStore* _tmp10_;
	GtkTreeIter _tmp11_;
	const gchar* _tmp12_;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gpointer _tmp15_;
	GSettings* _tmp16_;
	const gchar* _tmp17_;
	gboolean _tmp18_;
	gboolean valid = FALSE;
	gboolean _tmp46_;
#line 192 "preferences-dialog.vala"
	g_return_if_fail (self != NULL);
#line 192 "preferences-dialog.vala"
	g_return_if_fail (cell != NULL);
#line 192 "preferences-dialog.vala"
	g_return_if_fail (path_string != NULL);
#line 195 "preferences-dialog.vala"
	_tmp0_ = gtk_tree_path_new_from_string (path_string);
#line 195 "preferences-dialog.vala"
	path = _tmp0_;
#line 196 "preferences-dialog.vala"
	_tmp1_ = path;
#line 196 "preferences-dialog.vala"
	if (_tmp1_ == NULL) {
#line 197 "preferences-dialog.vala"
		__vala_GtkTreePath_free0 (path);
#line 197 "preferences-dialog.vala"
		return;
#line 1139 "preferences-dialog.c"
	}
#line 199 "preferences-dialog.vala"
	_tmp2_ = self->priv->notebook;
#line 199 "preferences-dialog.vala"
	id = gtk_notebook_get_current_page (_tmp2_) - 1;
#line 200 "preferences-dialog.vala"
	_tmp3_ = self->priv->list_stores;
#line 200 "preferences-dialog.vala"
	_tmp4_ = id;
#line 200 "preferences-dialog.vala"
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp4_);
#line 200 "preferences-dialog.vala"
	list_store = (GtkListStore*) _tmp5_;
#line 203 "preferences-dialog.vala"
	_tmp6_ = list_store;
#line 203 "preferences-dialog.vala"
	_tmp7_ = path;
#line 203 "preferences-dialog.vala"
	_tmp9_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp6_, &_tmp8_, _tmp7_);
#line 203 "preferences-dialog.vala"
	it = _tmp8_;
#line 203 "preferences-dialog.vala"
	if (!_tmp9_) {
#line 204 "preferences-dialog.vala"
		_g_object_unref0 (list_store);
#line 204 "preferences-dialog.vala"
		__vala_GtkTreePath_free0 (path);
#line 204 "preferences-dialog.vala"
		return;
#line 1169 "preferences-dialog.c"
	}
#line 206 "preferences-dialog.vala"
	key = NULL;
#line 207 "preferences-dialog.vala"
	_tmp10_ = list_store;
#line 207 "preferences-dialog.vala"
	_tmp11_ = it;
#line 207 "preferences-dialog.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 0, &key, -1);
#line 208 "preferences-dialog.vala"
	_tmp12_ = key;
#line 208 "preferences-dialog.vala"
	if (_tmp12_ == NULL) {
#line 209 "preferences-dialog.vala"
		_g_free0 (key);
#line 209 "preferences-dialog.vala"
		_g_object_unref0 (list_store);
#line 209 "preferences-dialog.vala"
		__vala_GtkTreePath_free0 (path);
#line 209 "preferences-dialog.vala"
		return;
#line 1191 "preferences-dialog.c"
	}
#line 211 "preferences-dialog.vala"
	_tmp13_ = self->priv->worm_settings;
#line 211 "preferences-dialog.vala"
	_tmp14_ = id;
#line 211 "preferences-dialog.vala"
	_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp14_);
#line 211 "preferences-dialog.vala"
	_tmp16_ = (GSettings*) _tmp15_;
#line 211 "preferences-dialog.vala"
	_tmp17_ = key;
#line 211 "preferences-dialog.vala"
	_tmp18_ = ((guint) g_settings_get_int (_tmp16_, _tmp17_)) == keyval;
#line 211 "preferences-dialog.vala"
	_g_object_unref0 (_tmp16_);
#line 211 "preferences-dialog.vala"
	if (_tmp18_) {
#line 212 "preferences-dialog.vala"
		_g_free0 (key);
#line 212 "preferences-dialog.vala"
		_g_object_unref0 (list_store);
#line 212 "preferences-dialog.vala"
		__vala_GtkTreePath_free0 (path);
#line 212 "preferences-dialog.vala"
		return;
#line 1217 "preferences-dialog.c"
	}
#line 215 "preferences-dialog.vala"
	valid = TRUE;
#line 1221 "preferences-dialog.c"
	{
		gint i = 0;
#line 216 "preferences-dialog.vala"
		i = 0;
#line 1226 "preferences-dialog.c"
		{
			gboolean _tmp19_ = FALSE;
#line 216 "preferences-dialog.vala"
			_tmp19_ = TRUE;
#line 216 "preferences-dialog.vala"
			while (TRUE) {
#line 1233 "preferences-dialog.c"
				gint _tmp21_;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				GeeArrayList* _tmp25_;
				gint _tmp26_;
				gpointer _tmp27_;
				GSettings* _tmp28_;
				gboolean _tmp29_;
#line 216 "preferences-dialog.vala"
				if (!_tmp19_) {
#line 1245 "preferences-dialog.c"
					gint _tmp20_;
#line 216 "preferences-dialog.vala"
					_tmp20_ = i;
#line 216 "preferences-dialog.vala"
					i = _tmp20_ + 1;
#line 1251 "preferences-dialog.c"
				}
#line 216 "preferences-dialog.vala"
				_tmp19_ = FALSE;
#line 216 "preferences-dialog.vala"
				_tmp21_ = i;
#line 216 "preferences-dialog.vala"
				if (!(_tmp21_ < NIBBLES_GAME_MAX_HUMANS)) {
#line 216 "preferences-dialog.vala"
					break;
#line 1261 "preferences-dialog.c"
				}
#line 218 "preferences-dialog.vala"
				_tmp25_ = self->priv->worm_settings;
#line 218 "preferences-dialog.vala"
				_tmp26_ = i;
#line 218 "preferences-dialog.vala"
				_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _tmp26_);
#line 218 "preferences-dialog.vala"
				_tmp28_ = (GSettings*) _tmp27_;
#line 218 "preferences-dialog.vala"
				_tmp29_ = ((guint) g_settings_get_int (_tmp28_, "key-up")) == keyval;
#line 218 "preferences-dialog.vala"
				_g_object_unref0 (_tmp28_);
#line 218 "preferences-dialog.vala"
				if (_tmp29_) {
#line 218 "preferences-dialog.vala"
					_tmp24_ = TRUE;
#line 1279 "preferences-dialog.c"
				} else {
					GeeArrayList* _tmp30_;
					gint _tmp31_;
					gpointer _tmp32_;
					GSettings* _tmp33_;
#line 219 "preferences-dialog.vala"
					_tmp30_ = self->priv->worm_settings;
#line 219 "preferences-dialog.vala"
					_tmp31_ = i;
#line 219 "preferences-dialog.vala"
					_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp31_);
#line 219 "preferences-dialog.vala"
					_tmp33_ = (GSettings*) _tmp32_;
#line 219 "preferences-dialog.vala"
					_tmp24_ = ((guint) g_settings_get_int (_tmp33_, "key-down")) == keyval;
#line 219 "preferences-dialog.vala"
					_g_object_unref0 (_tmp33_);
#line 1297 "preferences-dialog.c"
				}
#line 218 "preferences-dialog.vala"
				if (_tmp24_) {
#line 218 "preferences-dialog.vala"
					_tmp23_ = TRUE;
#line 1303 "preferences-dialog.c"
				} else {
					GeeArrayList* _tmp34_;
					gint _tmp35_;
					gpointer _tmp36_;
					GSettings* _tmp37_;
#line 220 "preferences-dialog.vala"
					_tmp34_ = self->priv->worm_settings;
#line 220 "preferences-dialog.vala"
					_tmp35_ = i;
#line 220 "preferences-dialog.vala"
					_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _tmp35_);
#line 220 "preferences-dialog.vala"
					_tmp37_ = (GSettings*) _tmp36_;
#line 220 "preferences-dialog.vala"
					_tmp23_ = ((guint) g_settings_get_int (_tmp37_, "key-left")) == keyval;
#line 220 "preferences-dialog.vala"
					_g_object_unref0 (_tmp37_);
#line 1321 "preferences-dialog.c"
				}
#line 218 "preferences-dialog.vala"
				if (_tmp23_) {
#line 218 "preferences-dialog.vala"
					_tmp22_ = TRUE;
#line 1327 "preferences-dialog.c"
				} else {
					GeeArrayList* _tmp38_;
					gint _tmp39_;
					gpointer _tmp40_;
					GSettings* _tmp41_;
#line 221 "preferences-dialog.vala"
					_tmp38_ = self->priv->worm_settings;
#line 221 "preferences-dialog.vala"
					_tmp39_ = i;
#line 221 "preferences-dialog.vala"
					_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, _tmp39_);
#line 221 "preferences-dialog.vala"
					_tmp41_ = (GSettings*) _tmp40_;
#line 221 "preferences-dialog.vala"
					_tmp22_ = ((guint) g_settings_get_int (_tmp41_, "key-right")) == keyval;
#line 221 "preferences-dialog.vala"
					_g_object_unref0 (_tmp41_);
#line 1345 "preferences-dialog.c"
				}
#line 218 "preferences-dialog.vala"
				if (_tmp22_) {
#line 1349 "preferences-dialog.c"
					GtkMessageDialog* dialog = NULL;
					GtkApplicationWindow* _tmp42_;
					GtkMessageDialog* _tmp43_;
					GtkMessageDialog* _tmp44_;
					GtkMessageDialog* _tmp45_;
#line 223 "preferences-dialog.vala"
					valid = FALSE;
#line 225 "preferences-dialog.vala"
					_tmp42_ = self->priv->window;
#line 225 "preferences-dialog.vala"
					_tmp43_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp42_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK, "%s", _ ("The key you selected is already assigned!"));
#line 225 "preferences-dialog.vala"
					g_object_ref_sink (_tmp43_);
#line 225 "preferences-dialog.vala"
					dialog = _tmp43_;
#line 232 "preferences-dialog.vala"
					_tmp44_ = dialog;
#line 232 "preferences-dialog.vala"
					gtk_dialog_run ((GtkDialog*) _tmp44_);
#line 233 "preferences-dialog.vala"
					_tmp45_ = dialog;
#line 233 "preferences-dialog.vala"
					gtk_widget_destroy ((GtkWidget*) _tmp45_);
#line 234 "preferences-dialog.vala"
					_g_object_unref0 (dialog);
#line 234 "preferences-dialog.vala"
					break;
#line 1377 "preferences-dialog.c"
				}
			}
		}
	}
#line 238 "preferences-dialog.vala"
	_tmp46_ = valid;
#line 238 "preferences-dialog.vala"
	if (_tmp46_) {
#line 1386 "preferences-dialog.c"
		GtkListStore* _tmp47_;
		GtkTreeIter _tmp48_;
		GeeArrayList* _tmp49_;
		gint _tmp50_;
		gpointer _tmp51_;
		GSettings* _tmp52_;
		const gchar* _tmp53_;
#line 240 "preferences-dialog.vala"
		_tmp47_ = list_store;
#line 240 "preferences-dialog.vala"
		_tmp48_ = it;
#line 240 "preferences-dialog.vala"
		gtk_list_store_set (_tmp47_, &_tmp48_, 2, keyval, -1);
#line 241 "preferences-dialog.vala"
		_tmp49_ = self->priv->worm_settings;
#line 241 "preferences-dialog.vala"
		_tmp50_ = id;
#line 241 "preferences-dialog.vala"
		_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, _tmp50_);
#line 241 "preferences-dialog.vala"
		_tmp52_ = (GSettings*) _tmp51_;
#line 241 "preferences-dialog.vala"
		_tmp53_ = key;
#line 241 "preferences-dialog.vala"
		g_settings_set_int (_tmp52_, _tmp53_, (gint) keyval);
#line 241 "preferences-dialog.vala"
		_g_object_unref0 (_tmp52_);
#line 1414 "preferences-dialog.c"
	}
#line 192 "preferences-dialog.vala"
	_g_free0 (key);
#line 192 "preferences-dialog.vala"
	_g_object_unref0 (list_store);
#line 192 "preferences-dialog.vala"
	__vala_GtkTreePath_free0 (path);
#line 1422 "preferences-dialog.c"
}


static void
preferences_dialog_accel_cleared_cb (PreferencesDialog* self,
                                     GtkCellRendererAccel* cell,
                                     const gchar* path_string)
{
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	gint id = 0;
	GtkNotebook* _tmp2_;
	GtkListStore* list_store = NULL;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gpointer _tmp5_;
	GtkTreeIter it = {0};
	GtkListStore* _tmp6_;
	GtkTreePath* _tmp7_;
	GtkTreeIter _tmp8_ = {0};
	gboolean _tmp9_;
	gchar* key = NULL;
	GtkListStore* _tmp10_;
	GtkTreeIter _tmp11_;
	const gchar* _tmp12_;
	GtkListStore* _tmp13_;
	GtkTreeIter _tmp14_;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gpointer _tmp17_;
	GSettings* _tmp18_;
	const gchar* _tmp19_;
#line 245 "preferences-dialog.vala"
	g_return_if_fail (self != NULL);
#line 245 "preferences-dialog.vala"
	g_return_if_fail (cell != NULL);
#line 245 "preferences-dialog.vala"
	g_return_if_fail (path_string != NULL);
#line 247 "preferences-dialog.vala"
	_tmp0_ = gtk_tree_path_new_from_string (path_string);
#line 247 "preferences-dialog.vala"
	path = _tmp0_;
#line 248 "preferences-dialog.vala"
	_tmp1_ = path;
#line 248 "preferences-dialog.vala"
	if (_tmp1_ == NULL) {
#line 249 "preferences-dialog.vala"
		__vala_GtkTreePath_free0 (path);
#line 249 "preferences-dialog.vala"
		return;
#line 1474 "preferences-dialog.c"
	}
#line 251 "preferences-dialog.vala"
	_tmp2_ = self->priv->notebook;
#line 251 "preferences-dialog.vala"
	id = gtk_notebook_get_current_page (_tmp2_) - 1;
#line 252 "preferences-dialog.vala"
	_tmp3_ = self->priv->list_stores;
#line 252 "preferences-dialog.vala"
	_tmp4_ = id;
#line 252 "preferences-dialog.vala"
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp4_);
#line 252 "preferences-dialog.vala"
	list_store = (GtkListStore*) _tmp5_;
#line 255 "preferences-dialog.vala"
	_tmp6_ = list_store;
#line 255 "preferences-dialog.vala"
	_tmp7_ = path;
#line 255 "preferences-dialog.vala"
	_tmp9_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp6_, &_tmp8_, _tmp7_);
#line 255 "preferences-dialog.vala"
	it = _tmp8_;
#line 255 "preferences-dialog.vala"
	if (!_tmp9_) {
#line 256 "preferences-dialog.vala"
		_g_object_unref0 (list_store);
#line 256 "preferences-dialog.vala"
		__vala_GtkTreePath_free0 (path);
#line 256 "preferences-dialog.vala"
		return;
#line 1504 "preferences-dialog.c"
	}
#line 258 "preferences-dialog.vala"
	key = NULL;
#line 259 "preferences-dialog.vala"
	_tmp10_ = list_store;
#line 259 "preferences-dialog.vala"
	_tmp11_ = it;
#line 259 "preferences-dialog.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 0, &key, -1);
#line 260 "preferences-dialog.vala"
	_tmp12_ = key;
#line 260 "preferences-dialog.vala"
	if (_tmp12_ == NULL) {
#line 261 "preferences-dialog.vala"
		_g_free0 (key);
#line 261 "preferences-dialog.vala"
		_g_object_unref0 (list_store);
#line 261 "preferences-dialog.vala"
		__vala_GtkTreePath_free0 (path);
#line 261 "preferences-dialog.vala"
		return;
#line 1526 "preferences-dialog.c"
	}
#line 263 "preferences-dialog.vala"
	_tmp13_ = list_store;
#line 263 "preferences-dialog.vala"
	_tmp14_ = it;
#line 263 "preferences-dialog.vala"
	gtk_list_store_set (_tmp13_, &_tmp14_, 2, 0, -1);
#line 264 "preferences-dialog.vala"
	_tmp15_ = self->priv->worm_settings;
#line 264 "preferences-dialog.vala"
	_tmp16_ = id;
#line 264 "preferences-dialog.vala"
	_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
#line 264 "preferences-dialog.vala"
	_tmp18_ = (GSettings*) _tmp17_;
#line 264 "preferences-dialog.vala"
	_tmp19_ = key;
#line 264 "preferences-dialog.vala"
	g_settings_set_int (_tmp18_, _tmp19_, 0);
#line 264 "preferences-dialog.vala"
	_g_object_unref0 (_tmp18_);
#line 245 "preferences-dialog.vala"
	_g_free0 (key);
#line 245 "preferences-dialog.vala"
	_g_object_unref0 (list_store);
#line 245 "preferences-dialog.vala"
	__vala_GtkTreePath_free0 (path);
#line 1554 "preferences-dialog.c"
}


static void
preferences_dialog_combo_box_changed_cb (PreferencesDialog* self,
                                         GtkComboBox* combo_box)
{
	gint id = 0;
	GeeArrayList* _tmp0_;
	gint color_new = 0;
	gint color_old = 0;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gpointer _tmp3_;
	GSettings* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeArrayList* _tmp42_;
	gint _tmp43_;
	gpointer _tmp44_;
	GSettings* _tmp45_;
	gint _tmp46_;
#line 267 "preferences-dialog.vala"
	g_return_if_fail (self != NULL);
#line 267 "preferences-dialog.vala"
	g_return_if_fail (combo_box != NULL);
#line 269 "preferences-dialog.vala"
	_tmp0_ = self->priv->combo_boxes;
#line 269 "preferences-dialog.vala"
	id = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (combo_box, gtk_combo_box_text_get_type (), GtkComboBoxText));
#line 270 "preferences-dialog.vala"
	color_new = gtk_combo_box_get_active (combo_box);
#line 271 "preferences-dialog.vala"
	_tmp1_ = self->priv->worm_settings;
#line 271 "preferences-dialog.vala"
	_tmp2_ = id;
#line 271 "preferences-dialog.vala"
	_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp1_, _tmp2_);
#line 271 "preferences-dialog.vala"
	_tmp4_ = (GSettings*) _tmp3_;
#line 271 "preferences-dialog.vala"
	_tmp5_ = g_settings_get_enum (_tmp4_, "color");
#line 271 "preferences-dialog.vala"
	_g_object_unref0 (_tmp4_);
#line 271 "preferences-dialog.vala"
	color_old = _tmp5_;
#line 273 "preferences-dialog.vala"
	_tmp6_ = color_new;
#line 273 "preferences-dialog.vala"
	_tmp7_ = color_old;
#line 273 "preferences-dialog.vala"
	if (_tmp6_ == _tmp7_) {
#line 274 "preferences-dialog.vala"
		return;
#line 1610 "preferences-dialog.c"
	}
	{
		gint i = 0;
#line 277 "preferences-dialog.vala"
		i = 0;
#line 1616 "preferences-dialog.c"
		{
			gboolean _tmp8_ = FALSE;
#line 277 "preferences-dialog.vala"
			_tmp8_ = TRUE;
#line 277 "preferences-dialog.vala"
			while (TRUE) {
#line 1623 "preferences-dialog.c"
				gint _tmp10_;
				gboolean _tmp11_ = FALSE;
				gint _tmp12_;
				gint _tmp13_;
#line 277 "preferences-dialog.vala"
				if (!_tmp8_) {
#line 1630 "preferences-dialog.c"
					gint _tmp9_;
#line 277 "preferences-dialog.vala"
					_tmp9_ = i;
#line 277 "preferences-dialog.vala"
					i = _tmp9_ + 1;
#line 1636 "preferences-dialog.c"
				}
#line 277 "preferences-dialog.vala"
				_tmp8_ = FALSE;
#line 277 "preferences-dialog.vala"
				_tmp10_ = i;
#line 277 "preferences-dialog.vala"
				if (!(_tmp10_ < NIBBLES_GAME_MAX_WORMS)) {
#line 277 "preferences-dialog.vala"
					break;
#line 1646 "preferences-dialog.c"
				}
#line 279 "preferences-dialog.vala"
				_tmp12_ = i;
#line 279 "preferences-dialog.vala"
				_tmp13_ = id;
#line 279 "preferences-dialog.vala"
				if (_tmp12_ != _tmp13_) {
#line 1654 "preferences-dialog.c"
					GeeArrayList* _tmp14_;
					gint _tmp15_;
					gpointer _tmp16_;
					GSettings* _tmp17_;
					gint _tmp18_;
#line 279 "preferences-dialog.vala"
					_tmp14_ = self->priv->worm_settings;
#line 279 "preferences-dialog.vala"
					_tmp15_ = i;
#line 279 "preferences-dialog.vala"
					_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
#line 279 "preferences-dialog.vala"
					_tmp17_ = (GSettings*) _tmp16_;
#line 279 "preferences-dialog.vala"
					_tmp18_ = color_new;
#line 279 "preferences-dialog.vala"
					_tmp11_ = g_settings_get_enum (_tmp17_, "color") == _tmp18_;
#line 279 "preferences-dialog.vala"
					_g_object_unref0 (_tmp17_);
#line 1674 "preferences-dialog.c"
				} else {
#line 279 "preferences-dialog.vala"
					_tmp11_ = FALSE;
#line 1678 "preferences-dialog.c"
				}
#line 279 "preferences-dialog.vala"
				if (_tmp11_) {
#line 1682 "preferences-dialog.c"
					GeeArrayList* _tmp19_;
					gint _tmp20_;
					gpointer _tmp21_;
					GSettings* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
#line 281 "preferences-dialog.vala"
					_tmp19_ = self->priv->worm_settings;
#line 281 "preferences-dialog.vala"
					_tmp20_ = i;
#line 281 "preferences-dialog.vala"
					_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp20_);
#line 281 "preferences-dialog.vala"
					_tmp22_ = (GSettings*) _tmp21_;
#line 281 "preferences-dialog.vala"
					_tmp23_ = color_old;
#line 281 "preferences-dialog.vala"
					g_settings_set_enum (_tmp22_, "color", _tmp23_);
#line 281 "preferences-dialog.vala"
					_g_object_unref0 (_tmp22_);
#line 284 "preferences-dialog.vala"
					_tmp24_ = i;
#line 284 "preferences-dialog.vala"
					if (_tmp24_ < NIBBLES_GAME_MAX_HUMANS) {
#line 1707 "preferences-dialog.c"
						{
							GeeArrayList* _cbox_list = NULL;
							GeeArrayList* _tmp25_;
							GeeArrayList* _tmp26_;
							gint _cbox_size = 0;
							GeeArrayList* _tmp27_;
							gint _tmp28_;
							gint _tmp29_;
							gint _cbox_index = 0;
#line 286 "preferences-dialog.vala"
							_tmp25_ = self->priv->combo_boxes;
#line 286 "preferences-dialog.vala"
							_tmp26_ = _g_object_ref0 (_tmp25_);
#line 286 "preferences-dialog.vala"
							_cbox_list = _tmp26_;
#line 286 "preferences-dialog.vala"
							_tmp27_ = _cbox_list;
#line 286 "preferences-dialog.vala"
							_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
#line 286 "preferences-dialog.vala"
							_tmp29_ = _tmp28_;
#line 286 "preferences-dialog.vala"
							_cbox_size = _tmp29_;
#line 286 "preferences-dialog.vala"
							_cbox_index = -1;
#line 286 "preferences-dialog.vala"
							while (TRUE) {
#line 1735 "preferences-dialog.c"
								gint _tmp30_;
								gint _tmp31_;
								gint _tmp32_;
								GtkComboBoxText* cbox = NULL;
								GeeArrayList* _tmp33_;
								gint _tmp34_;
								gpointer _tmp35_;
								gint index = 0;
								GeeArrayList* _tmp36_;
								GtkComboBoxText* _tmp37_;
								gint _tmp38_;
								gint _tmp39_;
#line 286 "preferences-dialog.vala"
								_tmp30_ = _cbox_index;
#line 286 "preferences-dialog.vala"
								_cbox_index = _tmp30_ + 1;
#line 286 "preferences-dialog.vala"
								_tmp31_ = _cbox_index;
#line 286 "preferences-dialog.vala"
								_tmp32_ = _cbox_size;
#line 286 "preferences-dialog.vala"
								if (!(_tmp31_ < _tmp32_)) {
#line 286 "preferences-dialog.vala"
									break;
#line 1760 "preferences-dialog.c"
								}
#line 286 "preferences-dialog.vala"
								_tmp33_ = _cbox_list;
#line 286 "preferences-dialog.vala"
								_tmp34_ = _cbox_index;
#line 286 "preferences-dialog.vala"
								_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _tmp34_);
#line 286 "preferences-dialog.vala"
								cbox = (GtkComboBoxText*) _tmp35_;
#line 288 "preferences-dialog.vala"
								_tmp36_ = self->priv->combo_boxes;
#line 288 "preferences-dialog.vala"
								_tmp37_ = cbox;
#line 288 "preferences-dialog.vala"
								index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp36_, _tmp37_);
#line 289 "preferences-dialog.vala"
								_tmp38_ = index;
#line 289 "preferences-dialog.vala"
								_tmp39_ = i;
#line 289 "preferences-dialog.vala"
								if (_tmp38_ == _tmp39_) {
#line 1782 "preferences-dialog.c"
									GtkComboBoxText* _tmp40_;
									gint _tmp41_;
#line 291 "preferences-dialog.vala"
									_tmp40_ = cbox;
#line 291 "preferences-dialog.vala"
									_tmp41_ = color_old;
#line 291 "preferences-dialog.vala"
									gtk_combo_box_set_active ((GtkComboBox*) _tmp40_, _tmp41_);
#line 292 "preferences-dialog.vala"
									_g_object_unref0 (cbox);
#line 292 "preferences-dialog.vala"
									break;
#line 1795 "preferences-dialog.c"
								}
#line 286 "preferences-dialog.vala"
								_g_object_unref0 (cbox);
#line 1799 "preferences-dialog.c"
							}
#line 286 "preferences-dialog.vala"
							_g_object_unref0 (_cbox_list);
#line 1803 "preferences-dialog.c"
						}
					}
#line 297 "preferences-dialog.vala"
					break;
#line 1808 "preferences-dialog.c"
				}
			}
		}
	}
#line 301 "preferences-dialog.vala"
	_tmp42_ = self->priv->worm_settings;
#line 301 "preferences-dialog.vala"
	_tmp43_ = id;
#line 301 "preferences-dialog.vala"
	_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, _tmp43_);
#line 301 "preferences-dialog.vala"
	_tmp45_ = (GSettings*) _tmp44_;
#line 301 "preferences-dialog.vala"
	_tmp46_ = color_new;
#line 301 "preferences-dialog.vala"
	g_settings_set_enum (_tmp45_, "color", _tmp46_);
#line 301 "preferences-dialog.vala"
	_g_object_unref0 (_tmp45_);
#line 1827 "preferences-dialog.c"
}


static void
preferences_dialog_class_init (PreferencesDialogClass * klass)
{
#line 20 "preferences-dialog.vala"
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
#line 20 "preferences-dialog.vala"
	g_type_class_adjust_private_offset (klass, &PreferencesDialog_private_offset);
#line 20 "preferences-dialog.vala"
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
#line 20 "preferences-dialog.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/preferences-dialog.ui");
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notebook", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, notebook));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "beginner_radio_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, beginner_radio_button));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "slow_radio_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, slow_radio_button));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "medium_radio_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, medium_radio_button));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fast_radio_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, fast_radio_button));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sound_check_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, sound_check_button));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fakes_check_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, fakes_check_button));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_store_1", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, list_store_1));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_store_2", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, list_store_2));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_store_3", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, list_store_3));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_store_4", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, list_store_4));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tree_view_1", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, tree_view_1));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tree_view_2", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, tree_view_2));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tree_view_3", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, tree_view_3));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tree_view_4", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, tree_view_4));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combo_box_1", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, combo_box_1));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combo_box_2", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, combo_box_2));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combo_box_3", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, combo_box_3));
#line 20 "preferences-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combo_box_4", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, combo_box_4));
#line 1880 "preferences-dialog.c"
}


static void
preferences_dialog_instance_init (PreferencesDialog * self)
{
#line 20 "preferences-dialog.vala"
	self->priv = preferences_dialog_get_instance_private (self);
#line 20 "preferences-dialog.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 1891 "preferences-dialog.c"
}


static void
preferences_dialog_finalize (GObject * obj)
{
	PreferencesDialog * self;
#line 20 "preferences-dialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES_DIALOG, PreferencesDialog);
#line 22 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->window);
#line 24 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->settings);
#line 25 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->worm_settings);
#line 28 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->notebook);
#line 30 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->beginner_radio_button);
#line 32 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->slow_radio_button);
#line 34 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->medium_radio_button);
#line 36 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->fast_radio_button);
#line 38 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->sound_check_button);
#line 40 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->fakes_check_button);
#line 42 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->list_store_1);
#line 44 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->list_store_2);
#line 46 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->list_store_3);
#line 48 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->list_store_4);
#line 50 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->tree_view_1);
#line 52 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->tree_view_2);
#line 54 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->tree_view_3);
#line 56 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->tree_view_4);
#line 58 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->combo_box_1);
#line 60 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->combo_box_2);
#line 62 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->combo_box_3);
#line 64 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->combo_box_4);
#line 66 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->radio_buttons);
#line 67 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->list_stores);
#line 68 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->tree_views);
#line 69 "preferences-dialog.vala"
	_g_object_unref0 (self->priv->combo_boxes);
#line 20 "preferences-dialog.vala"
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
#line 1955 "preferences-dialog.c"
}


GType
preferences_dialog_get_type (void)
{
	static volatile gsize preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PreferencesDialog", &g_define_type_info, 0);
		PreferencesDialog_private_offset = g_type_add_instance_private (preferences_dialog_type_id, sizeof (PreferencesDialogPrivate));
		g_once_init_leave (&preferences_dialog_type_id__volatile, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__volatile;
}



