/*
This file is part of Gnome Photo Printer.

    Gnome Photo Printer is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Gnome Photo Printer is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Gnome Photo Printer; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <gnome.h>
#include <libgnome/gnome-i18n.h>
#include <glade/glade.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnomeprint/gnome-print.h>
#include <libgnomeprint/gnome-print-job.h>
#include <libgnomeprintui/gnome-print-dialog.h>
#include "gpp_print.h"
#include "gpp_functions.h"
#include "gpp_widget.h"
#include "gpp_callbacks.h"
#include "gpp.h"

#define GNOME_PRINT_UNSTABLE_API

/* Main routine -> Lots of initializesing stuff :) */
int
main (int argc, char **argv)
{

	GnomeProgram *program;
	GtkWidget *window;
	gchar *file;

	/* Initialize Gnome and Gnome-vfs */
	program = gnome_program_init ("gpp", "0.6", LIBGNOMEUI_MODULE, argc,
				      argv, GNOME_PROGRAM_STANDARD_PROPERTIES,
				      GNOME_PARAM_ENABLE_SOUND, TRUE,
				      GNOME_CLIENT_PARAM_SM_CONNECT, TRUE,
				      NULL);

	if (!gnome_vfs_init ())
		g_error ("GNOME-VFS could not be initialized!\n");

	/* Initialize the gpp_definition structure */
	gpp_definition = g_malloc (sizeof (struct _print_definition));

	gpp_definition->to_file = FALSE;
	gpp_definition->output_file_name = g_strdup ("output.ps");
	gpp_definition->paper_size = g_strdup ("A4");
	gpp_definition->paper_size_x = 0;
	gpp_definition->paper_size_y = 0;
	gpp_definition->layout = LAYOUT_1;
	gpp_definition->layout_x = gpp_calculate_size_metric_to_dpi (20);
	gpp_definition->layout_y = gpp_calculate_size_metric_to_dpi (25);
	gpp_definition->image_scale_with_ratio = TRUE;
	gpp_definition->number_of_files = 0;
	gpp_definition->file_names =
		gtk_list_store_new (N_COLUMNS, GDK_TYPE_PIXBUF,
				    G_TYPE_STRING);

	/* Setup the Gnome Print stuff */
	gpp_config = gnome_print_config_default ();
	gpp_job = gnome_print_job_new (gpp_config);

	/* Build and show the widgets */
	file = gnome_program_locate_file (program,
					  GNOME_FILE_DOMAIN_APP_DATADIR,
					  "gpp.glade", FALSE, NULL);
	window = gpp_build_widget (file);

	gtk_widget_show_all (GTK_WIDGET (window));

	/* Gtk Main */
	gtk_main ();

	gnome_vfs_shutdown ();

	return 0;
}
