/***************************************************************************
 *            gnome-ppp.h
 *
 *  Mon May 10 20:13:51 2004
 *  Copyright  2004  Vladimir Đokić
 *  vladeck@gnome-ppp.org
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _GNOME_PPP_H_
#define _GNOME_PPP_H_

#ifdef __cplusplus
extern "C"
{
#endif

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "eggtrayicon.h"
#include <gnome.h>
#include <glade/glade.h>
#include <glib/gprintf.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/ioctl.h>
#include <arpa/inet.h>
#include <net/ppp_defs.h>
#include <net/if.h> 
#include <net/if_ppp.h>
#include <netinet/in.h>
#include <signal.h>


typedef struct _GNOMEPPPWin GNOMEPPPWin;
typedef struct _SetupWin SetupWin;
typedef struct _PhoneListWin PhoneListWin;
typedef struct _InitStringsWin InitStringsWin;
typedef struct _ConnectingWin ConnectingWin;
typedef struct _LogWin LogWin;
typedef struct _ConnectedWin ConnectedWin;
typedef struct _DetailsWin DetailsWin;
typedef struct _Notification Notification;
typedef struct _GNOMEPPP GNOMEPPP;

typedef struct _WVDialProc WVDialProc;
typedef struct _WVDialConfProc WVDialConfProc;

/* gnome_ppp window */
struct _GNOMEPPPWin {
	
	GtkWidget *window;
	GtkWidget *username;
	GtkWidget *password;
	GtkWidget *store_pwd;
	GtkWidget *phone;
};
/* setup window */
struct _SetupWin {
	
	GtkWidget *window;
	/* modem */
	GtkWidget *device;
	GtkWidget *type;
	GtkWidget *speed;
	GtkWidget *tone;
	GtkWidget *pulse;
	GtkWidget *volume;
	GtkWidget *phone_nums;
	GtkWidget *init_strs;
	GtkWidget *dial_prefix;
	GtkWidget *spin_dial_attempts;
	GtkWidget *label_dial_attempts;
	GtkWidget *dial_tone;
	/* networking */
	GtkWidget *static_ip;
	GtkWidget *dynamic_ip;
	GtkWidget *label_ip;
	GtkWidget *entry_ip;
	GtkWidget *domain;
	GtkWidget *auto_dns;
	GtkWidget *manual_dns;
	GtkWidget *list_dns;
	/* options */
	GtkWidget *minimize;
	GtkWidget *dock;
	GtkWidget *auto_reconnect;
	GtkWidget *abort_on_busy;
	GtkWidget *abort_on_no_dialtone;
	GtkWidget *check_carrier;
	GtkWidget *check_def_route;
	GtkWidget *stupid_mode;
	GtkWidget *custom_reply;
	GtkWidget *label_reply;
	GtkWidget *entry_reply;
	GtkWidget *spin_idle;
	GtkWidget *label_idle;
};
/* phone list window */
struct _PhoneListWin {

	GtkWidget *window;
	GtkWidget *phone_nums;
};
/* init strings list window */
struct _InitStringsWin {

	GtkWidget *window;
	GtkWidget *init_strs;
};
/* connecting window */
struct _ConnectingWin {

	GtkWidget *window;
	GtkWidget *msgs;	
};
/* log */
struct _LogWin {
	
	GtkWidget *window;
	GtkWidget *text_log;
};
/* connected window */
struct _ConnectedWin {

	GtkWidget *window;
	GtkWidget *time;
	
	gboolean show;
	int seconds;
	gboolean update;
	glong old_bytes_in;
	glong old_bytes_out;
};
/* details window */
struct _DetailsWin {
	
	GtkWidget *window;
	GtkWidget *interface;
	GtkWidget *status;
	GtkWidget *speed;
	GtkWidget *ip;
	GtkWidget *destination;
	GtkWidget *received;
	GtkWidget *sent;
	GtkWidget *received_packets;
	GtkWidget *sent_packets;
};
/* notification */
struct _Notification {
	
	EggTrayIcon *tray;
	GtkWidget *box;
	GtkWidget *pixmap;
	GtkWidget *menu;
};

struct _GNOMEPPP {

	GnomeProgram *app;
	GladeXML *xml;
	/* interface */
	GNOMEPPPWin gnome_ppp;
	SetupWin setup;
	ConnectingWin connecting;
	LogWin log;
	ConnectedWin connected;
	DetailsWin details;
	GtkWidget *detect;
	GtkWidget *about;
	PhoneListWin phone;
	InitStringsWin init_strs;
	/* notification */
	Notification notification;
	gboolean dock;
	/* icon factory */
	GtkIconFactory *icon_factory;
};
/* wvdial process */
struct _WVDialProc {
	
	const char *cmd[20];
	int out_pipe;
	int err_pipe;
	int in_pipe;
	int pid;
	GError *error;
	guint out_tag;
	guint err_tag;
	GIOChannel *out;
	GIOChannel *err;
};
/* wvdialconf process */
struct _WVDialConfProc {
	
	const char *cmd[20];
	int out_pipe;
	int err_pipe;
	int in_pipe;
	int pid;
	GError *error;
	guint out_tag;
	guint err_tag;
	GIOChannel *out;
	GIOChannel *err;
};

WVDialProc wvdial;
WVDialConfProc wvdialconf;
GNOMEPPP gnome_ppp;

/* utility functions */
void read_conf (void);
void populate_phone_list (const gchar *phone1, const gchar *phone2, const gchar *phone3, const gchar *phone4);
void populate_init_strs_list (const gchar *init2, const gchar *init3, const gchar *init4, const gchar *init5,
				const gchar *init6, const gchar *init7, const gchar *init8, const gchar *init9);
void populate_dns_list (const gchar *dns1, const gchar *dns2);
gchar *parse_conf_line (const gchar *line, char *str);
gchar *get_tree_value (GtkTreeModel *model, const gchar *index);
void write_conf (void);
void write_resolv_conf (const gchar *domain, const gchar *dns1, const gchar *dns2);
/* gnome_ppp callbacks */
void on_connect (GtkWidget *widget, gpointer data);
void on_setup (GtkWidget *widget, gpointer data);
void on_quit (GtkWidget *widget, gpointer data);
gboolean on_delete_event (GtkWidget *widget, GdkEvent *event, gpointer data);
/* setup window callbacks */
void on_detect (GtkWidget *widget, gpointer data);
void on_phone_nums (GtkWidget *widget, gpointer data);
void on_init_strs (GtkWidget *widget, gpointer data);
void on_phone_num_edited (GtkCellRendererText *renderer, gchar *path, gchar *string, gpointer data);
void on_init_str_edited (GtkCellRendererText *renderer, gchar *path, gchar *string, gpointer data);
void on_dial_attempts_changed (GtkWidget *widget, gpointer data);
void on_dns_edited (GtkCellRendererText *renderer, gchar *path, gchar *string, gpointer data);
void on_static_ip (GtkWidget *widget, gpointer data);
void on_dynamic_ip (GtkWidget *widget, gpointer data);
void on_auto_dns (GtkWidget *widget, gpointer data);
void on_manual_dns (GtkWidget *widget, gpointer data);
void on_custom_reply (GtkWidget *widget, gpointer data);
void on_idle_changed (GtkWidget *widget, gpointer data);
void on_setup_close (GtkWidget *widget, gpointer data);
/* connecting window callbacks */
void on_conn_cancel (GtkWidget *widget, gpointer data);
void on_log (GtkWidget *widget, gpointer data);
/* log window callbacks */
void on_log_close (GtkWidget *widget, gpointer data);
/* connected window callbacks */
void on_conn_disconnect (GtkWidget *widget, gpointer data);
void on_conn_details (GtkWidget *widget, gpointer data);
gboolean on_conn_delete_event (GtkWidget *widget, GdkEvent *event, gpointer data);
gboolean timer (gpointer data);
/* details window callbacks */
gchar *get_transfer_details (const gchar *iface, glong *packets_in, glong *packets_out, glong *bytes_in, glong *bytes_out);
gboolean get_addr_details (const gchar *iface, gchar **addr, gchar **bcast);
void on_details_close (GtkWidget *widget, gpointer data);
/* detect window callbacks */
void on_detect_cancel (GtkWidget *widget, gpointer data);
/* phone list window callbacks */
void on_phones_close (GtkWidget *widget, gpointer data);
/* init strings list window callbacks */
void on_init_strs_close (GtkWidget *widget, gpointer data);
/* wvdial process callbacks */
gboolean on_wvdial_out (GIOChannel *source, GIOCondition condition, gpointer data);
gboolean on_wvdial_err (GIOChannel *source, GIOCondition condition, gpointer data);
/* wvdialconf process callbacks */
gboolean on_wvdialconf_out (GIOChannel *source, GIOCondition condition, gpointer data);
gboolean on_wvdialconf_err (GIOChannel *source, GIOCondition condition, gpointer data);
/* notification area funcs & callbacks */
void init_notification (void);
void update_notification (guint status);
void show_notification (gboolean show);
void destroy_notification (void);
void on_notification_bpress_event (GtkWidget *widget, GdkEventButton *event, gpointer *data);
void on_notification_menu (GtkWidget *widget, gpointer data);

#ifdef __cplusplus
}
#endif

#endif /* _GNOME_PPP_H_ */
