/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#ifndef _GNOME_SCAN_UTILS_H_
#define _GNOME_SCAN_UTILS_H_

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define MM_PER_INCH 25.4

/**
 * GS_DEFINE_QUARK:
 * @quark_name:	function prefix
 * @String:	The string passed to g_quark_from_string()
 *
 * Generate a function that generate a static quark from @String.
 *
 * For example:
 * <programlisting>
GS_DEFINE_QUARK (foo_bar, FooBar);
 * </programlisting>
 *
 * expands to:
 *
 * <programlisting>
GQuark
gs_foo_bar_quark () {
	static GQuark quark = 0;
	if (!quark) {
		quark = g_quark_from_static_string ("FooBar");
	}
	return quark;
}
 * </programlisting>
 **/
#define	GS_DEFINE_QUARK(quark_name, String)	GQuark \
quark_name##_quark () { \
	static GQuark quark = 0; \
	if (!quark) { \
		quark = g_quark_from_static_string (String); } \
	return quark; \
}


/**
 * GnomeScanFormat:
 *
 **/
typedef struct _GnomeScanFormat GnomeScanFormat;
struct _GnomeScanFormat
{
	gchar *name;
	gchar *domain;
	gchar *description;
	gchar **mime_types;
	gchar **extensions;
};

typedef struct _GSPoint GSPoint;
struct _GSPoint
{
	gdouble x;
	gdouble y;
};

typedef struct _GSRectangle GSRectangle;
struct _GSRectangle
{
	gdouble x;
	gdouble y;
	gdouble width;
	gdouble height;
};

/**
 * GnomeScanUnit:
 **/
typedef enum /*< lowercase_name=gs_param_unit,prefix=GS_UNIT >*/
{
	GS_UNIT_NONE=-1,
	GS_UNIT_PIXEL=GTK_UNIT_PIXEL,
	GS_UNIT_POINT=GTK_UNIT_POINTS,
	GS_UNIT_MM=GTK_UNIT_MM,
	GS_UNIT_BIT,
	GS_UNIT_DPI,
	GS_UNIT_PERCENT,
	GS_UNIT_MICROSECOND
} GnomeScanUnit;

const gchar*
gs_enum_get_nick_from_value (GType type, guint value);

gdouble gs_convert							(gdouble val,
											   GnomeScanUnit from,
											   GnomeScanUnit to,
											   gdouble res);

gdouble gs_convert_to_mm					(gdouble val,
											 GnomeScanUnit unit,
											 gdouble res);

gdouble gs_convert_from_mm					(gdouble val,
											   GnomeScanUnit unit,
											   gdouble res);

GSRectangle* gs_rectangle_convert 			(GSRectangle *r,
											 GnomeScanUnit from,
											 GnomeScanUnit to,
											 gdouble res);
GSRectangle* gs_rectangle_convert_to_mm		(GSRectangle *r,
											  GnomeScanUnit unit,
											  gdouble res);

GSRectangle* gs_rectangle_convert_from_mm	(GSRectangle *r,
											 GnomeScanUnit unit,
											 gdouble res);

GSRectangle* gs_rectangle_rotate (GSRectangle *r,
								   GSRectangle *a,
								   guint angle);

#define gs_debug_rect(r) g_debug(G_STRLOC ": " #r " = %ix%i+%i+%i", (r)->width, (r)->height, (r)->x, (r)->y)
#define gs_debug_gsrect(r) g_debug(G_STRLOC ": " #r " = %.2fx%.2f+%.2f+%.2f", (r)->width, (r)->height, (r)->x, (r)->y)

G_END_DECLS

#endif /* _GNOME_SCAN_UTILS_H_ */
