//  Gnomoradio - roboradio/song-list-cache.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "song-list-cache.h"
#include "song-rainbow.h"

using namespace Roboradio;
using namespace std;

Roboradio::SongListCache::SongListCache ()
	: SongListAutomatic("Fetched Songs")
{
	construct();
	Song::signal_global_song_status_changed.connect(slot(*this, &SongListCache::status_changed));
	signal_removed.connect(SigC::slot(*this, &SongListCache::on_remove));
}

Roboradio::SongListCache::~SongListCache ()
{
}

void Roboradio::SongListCache::status_changed (SongRef song)
{
	if (!meets_criteria(song))
		return;

	iterator pos = begin();
	while (pos != end() && &*song != &**pos)
		++pos;
	
	if (pos == end())
		push_back(song);

	// FIXME: this will not remove songs, but that is probably not intended, even if their status changes
}

bool Roboradio::SongListCache::meets_criteria (const SongRef &song)
{
	return (dynamic_cast<SongRainbow*>(&*song)
		&& song->get_status().available);
}

void Roboradio::SongListCache::on_remove (iterator song)
{
	SongRainbow *sr = dynamic_cast<SongRainbow*>(&**song);
	if (sr)
		sr->uncache();
}
