// -*- c++ -*-

//  Gnomoradio - gnomoradio/main-window.h
//  Copyright (C) 2003  Jim Garrison, Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MAIN_WINDOW_H
#define __MAIN_WINDOW_H

#include <gtkmm.h>
#include <memory>
#include "wraporadio/wraporadio.h"
#include "playlist-chooser-store.h"
#include "playlist-view.h"
#include "player-controls.h"
//#include "visualize.h"

namespace Gnomoradio
{
	/* this class produces the main window of the application */

	class MainWindow : public Gtk::Window
	{
	public:
		MainWindow (Wraporadio::Init *init, PlaylistChooserStore &chooser_store);
		virtual ~MainWindow ();

		static Gtk::TargetEntry song_target;

		void find_current_song ();

       	protected:
		Gtk::VBox vbox, left;
		Gtk::HBox top;
		Gtk::HPaned hpaned;

	        Gtk::ScrolledWindow scrolled_window; // for chooser
	        Gtk::TreeView chooser; // play list chooser view (along left)
		PlaylistView list; // current play list (along right)
		Gtk::HBox list_controls; // list controls (repeat, shuffle, etc)
		PlayerControls controls;
	        Gtk::Entry search;
		Gtk::Button search_online;

		Gtk::ToggleButton repeat_button, shuffle_button;

		PlaylistChooserStore *store; // refers to the global object

		Gtk::MenuItem file_findcurrentsong;
		Gtk::MenuItem edit_songinfo;
		Gtk::MenuItem playlist_settings;
		Gtk::MenuItem playlist_removesong;
		Gtk::MenuItem playlist_remove;

		Gtk::Window *add_uri_box;
		Gtk::Entry uri_entry;

		Gtk::Window *about_box, *playlist_settings_box;

		//Visualize *visual;

		std::auto_ptr<Wraporadio::SongListSearch> search_list;

		Wraporadio::Init *wr;

		void different_list_viewed (Wraporadio::SongList sl);
		bool on_chooser_clicked (GdkEventButton *event);
	        void search_changed ();
	        void search_activate ();
	        void import_playlist ();
	        void export_playlist ();
	        void create_playlist ();
		void remove_playlist (Wraporadio::SongList songlist);
		void on_chooser_change ();
		void on_playlist_rename (const Glib::ustring& path, const Glib::ustring& new_text);
		void on_shuffle_clicked ();
		void on_repeat_clicked ();
		void on_right_click_songlist_settings_activate (Wraporadio::SongList songlist);
		void set_edit_song_info_sensitivity ();
	        void on_file_add_uri_activate ();
		void on_file_exit_activate ();
	        void on_edit_song_info_activate ();
		void on_edit_preferences_activate ();
		void on_playlist_settings_activate ();
		void on_playlist_remove_activate ();
		void on_playlist_removesong_activate ();
		void on_help_about_activate ();
		void on_uri_entry_activate();
		void on_uri_close_activate();
		void on_about_box_close ();
		void on_chooser_drag_data_received (const Glib::RefPtr<Gdk::DragContext> &context, int x, int y, const Gtk::SelectionData &selection_data, guint info, guint time);
		void on_state_changed ();
	};
}

#endif
