/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * GnoWavCut -- a GNOME/GTK+ based RIFF PCM Wave File splitter
 * Copyright (C) 2000 Yoichi Imai <yoichi@silver-forest.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "config.h"

#include <gnome.h>

void about_open(void)
{
	GtkWidget *about_box;
	GtkWidget *href;

	const char *authors[] = {
		"Yoichi Imai <yoichi@silver-forest.com>",
		NULL
	};
	about_box = gnome_about_new("GnoWavCut",
				    VERSION,
				    "Copyright (C) 2000, Yoichi Imai",
				    authors,
				    _("a GTK+/GNOME based RIFF PCM Wave file splitter\n") ,
				    NULL);

	href = gnome_href_new("http://gnowavcut.good-day.net/",
			      _("GnoWavCut Web page"));

	gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(about_box)->vbox),
			   href, FALSE, FALSE, 0);

	gtk_widget_show(href);
	gtk_widget_show(about_box);
}
