/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * GnoWavCut -- a GNOME/GTK+ based RIFF PCM Wave File splitter
 * Copyright (C) 2000 Yoichi Imai <yoichi@silver-forest.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "config.h"

#include <gnome.h>
#include "main.h"
#include "timelist.h"
#include "utils.h"
#include "wave.h"

static void timelist_insert(GnoWavCut *gnowavcut, int insert_point);

/*
static void timelist_row_destroy_cb(gpointer data);
static void timelist_row_destroy_cb(gpointer data)
{
  TimeData *time_data;

  time_data = (TimeData *) data;

  g_return_if_fail(time_data != NULL);

  g_free(time_data);
  } */

void timelist_insert_cb(GtkWidget *widget, gpointer data)
{
	GnoWavCut *gnowavcut;
	int insert_point;

	gnowavcut = (GnoWavCut *)data;

	g_return_if_fail(gnowavcut->now_pause == TRUE);

	/* insert_point = lseek(gnowavcut->wave_fd, 0, SEEK_CUR); */
	insert_point = gnowavcut->mini_old_point;
  
	timelist_insert(gnowavcut, insert_point);
}

void timelist_init_cb(GtkWidget *widget, gpointer data)
{
	GnoWavCut *gnowavcut;

	gnowavcut = (GnoWavCut *)data;

	gtk_clist_clear(GTK_CLIST(gnowavcut->clist));
}

void timelist_remove_cb(GtkWidget *widget, gpointer data)
{
	GnoWavCut *gnowavcut;
	GtkWidget *clist;
	/* GList *cur_sel; */

	gnowavcut = (GnoWavCut *)data;
	clist = gnowavcut->clist;

	if(GTK_CLIST(clist)->selection != NULL)
		gtk_clist_remove(GTK_CLIST(clist), (gint) GTK_CLIST(clist)->selection->data);

	/*  for (cur_sel = GTK_CLIST(clist)->selection; cur_sel != NULL; cur_sel = cur_sel->next) {
	    g_print("freeing %d\n", (gint) cur_sel->data);
	    gtk_clist_remove(GTK_CLIST(clist), (gint) cur_sel->data);

	    if(cur_sel == GTK_CLIST(clist)->selection_end) break;
	    } */
  
}
void timelist_end_cb(GtkWidget *widget, gpointer data)
{
	GnoWavCut *gnowavcut;
	guint32 wave_end;
	gchar *tmp;
  
	gnowavcut = (GnoWavCut *)data;

	if(gnowavcut->file_name == NULL) return;

	wave_end = gnowavcut->wave_info->data_size + WAVE_HEADER_SIZE;

	tmp = utils_get_mini_time_from_cur(gnowavcut->wave_info, wave_end);

	gtk_entry_set_text(GTK_ENTRY(gnowavcut->entry_end), tmp);

	g_free(tmp);
}
void timelist_from_cb(GtkWidget *widget, gpointer data)
{
	GnoWavCut *gnowavcut;
	gchar *tmp;
  
	gnowavcut = (GnoWavCut *)data;

	if(GTK_CLIST(gnowavcut->clist)->selection == NULL)
		return;

	gtk_clist_get_text(GTK_CLIST(gnowavcut->clist),
			   (gint) GTK_CLIST(gnowavcut->clist)->selection->data,
			   1,
			   &tmp);
	if(utils_get_cur_from_mini_time(gnowavcut->wave_info, tmp, NULL) == TRUE)
		gtk_entry_set_text(GTK_ENTRY(gnowavcut->entry_start), tmp);

}
void timelist_button_press_cb(GtkWidget *widget, GdkEventButton *event,
			      gpointer data)
{
	GnoWavCut *gnowavcut;
	int selected_row;
	gchar *time;
	int jump_point;
      
 	gnowavcut = (GnoWavCut *)data;
	if(gnowavcut->now_playing == FALSE) return;
	if(gnowavcut->now_mini_playing == TRUE) return;

	
	if(event && (event->button == 1 && event->type == GDK_2BUTTON_PRESS)) {
		if(GTK_CLIST(gnowavcut->clist)->selection == NULL) return;
		selected_row = (gint) GTK_CLIST(gnowavcut->clist)->selection->data;
		gtk_clist_get_text(GTK_CLIST(gnowavcut->clist), selected_row, 0, &time);
		if(time == NULL)
			return;
		if(utils_get_cur_from_mini_time(gnowavcut->wave_info, time, &jump_point) == FALSE)
			return;
		wave_jump(gnowavcut, jump_point);
	}
}
		   
void timelist_append_cb(GtkWidget *widget, gpointer data)
{
	GnoWavCut *gnowavcut;
	gchar *clist_item[2];
	gchar *tmp;
	guint32 start, end;

	gnowavcut = (GnoWavCut *)data;

	if(gnowavcut->file_name == NULL) return;

	tmp = gtk_entry_get_text(GTK_ENTRY(gnowavcut->entry_start));
	if(utils_get_cur_from_mini_time(gnowavcut->wave_info, tmp, &start) == FALSE) {
		utils_msgbox_error(_("Start entry is illegal."));
		return;
	}

	tmp = gtk_entry_get_text(GTK_ENTRY(gnowavcut->entry_end));
	if(utils_get_cur_from_mini_time(gnowavcut->wave_info, tmp, &end) == FALSE) {
		utils_msgbox_error(_("End entry is illegal."));
		return;
	}
	if (start > end) {
		utils_msgbox_error(_("Start point is grater than end point."));
		return;
	}

	clist_item[0] = utils_get_mini_time_from_cur(gnowavcut->wave_info, start);
	clist_item[1] = utils_get_mini_time_from_cur(gnowavcut->wave_info, end);

	gtk_clist_append(GTK_CLIST(gnowavcut->clist), clist_item);

	g_free(clist_item[0]);
	g_free(clist_item[1]);
}

static void timelist_insert(GnoWavCut *gnowavcut, int insert_point)
{
	WaveInfo *wave_info;
	GtkWidget *clist;
	gchar *clist_item[2];
	gchar *row_text;
	int tmp_time;

	wave_info = gnowavcut->wave_info;
	clist = gnowavcut->clist;

	if(GTK_CLIST(clist)->rows == 0) {
		clist_item[0] = g_strdup("000:00.000");
	} else {
		gtk_clist_get_text(GTK_CLIST(clist), GTK_CLIST(clist)->rows - 1, 1, &row_text);
		clist_item[0] = g_strdup(row_text);
	}

	if(utils_get_cur_from_mini_time(wave_info, clist_item[0], &tmp_time) != FALSE) {
		if(tmp_time > insert_point) {
			g_free(clist_item[0]);
			clist_item[0] = g_strdup("000:00.000");
		}
	}
	
	clist_item[1] = utils_get_mini_time_from_cur(wave_info, insert_point);
	gtk_clist_append(GTK_CLIST(clist), clist_item);

	g_free(clist_item[0]);
	g_free(clist_item[1]);
}

/* static void timelist_insert(GnoWavCut *gnowavcut, int insert_point)
   {
   WaveInfo *wave_info;
   GtkWidget *clist;
   TimeData *time_data;
   TimeData *old_time_data;
   gchar* clist_item[2];
   gint inserted_row;

   wave_info = gnowavcut->wave_info;
   clist = gnowavcut->clist;

   time_data = g_new0(TimeData, 1);

   if(GTK_CLIST(clist)->rows == 0) {
   time_data->start = WAVE_HEADER_SIZE;
   } else {
   old_time_data = (TimeData *) gtk_clist_get_row_data(GTK_CLIST(clist),
   GTK_CLIST(clist)->rows - 1);
   g_return_if_fail(old_time_data != NULL);

   time_data->start = old_time_data->end;
   }
   time_data->end = insert_point;
   time_data->end -= (time_data->end - WAVE_HEADER_SIZE) % wave_info->size_per_sample;
  
   clist_item[0] = utils_get_mini_time_from_cur(wave_info, time_data->start);
   // utils_get_time_from_seconds((time_data->start - WAVE_HEADER_SIZE) / wave_info->size_per_sec);
   clist_item[1] = utils_get_mini_time_from_cur(wave_info, time_data->end);
   // utils_get_time_from_seconds((time_data->end - WAVE_HEADER_SIZE) / wave_info->size_per_sec);

   inserted_row = gtk_clist_append(GTK_CLIST(clist), clist_item);

   gtk_clist_set_row_data_full(GTK_CLIST(clist), GTK_CLIST(clist)->rows - 1, time_data, timelist_row_destroy_cb);

   g_free(clist_item[0]);
   g_free(clist_item[1]);
   } */

