#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
"""
Information on this driver
"""

#
# Notes on this driver
#
name = _("DBF File Data Driver")
url = "http://schwinger.harvard.edu/~mspal/pystuff/dbf.txt"
doc = """
Description
-----------
Virtual database driver for loading data from a DBF file

Used whenever a data has to be imported from dbase III+

Support
-------
Supported Platforms:

  - Linux/BSD
  - Solaris
  - MS Windows 98/NT/2000/XP


Connection Properties
---------------------
* provider   -- The name of the provider, which is dbf (of course)
* directory  -- The directory where the DBF files are stored (required)
* dbname     -- The name of the database to use (required)

Examples
--------
[dbf]
comment = XYZ Import Database
provider = dbf
directory = c:\data\
dbname = Test

Notes
-----
1. This driver only allows unfiltered unsorted read-only data access.
   It is intended for migration purposes only.
"""
