#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# popy/DBdriver.py
#
# DESCRIPTION:
# Postgresql implementation of dbdriver using Python DB-SIG v2
# specification.
#
# NOTES:
#

__all__ = ('Connection')

from gnue.common.datasources.drivers.postgresql import Base
from gnue.common.datasources import GConnections

try:
  import PoPy
except ImportError:
  raise GConnections.DependencyError, ('PoPy', None)

class Connection(Base.Connection):
  _driver = PoPy
  _broken_fetchmany = True
